/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.rest.services;

import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.JacksonCommonUtil;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.rest.RESTException;
import Gbt.core.rest.RESTHttpMethods;
import Gbt.core.rest.RESTRequest;
import Gbt.core.rest.RESTRequestImpl;
import Gbt.core.rest.RESTServices;
import Gbt.core.rest.RESTServicesOptions;
import Gbt.utility.rest.models.AMIRestSMTP;
import java.io.File;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;

public final class SMTPServices
extends RESTServices {
    public static final String SERVICE_NAME = "smtp";
    private static final String SETTINGS_SMTP_URI = "/api/settings/smtp";
    private List<AMIRestSMTP> uploadData;

    public SMTPServices(AbstractLoggerWriter loggerWriter) {
        super(loggerWriter);
    }

    @Override
    public String getServiceName() {
        return SERVICE_NAME;
    }

    @Override
    public boolean readJsonData(AbstractJSONPOJO jsonData, RESTServicesOptions restServicesOptions) {
        return true;
    }

    @Override
    public boolean readJsonFiles(List<File> dataFiles, RESTServicesOptions restServicesOptions) {
        switch (restServicesOptions.getOptionName()) {
            case "get": {
                return true;
            }
            case "set": {
                try {
                    this.uploadData = JacksonCommonUtil.getUtil().readJSONArrayFile(dataFiles.get(0), restServicesOptions.getRequestPayloadCollectionType());
                }
                catch (Exception e) {
                    return false;
                }
                return this.uploadData != null;
            }
        }
        return true;
    }

    @Override
    public boolean uploadFiles(List<File> uploadFiles, RESTServicesOptions restServicesOptions) {
        return true;
    }

    @Override
    public boolean execute(String ipAddress, RESTServicesOptions restServicesOptions) {
        String logName = ipAddress + "_" + this.logDirPath + "_" + this.getServiceName();
        RESTRequestImpl request = null;
        switch (restServicesOptions.getOptionName()) {
            case "get": {
                request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHttpMethods(RESTHttpMethods.GET)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(SETTINGS_SMTP_URI).setCookies(this.sessionData)).setContentType("application/json")).build();
                try {
                    Response response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
                    this.jsonResults.addAll((Collection)this.clientReceiver.deserialize(response, new GenericType<List<AMIRestSMTP>>(){}));
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Get SMTP config success.");
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, this.getJsonResultsPrettyPrintString());
                    return true;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Get SMTP config fail.");
                    this.restExceptionMessages(re, ipAddress, logName);
                    this.jsonResults.add(new NullJSONData().setError(true).setMessages("Get SMTP config fail."));
                    return false;
                }
            }
            case "set": {
                for (AMIRestSMTP upload : this.uploadData) {
                    request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHttpMethods(RESTHttpMethods.PUT)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(SETTINGS_SMTP_URI).setServiceId(upload.getId().intValue()).setRawJsonData(upload)).setCookies(this.sessionData)).setContentType("application/json")).build();
                    try {
                        Response response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
                        AMIRestSMTP data = this.clientReceiver.deserialize(response, new GenericType<AMIRestSMTP>(){});
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Set SMTP config success.");
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, data.toString());
                        this.jsonResults.add(data);
                    }
                    catch (RESTException re) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Set SMTP config fail.");
                        this.restExceptionMessages(re, ipAddress, logName);
                        this.jsonResults.add(new NullJSONData().setError(true).setMessages("Set SMTP config fail."));
                        return false;
                    }
                }
                return true;
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Unknown option of " + this.getServiceName() + " service.");
        this.jsonResults.add(new NullJSONData().setError(true).setMessages("Unknown option of " + this.getServiceName() + " service."));
        return false;
    }
}

