/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.scan.upnpimpl;

import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.DefaultLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.utility.scan.ScanCommand;
import java.util.ArrayList;
import java.util.List;
import org.fourthline.cling.model.meta.LocalDevice;
import org.fourthline.cling.model.meta.RemoteDevice;
import org.fourthline.cling.model.meta.RemoteDeviceIdentity;
import org.fourthline.cling.model.meta.RemoteService;
import org.fourthline.cling.registry.Registry;
import org.fourthline.cling.registry.RegistryListener;

public final class UpnpScanRegistryListener
implements RegistryListener {
    private static final String DEFAULT_DEVICE_TYPE = "management";
    private volatile AbstractLoggerWriter logger = new DefaultLoggerWriter(this.getClass());
    private volatile List<String> availableIPList = new ArrayList<String>();

    public void remoteDeviceDiscoveryStarted(Registry registry, RemoteDevice device) {
        String host = ((RemoteDeviceIdentity)device.getIdentity()).getDescriptorURL().getHost();
        if (device.getType().getType().equals(DEFAULT_DEVICE_TYPE) && device.getServices().length != 0) {
            int redfishCount = 0;
            for (RemoteService service : device.getServices()) {
                if (!service.getServiceType().getNamespace().equals("dmtf-org")) continue;
                ++redfishCount;
            }
            if (redfishCount > 0) {
                this.writeLogs(GbtLogLevel.INFO, "scan", "Nodelist", host);
                this.writeLogs(GbtLogLevel.INFO, "scan", host + "_" + ScanCommand.ScanType.SSDP.toString(), "Discover Location        : " + ((RemoteDeviceIdentity)device.getIdentity()).getDescriptorURL());
                this.writeLogs(GbtLogLevel.INFO, "scan", host + "_" + ScanCommand.ScanType.SSDP.toString(), "Device UUID              : " + ((RemoteDeviceIdentity)device.getIdentity()).getUdn().getIdentifierString());
                this.writeLogs(GbtLogLevel.INFO, "scan", host + "_" + ScanCommand.ScanType.SSDP.toString(), "Device Type              : " + device.getType().toString());
                this.writeLogs(GbtLogLevel.INFO, "scan", host + "_" + ScanCommand.ScanType.SSDP.toString(), "Device Friendly Name     : " + device.getDetails().getFriendlyName());
                this.writeLogs(GbtLogLevel.INFO, "scan", host + "_" + ScanCommand.ScanType.SSDP.toString(), "Device Model Name        : " + device.getDetails().getModelDetails().getModelName());
                this.writeLogs(GbtLogLevel.INFO, "scan", host + "_" + ScanCommand.ScanType.SSDP.toString(), "Device Model Number      : " + device.getDetails().getModelDetails().getModelNumber());
                this.writeLogs(GbtLogLevel.INFO, "scan", host + "_" + ScanCommand.ScanType.SSDP.toString(), "Device Model Description : " + device.getDetails().getModelDetails().getModelDescription());
                this.writeLogs(GbtLogLevel.INFO, "scan", host + "_" + ScanCommand.ScanType.SSDP.toString(), "Device Manufacturer      : " + device.getDetails().getManufacturerDetails().getManufacturer());
                this.writeLogs(GbtLogLevel.INFO, "scan", host + "_" + ScanCommand.ScanType.SSDP.toString(), "Device Manufacturer URL  : " + device.getDetails().getManufacturerDetails().getManufacturerURI().toString());
                for (RemoteService service : device.getServices()) {
                    if (!service.getServiceType().getNamespace().equals("dmtf-org")) continue;
                    this.writeLogs(GbtLogLevel.INFO, "scan", host + "_" + ScanCommand.ScanType.SSDP.toString(), "Service type             : " + service.getServiceType().toString());
                    this.writeLogs(GbtLogLevel.INFO, "scan", host + "_" + ScanCommand.ScanType.SSDP.toString(), "Service ID               : " + service.getServiceId().toString());
                }
                this.availableIPList.add(host);
            }
        }
    }

    public void remoteDeviceDiscoveryFailed(Registry registry, RemoteDevice device, Exception ex) {
        String host = ((RemoteDeviceIdentity)device.getIdentity()).getDescriptorURL().getHost();
        this.writeLogs(GbtLogLevel.ERROR, "scan", host + "_" + ScanCommand.ScanType.SSDP.toString(), "Discovery failed  : " + device.getDisplayString(), ex);
    }

    public void remoteDeviceAdded(Registry registry, RemoteDevice device) {
    }

    public void remoteDeviceUpdated(Registry registry, RemoteDevice device) {
    }

    public void remoteDeviceRemoved(Registry registry, RemoteDevice device) {
    }

    public void localDeviceAdded(Registry registry, LocalDevice device) {
    }

    public void localDeviceRemoved(Registry registry, LocalDevice device) {
    }

    public void beforeShutdown(Registry registry) {
        if (!this.availableIPList.isEmpty()) {
            System.out.println("Available BMC members : ");
            for (String ip : this.availableIPList) {
                System.out.println(ip);
            }
        }
        System.out.println("Available IP address numbers : " + this.availableIPList.size() + "\n");
    }

    public void afterShutdown() {
        System.out.println("Shutdown registry complete.");
    }

    public List<String> getAvailableIPList() {
        return this.availableIPList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLogs(GbtLogLevel level, String commandName, String commandID, String messages) {
        AbstractLoggerWriter abstractLoggerWriter = this.logger;
        synchronized (abstractLoggerWriter) {
            this.logger.appendPath(commandName).writeLogs(level, commandID, messages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLogs(GbtLogLevel level, String commandName, String commandID, String messages, Throwable ex) {
        AbstractLoggerWriter abstractLoggerWriter = this.logger;
        synchronized (abstractLoggerWriter) {
            this.logger.appendPath(commandName).writeLogs(level, commandID, messages, ex);
        }
    }
}

