/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.useraccounts;

import com.fasterxml.jackson.annotation.JsonValue;

public enum UserAccountCommandActions {
    UNKNOWN("unknown"),
    LIST("list"),
    SET("set"),
    ENABLE("enable"),
    DISABLE("disable");

    private static final String UNKNOWN_ITEM = "unknown";
    private static final String LIST_ITEM = "list";
    private static final String SET_ITEM = "set";
    private static final String ENABLE_ITEM = "enable";
    private static final String DISABLE_ITEM = "disable";
    private final String item;

    private UserAccountCommandActions(String item) {
        this.item = item;
    }

    public final boolean isListAction() {
        return this == LIST;
    }

    public final boolean isSetAction() {
        return this == SET;
    }

    public final boolean isEnableAction() {
        return this == ENABLE;
    }

    public final boolean isDisableAction() {
        return this == DISABLE;
    }

    @JsonValue
    public String toString() {
        return this.item;
    }

    public static final UserAccountCommandActions parse(String rawString) {
        if (rawString == null) {
            return UNKNOWN;
        }
        switch (rawString.toLowerCase()) {
            case "list": {
                return LIST;
            }
            case "set": {
                return SET;
            }
            case "enable": {
                return ENABLE;
            }
            case "disable": {
                return DISABLE;
            }
        }
        return UNKNOWN;
    }
}

