/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.coding;

import com.veraxsystems.vxipmi.coding.commands.IpmiVersion;
import com.veraxsystems.vxipmi.coding.commands.ResponseData;
import com.veraxsystems.vxipmi.coding.payload.IpmiPayload;
import com.veraxsystems.vxipmi.coding.payload.lan.IPMIException;
import com.veraxsystems.vxipmi.coding.protocol.AuthenticationType;
import com.veraxsystems.vxipmi.coding.protocol.IpmiMessage;
import com.veraxsystems.vxipmi.coding.protocol.Ipmiv15Message;
import com.veraxsystems.vxipmi.coding.protocol.Ipmiv20Message;
import com.veraxsystems.vxipmi.coding.protocol.PayloadType;
import com.veraxsystems.vxipmi.coding.protocol.encoder.Protocolv20Encoder;
import com.veraxsystems.vxipmi.coding.security.CipherSuite;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;

public abstract class PayloadCoder {
    private IpmiVersion ipmiVersion;
    private AuthenticationType authenticationType;
    private CipherSuite cipherSuite;

    public void setIpmiVersion(IpmiVersion ipmiVersion) {
        this.ipmiVersion = ipmiVersion;
    }

    public IpmiVersion getIpmiVersion() {
        return this.ipmiVersion;
    }

    public void setAuthenticationType(AuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
    }

    public AuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public void setCipherSuite(CipherSuite cipherSuite) {
        this.cipherSuite = cipherSuite;
    }

    public CipherSuite getCipherSuite() {
        return this.cipherSuite;
    }

    public PayloadCoder() {
        this.setSessionParameters(IpmiVersion.V20, CipherSuite.getEmpty(), AuthenticationType.RMCPPlus);
    }

    public PayloadCoder(IpmiVersion version, CipherSuite cipherSuite, AuthenticationType authenticationType) {
        this.setSessionParameters(version, cipherSuite, authenticationType);
    }

    public void setSessionParameters(IpmiVersion version, CipherSuite cipherSuite, AuthenticationType authenticationType) {
        if (version == IpmiVersion.V20 && authenticationType != AuthenticationType.RMCPPlus) {
            throw new IllegalArgumentException("Authentication Type must be RMCPPlus for IPMI v2.0 messages");
        }
        this.setIpmiVersion(version);
        this.setAuthenticationType(authenticationType);
        this.setCipherSuite(cipherSuite);
    }

    public IpmiMessage encodePayload(int messageSequenceNumber, int sessionSequenceNumber, int sessionId) throws NoSuchAlgorithmException, InvalidKeyException {
        if (this.getIpmiVersion() == IpmiVersion.V15) {
            return this.encodeV15Payload(messageSequenceNumber, sessionSequenceNumber, sessionId);
        }
        return this.encodeV20Payload(messageSequenceNumber, sessionSequenceNumber, sessionId);
    }

    private Ipmiv15Message encodeV15Payload(int messageSequenceNumber, int sessionSequenceNumber, int sessionId) throws NoSuchAlgorithmException, InvalidKeyException {
        Ipmiv15Message message = new Ipmiv15Message();
        message.setAuthenticationType(this.getAuthenticationType());
        message.setSessionID(sessionId);
        message.setSessionSequenceNumber(sessionSequenceNumber);
        message.setPayload(this.preparePayload(messageSequenceNumber));
        return message;
    }

    private Ipmiv20Message encodeV20Payload(int messageSequenceNumber, int sessionSequenceNumber, int sessionId) throws NoSuchAlgorithmException, InvalidKeyException {
        Ipmiv20Message message = new Ipmiv20Message(this.getCipherSuite().getConfidentialityAlgorithm());
        message.setAuthenticationType(this.getAuthenticationType());
        message.setSessionID(sessionId);
        message.setSessionSequenceNumber(sessionSequenceNumber);
        message.setPayloadType(this.getSupportedPayloadType());
        message.setPayloadAuthenticated(this.getCipherSuite().getIntegrityAlgorithm().getCode() != 0);
        message.setPayloadEncrypted(this.getCipherSuite().getConfidentialityAlgorithm().getCode() != 0);
        message.setPayload(this.preparePayload(messageSequenceNumber));
        message.setAuthCode(this.getCipherSuite().getIntegrityAlgorithm().generateAuthCode(message.getIntegrityAlgorithmBase(new Protocolv20Encoder())));
        return message;
    }

    public abstract PayloadType getSupportedPayloadType();

    protected abstract IpmiPayload preparePayload(int var1) throws NoSuchAlgorithmException, InvalidKeyException;

    public abstract ResponseData getResponseData(IpmiMessage var1) throws IPMIException, NoSuchAlgorithmException, InvalidKeyException;
}

