/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.coding.commands.payload;

import com.veraxsystems.vxipmi.coding.commands.IpmiCommandCoder;
import com.veraxsystems.vxipmi.coding.commands.IpmiVersion;
import com.veraxsystems.vxipmi.coding.commands.ResponseData;
import com.veraxsystems.vxipmi.coding.commands.payload.ActivatePayloadResponseData;
import com.veraxsystems.vxipmi.coding.payload.CompletionCode;
import com.veraxsystems.vxipmi.coding.payload.IpmiPayload;
import com.veraxsystems.vxipmi.coding.payload.lan.IPMIException;
import com.veraxsystems.vxipmi.coding.payload.lan.IpmiLanRequest;
import com.veraxsystems.vxipmi.coding.payload.lan.IpmiLanResponse;
import com.veraxsystems.vxipmi.coding.payload.lan.NetworkFunction;
import com.veraxsystems.vxipmi.coding.protocol.AuthenticationType;
import com.veraxsystems.vxipmi.coding.protocol.IpmiMessage;
import com.veraxsystems.vxipmi.coding.protocol.PayloadType;
import com.veraxsystems.vxipmi.coding.security.CipherSuite;
import com.veraxsystems.vxipmi.common.MessageComposer;
import com.veraxsystems.vxipmi.common.MessageReader;
import com.veraxsystems.vxipmi.common.TypeConverter;

public abstract class ActivatePayload
extends IpmiCommandCoder {
    private static final int REQUEST_DATA_LENGTH = 6;
    private static final int AUXILARY_DATA_LENGTH = 4;
    private static final int INBOUND_PAYLOAD_SIZE_LENGTH = 2;
    private static final int OUTBOUND_PAYLOAD_SIZE_LENGTH = 2;
    private static final int PAYLOAD_UDP_PORT_NUMBER_DATA_LENGTH = 2;
    private static final int PAYLOAD_VLAN_NUMBER_DATA_LENGTH = 2;
    private final int payloadInstance;

    public abstract PayloadType getPayloadType();

    protected ActivatePayload(IpmiVersion ipmiVersion, CipherSuite cipherSuite, AuthenticationType authenticationType, int payloadInstance) {
        super(ipmiVersion, cipherSuite, authenticationType);
        this.payloadInstance = payloadInstance;
    }

    @Override
    public byte getCommandCode() {
        return 72;
    }

    @Override
    public NetworkFunction getNetworkFunction() {
        return NetworkFunction.ApplicationRequest;
    }

    @Override
    protected IpmiPayload preparePayload(int sequenceNumber) {
        byte[] message = MessageComposer.get(6).appendField(TypeConverter.intToByte(this.getPayloadType().getCode())).appendField(TypeConverter.intToByte(this.payloadInstance)).appendField(this.prepareAuxilaryRequestData()).getMessage();
        return new IpmiLanRequest(this.getNetworkFunction(), this.getCommandCode(), message, TypeConverter.intToByte(sequenceNumber));
    }

    protected abstract byte[] prepareAuxilaryRequestData();

    @Override
    public ResponseData getResponseData(IpmiMessage message) throws IPMIException {
        if (!this.isCommandResponse(message)) {
            throw new IllegalArgumentException("This is not a response for Activate Payload command");
        }
        if (!(message.getPayload() instanceof IpmiLanResponse)) {
            throw new IllegalArgumentException("Invalid response payload");
        }
        if (((IpmiLanResponse)message.getPayload()).getCompletionCode() != CompletionCode.Ok) {
            throw new IPMIException(((IpmiLanResponse)message.getPayload()).getCompletionCode());
        }
        MessageReader messageReader = new MessageReader(message.getPayload().getData());
        ActivatePayloadResponseData responseData = this.createEmptyResponse();
        responseData.setAuxilaryInformationData(messageReader.readNextField(4));
        responseData.setInboundPayloadSize(messageReader.readNextField(2));
        responseData.setOutboundPayloadSize(messageReader.readNextField(2));
        responseData.setPayloadUdpPortNumber(messageReader.readNextField(2));
        responseData.setPayloadVlanNumber(messageReader.readNextField(2));
        return responseData;
    }

    protected abstract ActivatePayloadResponseData createEmptyResponse();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActivatePayload that = (ActivatePayload)o;
        if (this.payloadInstance != that.payloadInstance) {
            return false;
        }
        if (this.getPayloadType() != that.getPayloadType()) {
            return false;
        }
        return this.getCipherSuite().equals(that.getCipherSuite());
    }

    public int hashCode() {
        int result = this.payloadInstance;
        result = 31 * result + this.getPayloadType().getCode();
        result = 31 * result + (this.getCipherSuite() != null ? this.getCipherSuite().hashCode() : 0);
        return result;
    }
}

