/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.coding.commands.payload;

import com.veraxsystems.vxipmi.coding.commands.IpmiCommandCoder;
import com.veraxsystems.vxipmi.coding.commands.IpmiVersion;
import com.veraxsystems.vxipmi.coding.commands.ResponseData;
import com.veraxsystems.vxipmi.coding.commands.payload.GetChannelPayloadSupportResponseData;
import com.veraxsystems.vxipmi.coding.payload.CompletionCode;
import com.veraxsystems.vxipmi.coding.payload.IpmiPayload;
import com.veraxsystems.vxipmi.coding.payload.lan.IPMIException;
import com.veraxsystems.vxipmi.coding.payload.lan.IpmiLanRequest;
import com.veraxsystems.vxipmi.coding.payload.lan.IpmiLanResponse;
import com.veraxsystems.vxipmi.coding.payload.lan.NetworkFunction;
import com.veraxsystems.vxipmi.coding.protocol.AuthenticationType;
import com.veraxsystems.vxipmi.coding.protocol.IpmiMessage;
import com.veraxsystems.vxipmi.coding.security.CipherSuite;
import com.veraxsystems.vxipmi.common.TypeConverter;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;

public class GetChannelPayloadSupport
extends IpmiCommandCoder {
    private byte channelNumber;

    public GetChannelPayloadSupport() {
        super(IpmiVersion.V20, new CipherSuite(0, 0, 0, 0), AuthenticationType.RMCPPlus);
    }

    public GetChannelPayloadSupport(byte channelNumber) {
        super(IpmiVersion.V20, new CipherSuite(0, 0, 0, 0), AuthenticationType.RMCPPlus);
        this.setChannelNumber(channelNumber);
    }

    public GetChannelPayloadSupport(byte channelNumber, CipherSuite cipherSuite, AuthenticationType authenticationType) {
        super(IpmiVersion.V20, cipherSuite, authenticationType);
        this.setChannelNumber(channelNumber);
    }

    public byte getChannelNumber() {
        return this.channelNumber;
    }

    public void setChannelNumber(int channelNumber) {
        if (channelNumber < 0 || channelNumber > 15 || channelNumber == 12 || channelNumber == 13) {
            throw new IllegalArgumentException("Invalid channel number");
        }
        this.channelNumber = TypeConverter.intToByte(channelNumber);
    }

    @Override
    public byte getCommandCode() {
        return 78;
    }

    @Override
    public NetworkFunction getNetworkFunction() {
        return NetworkFunction.ApplicationRequest;
    }

    @Override
    protected IpmiPayload preparePayload(int sequenceNumber) {
        byte[] requestData = new byte[]{this.channelNumber};
        return new IpmiLanRequest(this.getNetworkFunction(), this.getCommandCode(), requestData, TypeConverter.intToByte(sequenceNumber));
    }

    @Override
    public ResponseData getResponseData(IpmiMessage message) throws IPMIException, NoSuchAlgorithmException, InvalidKeyException {
        if (!this.isCommandResponse(message)) {
            throw new IllegalArgumentException("This is not a response for Get Payload Info command");
        }
        if (!(message.getPayload() instanceof IpmiLanResponse)) {
            throw new IllegalArgumentException("Invalid response payload");
        }
        if (((IpmiLanResponse)message.getPayload()).getCompletionCode() != CompletionCode.Ok) {
            throw new IPMIException(((IpmiLanResponse)message.getPayload()).getCompletionCode());
        }
        GetChannelPayloadSupportResponseData data = new GetChannelPayloadSupportResponseData();
        byte[] responseData = message.getPayload().getData();
        data.setStandardPayloads(responseData[0]);
        data.setSessionSetupPayloads(responseData[1]);
        data.setOemPayloads(responseData[2]);
        return data;
    }
}

