/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLUtil {
    public static String documentToString(Document document) throws Exception {
        return XMLUtil.documentToString(document, true);
    }

    public static String documentToString(Document document, boolean standalone) throws Exception {
        String prol = "<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"" + (standalone ? "yes" : "no") + "\"?>";
        return prol + XMLUtil.nodeToString(document.getDocumentElement(), new HashSet<String>(), document.getDocumentElement().getNamespaceURI());
    }

    public static String documentToFragmentString(Document document) throws Exception {
        return XMLUtil.nodeToString(document.getDocumentElement(), new HashSet<String>(), document.getDocumentElement().getNamespaceURI());
    }

    /*
     * WARNING - void declaration
     */
    protected static String nodeToString(Node node, Set<String> parentPrefixes, String namespaceURI) throws Exception {
        StringBuilder b = new StringBuilder();
        if (node == null) {
            return "";
        }
        if (node instanceof Element) {
            boolean bl;
            int i;
            Element element = (Element)node;
            b.append("<");
            b.append(element.getNodeName());
            HashMap<String, String> thisLevelPrefixes = new HashMap<String, String>();
            if (element.getPrefix() != null && !parentPrefixes.contains(element.getPrefix())) {
                thisLevelPrefixes.put(element.getPrefix(), element.getNamespaceURI());
            }
            if (element.hasAttributes()) {
                void var7_8;
                NamedNodeMap map = element.getAttributes();
                boolean bl2 = false;
                while (var7_8 < map.getLength()) {
                    Node attr = map.item((int)var7_8);
                    if (!attr.getNodeName().startsWith("xmlns")) {
                        if (attr.getPrefix() != null && !parentPrefixes.contains(attr.getPrefix())) {
                            thisLevelPrefixes.put(attr.getPrefix(), element.getNamespaceURI());
                        }
                        b.append(" ");
                        b.append(attr.getNodeName());
                        b.append("=\"");
                        b.append(attr.getNodeValue());
                        b.append("\"");
                    }
                    ++var7_8;
                }
            }
            if (namespaceURI != null && !thisLevelPrefixes.containsValue(namespaceURI) && !namespaceURI.equals(element.getParentNode().getNamespaceURI())) {
                b.append(" xmlns=\"").append(namespaceURI).append("\"");
            }
            for (Map.Entry entry : thisLevelPrefixes.entrySet()) {
                b.append(" xmlns:").append((String)entry.getKey()).append("=\"").append((String)entry.getValue()).append("\"");
                parentPrefixes.add((String)entry.getKey());
            }
            NodeList children = element.getChildNodes();
            boolean bl3 = true;
            for (i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child.getNodeType() == 2) continue;
                bl = false;
                break;
            }
            if (!bl) {
                b.append(">");
                for (i = 0; i < children.getLength(); ++i) {
                    b.append(XMLUtil.nodeToString(children.item(i), parentPrefixes, children.item(i).getNamespaceURI()));
                }
                b.append("</");
                b.append(element.getNodeName());
                b.append(">");
            } else {
                b.append("/>");
            }
            for (String thisLevelPrefix : thisLevelPrefixes.keySet()) {
                parentPrefixes.remove(thisLevelPrefix);
            }
        } else if (node.getNodeValue() != null) {
            b.append(XMLUtil.encodeText(node.getNodeValue(), node instanceof Attr));
        }
        return b.toString();
    }

    public static String encodeText(String s) {
        return XMLUtil.encodeText(s, true);
    }

    public static String encodeText(String s, boolean encodeQuotes) {
        s = s.replaceAll("&", "&amp;");
        s = s.replaceAll("<", "&lt;");
        s = s.replaceAll(">", "&gt;");
        if (encodeQuotes) {
            s = s.replaceAll("'", "&apos;");
            s = s.replaceAll("\"", "&quot;");
        }
        return s;
    }

    public static Element appendNewElement(Document document, Element parent, Enum el) {
        return XMLUtil.appendNewElement(document, parent, el.toString());
    }

    public static Element appendNewElement(Document document, Element parent, String element) {
        Element child = document.createElement(element);
        parent.appendChild(child);
        return child;
    }

    public static Element appendNewElementIfNotNull(Document document, Element parent, Enum el, Object content) {
        return XMLUtil.appendNewElementIfNotNull(document, parent, el, content, null);
    }

    public static Element appendNewElementIfNotNull(Document document, Element parent, Enum el, Object content, String namespace) {
        return XMLUtil.appendNewElementIfNotNull(document, parent, el.toString(), content, namespace);
    }

    public static Element appendNewElementIfNotNull(Document document, Element parent, String element, Object content) {
        return XMLUtil.appendNewElementIfNotNull(document, parent, element, content, null);
    }

    public static Element appendNewElementIfNotNull(Document document, Element parent, String element, Object content, String namespace) {
        if (content == null) {
            return parent;
        }
        return XMLUtil.appendNewElement(document, parent, element, content, namespace);
    }

    public static Element appendNewElement(Document document, Element parent, String element, Object content) {
        return XMLUtil.appendNewElement(document, parent, element, content, null);
    }

    public static Element appendNewElement(Document document, Element parent, String element, Object content, String namespace) {
        Element childElement = namespace != null ? document.createElementNS(namespace, element) : document.createElement(element);
        if (content != null) {
            childElement.appendChild(document.createTextNode(content.toString()));
        }
        parent.appendChild(childElement);
        return childElement;
    }

    public static String getTextContent(Node node) {
        StringBuffer buffer = new StringBuffer();
        NodeList childList = node.getChildNodes();
        for (int i = 0; i < childList.getLength(); ++i) {
            Node child = childList.item(i);
            if (child.getNodeType() != 3) continue;
            buffer.append(child.getNodeValue());
        }
        return buffer.toString();
    }
}

