/*
 * Decompiled with CFR 0.152.
 */
package org.seamless.util.dbunit;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ReplacementDataSet;
import org.dbunit.dataset.xml.FlatXmlDataSet;
import org.dbunit.operation.DatabaseOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DBUnitOperations
extends ArrayList<Op> {
    private static final Logger log = Logger.getLogger(DBUnitOperations.class.getName());

    public abstract DataSource getDataSource();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        log.info("Executing DBUnit operations: " + this.size());
        IDatabaseConnection con = null;
        try {
            con = this.getConnection();
            this.disableReferentialIntegrity(con);
            for (Op op : this) {
                op.execute(con);
            }
            this.enableReferentialIntegrity(con);
        }
        finally {
            if (con != null) {
                try {
                    con.close();
                }
                catch (Exception ex) {
                    log.log(Level.WARNING, "Failed to close connection after DBUnit operation: " + ex, ex);
                }
            }
        }
    }

    protected IDatabaseConnection getConnection() {
        try {
            DataSource datasource = this.getDataSource();
            Connection con = datasource.getConnection();
            DatabaseConnection dbUnitCon = new DatabaseConnection(con);
            this.editConfig(dbUnitCon.getConfig());
            return dbUnitCon;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected abstract void disableReferentialIntegrity(IDatabaseConnection var1);

    protected abstract void enableReferentialIntegrity(IDatabaseConnection var1);

    protected void editConfig(DatabaseConfig config) {
    }

    public class FileOp
    extends Op {
        public FileOp(String dataLocation) {
            super(dataLocation);
        }

        public FileOp(String dataLocation, String dtdLocation) {
            super(dataLocation, dtdLocation);
        }

        public FileOp(String dataLocation, String dtdLocation, DatabaseOperation operation) {
            super(dataLocation, dtdLocation, operation);
        }

        protected InputStream openStream(String location) {
            try {
                return new FileInputStream(location);
            }
            catch (FileNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static class ClasspathOp
    extends Op {
        public ClasspathOp(String dataLocation) {
            super(dataLocation);
        }

        public ClasspathOp(String dataLocation, String dtdLocation) {
            super(dataLocation, dtdLocation);
        }

        public ClasspathOp(String dataLocation, String dtdLocation, DatabaseOperation operation) {
            super(dataLocation, dtdLocation, operation);
        }

        protected InputStream openStream(String location) {
            return Thread.currentThread().getContextClassLoader().getResourceAsStream(location);
        }
    }

    public static abstract class Op {
        ReplacementDataSet dataSet;
        DatabaseOperation operation;

        public Op(String dataLocation) {
            this(dataLocation, null, DatabaseOperation.CLEAN_INSERT);
        }

        public Op(String dataLocation, String dtdLocation) {
            this(dataLocation, dtdLocation, DatabaseOperation.CLEAN_INSERT);
        }

        public Op(String dataLocation, String dtdLocation, DatabaseOperation operation) {
            try {
                this.dataSet = dtdLocation != null ? new ReplacementDataSet((IDataSet)new FlatXmlDataSet(this.openStream(dataLocation), this.openStream(dtdLocation))) : new ReplacementDataSet((IDataSet)new FlatXmlDataSet(this.openStream(dataLocation)));
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            this.dataSet.addReplacementObject((Object)"[NULL]", null);
            this.operation = operation;
        }

        public IDataSet getDataSet() {
            return this.dataSet;
        }

        public DatabaseOperation getOperation() {
            return this.operation;
        }

        public void execute(IDatabaseConnection connection) {
            try {
                this.operation.execute(connection, (IDataSet)this.dataSet);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        protected abstract InputStream openStream(String var1);
    }
}

