/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.acls.domain;

import org.springframework.security.acls.domain.AclFormattingUtils;
import org.springframework.security.acls.model.Permission;

public abstract class AbstractPermission
implements Permission {
    protected final char code;
    protected int mask;

    protected AbstractPermission(int mask) {
        this.mask = mask;
        this.code = (char)42;
    }

    protected AbstractPermission(int mask, char code) {
        this.mask = mask;
        this.code = code;
    }

    public final boolean equals(Object arg0) {
        if (arg0 == null) {
            return false;
        }
        if (!(arg0 instanceof Permission)) {
            return false;
        }
        Permission rhs = (Permission)arg0;
        return this.mask == rhs.getMask();
    }

    public final int getMask() {
        return this.mask;
    }

    public String getPattern() {
        return AclFormattingUtils.printBinary(this.mask, this.code);
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "[" + this.getPattern() + "=" + this.mask + "]";
    }

    public final int hashCode() {
        return this.mask;
    }
}

