/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.protocol.sync;

import java.util.List;
import java.util.logging.Logger;
import org.fourthline.cling.UpnpService;
import org.fourthline.cling.model.NetworkAddress;
import org.fourthline.cling.model.gena.RemoteGENASubscription;
import org.fourthline.cling.model.message.StreamRequestMessage;
import org.fourthline.cling.model.message.StreamResponseMessage;
import org.fourthline.cling.model.message.UpnpResponse;
import org.fourthline.cling.model.message.gena.IncomingSubscribeResponseMessage;
import org.fourthline.cling.model.message.gena.OutgoingSubscribeRequestMessage;
import org.fourthline.cling.model.meta.RemoteService;
import org.fourthline.cling.protocol.SendingSync;
import org.fourthline.cling.transport.RouterException;

public class SendingSubscribe
extends SendingSync<OutgoingSubscribeRequestMessage, IncomingSubscribeResponseMessage> {
    private static final Logger log = Logger.getLogger(SendingSubscribe.class.getName());
    protected final RemoteGENASubscription subscription;

    public SendingSubscribe(UpnpService upnpService, RemoteGENASubscription subscription, List<NetworkAddress> activeStreamServers) {
        super(upnpService, new OutgoingSubscribeRequestMessage(subscription, subscription.getEventCallbackURLs(activeStreamServers, upnpService.getConfiguration().getNamespace()), upnpService.getConfiguration().getEventSubscriptionHeaders((RemoteService)subscription.getService())));
        this.subscription = subscription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IncomingSubscribeResponseMessage executeSync() throws RouterException {
        if (!((OutgoingSubscribeRequestMessage)this.getInputMessage()).hasCallbackURLs()) {
            log.fine("Subscription failed, no active local callback URLs available (network disabled?)");
            this.getUpnpService().getConfiguration().getRegistryListenerExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    SendingSubscribe.this.subscription.fail(null);
                }
            });
            return null;
        }
        log.fine("Sending subscription request: " + this.getInputMessage());
        try {
            this.getUpnpService().getRegistry().registerPendingRemoteSubscription(this.subscription);
            StreamResponseMessage response = null;
            try {
                response = this.getUpnpService().getRouter().send((StreamRequestMessage)this.getInputMessage());
            }
            catch (RouterException ex) {
                this.onSubscriptionFailure();
                IncomingSubscribeResponseMessage incomingSubscribeResponseMessage = null;
                this.getUpnpService().getRegistry().unregisterPendingRemoteSubscription(this.subscription);
                return incomingSubscribeResponseMessage;
            }
            if (response == null) {
                this.onSubscriptionFailure();
                IncomingSubscribeResponseMessage ex = null;
                return ex;
            }
            final IncomingSubscribeResponseMessage responseMessage = new IncomingSubscribeResponseMessage(response);
            if (((UpnpResponse)response.getOperation()).isFailed()) {
                log.fine("Subscription failed, response was: " + responseMessage);
                this.getUpnpService().getConfiguration().getRegistryListenerExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        SendingSubscribe.this.subscription.fail((UpnpResponse)responseMessage.getOperation());
                    }
                });
            } else if (!responseMessage.isValidHeaders()) {
                log.severe("Subscription failed, invalid or missing (SID, Timeout) response headers");
                this.getUpnpService().getConfiguration().getRegistryListenerExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        SendingSubscribe.this.subscription.fail((UpnpResponse)responseMessage.getOperation());
                    }
                });
            } else {
                log.fine("Subscription established, adding to registry, response was: " + response);
                this.subscription.setSubscriptionId(responseMessage.getSubscriptionId());
                this.subscription.setActualSubscriptionDurationSeconds(responseMessage.getSubscriptionDurationSeconds());
                this.getUpnpService().getRegistry().addRemoteSubscription(this.subscription);
                this.getUpnpService().getConfiguration().getRegistryListenerExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        SendingSubscribe.this.subscription.establish();
                    }
                });
            }
            IncomingSubscribeResponseMessage incomingSubscribeResponseMessage = responseMessage;
            return incomingSubscribeResponseMessage;
        }
        finally {
            this.getUpnpService().getRegistry().unregisterPendingRemoteSubscription(this.subscription);
        }
    }

    protected void onSubscriptionFailure() {
        log.fine("Subscription failed");
        this.getUpnpService().getConfiguration().getRegistryListenerExecutor().execute(new Runnable(){

            @Override
            public void run() {
                SendingSubscribe.this.subscription.fail(null);
            }
        });
    }
}

