/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.redfish;

import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.JacksonCommonUtil;
import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.core.receivers.RESTClientReceiver;
import Gbt.core.redfish.RedfishApiOptions;
import Gbt.core.redfish.RedfishApiPayload;
import Gbt.core.redfish.RedfishCommonProperties;
import Gbt.core.redfish.RedfishResourceTypes;
import Gbt.core.redfish.RedfishSchemasManager;
import Gbt.core.rest.RESTException;
import Gbt.core.rest.RESTHttpMethods;
import Gbt.core.rest.RESTProtocolHeaders;
import Gbt.core.rest.RESTRequest;
import Gbt.core.rest.RESTRequestImpl;
import Gbt.utility.bmcinfo.BMCVendor;
import Gbt.utility.redfish.RestFullResponseData;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.LogLevel;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchema;
import com.veraxsystems.vxipmi.api.async.ConnectionHandle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Response;

public abstract class RedfishApiService<T extends RedfishApiPayload<T, ? extends RedfishApiOptions>> {
    protected final T servicePayload;
    protected String logDirPath;
    protected String serviceLogsId;
    protected final AbstractLoggerWriter loggerWriter;
    protected final RESTClientReceiver restReceiver;
    protected final GbtIPMICommandReceiver ipmiReceiver;
    protected JsonNode requestBody;
    protected List<AbstractJSONPOJO> responseData;

    protected RedfishApiService(T servicePayload) {
        this.servicePayload = servicePayload;
        this.logDirPath = "redfish";
        this.serviceLogsId = ((RedfishApiPayload)this.servicePayload).ipAddress + "_" + this.logDirPath + "_" + this.getServiceName();
        this.loggerWriter = ((RedfishApiPayload)this.servicePayload).loggerWriter;
        this.restReceiver = RESTClientReceiver.getInstance();
        this.ipmiReceiver = GbtIPMICommandReceiver.getInstance();
        this.responseData = new ArrayList<AbstractJSONPOJO>();
    }

    public abstract String getServiceName();

    protected abstract boolean checkRawArgs();

    protected abstract boolean checkPayLoad();

    public abstract boolean execute();

    public void setLogDirPath(String logDirPath) {
        this.logDirPath = logDirPath;
        this.serviceLogsId = ((RedfishApiPayload)this.servicePayload).ipAddress + "_" + this.logDirPath + "_" + this.getServiceName();
    }

    public String getServiceLogsId() {
        return this.serviceLogsId;
    }

    protected boolean uploadFileValidation(RedfishResourceTypes redfishType) {
        switch (redfishType) {
            case Ignore: {
                try {
                    this.requestBody = JacksonCommonUtil.getUtil().readRootNode(((RedfishApiPayload)this.servicePayload).uploadJsonFile);
                    return true;
                }
                catch (IOException ioe) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((RedfishApiPayload)this.servicePayload).ipAddress + "] Cannot upload json data, or file not exist.");
                    return false;
                }
            }
        }
        try {
            this.requestBody = JacksonCommonUtil.getUtil().readRootNode(((RedfishApiPayload)this.servicePayload).uploadJsonFile);
            return true;
        }
        catch (IOException ioe) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((RedfishApiPayload)this.servicePayload).ipAddress + "] Cannot upload json data, or file not exist.");
            return false;
        }
    }

    protected boolean uploadDataValidation(RedfishResourceTypes redfishType, AbstractJSONPOJO uploadData) {
        switch (redfishType) {
            case Ignore: {
                this.requestBody = JacksonCommonUtil.getUtil().readRootNode(uploadData);
                return true;
            }
        }
        try {
            JsonSchema schema = RedfishSchemasManager.getManager().getSchema(redfishType);
            this.requestBody = JacksonCommonUtil.getUtil().readRootNode(uploadData);
            ProcessingReport reports = JacksonCommonUtil.getUtil().validateJson(schema, this.requestBody);
            if (!reports.isSuccess()) {
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((RedfishApiPayload)this.servicePayload).ipAddress + "] Upload instance data is invalid.");
                for (ProcessingMessage report : reports) {
                    if (!report.getLogLevel().equals((Object)LogLevel.ERROR)) continue;
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((RedfishApiPayload)this.servicePayload).ipAddress + "] " + report.getMessage());
                }
                return false;
            }
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, this.serviceLogsId, "[" + ((RedfishApiPayload)this.servicePayload).ipAddress + "] Upload instance data is valid.");
            return true;
        }
        catch (ProcessingException excp) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((RedfishApiPayload)this.servicePayload).ipAddress + "] Cannot parse the json schema.");
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((RedfishApiPayload)this.servicePayload).ipAddress + "] " + excp.getProcessingMessage().getMessage());
            return false;
        }
    }

    protected RESTProtocolHeaders getProtocol() {
        ConnectionHandle handle = this.ipmiReceiver.createIPMIConnection(((RedfishApiPayload)this.servicePayload).getIpAddress(), "admin", "password", this.logDirPath, this.serviceLogsId);
        if (handle == null) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((RedfishApiPayload)this.servicePayload).getIpAddress() + "] IPMI connection fail.");
            this.ipmiReceiver.closeIPMIConnection(handle, this.logDirPath, this.serviceLogsId);
            return null;
        }
        BMCVendor vendor = this.ipmiReceiver.getBmcVendor(handle, this.logDirPath, this.serviceLogsId);
        this.ipmiReceiver.closeIPMIConnection(handle, this.logDirPath, this.serviceLogsId);
        if (vendor == BMCVendor.OPENBMC) {
            return RESTProtocolHeaders.HTTP;
        }
        return RESTProtocolHeaders.HTTPS;
    }

    protected String getETag(RESTProtocolHeaders protocolHeader, Client client, String resourceUri) {
        String etag = null;
        try {
            RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((RedfishApiPayload)this.servicePayload).getIpAddress())).setProtocolHeader(protocolHeader)).setPort(((RedfishApiPayload)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.GET)).setContentType("application/json")).setServiceURI(resourceUri).build();
            Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
            etag = response.getHeaderString("ETag");
        }
        catch (RESTException e) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((RedfishApiPayload)this.servicePayload).getIpAddress() + "] Cannot get etag.", e);
        }
        return etag;
    }

    public final boolean requestValidation() {
        if (((RedfishApiPayload)this.servicePayload).restRawArgs != null) {
            return this.checkRawArgs();
        }
        return this.checkPayLoad();
    }

    public final List<AbstractJSONPOJO> getResponseData() {
        return this.responseData;
    }

    public static final boolean isRedfishErrorResponse(JsonNode rootNode) {
        if (rootNode == null) {
            return false;
        }
        return rootNode.get(RedfishCommonProperties.ERROR.toString()) != null;
    }

    public static final boolean isRedfishErrorResponse(RestFullResponseData responseData) {
        return RedfishApiService.isRedfishErrorResponse(responseData.getResponseBody());
    }

    public static final List<String> getAllMembers(JsonNode rootNode) {
        ArrayList<String> members = new ArrayList<String>();
        if (rootNode == null) {
            return members;
        }
        if (rootNode.get(RedfishCommonProperties.MEMBERS.toString()) == null) {
            return members;
        }
        if (!rootNode.get(RedfishCommonProperties.MEMBERS.toString()).isArray()) {
            return members;
        }
        Iterator itar = rootNode.get(RedfishCommonProperties.MEMBERS.toString()).elements();
        while (itar.hasNext()) {
            members.add(((JsonNode)itar.next()).get(RedfishCommonProperties.ODATA_ID.toString()).asText());
        }
        return members;
    }

    public static final List<String> getAllMembers(RestFullResponseData responseData) {
        return RedfishApiService.getAllMembers(responseData.getResponseBody());
    }

    public static final Map<String, String> getAllSubResourceIds(JsonNode rootNode) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (rootNode == null) {
            return map;
        }
        Iterator rootFieldNames = rootNode.fieldNames();
        while (rootFieldNames.hasNext()) {
            String rootfieldName = (String)rootFieldNames.next();
            map.putAll(RedfishApiService.recursiveSearchJsonNode(rootfieldName, rootNode.get(rootfieldName), RedfishCommonProperties.ODATA_ID.toString()));
        }
        return map;
    }

    public static final Map<String, String> getAllSubResourceIds(RestFullResponseData responseData) {
        return RedfishApiService.getAllSubResourceIds(responseData.getResponseBody());
    }

    public static final Map<String, String> getAllActionTargets(JsonNode rootNode) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (rootNode == null) {
            return map;
        }
        Iterator rootFieldNames = rootNode.fieldNames();
        while (rootFieldNames.hasNext()) {
            String rootfieldName = (String)rootFieldNames.next();
            map.putAll(RedfishApiService.recursiveSearchJsonNode(rootfieldName, rootNode.get(rootfieldName), RedfishCommonProperties.TARGET.toString()));
        }
        return map;
    }

    public static final Map<String, String> getAllActionTargets(RestFullResponseData responseData) {
        return RedfishApiService.getAllActionTargets(responseData.getResponseBody());
    }

    private static final Map<String, String> recursiveSearchJsonNode(String fieldName, JsonNode fieldNode, String searchKey) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (fieldNode == null) {
            return map;
        }
        switch (fieldNode.getNodeType()) {
            case OBJECT: {
                JsonNode nextFieldNode = fieldNode.get(searchKey);
                if (nextFieldNode == null) {
                    Iterator nextFieldNames = fieldNode.fieldNames();
                    while (nextFieldNames.hasNext()) {
                        String nextFieldName = (String)nextFieldNames.next();
                        map.putAll(RedfishApiService.recursiveSearchJsonNode(nextFieldName, fieldNode.get(nextFieldName), searchKey));
                    }
                    return map;
                }
                switch (nextFieldNode.getNodeType()) {
                    case STRING: {
                        map.put(fieldName, nextFieldNode.asText());
                        return map;
                    }
                }
                return map;
            }
        }
        return map;
    }
}

