/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.vmedia.redirection;

import Gbt.core.vmedia.data.KvmSessionToken;
import Gbt.core.vmedia.data.VmediaInstanceConfig;
import Gbt.core.vmedia.redirection.CdromIsoRedirection;
import Gbt.core.vmedia.redirection.HarddiskRedir;
import java.io.File;
import javax.ws.rs.client.Client;

public class IusbRedirectionManager {
    public static final byte AUTH_USER_PKT_SIZE = 98;
    public static final short WEB_AUTH_PKT_MAX_SIZE = 98;
    public static final short SSI_AUTH_PKT_MAX_SIZE = 210;
    public static final int DEVICE_REDIR_STATUS_IDLE = 0;
    public static final int DEVICE_REDIR_STATUS_CONNECTED = 1;
    public static final int JVIEWER = 2;
    public static final int VMAPP = 4;
    public static final int MAX_IMAGE_LENGTH = 256;
    public static final int DEVICE_INFO_MAX_SIZE = 260;
    public static final byte STOP_NORMAL = 0;
    public static final byte STOP_ON_EJECT = 1;
    public static final byte STOP_ON_TERMINATE = 2;
    public static final byte STOP_ON_DEVICE_REMOVAL = 3;
    public static final byte STOP_ON_SERVER_RESTART = 4;
    public static final byte STOP_ON_CONNECTION_LOSS = 5;
    public static final byte STOP_PORT_NOT_IN_LISTEN = 6;
    public static final byte DEVICE_USED = 0;
    public static final byte DEVICE_FREE = 1;
    public static final int CONNECTION_ACCEPTED = 1;
    public static final int CONNECTION_PERM_DENIED = 5;
    public static final int CONNECTION_INVALID_SESSION_TOKEN = 3;
    public static final int CONNECTION_MAX_USER = 8;
    public static final int LICENSE_EXPIRED = 13;
    public static final int LINUX_DRIVE_TYPE_USB = 0;
    public static final int LINUX_DRIVE_TYPE_HDD = 1;
    public static final int WINDOWS_DRIVE_TYPE_USB = 2;
    public static final int WINDOWS_DRIVE_TYPE_HDD = 3;
    public static final byte MEDIA_TYPE_HDD = 0;
    public static final byte MEDIA_TYPE_USB = -128;
    private CdromIsoRedirection[] cdromSession;
    private HarddiskRedir[] hardDiskSession;
    private boolean cdButtonRedirState = false;
    private boolean hdButtonRedirState = false;

    public IusbRedirectionManager(VmediaInstanceConfig vmediaInstanceConfig) {
        this.cdromSession = new CdromIsoRedirection[vmediaInstanceConfig.getCdromNumber()];
        this.hardDiskSession = new HarddiskRedir[vmediaInstanceConfig.getHddNumber()];
    }

    public boolean StartISORedir(Client client, KvmSessionToken kvmSessionToken, String host, File isoImagePath, int port, int cddevice_no) {
        try {
            if (this.cdromSession[cddevice_no] != null) {
                if (this.cdromSession[cddevice_no].isRedirActive()) {
                    return false;
                }
                this.cdromSession[cddevice_no] = null;
                System.gc();
            }
            this.cdromSession[cddevice_no] = new CdromIsoRedirection(false);
            if (!this.cdromSession[cddevice_no].startRedirection(client, kvmSessionToken, host, isoImagePath, port, cddevice_no)) {
                System.out.println("Mount vmedia fail");
                this.cdromSession[cddevice_no].setErrorMessage(" ");
                this.StopISORedir(cddevice_no, 0);
                return false;
            }
        }
        catch (UnsatisfiedLinkError e) {
            System.out.println("6_8_IUBREDIR 6_12_IUSBREDIR");
            this.StopISORedir(cddevice_no, 0);
            return false;
        }
        catch (Exception e) {
            System.out.println("6_8_IUSBREDIR " + e.getMessage());
            this.StopISORedir(cddevice_no, 0);
            return false;
        }
        return true;
    }

    public boolean StopISORedir(int cddevice_no, int stopMode) {
        int ret = 0;
        if (this.cdromSession[cddevice_no] != null) {
            if (!this.cdromSession[cddevice_no].stopRedirection()) {
                return false;
            }
            if (this.cdromSession[cddevice_no].getCdReconnect()) {
                return true;
            }
            ret = this.cdromSession[cddevice_no].getCdStopMode();
            if (ret != 6) {
                this.setCDStopMode(stopMode, cddevice_no);
            }
            this.cdromSession[cddevice_no] = null;
            System.gc();
        }
        return true;
    }

    public boolean isCDROMPhysicalDrive(int cddevice_no) {
        return this.cdromSession[cddevice_no] != null && this.cdromSession[cddevice_no].isPhysicalDevice();
    }

    public boolean isHarddiskPhysicalDrive(int device_no) {
        return this.hardDiskSession[device_no] != null && this.hardDiskSession[device_no].isPhysicalDevice();
    }

    public void stopCDROMAbnormal(int device_no) {
        try {
            System.gc();
            this.cdromSession[device_no].setCdromRedirStatus(0);
            this.cdromSession[device_no] = null;
        }
        catch (ArrayIndexOutOfBoundsException aie) {
            System.gc();
            System.out.println(aie.getMessage());
        }
    }

    public void stopHarddiskAbnormal(int device_no) {
        try {
            System.gc();
            this.hardDiskSession[device_no].setHarddiskRedirStatus(0);
            this.hardDiskSession[device_no] = null;
        }
        catch (ArrayIndexOutOfBoundsException aie) {
            System.gc();
            System.out.println(aie.getMessage());
        }
    }

    public int getCdromIsoRedirectionStatus(int device_no) {
        int ret = 0;
        try {
            if (this.cdromSession[device_no] != null) {
                ret = this.cdromSession[device_no].getCdromRedirStatus();
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            ret = 0;
        }
        return ret;
    }

    public int getHarddiskRedirStatus(int device_no) {
        int ret = 0;
        try {
            if (this.hardDiskSession[device_no] != null) {
                ret = this.hardDiskSession[device_no].getHarddiskRedirStatus();
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            ret = 0;
        }
        return ret;
    }

    public String getCDROMSource(int cddevice_no) {
        if (this.cdromSession[cddevice_no] != null) {
            return this.cdromSession[cddevice_no].getSourceDrive().getAbsolutePath();
        }
        return "";
    }

    public String getHarddiskSource(int device_no) {
        if (this.hardDiskSession[device_no] != null) {
            return this.hardDiskSession[device_no].getSourceDrive();
        }
        return "";
    }

    public int getCDROMReadBytes(int cddevice_no) {
        if (this.cdromSession[cddevice_no] != null) {
            return this.cdromSession[cddevice_no].getBytesRedirected();
        }
        return 0;
    }

    public int getHarddiskReadBytes(int device_no) {
        if (this.hardDiskSession[device_no] != null) {
            return this.hardDiskSession[device_no].getBytesRedirected();
        }
        return 0;
    }

    public CdromIsoRedirection getCdromSession(int cddevice_no) {
        CdromIsoRedirection cdROMSession = null;
        if (cddevice_no < this.cdromSession.length) {
            cdROMSession = this.cdromSession[cddevice_no];
        }
        return cdROMSession;
    }

    public void setCdromSession(CdromIsoRedirection cdromSession, int cddevice_no) {
        this.cdromSession[cddevice_no] = cdromSession;
    }

    public HarddiskRedir getHarddiskSession(int device_no) {
        HarddiskRedir hardDiskRedir = null;
        if (device_no < this.hardDiskSession.length) {
            hardDiskRedir = this.hardDiskSession[device_no];
        }
        return hardDiskRedir;
    }

    public void setHarddiskSession(HarddiskRedir harddiskSession, int device_no) {
        this.hardDiskSession[device_no] = harddiskSession;
    }

    public int getCDInstanceNumber(int devNum) {
        return this.cdromSession[devNum].getCdInstanceNum();
    }

    public int getHDInstanceNumber(int devNum) {
        return this.hardDiskSession[devNum].getHdInstanceNum();
    }

    public int getCDROMDeviceStatus(int instanceNum) {
        int ret = 1;
        try {
            if (this.cdromSession[instanceNum] != null) {
                ret = this.cdromSession[instanceNum].getCdROMDeviceStatus();
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            ret = 1;
        }
        return ret;
    }

    public void setCDROMDeviceStatus(int instanceNum, int deviceStatus) {
        try {
            this.cdromSession[instanceNum].setCdROMDeviceStatus(deviceStatus);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public int getHardDiskDeviceStatus(int instanceNum) {
        int ret = 1;
        try {
            if (this.hardDiskSession[instanceNum] != null) {
                ret = this.hardDiskSession[instanceNum].getHardDiskDeviceStatus();
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            ret = 1;
        }
        return ret;
    }

    public void setHardDiskDeviceStatus(int instanceNum, int deviceStatus) {
        try {
            this.hardDiskSession[instanceNum].setHardDiskDeviceStatus(deviceStatus);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public int getCDStopMode(int index) {
        int ret;
        try {
            if (this.cdromSession[index] == null) {
                return 0;
            }
            ret = this.cdromSession[index].getCdStopMode();
        }
        catch (Exception aie) {
            aie.printStackTrace();
            ret = 0;
        }
        return ret;
    }

    public void setCDStopMode(int mode, int index) {
        try {
            this.cdromSession[index].setCdStopMode(mode);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.cdromSession[index].setCdStopMode(0);
        }
    }

    public int getHDStopMode(int index) {
        int ret;
        try {
            if (this.hardDiskSession[index] == null) {
                return 0;
            }
            ret = this.hardDiskSession[index].getHdStopMode();
        }
        catch (Exception e) {
            ret = 0;
        }
        return ret;
    }

    public void setHDStopMode(int mode, int index) {
        try {
            this.hardDiskSession[index].setHdStopMode(mode);
        }
        catch (Exception e) {
            this.hardDiskSession[index].setHdStopMode(0);
        }
    }
}

