/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.CUPS;

import Gbt.core.ipmi.GbtIPMIOptions;
import Gbt.core.ipmi.GbtIpmiCommandResponseData;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.utility.CUPS.CUPSCommand;
import Gbt.utility.CUPS.CUPSReadingData;
import Gbt.utility.Common.GIGABYTEChecksum;
import com.veraxsystems.vxipmi.common.TypeConverter;

public enum CUPSIPMIOptions implements GbtIPMIOptions<CUPSCommand.Builder>
{
    GET_INDEX(0, "Index"),
    GET_CPU(1, "CPU"),
    GET_MEMORY(2, "Memory"),
    GET_IO(3, "I/O"),
    GET_CUSTOM(4, "Custom");

    private static final byte NET_FN = 6;
    private static final byte CMD = 52;
    private static final String GET_INDEX_VALUE = "Index";
    private static final String GET_CPU_READING = "CPU";
    private static final String GET_MEMORY_READING = "Memory";
    private static final String GET_IO_READING = "I/O";
    private static final String GET_CUSTOM_READING = "Custom";
    private final int optionCode;
    private final String item;

    private CUPSIPMIOptions(int optionCode, String item) {
        this.optionCode = optionCode;
        this.item = item;
    }

    @Override
    public int getOptionCode() {
        return this.optionCode;
    }

    @Override
    public String getItem() {
        return this.item;
    }

    @Override
    public byte getNetFn() {
        return 6;
    }

    @Override
    public byte getCommandCode() {
        return 52;
    }

    @Override
    public byte[] rebuildRequestData(CUPSCommand.Builder commandArgs) {
        switch (this) {
            case GET_INDEX: {
                int netFn = 46;
                byte cmdCode = 101;
                return GIGABYTEChecksum.getChecksumIPMIReq(new byte[]{70, 44, (byte)(netFn << 2), 28, 32, 0, cmdCode}, new byte[]{87, 1, 0, 1});
            }
            case GET_CPU: {
                int netFn = 4;
                byte cmdCode = 45;
                int sensorNum = -66;
                return GIGABYTEChecksum.getChecksumIPMIReq(new byte[]{70, 44, (byte)(netFn << 2), 28, 32, 0, cmdCode}, new byte[]{(byte)(sensorNum & 0xFF)});
            }
            case GET_MEMORY: {
                int netFn = 4;
                byte cmdCode = 45;
                int sensorNum = -64;
                return GIGABYTEChecksum.getChecksumIPMIReq(new byte[]{70, 44, (byte)(netFn << 2), 28, 32, 0, cmdCode}, new byte[]{(byte)(sensorNum & 0xFF)});
            }
            case GET_IO: {
                int netFn = 4;
                byte cmdCode = 45;
                int sensorNum = -65;
                return GIGABYTEChecksum.getChecksumIPMIReq(new byte[]{70, 44, (byte)(netFn << 2), 28, 32, 0, cmdCode}, new byte[]{(byte)(sensorNum & 0xFF)});
            }
            case GET_CUSTOM: {
                int netFn = 4;
                byte cmdCode = 45;
                byte sensorNum = (byte)commandArgs.getSensorNumber();
                return GIGABYTEChecksum.getChecksumIPMIReq(new byte[]{70, 44, (byte)(netFn << 2), 28, 32, 0, cmdCode}, new byte[]{(byte)(sensorNum & 0xFF)});
            }
        }
        return null;
    }

    @Override
    public AbstractJSONPOJO parserResponseData(GbtIpmiCommandResponseData gbtResponseData) {
        byte[] resp = gbtResponseData.getAllResponseData();
        CUPSReadingData cupsReadingData = new CUPSReadingData();
        switch (this) {
            case GET_INDEX: {
                if (gbtResponseData.isHasResponseData()) {
                    return cupsReadingData.setRawData(resp).setSensorName(GET_INDEX_VALUE).setSensorNumber(0).setSensorReading(TypeConverter.byteToInt(resp[3])).setSensorStatus(0);
                }
                return cupsReadingData.setSensorName(GET_INDEX_VALUE).setSensorNumber(0).setSensorReading(0).setSensorStatus(0);
            }
            case GET_CPU: {
                if (gbtResponseData.isHasResponseData()) {
                    return cupsReadingData.setRawData(resp).setSensorName(GET_CPU_READING).setSensorNumber(TypeConverter.byteToInt((byte)-66)).setSensorReading(TypeConverter.byteToInt(resp[0])).setSensorStatus(TypeConverter.byteToInt(resp[1]) & 0x20);
                }
                return cupsReadingData.setSensorName(GET_CPU_READING).setSensorNumber(TypeConverter.byteToInt((byte)-66)).setSensorReading(0).setSensorStatus(0);
            }
            case GET_MEMORY: {
                if (gbtResponseData.isHasResponseData()) {
                    return cupsReadingData.setRawData(resp).setSensorName(GET_MEMORY_READING).setSensorNumber(TypeConverter.byteToInt((byte)-64)).setSensorReading(TypeConverter.byteToInt(resp[0])).setSensorStatus(TypeConverter.byteToInt(resp[1]) & 0x20);
                }
                return cupsReadingData.setSensorName(GET_MEMORY_READING).setSensorNumber(TypeConverter.byteToInt((byte)-64)).setSensorReading(0).setSensorStatus(0);
            }
            case GET_IO: {
                if (gbtResponseData.isHasResponseData()) {
                    return cupsReadingData.setRawData(resp).setSensorName(GET_IO_READING).setSensorNumber(TypeConverter.byteToInt((byte)-65)).setSensorReading(TypeConverter.byteToInt(resp[0])).setSensorStatus(TypeConverter.byteToInt(resp[1]) & 0x20);
                }
                return cupsReadingData.setSensorName(GET_IO_READING).setSensorNumber(TypeConverter.byteToInt((byte)-65)).setSensorReading(0).setSensorStatus(0);
            }
            case GET_CUSTOM: {
                if (gbtResponseData.isHasResponseData()) {
                    return cupsReadingData.setRawData(resp).setSensorName(GET_CUSTOM_READING).setSensorReading(TypeConverter.byteToInt(resp[0])).setSensorStatus(TypeConverter.byteToInt(resp[1]) & 0x20);
                }
                return cupsReadingData.setSensorName(GET_CUSTOM_READING).setSensorReading(0).setSensorStatus(0);
            }
        }
        return new NullJSONData().setMessages("Unknown CUPS IPMI command option.").setError(true);
    }
}

