/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.IKVM;

import Gbt.utility.Common.CommonFunction;
import java.io.File;

public final class JNLPBase {
    private JNLPBase() {
    }

    public static final File getJNLPFileName(String IP) {
        return new File(IP.replaceAll(":", "_") + "_viewer.jnlp");
    }

    public static final String getVertivJNLPContent(String IP, boolean isAST2500, String username, String password) {
        String hostIP;
        StringBuilder jnlpContent = new StringBuilder();
        hostIP = CommonFunction.isIPv6(IP) ? (hostIP = "[" + IP + "]") : IP;
        jnlpContent.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append("\n");
        jnlpContent.append("<jnlp codebase=\"https://").append(hostIP).append(":443/\" spec=\"1.0+\">").append("\n");
        jnlpContent.append("<information>").append("\n");
        jnlpContent.append("<title>Virtual KVM Client</title>").append("\n");
        jnlpContent.append("<vendor>Avocent Corporation</vendor>").append("\n");
        jnlpContent.append("<icon href=\"https://").append(hostIP).append(":443/images/logo.gif\" kind=\"splash\"/>").append("\n");
        jnlpContent.append("<shortcut online=\"true\"/>").append("\n");
        jnlpContent.append("</information>").append("\n");
        if (isAST2500) {
            jnlpContent.append("<application-desc main-class=\"com.avocent.client.kvm.Main\">").append("\n");
        } else {
            jnlpContent.append("<application-desc main-class=\"com.avocent.kvm.client.Main\">").append("\n");
        }
        jnlpContent.append("<argument>title=- ").append(IP).append("</argument>").append("\n");
        jnlpContent.append("<argument>ip=").append(IP).append("</argument>").append("\n");
        if (isAST2500) {
            jnlpContent.append("<argument>platform=ast2500</argument>").append("\n");
        } else {
            jnlpContent.append("<argument>platform=ast2400</argument>").append("\n");
        }
        jnlpContent.append("<argument>vmprivilege=true</argument>").append("\n");
        jnlpContent.append("<argument>user=").append(username).append("</argument>").append("\n");
        jnlpContent.append("<argument>passwd=").append(password).append("</argument>").append("\n");
        jnlpContent.append("<argument>kmport=2068</argument>").append("\n");
        jnlpContent.append("<argument>vport=2068</argument>").append("\n");
        jnlpContent.append("<argument>apcp=1</argument>").append("\n");
        jnlpContent.append("<argument>version=2</argument>").append("\n");
        jnlpContent.append("<argument>platform=ASPEED</argument>").append("\n");
        jnlpContent.append("<argument>color=0</argument>").append("\n");
        jnlpContent.append("<argument>chat=1</argument>").append("\n");
        jnlpContent.append("<argument>softkeys=1</argument>").append("\n");
        jnlpContent.append("<argument>statusbar=ip,un,fr,bw,kp,led</argument>").append("\n");
        jnlpContent.append("<argument>power=1</argument>").append("\n");
        jnlpContent.append("<argument>language=en</argument>").append("\n");
        if (isAST2500) {
            jnlpContent.append("<argument>VM=1</argument>").append("\n");
            jnlpContent.append("<argument>scaling=15</argument>").append("\n");
        }
        jnlpContent.append("</application-desc>").append("\n");
        jnlpContent.append("<security>").append("\n");
        jnlpContent.append("<all-permissions/>").append("\n");
        jnlpContent.append("</security>").append("\n");
        jnlpContent.append("<resources>").append("\n");
        jnlpContent.append("<j2se version=\"1.6 1.5 1.4+\"/>").append("\n");
        jnlpContent.append("<jar href=\"https://").append(hostIP).append(":443/software/avctKVM.jar\" download=\"eager\" main=\"true\" />").append("\n");
        jnlpContent.append("</resources>").append("\n");
        jnlpContent.append("<resources os=\"Windows\" arch=\"x86\">").append("\n");
        jnlpContent.append("<nativelib href=\"https://").append(hostIP).append(":443/software/avctKVMIOWin32.jar\" download=\"eager\"/>").append("\n");
        jnlpContent.append("</resources>").append("\n");
        jnlpContent.append("<resources os=\"Windows\" arch=\"amd64\">").append("\n");
        jnlpContent.append("<nativelib href=\"https://").append(hostIP).append(":443/software/avctKVMIOWin64.jar\" download=\"eager\"/>").append("\n");
        jnlpContent.append("</resources>").append("\n");
        jnlpContent.append("<resources os=\"Windows\" arch=\"x86_64\">").append("\n");
        jnlpContent.append("<nativelib href=\"https://").append(hostIP).append(":443/software/avctKVMIOWin64.jar\" download=\"eager\"/>").append("\n");
        jnlpContent.append("</resources>").append("\n");
        jnlpContent.append("<resources os=\"Linux\" arch=\"x86\">").append("\n");
        jnlpContent.append("<nativelib href=\"https://").append(hostIP).append(":443/software/avctKVMIOLinux32.jar\" download=\"eager\"/>").append("\n");
        jnlpContent.append("</resources>").append("\n");
        jnlpContent.append("<resources os=\"Linux\" arch=\"i386\">").append("\n");
        jnlpContent.append("<nativelib href=\"https://").append(hostIP).append(":443/software/avctKVMIOLinux32.jar\" download=\"eager\"/>").append("\n");
        jnlpContent.append("</resources>").append("\n");
        jnlpContent.append("<resources os=\"Linux\" arch=\"i586\">").append("\n");
        jnlpContent.append("<nativelib href=\"https://").append(hostIP).append(":443/software/avctKVMIOLinux32.jar\" download=\"eager\"/>").append("\n");
        jnlpContent.append("</resources>").append("\n");
        jnlpContent.append("<resources os=\"Linux\" arch=\"i686\">").append("\n");
        jnlpContent.append("<nativelib href=\"https://").append(hostIP).append(":443/software/avctKVMIOLinux32.jar\" download=\"eager\"/>").append("\n");
        jnlpContent.append("</resources>").append("\n");
        jnlpContent.append("<resources os=\"Linux\" arch=\"amd64\">").append("\n");
        jnlpContent.append("<nativelib href=\"https://").append(hostIP).append(":443/software/avctKVMIOLinux64.jar\" download=\"eager\"/>").append("\n");
        jnlpContent.append("</resources>").append("\n");
        jnlpContent.append("<resources os=\"Linux\" arch=\"x86_64\">").append("\n");
        jnlpContent.append("<nativelib href=\"https://").append(hostIP).append(":443/software/avctKVMIOLinux64.jar\" download=\"eager\"/>").append("\n");
        jnlpContent.append("</resources>").append("\n");
        jnlpContent.append("<resources os=\"Mac OS X\" arch=\"x86_64\">").append("\n");
        jnlpContent.append("<nativelib href=\"https://").append(hostIP).append(":443/software/avctKVMIOMac64.jar\" download=\"eager\"/>").append("\n");
        jnlpContent.append("</resources>").append("\n");
        if (isAST2500) {
            jnlpContent.append("<resources os=\"Windows\" arch=\"x86\">").append("\n");
            jnlpContent.append("<nativelib href=\"https://").append(hostIP).append(":443/software/avctVMAPI_DLLWin32.jar\" download=\"eager\"/>").append("\n");
            jnlpContent.append("</resources>").append("\n");
            jnlpContent.append("<resources os=\"Windows\" arch=\"amd64\">").append("\n");
            jnlpContent.append("<nativelib href=\"https://").append(hostIP).append(":443/software/avctVMAPI_DLLWin64.jar\" download=\"eager\"/>").append("\n");
            jnlpContent.append("</resources>").append("\n");
            jnlpContent.append("<resources os=\"Windows\" arch=\"x86_64\">").append("\n");
            jnlpContent.append("<nativelib href=\"https://").append(hostIP).append(":443/software/avctVMAPI_DLLWin64.jar\" download=\"eager\"/>").append("\n");
            jnlpContent.append("</resources>").append("\n");
            jnlpContent.append("<resources os=\"Linux\" arch=\"x86\">").append("\n");
            jnlpContent.append("<nativelib href=\"https://").append(hostIP).append(":443/software/avctVMAPI_DLLLinux32.jar\" download=\"eager\"/>").append("\n");
            jnlpContent.append("</resources>").append("\n");
            jnlpContent.append("<resources os=\"Linux\" arch=\"i386\">").append("\n");
            jnlpContent.append("<nativelib href=\"https://").append(hostIP).append(":443/software/avctVMAPI_DLLLinux32.jar\" download=\"eager\"/>").append("\n");
            jnlpContent.append("</resources>").append("\n");
            jnlpContent.append("<resources os=\"Linux\" arch=\"i586\">").append("\n");
            jnlpContent.append("<nativelib href=\"https://").append(hostIP).append(":443/software/avctVMAPI_DLLLinux32.jar\" download=\"eager\"/>").append("\n");
            jnlpContent.append("</resources>").append("\n");
            jnlpContent.append("<resources os=\"Linux\" arch=\"i686\">").append("\n");
            jnlpContent.append("<nativelib href=\"https://").append(hostIP).append(":443/software/avctVMAPI_DLLLinux32.jar\" download=\"eager\"/>").append("\n");
            jnlpContent.append("</resources>").append("\n");
            jnlpContent.append("<resources os=\"Linux\" arch=\"amd64\">").append("\n");
            jnlpContent.append("<nativelib href=\"https://").append(hostIP).append(":443/software/avctVMAPI_DLLLinux64.jar\" download=\"eager\"/>").append("\n");
            jnlpContent.append("</resources>").append("\n");
            jnlpContent.append("<resources os=\"Linux\" arch=\"x86_64\">").append("\n");
            jnlpContent.append("<nativelib href=\"https://").append(hostIP).append(":443/software/avctVMAPI_DLLLinux64.jar\" download=\"eager\"/>").append("\n");
            jnlpContent.append("</resources>").append("\n");
            jnlpContent.append("<resources os=\"Mac OS X\" arch=\"x86_64\">").append("\n");
            jnlpContent.append("<nativelib href=\"https://").append(hostIP).append(":443/software/avctVMAPI_DLLMac64.jar\" download=\"eager\"/>").append("\n");
            jnlpContent.append("</resources>").append("\n");
        }
        jnlpContent.append("</jnlp>").append("\n");
        return jnlpContent.toString();
    }

    public static final String getAMIJNLPContent(String IP, String kvmToken, String cookie, String csrfToken) {
        StringBuilder jnlpContent = new StringBuilder();
        jnlpContent.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        jnlpContent.append("<jnlp spec=\"1.0+\" codebase=\"https://" + IP + ":443/Java\">");
        jnlpContent.append("<information>");
        jnlpContent.append("<title>JViewer</title>");
        jnlpContent.append("<vendor>American Megatrends, Inc.</vendor>");
        jnlpContent.append("<description kind=\"one-line\">JViewer Console Redirection Application</description>");
        jnlpContent.append("<description kind=\"tooltip\">JViewer Console Redirection Application</description>");
        jnlpContent.append("<description kind=\"short\">");
        jnlpContent.append("JViewer enables a user to view the video display of managed server via KVM.");
        jnlpContent.append("It also enables the user to redirect his local keyboard, mouse for managing the server remotely.");
        jnlpContent.append("</description>");
        jnlpContent.append("</information>");
        jnlpContent.append("<security>");
        jnlpContent.append("<all-permissions/>");
        jnlpContent.append("</security>");
        jnlpContent.append("<resources>");
        jnlpContent.append("<j2se version=\"1.8+\" initial-heap-size=\"100m\" max-heap-size=\"256m\"/>");
        jnlpContent.append("</resources>");
        jnlpContent.append("<resources>");
        jnlpContent.append("<j2se version=\"1.8+\"/>");
        jnlpContent.append("<jar href=\"release/JViewer.jar\"/>");
        jnlpContent.append("</resources>");
        jnlpContent.append("<resources>");
        jnlpContent.append("<j2se version=\"1.8+\"/>");
        jnlpContent.append("<jar href=\"release/JViewer-SOC.jar\"/>");
        jnlpContent.append("</resources>");
        jnlpContent.append("<resources>");
        jnlpContent.append("<j2se version=\"1.8+\"/>");
        jnlpContent.append("<jar href=\"release/JViewer-OEM.jar\"/>");
        jnlpContent.append("</resources>");
        jnlpContent.append("<resources>");
        jnlpContent.append("<j2se version=\"1.8+\"/>");
        jnlpContent.append("<jar href=\"release/JViewer-AVIStream.jar\"/>");
        jnlpContent.append("</resources>");
        jnlpContent.append("<resources os=\"Windows\" arch=\"x86\">");
        jnlpContent.append("<j2se version=\"1.8+\"/>");
        jnlpContent.append("<nativelib href=\"release/Win32.jar\"/>");
        jnlpContent.append("</resources>");
        jnlpContent.append("<resources os=\"Windows\" arch=\"amd64\">");
        jnlpContent.append("<j2se version=\"1.8+\"/>");
        jnlpContent.append("<nativelib href=\"release/Win64.jar\"/>");
        jnlpContent.append("</resources>");
        jnlpContent.append("<resources os=\"Linux\" arch=\"x86\">");
        jnlpContent.append("<j2se version=\"1.8+\"/>");
        jnlpContent.append("<nativelib href=\"release/Linux_x86_32.jar\"/>");
        jnlpContent.append("</resources>");
        jnlpContent.append("<resources os=\"Linux\" arch=\"i386\">");
        jnlpContent.append("<j2se version=\"1.8+\"/>");
        jnlpContent.append("<nativelib href=\"release/Linux_x86_32.jar\"/>");
        jnlpContent.append("</resources>");
        jnlpContent.append("<resources os=\"Linux\" arch=\"x86_64\">");
        jnlpContent.append("<j2se version=\"1.8+\"/>");
        jnlpContent.append("<nativelib href=\"release/Linux_x86_64.jar\"/>");
        jnlpContent.append("</resources>");
        jnlpContent.append("<resources os=\"Linux\" arch=\"amd64\">");
        jnlpContent.append("<j2se version=\"1.8+\"/>");
        jnlpContent.append("<nativelib href=\"release/Linux_x86_64.jar\"/>");
        jnlpContent.append("</resources>");
        jnlpContent.append("<resources os=\"Mac OS X\" arch=\"x86_64\">");
        jnlpContent.append("<j2se version=\"1.8+\"/>");
        jnlpContent.append("<nativelib href=\"release/Mac64.jar\"/>");
        jnlpContent.append("</resources>");
        jnlpContent.append("<resources>");
        jnlpContent.append("<j2se version=\"1.8+\"/>");
        jnlpContent.append("<jar href=\"release/JViewer-FolderRedir.jar\"/>");
        jnlpContent.append("</resources>");
        jnlpContent.append("<application-desc>");
        jnlpContent.append("<argument>-apptype</argument>");
        jnlpContent.append("<argument>JViewer</argument>");
        jnlpContent.append("<argument>-hostname</argument>");
        jnlpContent.append("<argument>" + IP + "</argument>");
        jnlpContent.append("<argument>-kvmtoken</argument>");
        jnlpContent.append("<argument>" + kvmToken + "</argument>");
        jnlpContent.append("<argument>-kvmsecure</argument>");
        jnlpContent.append("<argument>1</argument>");
        jnlpContent.append("<argument>-kvmport</argument>");
        jnlpContent.append("<argument>443</argument>");
        jnlpContent.append("<argument>-vmsecure</argument>");
        jnlpContent.append("<argument>1</argument>");
        jnlpContent.append("<argument>-cdstate</argument>");
        jnlpContent.append("<argument>1</argument>");
        jnlpContent.append("<argument>-hdstate</argument>");
        jnlpContent.append("<argument>1</argument>");
        jnlpContent.append("<argument>-cdport</argument>");
        jnlpContent.append("<argument>0</argument>");
        jnlpContent.append("<argument>-hdport</argument>");
        jnlpContent.append("<argument>0</argument>");
        jnlpContent.append("<argument>-cdnum</argument>");
        jnlpContent.append("<argument>1</argument>");
        jnlpContent.append("<argument>-hdnum</argument>");
        jnlpContent.append("<argument>1</argument>");
        jnlpContent.append("<argument>-extendedpriv</argument>");
        jnlpContent.append("<argument>259</argument>");
        jnlpContent.append("<argument>-localization</argument>");
        jnlpContent.append("<argument>CN</argument>");
        jnlpContent.append("<argument>-keyboardlayout</argument>");
        jnlpContent.append("<argument>AD</argument>");
        jnlpContent.append("<argument>-singleportenabled</argument>");
        jnlpContent.append("<argument>1</argument>");
        jnlpContent.append("<argument>-webcookie</argument>");
        jnlpContent.append("<argument>" + cookie + "</argument>");
        jnlpContent.append("<argument>-oemfeatures</argument>");
        jnlpContent.append("<argument>1515</argument>");
        jnlpContent.append("<argument>-kvmcdnum</argument>");
        jnlpContent.append("<argument>1</argument>");
        jnlpContent.append("<argument>-kvmhdnum</argument>");
        jnlpContent.append("<argument>1</argument>");
        jnlpContent.append("<argument>-powersavemode</argument>");
        jnlpContent.append("<argument>0</argument>");
        jnlpContent.append("<argument>-retrycount</argument>");
        jnlpContent.append("<argument>3</argument>");
        jnlpContent.append("<argument>-retryinterval</argument>");
        jnlpContent.append("<argument>10</argument>");
        jnlpContent.append("<argument>-webport</argument>");
        jnlpContent.append("<argument>443</argument>");
        jnlpContent.append("<argument>-websecure</argument>");
        jnlpContent.append("<argument>1</argument>");
        jnlpContent.append("<argument>-restService</argument>");
        jnlpContent.append("<argument>1</argument>");
        jnlpContent.append("<argument>-csrftoken</argument>");
        jnlpContent.append("<argument>" + csrfToken + "</argument>");
        jnlpContent.append("</application-desc>");
        jnlpContent.append("</jnlp>");
        return jnlpContent.toString();
    }
}

