/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.OSdeploy;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.engines.records.CommandTaskRecords;
import Gbt.core.engines.records.EngineRecordStates;
import Gbt.core.engines.records.EngineRecords;
import Gbt.core.engines.records.SSHCmdRecords;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.core.receivers.GbtLocalCommandReceiver;
import Gbt.core.receivers.GbtSSHCommandReceiver;
import Gbt.utility.Chassis.PowerCommand;
import Gbt.utility.Common.CommonFunction;
import Gbt.utility.OSdeploy.OSDeployData;
import Gbt.utility.bmcinfo.BMCVendor;
import Gbt.utility.bootoptions.BootOptions;
import Gbt.utility.maclist.GetMACListCommand;
import Gbt.utility.maclist.LANMacData;
import Gbt.utility.rest.models.vmcli.AMIRestVmcliImages;
import Gbt.utility.rest.options.VmcliServiceOptions;
import Gbt.utility.rest.services.VmcliUtilService;
import Gbt.utility.vmclitool.VmcliMountInfo;
import com.jcraft.jsch.Session;
import com.veraxsystems.vxipmi.api.async.ConnectionHandle;
import com.veraxsystems.vxipmi.coding.commands.chassis.GetChassisStatusResponseData;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.commons.io.FileUtils;

public final class OSDeployCommand
extends AbstractCommand<Builder> {
    public static final String COMMAND_NAME = "osdeploy";
    private final GbtIPMICommandReceiver ipmiReceiver = GbtIPMICommandReceiver.getInstance();
    private final GbtLocalCommandReceiver localReceiver = GbtLocalCommandReceiver.getInstance();
    private final GbtSSHCommandReceiver sshReceiver = GbtSSHCommandReceiver.getInstance();
    private String stage = "";
    private static final String PREPARE = "[Preparing to install]";
    private static final String INSTALLING = "[Starting to Install]";
    private static final String CHECKING = "[Checking install status]";
    private static final String INSTLOGPATH = "/home/uploaded/";

    private OSDeployCommand(Builder commandArgs) {
        super(commandArgs);
        this.commandID = ((Builder)this.commandArgs).bmcMac != null ? ((Builder)this.commandArgs).bmcIP + "_" + ((Builder)this.commandArgs).bmcMac + "_" + COMMAND_NAME : ((Builder)this.commandArgs).bmcIP + "_" + COMMAND_NAME;
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDocumentsName() {
        return COMMAND_NAME;
    }

    @Override
    public boolean checkAll() {
        if (this.ipmiReceiver == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI command receiver is null.");
            return false;
        }
        if (this.localReceiver == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Local command receiver is null.");
            return false;
        }
        if (this.sshReceiver == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] SSH command receiver is null.");
            return false;
        }
        if (!((Builder)this.commandArgs).checkArgs()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Command arguments check fail.");
            return false;
        }
        if (this.commandArgs == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Remote BMC IP is null.");
            return false;
        }
        return true;
    }

    @Override
    public boolean execute() {
        boolean result = true;
        this.stage = PREPARE;
        ConnectionHandle handle = this.ipmiReceiver.createIPMIConnection(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, COMMAND_NAME, this.commandID);
        if (handle == null) {
            result = false;
        } else {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Start to os deploy by source client " + ((Builder)this.commandArgs).serverIP + ".");
        }
        if (result) {
            this.forcePowerON(handle);
        }
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (result && !this.checkIsAMI(handle)) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Check BMC firmware type fail.");
            this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
            result = false;
        }
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (result && !this.mountMiniOS()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Mount ISO file fail.");
            this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
            result = false;
        }
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (result) {
            result = ((Builder)this.commandArgs).customInstall ? this.installByCustomISO(handle) : (!((Builder)this.commandArgs).isLinux ? this.installByWINISO(handle) : this.installByLNXISO(handle));
        }
        OSDeployData osdeployData = new OSDeployData();
        osdeployData.setBMCIP(((Builder)this.commandArgs).bmcIP);
        osdeployData.setOSType(((Builder)this.commandArgs).osType);
        osdeployData.setResult(result);
        this.commandResults.add(osdeployData);
        return result;
    }

    @Override
    public void cancelHook(Object obj) {
    }

    @Override
    public void close() throws Exception {
        ((Builder)this.commandArgs).close();
    }

    private void forcePowerON(ConnectionHandle handle) {
        GetChassisStatusResponseData powerStates = this.ipmiReceiver.getChassisPowerStates(handle, COMMAND_NAME, this.commandID);
        if (!powerStates.isPowerOn()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Target node power off and start to turn on.");
            this.ipmiReceiver.chassisPowerCommand(handle, PowerCommand.PowerUp, COMMAND_NAME, this.commandID);
            do {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Wait for target node power on.");
                powerStates = this.ipmiReceiver.getChassisPowerStates(handle, COMMAND_NAME, this.commandID);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (!powerStates.isPowerOn());
        } else {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Target node is power on.");
        }
    }

    private boolean installByLNXISO(ConnectionHandle handle) {
        if (((Builder)this.commandArgs).vmcdrom) {
            this.ipmiReceiver.setBootOption(handle, BootOptions.VMCDROM, ((Builder)this.commandArgs).uefiMode, COMMAND_NAME, this.commandID);
        } else if (((Builder)this.commandArgs).isAMI) {
            this.ipmiReceiver.setBootOption(handle, BootOptions.VMCDROM, ((Builder)this.commandArgs).uefiMode, COMMAND_NAME, this.commandID);
        } else {
            this.ipmiReceiver.setBootOption(handle, BootOptions.CDROM, ((Builder)this.commandArgs).uefiMode, COMMAND_NAME, this.commandID);
        }
        this.ipmiReceiver.chassisPowerCommand(handle, PowerCommand.PowerCycle, COMMAND_NAME, this.commandID);
        Map<String, String> macs = this.get3LANMACs();
        if (macs == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Get mac list fail.");
            this.unmountMiniOS();
            this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
            return false;
        }
        String dataLANIP = this.waitBootComplete(macs, "root", "111111", handle, 10000, true);
        this.unmountMiniOS();
        if (dataLANIP.equals("0.0.0.0")) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Cannot boot into mini OS!");
            this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
            return false;
        }
        Session session = this.sshReceiver.openSession(dataLANIP, "root", "111111", COMMAND_NAME, this.commandID);
        SSHCmdRecords sshRecords = this.sshReceiver.executeCMD(session, "wget http://" + ((Builder)this.commandArgs).serverIP + "/" + ((Builder)this.commandArgs).userID + "_configPkg/configPkg.zip", true, COMMAND_NAME, this.commandID);
        if (!sshRecords.getResults().contains("200 OK")) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Download configPkg fail.");
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, sshRecords.getResults());
            sshRecords.clearMesg();
            this.unmountMiniOS();
            this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
            this.sshReceiver.closeSession(session, COMMAND_NAME, this.commandID);
            return false;
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Download configPkg success.");
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.TRACE, this.commandID, sshRecords.getResults());
        sshRecords.clearMesg();
        sshRecords = this.sshReceiver.executeCMD(session, "unzip configPkg.zip", true, COMMAND_NAME, this.commandID);
        sshRecords = this.sshReceiver.executeCMD(session, "chmod -R 755 *", true, COMMAND_NAME, this.commandID);
        if (sshRecords.getStates().isFail()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Change scripts privilege fail.");
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, sshRecords.getResults());
            sshRecords.clearMesg();
            this.unmountMiniOS();
            this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
            this.sshReceiver.closeSession(session, COMMAND_NAME, this.commandID);
            return false;
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Change scripts privilege success.");
        sshRecords.clearMesg();
        sshRecords = ((Builder)this.commandArgs).uefiMode ? this.sshReceiver.executeCMD(session, "cd configPkg/configUtil/scripts && ./part_uefi.sh", true, COMMAND_NAME, this.commandID) : this.sshReceiver.executeCMD(session, "cd configPkg/configUtil/scripts && ./part.sh", true, COMMAND_NAME, this.commandID);
        if (sshRecords.getResults().toLowerCase().contains("success")) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Clear partition success.");
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.TRACE, this.commandID, sshRecords.getResults());
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.WARN, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Interrupt OS deployments.");
                this.unmountMiniOS();
                this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                this.sshReceiver.closeSession(session, COMMAND_NAME, this.commandID);
                return false;
            }
        } else {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Clear partition fail!");
            this.unmountMiniOS();
            this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
            this.sshReceiver.closeSession(session, COMMAND_NAME, this.commandID);
            return false;
        }
        sshRecords.clearMesg();
        sshRecords = this.sshReceiver.executeCMD(session, "cd configPkg/configUtil/scripts && ./" + ((Builder)this.commandArgs).osInstallScript, true, COMMAND_NAME, this.commandID);
        if (sshRecords.getStates().isFail()) {
            this.unmountMiniOS();
            this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
            this.sshReceiver.closeSession(session, COMMAND_NAME, this.commandID);
            return false;
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Grub install success, rebooting to installer...");
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.TRACE, this.commandID, sshRecords.getResults());
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Interrupt OS deployments.");
            this.unmountMiniOS();
            this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
            this.sshReceiver.closeSession(session, COMMAND_NAME, this.commandID);
            return false;
        }
        sshRecords.clearMesg();
        this.ipmiReceiver.setBootOption(handle, BootOptions.Disk, ((Builder)this.commandArgs).uefiMode, COMMAND_NAME, this.commandID);
        this.ipmiReceiver.chassisPowerCommand(handle, PowerCommand.PowerCycle, COMMAND_NAME, this.commandID);
        this.sshReceiver.closeSession(session, COMMAND_NAME, this.commandID);
        boolean waitResult = false;
        this.ipmiReceiver.chassisIdentifyCommand(handle, (byte)-1, COMMAND_NAME, this.commandID);
        waitResult = this.waitUntilInstallComplete(handle, macs);
        if (!waitResult) {
            this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
            return false;
        }
        this.ipmiReceiver.chassisIdentifyCommand(handle, (byte)1, COMMAND_NAME, this.commandID);
        this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
        return true;
    }

    private boolean installByCustomISO(ConnectionHandle handle) {
        if (((Builder)this.commandArgs).vmcdrom) {
            this.ipmiReceiver.setBootOption(handle, BootOptions.VMCDROM, ((Builder)this.commandArgs).uefiMode, COMMAND_NAME, this.commandID);
        } else if (((Builder)this.commandArgs).isAMI) {
            this.ipmiReceiver.setBootOption(handle, BootOptions.VMCDROM, ((Builder)this.commandArgs).uefiMode, COMMAND_NAME, this.commandID);
        } else {
            this.ipmiReceiver.setBootOption(handle, BootOptions.CDROM, ((Builder)this.commandArgs).uefiMode, COMMAND_NAME, this.commandID);
        }
        this.ipmiReceiver.chassisPowerCommand(handle, PowerCommand.PowerCycle, COMMAND_NAME, this.commandID);
        Map<String, String> macs = this.get3LANMACs();
        if (macs == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Get mac list fail.");
            this.unmountMiniOS();
            this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
            return false;
        }
        this.stage = INSTALLING;
        String dataLANIP = this.waitBootComplete(macs, ((Builder)this.commandArgs).installOSAccount, ((Builder)this.commandArgs).installOSPassword, handle, 10000, true);
        this.stage = CHECKING;
        Session session = this.sshReceiver.openSession(dataLANIP, ((Builder)this.commandArgs).installOSAccount, ((Builder)this.commandArgs).installOSPassword, COMMAND_NAME, this.commandID);
        if (session == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Cannot ensure install status.");
            this.unmountMiniOS();
            this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
            this.sshReceiver.closeSession(session, COMMAND_NAME, this.commandID);
            return false;
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " SSH open success, install complete!");
        this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
        return true;
    }

    private boolean installByWINISO(ConnectionHandle handle) {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (((Builder)this.commandArgs).vmcdrom) {
            this.ipmiReceiver.setBootOption(handle, BootOptions.VMCDROM, ((Builder)this.commandArgs).uefiMode, COMMAND_NAME, this.commandID);
        } else if (((Builder)this.commandArgs).isAMI) {
            this.ipmiReceiver.setBootOption(handle, BootOptions.VMCDROM, ((Builder)this.commandArgs).uefiMode, COMMAND_NAME, this.commandID);
        } else {
            this.ipmiReceiver.setBootOption(handle, BootOptions.CDROM, ((Builder)this.commandArgs).uefiMode, COMMAND_NAME, this.commandID);
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.ipmiReceiver.chassisPowerCommand(handle, PowerCommand.PowerCycle, COMMAND_NAME, this.commandID);
        try {
            Thread.sleep(20000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Map<String, String> macs = this.get3LANMACs();
        if (macs == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Get mac list fail.");
            this.unmountMiniOS();
            this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
            return false;
        }
        String dataLANIP = this.waitBootComplete(macs, "administrator", "admin123", handle, 10000, true);
        if (dataLANIP.equals("0.0.0.0")) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Cannot boot into mini OS!");
            this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
            return false;
        }
        this.unmountMiniOS();
        Session session = this.sshReceiver.openSession(dataLANIP, "administrator", "admin123", COMMAND_NAME, this.commandID);
        SSHCmdRecords sshRecords = this.sshReceiver.executeCMD(session, "%SYSTEMDRIVE%\\Windows\\wget\\wget.exe http://" + ((Builder)this.commandArgs).serverIP + "/" + ((Builder)this.commandArgs).userID + "_configPkg/instWin.bat -P %SYSTEMDRIVE%\\Windows\\wget\\", false, COMMAND_NAME, this.commandID);
        if (!sshRecords.getErrors().contains("saved")) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Download install script fail.");
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, sshRecords.getResults());
            this.unmountMiniOS();
            this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
            this.sshReceiver.closeSession(session, COMMAND_NAME, this.commandID);
            sshRecords.clearMesg();
            return false;
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Download install script success.");
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.TRACE, this.commandID, sshRecords.getResults());
        sshRecords.clearMesg();
        sshRecords = this.sshReceiver.executeCMD(session, "unzip configPkg.zip", true, COMMAND_NAME, this.commandID);
        sshRecords = this.sshReceiver.executeCMD(session, "%SYSTEMDRIVE%\\Windows\\wget\\wget.exe http://" + ((Builder)this.commandArgs).serverIP + "/" + ((Builder)this.commandArgs).userID + "_configPkg/clearPart.bat -P %SYSTEMDRIVE%\\Windows\\wget\\", false, COMMAND_NAME, this.commandID);
        if (!sshRecords.getErrors().contains("saved")) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Download partition script fail.");
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, sshRecords.getResults());
            sshRecords.clearMesg();
            this.unmountMiniOS();
            this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
            this.sshReceiver.closeSession(session, COMMAND_NAME, this.commandID);
            return false;
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Download partition script success.");
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.TRACE, this.commandID, sshRecords.getResults());
        sshRecords.clearMesg();
        sshRecords = this.sshReceiver.executeCMD(session, "unzip configPkg.zip", true, COMMAND_NAME, this.commandID);
        sshRecords = this.sshReceiver.executeCMD(session, "%SYSTEMDRIVE%\\Windows\\wget\\clearPart.bat 1", false, COMMAND_NAME, this.commandID);
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + sshRecords.getResults());
        String pureServerIP = ((Builder)this.commandArgs).serverIP;
        if (((Builder)this.commandArgs).serverIP.contains(":")) {
            pureServerIP = ((Builder)this.commandArgs).serverIP.substring(0, ((Builder)this.commandArgs).serverIP.indexOf(":"));
        }
        String cmd = "";
        cmd = ((Builder)this.commandArgs).uefiMode ? "%SYSTEMDRIVE%\\Windows\\wget\\instWin.bat " + pureServerIP + " 1" : "%SYSTEMDRIVE%\\Windows\\wget\\instWin.bat " + pureServerIP + " 0";
        System.out.println(cmd);
        Future<EngineRecords> futureRecord = this.sshReceiver.asynExecuteCMD(session, cmd, 5000, false, COMMAND_NAME, this.commandID);
        this.stage = INSTALLING;
        boolean waitResult = false;
        this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
        handle = this.ipmiReceiver.createIPMIConnection(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, COMMAND_NAME, this.commandID);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.ipmiReceiver.chassisIdentifyCommand(handle, (byte)-1, COMMAND_NAME, this.commandID);
        waitResult = this.waitUntilWinInstallComplete(session, handle, sshRecords, ((Builder)this.commandArgs).osType);
        futureRecord.cancel(true);
        if (!waitResult) {
            this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
            return false;
        }
        this.ipmiReceiver.chassisIdentifyCommand(handle, (byte)1, COMMAND_NAME, this.commandID);
        this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
        return true;
    }

    private Map<String, String> get3LANMACs() {
        HashMap<String, String> macs = new HashMap<String, String>();
        GetMACListCommand command = new GetMACListCommand.Builder().setBMCIP(((Builder)this.commandArgs).bmcIP).setBMCUsername(((Builder)this.commandArgs).bmcUsername).setBMCPassword(((Builder)this.commandArgs).bmcPassword).setGroupID(0).build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            record.setStates(EngineRecordStates.Fail);
            return null;
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            record.setStates(EngineRecordStates.Fail);
            return null;
        }
        try {
            LANMacData lanList = command.getCommandResults().get(0).castConcreteJSON(LANMacData.class);
            macs.put("LAN1", lanList.getLan1());
            macs.put("LAN2", lanList.getLan2());
            macs.put("LAN3", lanList.getLan3());
            macs.put("LAN4", lanList.getLan4());
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Data LAN 1 MAC address : " + (String)macs.get("LAN1"));
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Data LAN 2 MAC address : " + (String)macs.get("LAN2"));
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Data LAN 3 MAC address : " + (String)macs.get("LAN3"));
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Data LAN 4 MAC address : " + (String)macs.get("LAN4"));
            command.close();
        }
        catch (Exception e) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Get LAN MAC fail!");
            record.setStates(EngineRecordStates.Fail);
            return null;
        }
        return macs;
    }

    private String waitBootComplete(Map<String, String> macs, String username, String password, ConnectionHandle handle, int pingInterval, boolean longWaitReboot) {
        int count = 0;
        String dataLANIP = "0.0.0.0";
        Session session = null;
        do {
            ++count;
            if (Thread.currentThread().isInterrupted()) break;
            if (count % 50 == 0 && longWaitReboot) {
                this.ipmiReceiver.chassisPowerCommand(handle, PowerCommand.PowerCycle, COMMAND_NAME, this.commandID);
            }
            try {
                Thread.sleep(pingInterval);
            }
            catch (InterruptedException ie) {
                break;
            }
            dataLANIP = ((Builder)this.commandArgs).debugFile != null ? this.findIPByDebugFile() : this.localReceiver.getActivateDHCPIP(macs, COMMAND_NAME, this.commandID);
            if (dataLANIP.equals("0.0.0.0")) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Wait for target node boot complete ...[" + this.getElapsedTimes() + "](" + count + ")");
                continue;
            }
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Find data LAN IP:" + dataLANIP);
            if (!this.localReceiver.pingDataLAN(dataLANIP, COMMAND_NAME, this.commandID)) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Wait for target node boot complete ...[" + this.getElapsedTimes() + "](" + count + ")");
                continue;
            }
            session = this.sshReceiver.openSession(dataLANIP, username, password, COMMAND_NAME, this.commandID);
            if (!session.isConnected()) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Wait for target node boot complete(" + username + "/" + password + ") ...[" + this.getElapsedTimes() + "](" + count + ")");
                if (count <= 200) continue;
                dataLANIP = "0.0.0.0";
                break;
            }
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Target node boot complete! [" + this.getElapsedTimes() + "]");
            this.sshReceiver.closeSession(session, COMMAND_NAME, this.commandID);
            break;
        } while (count <= 200 && !this.isOverTime(((Builder)this.commandArgs).timeout));
        if (this.isOverTime(((Builder)this.commandArgs).timeout)) {
            dataLANIP = "0.0.0.0";
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Install process timeout! [" + this.getElapsedTimes() + "]");
        }
        return dataLANIP;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean waitUntilInstallComplete(ConnectionHandle handle, Map<String, String> macs) {
        boolean result = false;
        this.stage = INSTALLING;
        File instLog = this.findValidInstLog(macs);
        do {
            block11: {
                if (instLog != null) {
                    try {
                        String content = FileUtils.readFileToString((File)instLog);
                        if (content.contains("[GbtUtility] Install process complete!")) {
                            result = true;
                            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Install complete according to inst log! [" + this.getElapsedTimes() + "]");
                            instLog.delete();
                            break;
                        }
                        String[] contents = content.split("\n");
                        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Install is processing... [" + this.getElapsedTimes() + "]");
                        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + contents[contents.length - 1]);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Read inst log fail. [" + this.getElapsedTimes() + "]");
                    }
                } else {
                    String dataLANIP = "";
                    dataLANIP = ((Builder)this.commandArgs).debugFile != null ? this.findIPByDebugFile() : this.localReceiver.getActivateDHCPIP(macs, COMMAND_NAME, this.commandID);
                    if (!dataLANIP.equals("0.0.0.0")) {
                        Session session = this.sshReceiver.openSession(dataLANIP, ((Builder)this.commandArgs).installOSAccount, ((Builder)this.commandArgs).installOSPassword, COMMAND_NAME, this.commandID);
                        if (!session.isConnected()) {
                            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Wait for target node boot complete(" + ((Builder)this.commandArgs).installOSAccount + "/" + ((Builder)this.commandArgs).installOSPassword + ") ...[" + this.getElapsedTimes() + "]");
                            break block11;
                        } else {
                            result = true;
                            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Target node boot complete! [" + this.getElapsedTimes() + "]");
                            this.sshReceiver.closeSession(session, COMMAND_NAME, this.commandID);
                            break;
                        }
                    }
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Wait for target node data lan IP...[" + this.getElapsedTimes() + "]");
                }
            }
            try {
                Thread.sleep(20000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!this.isOverTime(((Builder)this.commandArgs).timeout));
        if (!this.isOverTime(((Builder)this.commandArgs).timeout)) return result;
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Waiting install progress complete timeout! [" + this.getElapsedTimes() + "]");
        return false;
    }

    private File findValidInstLog(Map<String, String> macs) {
        File instLog = null;
        for (String lan : macs.keySet()) {
            if (lan.equals("BMC")) continue;
            String mac = macs.get(lan).replaceAll(":", "").toLowerCase();
            instLog = new File(INSTLOGPATH + mac + "_inst.log");
            if (!instLog.exists()) continue;
            try {
                BasicFileAttributes attr = Files.readAttributes(instLog.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                if (attr.creationTime().toMillis() > this.getStartTime().getMillis()) {
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Find inst log: " + instLog);
                    return instLog;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return instLog;
        }
        return null;
    }

    private boolean monitorInstallerMessage(Session session, ConnectionHandle handle, Map<String, String> macs, SSHCmdRecords sshRecords) {
        boolean result = false;
        String dataLANIP = this.waitBootComplete(macs, "installer", "test", handle, 10000, false);
        session = this.sshReceiver.openSession(dataLANIP, "installer", "test", COMMAND_NAME, this.commandID);
        int failCount = 0;
        do {
            if (Thread.currentThread().isInterrupted()) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.WARN, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Interrupt OS deployment process.");
                result = false;
                break;
            }
            sshRecords = this.sshReceiver.executeShell(session, "cat /var/log/syslog | tail -n 20", COMMAND_NAME, this.commandID);
            if (sshRecords.getStates().isPass()) {
                this.stage = INSTALLING;
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Waiting for install progress complete...[" + this.getElapsedTimes() + "]");
                boolean lock = false;
                for (String msg : sshRecords.getLineMessages()) {
                    if (msg.contains("BusyBox")) {
                        lock = true;
                    }
                    if (msg.contains("~ # exit")) {
                        lock = false;
                    }
                    if (!lock) continue;
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.TRACE, this.commandID, msg);
                }
                if (sshRecords.getLineMessages().contains("[GbtUtility] Install process complete!")) {
                    this.stage = CHECKING;
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Install process complete! [" + this.getElapsedTimes() + "]");
                    result = true;
                    break;
                }
                try {
                    Thread.sleep(50000L);
                    continue;
                }
                catch (InterruptedException ie) {
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.WARN, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Interrupt OS deployment process.");
                    result = false;
                    break;
                }
            }
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Shell execute fail, try to open the session again.[" + this.getElapsedTimes() + "]");
            this.sshReceiver.closeSession(session);
            session = this.sshReceiver.openSession(dataLANIP, "installer", "test", COMMAND_NAME, this.commandID);
            if (session.isConnected()) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Open session success, retry to execute shell.[" + this.getElapsedTimes() + "]");
            } else {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Open session fail, retry ... (" + failCount + ") [" + this.getElapsedTimes() + "]");
                ++failCount;
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ie) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.WARN, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Interrupt OS deployment process.");
                result = false;
                break;
            }
        } while (failCount <= 20);
        if (failCount > 20) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " SSH fail and over retry count! [" + this.getElapsedTimes() + "]");
            result = false;
            session = this.sshReceiver.openSession(dataLANIP, ((Builder)this.commandArgs).installOSAccount, ((Builder)this.commandArgs).installOSPassword, COMMAND_NAME, this.commandID);
            if (session.isConnected()) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Open session success.[" + this.getElapsedTimes() + "]");
                result = true;
            } else {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Open session fail.[" + this.getElapsedTimes() + "]");
                result = false;
            }
        }
        this.sshReceiver.closeSession(session, COMMAND_NAME, this.commandID);
        return result;
    }

    private boolean waitUntilInstallComplete(Session session, ConnectionHandle handle, Map<String, String> macs, SSHCmdRecords sshRecords, String osType) {
        this.stage = INSTALLING;
        String dataLANIP = "0.0.0.0";
        while (dataLANIP.equals("0.0.0.0") && !this.isOverTime(((Builder)this.commandArgs).timeout)) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Waiting for install progress complete...[" + this.getElapsedTimes() + "]");
            if (Thread.currentThread().isInterrupted()) {
                return false;
            }
            dataLANIP = this.waitBootComplete(macs, ((Builder)this.commandArgs).installOSAccount, ((Builder)this.commandArgs).installOSPassword, handle, 60000, false);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (this.isOverTime(((Builder)this.commandArgs).timeout)) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Waiting install progress complete timeout! [" + this.getElapsedTimes() + "]");
            return false;
        }
        boolean checkResult = false;
        for (int count = 0; !checkResult && count < 3; ++count) {
            session = this.sshReceiver.openSession(dataLANIP, ((Builder)this.commandArgs).installOSAccount, ((Builder)this.commandArgs).installOSPassword, COMMAND_NAME, this.commandID);
            if (Thread.currentThread().isInterrupted()) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.WARN, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Interrupt OS deployment process.");
                this.sshReceiver.closeSession(session, COMMAND_NAME, this.commandID);
                return false;
            }
            String instLogPath = "";
            if (osType.contains("suse")) {
                instLogPath = "/var/log/YaST2/y2start.log";
            } else if (osType.contains("cent")) {
                instLogPath = "/var/log/anaconda.log";
            } else if (osType.contains("redhat")) {
                instLogPath = "/var/log/anaconda/anaconda.log";
            }
            this.stage = CHECKING;
            sshRecords = this.sshReceiver.executeCMD(session, "cat /etc/*-release", false, COMMAND_NAME, this.commandID);
            if (sshRecords.getStates().isPass()) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.TRACE, this.commandID, sshRecords.getResults());
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Install process complete! [" + this.getElapsedTimes() + "]");
                this.sshReceiver.closeSession(session, COMMAND_NAME, this.commandID);
                return true;
            }
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Shell execute fail, check install status fail. [" + this.getElapsedTimes() + "]");
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, sshRecords.getErrors());
            this.sshReceiver.closeSession(session, COMMAND_NAME, this.commandID);
            try {
                Thread.sleep(5000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean waitUntilWinInstallComplete(Session session, ConnectionHandle handle, SSHCmdRecords sshRecords, String osType) {
        this.stage = INSTALLING;
        while (!this.isOverTime(((Builder)this.commandArgs).timeout)) {
            sshRecords = this.sshReceiver.executeCMD(session, "powershell -command \"& {Get-Content X:\\Windows\\panther\\Setupact.log | Select-Object -last 5}\"", false);
            if (!session.isConnected()) {
                this.stage = CHECKING;
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Installation complete! [" + this.getElapsedTimes() + "]");
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.TRACE, this.commandID, sshRecords.getResults());
                this.sshReceiver.closeSession(session, COMMAND_NAME, this.commandID);
                return true;
            }
            if (sshRecords.getResults().toLowerCase().contains("setup was unable to create a new system partition")) {
                this.stage = CHECKING;
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Windows install error:\n " + sshRecords.getResults() + "\n=============================\n");
                this.sshReceiver.closeSession(session, COMMAND_NAME, this.commandID);
                return false;
            }
            if (sshRecords.getResults().toLowerCase().contains("the selected disk is of the gpt partition style")) {
                this.stage = CHECKING;
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Windows install error:\n " + sshRecords.getResults() + "\n=============================\n");
                this.sshReceiver.closeSession(session, COMMAND_NAME, this.commandID);
                return false;
            }
            if (sshRecords.getResults().toLowerCase().contains("an error occurred while applying unattend disk configuration")) {
                this.stage = CHECKING;
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Windows install error:\n " + sshRecords.getResults() + "\n=============================\n");
                this.sshReceiver.closeSession(session, COMMAND_NAME, this.commandID);
                return false;
            }
            if (sshRecords.getResults().toLowerCase().contains("no language pack available")) {
                this.stage = CHECKING;
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Windows install error:\n " + sshRecords.getResults() + "\n=============================\n");
                this.sshReceiver.closeSession(session, COMMAND_NAME, this.commandID);
                return false;
            }
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Execute SSH command success, Installation still keep going... [" + this.getElapsedTimes() + "]");
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]\n==========================\n" + sshRecords.getResults() + "\n" + sshRecords.getErrors() + "\n==================");
            try {
                Thread.sleep(20000L);
            }
            catch (InterruptedException e) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Interrupt OS deployments.");
                this.sshReceiver.closeSession(session, COMMAND_NAME, this.commandID);
                return false;
            }
            sshRecords.clearMesg();
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Waitting over timeout, end process! [" + this.getElapsedTimes() + "]");
        this.sshReceiver.closeSession(session, COMMAND_NAME, this.commandID);
        return false;
    }

    private boolean mountMiniOS() {
        if (((Builder)this.commandArgs).isAMI) {
            return this.mountMiniOSAMI();
        }
        return this.mountMiniOSVertive();
    }

    private boolean unmountMiniOS() {
        if (((Builder)this.commandArgs).isAMI) {
            return this.unmountMiniOSAMI();
        }
        return this.unmountMiniOSVertive();
    }

    private boolean mountMiniOSAMI() {
        VmcliUtilService services = new VmcliUtilService(this.loggerWriter);
        String path = "./Rest_Json/vmcli_settings.json";
        File file = new File(path);
        ArrayList<File> files = new ArrayList<File>();
        files.add(file);
        String pureServerIP = ((Builder)this.commandArgs).serverIP;
        if (((Builder)this.commandArgs).serverIP.contains(":")) {
            pureServerIP = ((Builder)this.commandArgs).serverIP.substring(0, ((Builder)this.commandArgs).serverIP.indexOf(":"));
        }
        services.readJsonFiles(files, VmcliServiceOptions.SET_GENERAL_CONFIG);
        services.getVmcliConfigUploadData().setCd_remote_user_name("smbuser");
        services.getVmcliConfigUploadData().setCd_remote_password("111111");
        services.getVmcliConfigUploadData().setCd_remote_domain_name("");
        services.getVmcliConfigUploadData().setCd_remote_server_address(pureServerIP);
        services.getVmcliConfigUploadData().setCd_remote_source_path("/" + ((Builder)this.commandArgs).userID + "_smbuser");
        services.openSession(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, true);
        if (!services.execute(((Builder)this.commandArgs).bmcIP, VmcliServiceOptions.SET_GENERAL_CONFIG)) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Rest set config fail!");
            services.closeSession(((Builder)this.commandArgs).bmcIP);
            return false;
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Rest set config success.");
        path = "./Rest_Json/vmclimount.json";
        file = new File(path);
        files.clear();
        files.add(file);
        services.readJsonFiles(files, VmcliServiceOptions.MOUNT);
        services.getVmcliImgUploadData().setImage_index(new BigInteger("0"));
        services.getVmcliImgUploadData().setImage_name(((Builder)this.commandArgs).miniOSISOName);
        services.execute(((Builder)this.commandArgs).bmcIP, VmcliServiceOptions.UNMOUNT);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        services.readJsonFiles(files, VmcliServiceOptions.MOUNT);
        services.getVmcliImgUploadData().setImage_index(new BigInteger("1"));
        services.getVmcliImgUploadData().setImage_name(((Builder)this.commandArgs).miniOSISOName);
        services.execute(((Builder)this.commandArgs).bmcIP, VmcliServiceOptions.UNMOUNT);
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!services.execute(((Builder)this.commandArgs).bmcIP, VmcliServiceOptions.LIST_IMAGE)) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Rest list image fail!");
            services.closeSession(((Builder)this.commandArgs).bmcIP);
            return false;
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Rest list image success.");
        for (AbstractJSONPOJO records : services.getJsonResults()) {
            if (!(records instanceof AMIRestVmcliImages)) continue;
            BigInteger id = ((AMIRestVmcliImages)records).getId();
            String isoName = ((AMIRestVmcliImages)records).getImage_name();
            BigInteger index = ((AMIRestVmcliImages)records).getImage_index();
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Image index:" + index + " name:" + isoName);
            if (id == null || !isoName.equals(((Builder)this.commandArgs).miniOSISOName)) continue;
            path = "./Rest_Json/vmclimount.json";
            file = new File(path);
            files.clear();
            files.add(file);
            services.readJsonFiles(files, VmcliServiceOptions.MOUNT);
            services.getVmcliImgUploadData().setImage_index(index);
            services.getVmcliImgUploadData().setImage_name(((Builder)this.commandArgs).miniOSISOName);
            break;
        }
        if (!services.execute(((Builder)this.commandArgs).bmcIP, VmcliServiceOptions.MOUNT)) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Rest mount ISO fail!");
            services.closeSession(((Builder)this.commandArgs).bmcIP);
            return false;
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Rest mount ISO success.");
        services.closeSession(((Builder)this.commandArgs).bmcIP);
        return true;
    }

    private boolean unmountMiniOSAMI() {
        VmcliUtilService services = new VmcliUtilService(this.loggerWriter);
        String path = "./Rest_Json/vmclimount.json";
        File file = new File(path);
        ArrayList<File> files = new ArrayList<File>();
        files.add(file);
        services.readJsonFiles(files, VmcliServiceOptions.MOUNT);
        services.getVmcliImgUploadData().setImage_name(((Builder)this.commandArgs).miniOSISOName);
        services.openSession(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, true);
        services.execute(((Builder)this.commandArgs).bmcIP, VmcliServiceOptions.UNMOUNT);
        services.closeSession(((Builder)this.commandArgs).bmcIP);
        return true;
    }

    private boolean mountMiniOSVertive() {
        boolean result = false;
        File f = new File(((Builder)this.commandArgs).miniOSISOName);
        if (!f.exists()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Mini OS ISO is not exist!");
            return false;
        }
        this.localReceiver.changeFilePermission("tools/vmcliUtility/*", COMMAND_NAME, this.commandID);
        VmcliMountInfo vmcliMountInfo = new VmcliMountInfo();
        vmcliMountInfo.setBmcIP(((Builder)this.commandArgs).bmcIP);
        vmcliMountInfo.setBmcUsername(((Builder)this.commandArgs).bmcUsername);
        vmcliMountInfo.setBmcPassword(((Builder)this.commandArgs).bmcPassword);
        vmcliMountInfo.setCdROM(((Builder)this.commandArgs).miniOSISOName);
        result = this.localReceiver.vmcliMount(vmcliMountInfo, COMMAND_NAME, this.commandID);
        return result;
    }

    private boolean unmountMiniOSVertive() {
        boolean unmount = false;
        int counter = 0;
        while (!(unmount = this.localReceiver.vmcliUnmount(((Builder)this.commandArgs).bmcIP, COMMAND_NAME, this.commandID))) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                break;
            }
            if (!unmount && ++counter < 10) continue;
        }
        return unmount;
    }

    private boolean checkIsAMI(ConnectionHandle handle) {
        BMCVendor bmcVendor = this.ipmiReceiver.getBmcVendor(handle, COMMAND_NAME, this.commandID);
        switch (bmcVendor) {
            case VERTIV: {
                ((Builder)this.commandArgs).isAMI = false;
                return true;
            }
            case AMI: {
                ((Builder)this.commandArgs).isAMI = true;
                return true;
            }
            case OPENBMC: {
                ((Builder)this.commandArgs).isAMI = false;
                return false;
            }
        }
        return false;
    }

    private String findIPByDebugFile() {
        String dataLANIP = "0.0.0.0";
        List<String> srcList = CommonFunction.readFile(((Builder)this.commandArgs).debugFile.getAbsolutePath());
        if (srcList.isEmpty()) {
            System.out.println("Debug file is empty, please check file content!\n");
            return "0.0.0.0";
        }
        for (String line : srcList) {
            String[] para = line.split(",");
            if (!para[0].equals(((Builder)this.commandArgs).bmcIP)) continue;
            dataLANIP = para[1];
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "]" + this.stage + " Get data lan IP from debug:" + dataLANIP);
            break;
        }
        return dataLANIP;
    }

    public static final class Builder
    extends AbstractCommandBuilder<Builder> {
        private String bmcIP;
        private String bmcUsername = "admin";
        private String bmcPassword = "password";
        private String bmcMac;
        private String serverIP;
        private String miniOSISOName;
        private String osType;
        private String userID = "user";
        private int timeout = 60;
        private String installOSAccount = "user";
        private String installOSPassword = "111111";
        private String installOSRootAccount = "root";
        private String installOSRootPassword = "111111";
        private String osInstallScript;
        private boolean isAMI = false;
        private boolean customInstall = false;
        private boolean isLinux = true;
        private boolean uefiMode = false;
        private boolean vmcdrom = false;
        private File debugFile = null;
        private File configFile = null;

        @Override
        public boolean checkArgs() {
            if (this.args != null) {
                for (int i = 0; i < this.args.length; ++i) {
                    if (this.args[i].contains("timeout=")) {
                        this.timeout = Integer.parseInt(this.args[i].substring(this.args[i].lastIndexOf("timeout=") + 8));
                        continue;
                    }
                    if (this.args[i].contains("account=")) {
                        this.installOSRootAccount = this.args[i].substring(this.args[i].lastIndexOf("account=") + 8);
                        continue;
                    }
                    if (this.args[i].contains("password=")) {
                        this.installOSRootPassword = this.args[i].substring(this.args[i].lastIndexOf("password=") + 9);
                        continue;
                    }
                    if (this.args[i].contains("uefi=")) {
                        this.uefiMode = Boolean.valueOf(this.args[i].substring(this.args[i].lastIndexOf("uefi=") + 5));
                        continue;
                    }
                    if (this.args[i].contains("vmcdrom=")) {
                        this.vmcdrom = Boolean.valueOf(this.args[i].substring(this.args[i].lastIndexOf("vmcdrom=") + 8));
                        continue;
                    }
                    if (this.args[i].contains("debug=")) {
                        this.debugFile = new File(this.args[i].substring(this.args[i].lastIndexOf("debug=") + 6));
                        if (this.debugFile.exists()) continue;
                        System.out.println("Debug file is not exist!");
                        return false;
                    }
                    if (this.args[i].contains("config=")) {
                        this.configFile = new File(this.args[i].substring(this.args[i].lastIndexOf("config=") + 7));
                        if (this.configFile.exists()) continue;
                        System.out.println("Config file is not exist!");
                        return false;
                    }
                    if (i == 0) {
                        this.miniOSISOName = this.args[i];
                        continue;
                    }
                    if (i == 1) {
                        this.serverIP = this.args[i];
                        continue;
                    }
                    if (i != 2) continue;
                    this.osType = this.args[i];
                }
                if (!this.readConfigFile()) {
                    return false;
                }
                if (this.miniOSISOName == null || this.serverIP == null || this.osType == null) {
                    System.out.println("***Please ensure those parameters are not null:");
                    System.out.println("Mini OS name:" + this.miniOSISOName);
                    System.out.println("Source server address:" + this.serverIP);
                    System.out.println("OS type:" + this.osType);
                    return false;
                }
                switch (this.osType) {
                    case "ubuntu14": {
                        this.osInstallScript = "instUbuntu14.sh" + (this.uefiMode ? " uefi" : "");
                        break;
                    }
                    case "ubuntu16": {
                        this.osInstallScript = "instUbuntu16.sh" + (this.uefiMode ? " uefi" : "");
                        break;
                    }
                    case "centos6": {
                        this.osInstallScript = "instCent6.sh" + (this.uefiMode ? " uefi" : "");
                        break;
                    }
                    case "centos7": {
                        this.osInstallScript = "instCent7.sh" + (this.uefiMode ? " uefi" : "");
                        break;
                    }
                    case "redhat75": {
                        this.osInstallScript = "instRedhat7.sh" + (this.uefiMode ? " uefi" : "");
                        break;
                    }
                    case "suse11": {
                        this.osInstallScript = "instSuse11.sh" + (this.uefiMode ? " uefi" : "");
                        break;
                    }
                    case "suse12": {
                        this.osInstallScript = "instSuse12.sh" + (this.uefiMode ? " uefi" : "");
                        break;
                    }
                    case "win2016": {
                        this.osInstallScript = "instWin.bat";
                        this.isLinux = false;
                        break;
                    }
                    case "custom": {
                        this.customInstall = true;
                        break;
                    }
                    default: {
                        System.out.println("OS type is not correct!");
                        return false;
                    }
                }
                return true;
            }
            return false;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public OSDeployCommand build() {
            return new OSDeployCommand(this);
        }

        public Builder setBMCIP(String bmcIP) {
            this.bmcIP = bmcIP;
            return this.getThis();
        }

        public Builder setBMCUsername(String username) {
            this.bmcUsername = username;
            return this.getThis();
        }

        public Builder setBMCPassword(String password) {
            this.bmcPassword = password;
            return this.getThis();
        }

        public Builder setBMCMAC(String mac) {
            this.bmcMac = mac;
            return this.getThis();
        }

        public Builder setServerIP(String serverIP) {
            this.serverIP = serverIP;
            return this.getThis();
        }

        public Builder setOSImage(String osISOName) {
            this.miniOSISOName = osISOName;
            return this.getThis();
        }

        public Builder setOSType(String osType) {
            this.osType = osType;
            return this.getThis();
        }

        @Override
        public void close() throws Exception {
            this.args = null;
            this.bmcIP = null;
            this.bmcUsername = null;
            this.bmcPassword = null;
            this.serverIP = null;
            this.miniOSISOName = null;
            this.loggerWriter.close();
        }

        private boolean readConfigFile() {
            if (this.configFile != null) {
                try {
                    List<String> lines = CommonFunction.readFile(this.configFile.getAbsolutePath());
                    for (int i = 0; i < lines.size() - 1; ++i) {
                        String keyword = lines.get(i);
                        String value = lines.get(i + 1);
                        if (keyword.contains("USER_ID")) {
                            this.userID = value;
                            continue;
                        }
                        if (keyword.contains("OS_TYPE")) {
                            this.osType = value;
                            continue;
                        }
                        if (keyword.contains("UEFI")) {
                            this.uefiMode = Boolean.valueOf(value);
                            continue;
                        }
                        if (keyword.contains("WIN_MINI_OS") && this.osType.toLowerCase().contains("win")) {
                            this.miniOSISOName = value;
                            continue;
                        }
                        if (keyword.contains("LNX_MINI_OS")) {
                            this.miniOSISOName = value;
                            continue;
                        }
                        if (keyword.contains("SOURCE_SERVER_ADDRESS")) {
                            this.serverIP = value;
                            continue;
                        }
                        if (keyword.contains("OS_USER_NAME")) {
                            this.installOSAccount = value;
                            continue;
                        }
                        if (!keyword.contains("OS_USER_PASSWORD")) continue;
                        this.installOSPassword = value;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println("Config file format is not correct!");
                    return false;
                }
            }
            return true;
        }
    }
}

