/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.SDR.record;

import Gbt.utility.SDR.record.DeviceType;
import Gbt.utility.SDR.record.SensorRecord;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.veraxsystems.vxipmi.common.TypeConverter;

public final class FruDeviceLocatorRecord
extends SensorRecord {
    private int deviceAccessAddress;
    private int deviceId;
    private boolean logical;
    private int accessLun;
    private int managementChannelNumber;
    private DeviceType deviceType;
    private int deviceTypeModifier;
    private int fruEntityId;
    private int fruEntityInstance;
    private String name;

    @Override
    protected void populateTypeSpecficValues(byte[] recordData, SensorRecord record) {
        this.setDeviceAccessAddress((TypeConverter.byteToInt(recordData[5]) & 0xFE) >> 1);
        this.setLogical((TypeConverter.byteToInt(recordData[7]) & 0x80) != 0);
        int deviceId = TypeConverter.byteToInt(recordData[6]);
        if (!this.isLogical()) {
            deviceId &= 0xFE;
            deviceId >>= 1;
        }
        this.setDeviceId(deviceId);
        int id = TypeConverter.byteToInt(recordData[6]);
        if (!this.isLogical()) {
            id >>= 1;
        }
        this.setId(id);
        this.setAccessLun((TypeConverter.byteToInt(recordData[7]) & 0xC) >> 2);
        this.setManagementChannelNumber((TypeConverter.byteToInt(recordData[8]) & 0xF0) >> 4);
        this.setDeviceType(DeviceType.parseInt(TypeConverter.byteToInt(recordData[10])));
        this.setDeviceTypeModifier(TypeConverter.byteToInt(recordData[11]));
        this.setFruEntityId(TypeConverter.byteToInt(recordData[12]));
        this.setFruEntityInstance(TypeConverter.byteToInt(recordData[13]));
        byte[] name = new byte[recordData.length - 16];
        System.arraycopy(recordData, 16, name, 0, name.length);
        this.setName(this.decodeName(recordData[15], name));
    }

    @JsonProperty(value="DeviceAccessAddress")
    public int getDeviceAccessAddress() {
        return this.deviceAccessAddress;
    }

    public FruDeviceLocatorRecord setDeviceAccessAddress(int deviceAccessAddress) {
        this.deviceAccessAddress = deviceAccessAddress;
        return this;
    }

    @JsonProperty(value="DeviceId")
    public int getDeviceId() {
        return this.deviceId;
    }

    public FruDeviceLocatorRecord setDeviceId(int deviceId) {
        this.deviceId = deviceId;
        return this;
    }

    @JsonProperty(value="IsLogical")
    public boolean isLogical() {
        return this.logical;
    }

    public FruDeviceLocatorRecord setLogical(boolean logical) {
        this.logical = logical;
        return this;
    }

    @JsonProperty(value="AccessLun")
    public int getAccessLun() {
        return this.accessLun;
    }

    public FruDeviceLocatorRecord setAccessLun(int accessLun) {
        this.accessLun = accessLun;
        return this;
    }

    @JsonProperty(value="ManagementChannelNumber")
    public int getManagementChannelNumber() {
        return this.managementChannelNumber;
    }

    public FruDeviceLocatorRecord setManagementChannelNumber(int managementChannelNumber) {
        this.managementChannelNumber = managementChannelNumber;
        return this;
    }

    @JsonProperty(value="DeviceType")
    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    public FruDeviceLocatorRecord setDeviceType(DeviceType deviceType) {
        this.deviceType = deviceType;
        return this;
    }

    @JsonProperty(value="DeviceTypeModifier")
    public int getDeviceTypeModifier() {
        return this.deviceTypeModifier;
    }

    public FruDeviceLocatorRecord setDeviceTypeModifier(int deviceTypeModifier) {
        this.deviceTypeModifier = deviceTypeModifier;
        return this;
    }

    @JsonProperty(value="FruEntityId")
    public int getFruEntityId() {
        return this.fruEntityId;
    }

    public FruDeviceLocatorRecord setFruEntityId(int fruEntityId) {
        this.fruEntityId = fruEntityId;
        return this;
    }

    @JsonProperty(value="FruEntityInstance")
    public int getFruEntityInstance() {
        return this.fruEntityInstance;
    }

    public FruDeviceLocatorRecord setFruEntityInstance(int fruEntityInstance) {
        this.fruEntityInstance = fruEntityInstance;
        return this;
    }

    @JsonProperty(value="Name")
    public String getName() {
        return this.name;
    }

    public FruDeviceLocatorRecord setName(String name) {
        this.name = name;
        return this;
    }
}

