/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.SDR.record;

import Gbt.utility.SDR.SdrSensorThresholdReadingData;
import Gbt.utility.SDR.record.AddressType;
import Gbt.utility.SDR.record.EntityId;
import Gbt.utility.SDR.record.ModifierUnitUsage;
import Gbt.utility.SDR.record.RateUnit;
import Gbt.utility.SDR.record.SensorDirection;
import Gbt.utility.SDR.record.SensorRecord;
import Gbt.utility.SDR.record.SensorType;
import Gbt.utility.SDR.record.SensorUnit;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.veraxsystems.vxipmi.common.TypeConverter;
import java.util.Arrays;

public final class FullSensorRecord
extends SensorRecord {
    private byte sensorOwnerId;
    private AddressType addressType;
    private byte channelNumber;
    private byte sensorOwnerLun;
    private byte sensorNumber;
    private EntityId entityId;
    private Boolean entityPhysical;
    private byte entityInstanceNumber;
    private Boolean hysteresisReadable;
    private Boolean thresholdsReadable;
    private SensorType sensorType;
    private int eventReadingType;
    private RateUnit rateUnit;
    private ModifierUnitUsage modifierUnitUsage;
    private SensorUnit sensorBaseUnit;
    private SensorUnit sensorModifierUnit;
    private double m;
    private double tolerance;
    private double b;
    private double accuracy;
    private int rExp;
    private SensorDirection sensorDirection;
    private double nominalReading;
    private double normalMaximum;
    private double normalMinimum;
    private double sensorReading;
    private double sensorMaximumReading;
    private double sensorMinmumReading;
    private double upperNonRecoverableThreshold;
    private double lowerNonRecoverableThreshold;
    private double upperCriticalThreshold;
    private double lowerCriticalThreshold;
    private double upperNonCriticalThreshold;
    private double lowerNonCriticalThreshold;
    private String name;
    private byte sensorUnits1;
    private int linearization;
    private Boolean upperNonRecoverableThresholdReadable = false;
    private Boolean upperCriticalThresholdReadable = false;
    private Boolean upperNonCriticalThresholdReadable = false;
    private Boolean lowerNonRecoverableThresholdReadable = false;
    private Boolean lowerCriticalThresholdReadable = false;
    private Boolean lowerNonCriticalThresholdReadable = false;
    private byte[] sensorReadingCalParameter;
    private byte[] settableThresholdMask;

    private double getM() {
        return this.m;
    }

    private void setM(double m) {
        this.m = m;
    }

    private double getB() {
        return this.b;
    }

    private void setB(double b) {
        this.b = b;
    }

    private void setrExp(int rExp) {
        this.rExp = rExp;
    }

    private int getrExp() {
        return this.rExp;
    }

    @Override
    protected void populateTypeSpecficValues(byte[] recordData, SensorRecord record) {
        this.setSensorReadingCalParameter(Arrays.copyOfRange(recordData, 20, 30));
        this.setSensorOwnerId(TypeConverter.intToByte((TypeConverter.byteToInt(recordData[5]) & 0xFE) >> 1));
        this.setAddressType(AddressType.parseInt(TypeConverter.byteToInt(recordData[5]) & 1));
        this.setChannelNumber(TypeConverter.intToByte((TypeConverter.byteToInt(recordData[6]) & 0xF0) >> 4));
        this.setSensorOwnerLun(TypeConverter.intToByte(TypeConverter.byteToInt(recordData[6]) & 3));
        this.setSensorNumber(recordData[7]);
        this.setEntityId(EntityId.parseInt(TypeConverter.byteToInt(recordData[8])));
        this.setEntityPhysical((TypeConverter.byteToInt(recordData[9]) & 0x80) == 0);
        this.setEntityInstanceNumber(TypeConverter.intToByte(TypeConverter.byteToInt(recordData[9]) & 0x7F));
        int hysteresis = (TypeConverter.byteToInt(recordData[11]) & 0x30) >> 4;
        if (hysteresis == 1 || hysteresis == 2) {
            this.setHysteresisReadable(true);
        } else {
            this.setHysteresisReadable(false);
        }
        int thresholds = (TypeConverter.byteToInt(recordData[11]) & 0xC) >> 2;
        if (thresholds == 1 || thresholds == 2) {
            this.setThresholdsReadable(true);
        } else {
            this.setThresholdsReadable(false);
        }
        if (thresholds == 2) {
            this.setSettableThresholdMask(Arrays.copyOfRange(recordData, 19, 20));
        } else {
            byte[] zero = new byte[]{0};
            this.setSettableThresholdMask(zero);
        }
        this.setSensorType(SensorType.parseInt(TypeConverter.byteToInt(recordData[12])));
        this.setEventReadingType(TypeConverter.byteToInt(recordData[13]));
        this.setRateUnit(RateUnit.parseInt((TypeConverter.byteToInt(recordData[20]) & 0x38) >> 3));
        this.setModifierUnitUsage(ModifierUnitUsage.parseInt((TypeConverter.byteToInt(recordData[20]) & 6) >> 1));
        this.setSensorBaseUnit(SensorUnit.parseInt(TypeConverter.byteToInt(recordData[21])));
        this.setSensorModifierUnit(SensorUnit.parseInt(TypeConverter.byteToInt(recordData[22])));
        int calcM = TypeConverter.byteToInt(recordData[24]);
        this.setM(TypeConverter.decode2sComplement(calcM |= (TypeConverter.byteToInt(recordData[25]) & 0xC0) << 2, 9));
        this.sensorUnits1 = recordData[20];
        this.setTolerance(this.calcFormula((TypeConverter.byteToInt(recordData[25]) & 0x3F) / 2, 8, 0.0, this.sensorUnits1));
        int calcB = TypeConverter.byteToInt(recordData[26]);
        this.setB(TypeConverter.decode2sComplement(calcB |= (TypeConverter.byteToInt(recordData[27]) & 0xC0) << 2, 9));
        int calcAcc = TypeConverter.byteToInt(recordData[27]) & 0x3F;
        int exp = TypeConverter.byteToInt(recordData[28]) & 3;
        this.setAccuracy((double)(calcAcc |= (TypeConverter.byteToInt(recordData[28]) & 0xF0) << 2) / 10000.0 * Math.pow(10.0, exp));
        this.setSensorDirection(SensorDirection.parseInt(TypeConverter.byteToInt(recordData[28]) & 3));
        this.setrExp(TypeConverter.decode2sComplement((TypeConverter.byteToInt(recordData[29]) & 0xF0) >> 4, 3));
        int bExp = TypeConverter.decode2sComplement(TypeConverter.byteToInt(recordData[29]) & 0xF, 3);
        this.setB(this.getB() * Math.pow(10.0, bExp));
        this.setNominalReading(this.calcFormula(TypeConverter.byteToInt(recordData[31])));
        this.setNormalMaximum(this.calcFormula(TypeConverter.byteToInt(recordData[32])));
        this.setNormalMinimum(this.calcFormula(TypeConverter.byteToInt(recordData[33])));
        this.setSensorMaximumReading(this.calcFormula(TypeConverter.byteToInt(recordData[34])));
        this.setSensorMinmumReading(this.calcFormula(TypeConverter.byteToInt(recordData[35])));
        if ((TypeConverter.byteToInt(recordData[10]) & 4) != 0) {
            if ((TypeConverter.byteToInt(recordData[18]) & 0x20) != 0) {
                this.setUpperNonRecoverableThresholdReadable(true);
                this.setUpperNonRecoverableThreshold(this.calcFormula(TypeConverter.byteToInt(recordData[36])));
            }
            if ((TypeConverter.byteToInt(recordData[18]) & 0x10) != 0) {
                this.setUpperCriticalThresholdReadable(true);
                this.setUpperCriticalThreshold(this.calcFormula(TypeConverter.byteToInt(recordData[37])));
            }
            if ((TypeConverter.byteToInt(recordData[18]) & 8) != 0) {
                this.setUpperNonCriticalThresholdReadable(true);
                this.setUpperNonCriticalThreshold(this.calcFormula(TypeConverter.byteToInt(recordData[38])));
            }
            if ((TypeConverter.byteToInt(recordData[18]) & 4) != 0) {
                this.setLowerNonRecoverableThresholdReadable(true);
                this.setLowerNonRecoverableThreshold(this.calcFormula(TypeConverter.byteToInt(recordData[39])));
            }
            if ((TypeConverter.byteToInt(recordData[18]) & 2) != 0) {
                this.setLowerCriticalThresholdReadable(true);
                this.setLowerCriticalThreshold(this.calcFormula(TypeConverter.byteToInt(recordData[40])));
            }
            if ((TypeConverter.byteToInt(recordData[18]) & 1) != 0) {
                this.setLowerNonCriticalThresholdReadable(true);
                this.setLowerNonCriticalThreshold(this.calcFormula(TypeConverter.byteToInt(recordData[41])));
            }
        }
        byte[] name = new byte[recordData.length - 48];
        System.arraycopy(recordData, 48, name, 0, name.length);
        this.setName(this.decodeName(recordData[47], name));
        this.linearization = TypeConverter.byteToInt(recordData[23]) & 0x7F;
    }

    public double calcFormula(int value) {
        return this.calcFormula(value, 8, this.getB(), this.sensorUnits1);
    }

    protected double calcFormula(int value, int length, double b, byte sensorUnits1) {
        int dataFormat = (TypeConverter.byteToInt(sensorUnits1) & 0xC0) >> 6;
        int base = 0;
        switch (dataFormat) {
            case 0: {
                base = value;
                break;
            }
            case 1: {
                base = TypeConverter.decode1sComplement(value, length - 1);
                break;
            }
            case 2: {
                base = TypeConverter.decode2sComplement(value, length - 1);
                break;
            }
            case 3: {
                base = value;
                break;
            }
            default: {
                return base;
            }
        }
        double result = (this.getM() * (double)base + this.getB()) * Math.pow(10.0, this.getrExp());
        switch (this.linearization) {
            case 0: {
                return result;
            }
            case 1: {
                return Math.log(result);
            }
            case 2: {
                return Math.log10(result);
            }
            case 3: {
                return Math.log(result) / Math.log(2.0);
            }
            case 5: {
                return Math.pow(10.0, result);
            }
            case 6: {
                return Math.pow(2.0, result);
            }
            case 7: {
                return 1.0 / result;
            }
            case 8: {
                return Math.pow(result, 2.0);
            }
            case 9: {
                return Math.pow(result, 3.0);
            }
            case 10: {
                return Math.pow(result, 0.5);
            }
            case 11: {
                return Math.pow(result, 0.33);
            }
        }
        return base;
    }

    public int revertFormula(double readingValue) {
        return this.revertFormula(readingValue, 8, this.getB(), this.sensorUnits1);
    }

    protected int revertFormula(double readingValue, int length, double b, byte sensorUnits1) {
        int base = 0;
        double result = 0.0;
        switch (this.linearization) {
            case 0: {
                result = readingValue;
                break;
            }
            case 1: {
                result = Math.pow(Math.E, readingValue);
                break;
            }
            case 2: {
                result = Math.pow(10.0, readingValue);
                break;
            }
            case 3: {
                result = Math.pow(2.0, readingValue);
                break;
            }
            case 5: {
                result = Math.log(readingValue) / Math.log(10.0);
                break;
            }
            case 6: {
                result = Math.log(readingValue) / Math.log(2.0);
                break;
            }
            case 7: {
                result = 1.0 / readingValue;
                break;
            }
            case 8: {
                result = Math.pow(readingValue, 0.0);
                break;
            }
            case 9: {
                result = Math.pow(readingValue, 0.0);
                break;
            }
            case 10: {
                result = Math.pow(readingValue, 2.0);
                break;
            }
            case 11: {
                result = Math.pow(readingValue, 3.0303030303030303);
            }
        }
        base = (int)Math.round((result / Math.pow(10.0, this.getrExp()) - this.getB()) / this.getM());
        int dataFormat = (TypeConverter.byteToInt(sensorUnits1) & 0xC0) >> 6;
        switch (dataFormat) {
            case 0: {
                break;
            }
            case 1: {
                base = TypeConverter.decode1sComplement(base, length - 1);
                break;
            }
            case 2: {
                base = TypeConverter.decode2sComplement(base, length - 1);
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid data format in sensorUnits1");
            }
        }
        return base;
    }

    @JsonProperty(value="SensorResolution")
    public double getSensorResolution() {
        return Math.abs(this.getM() / 2.0 * Math.pow(10.0, this.getrExp()));
    }

    @JsonProperty(value="SensorOwnerId")
    public byte getSensorOwnerId() {
        return this.sensorOwnerId;
    }

    public void setSensorOwnerId(byte sensorOwnerId) {
        this.sensorOwnerId = sensorOwnerId;
    }

    @JsonProperty(value="AddressType")
    public AddressType getAddressType() {
        return this.addressType;
    }

    public void setAddressType(AddressType addressType) {
        this.addressType = addressType;
    }

    @JsonProperty(value="ChannelNumber")
    public byte getChannelNumber() {
        return this.channelNumber;
    }

    public void setChannelNumber(byte channelNumber) {
        this.channelNumber = channelNumber;
    }

    @JsonProperty(value="SensorOwnerLun")
    public byte getSensorOwnerLun() {
        return this.sensorOwnerLun;
    }

    public void setSensorOwnerLun(byte sensorOwnerLun) {
        this.sensorOwnerLun = sensorOwnerLun;
    }

    @JsonProperty(value="SensorNumber")
    public byte getSensorNumber() {
        return this.sensorNumber;
    }

    public void setSensorNumber(byte sensorNumber) {
        this.sensorNumber = sensorNumber;
    }

    @JsonProperty(value="EntityId")
    public EntityId getEntityId() {
        return this.entityId;
    }

    public void setEntityId(EntityId entityId) {
        this.entityId = entityId;
    }

    @JsonProperty(value="EntityPhysical")
    public Boolean isEntityPhysical() {
        return this.entityPhysical;
    }

    public void setEntityPhysical(Boolean entityPhysical) {
        this.entityPhysical = entityPhysical;
    }

    @JsonProperty(value="EntityInstanceNumber")
    public byte getEntityInstanceNumber() {
        return this.entityInstanceNumber;
    }

    public void setEntityInstanceNumber(byte entityInstanceNumber) {
        this.entityInstanceNumber = entityInstanceNumber;
    }

    @JsonProperty(value="HysteresisReadable")
    public Boolean isHysteresisReadable() {
        return this.hysteresisReadable;
    }

    public void setHysteresisReadable(Boolean hysteresisReadable) {
        this.hysteresisReadable = hysteresisReadable;
    }

    @JsonProperty(value="ThresholdsReadable")
    public Boolean isThresholdsReadable() {
        return this.thresholdsReadable;
    }

    public void setThresholdsReadable(Boolean thresholdsReadable) {
        this.thresholdsReadable = thresholdsReadable;
    }

    @JsonProperty(value="SensorType")
    public SensorType getSensorType() {
        return this.sensorType;
    }

    public void setSensorType(SensorType sensorType) {
        this.sensorType = sensorType;
    }

    @JsonProperty(value="EventReadingType")
    public int getEventReadingType() {
        return this.eventReadingType;
    }

    public void setEventReadingType(int eventReadingType) {
        this.eventReadingType = eventReadingType;
    }

    @JsonProperty(value="RateUnit")
    public RateUnit getRateUnit() {
        return this.rateUnit;
    }

    public void setRateUnit(RateUnit rateUnit) {
        this.rateUnit = rateUnit;
    }

    @JsonProperty(value="ModifierUnitUsage")
    public ModifierUnitUsage getModifierUnitUsage() {
        return this.modifierUnitUsage;
    }

    public void setModifierUnitUsage(ModifierUnitUsage modifierUnitUsage) {
        this.modifierUnitUsage = modifierUnitUsage;
    }

    @JsonProperty(value="SensorBaseUnit")
    public SensorUnit getSensorBaseUnit() {
        return this.sensorBaseUnit;
    }

    public void setSensorBaseUnit(SensorUnit sensorBaseUnit) {
        this.sensorBaseUnit = sensorBaseUnit;
    }

    @JsonProperty(value="SensorModifierUnit")
    public SensorUnit getSensorModifierUnit() {
        return this.sensorModifierUnit;
    }

    public void setSensorModifierUnit(SensorUnit sensorModifierUnit) {
        this.sensorModifierUnit = sensorModifierUnit;
    }

    @JsonProperty(value="Tolerance")
    public double getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(double tolerance) {
        this.tolerance = tolerance;
    }

    @JsonProperty(value="Accuracy")
    public double getAccuracy() {
        return this.accuracy;
    }

    public void setAccuracy(double accuracy) {
        this.accuracy = accuracy;
    }

    @JsonProperty(value="SensorDirection")
    public SensorDirection getSensorDirection() {
        return this.sensorDirection;
    }

    public void setSensorDirection(SensorDirection sensorDirection) {
        this.sensorDirection = sensorDirection;
    }

    @JsonProperty(value="NominalReading")
    public double getNominalReading() {
        return this.nominalReading;
    }

    public void setNominalReading(double nominalReading) {
        this.nominalReading = nominalReading;
    }

    @JsonProperty(value="NormalMaximum")
    public double getNormalMaximum() {
        return this.normalMaximum;
    }

    public void setNormalMaximum(double normalMaximum) {
        this.normalMaximum = normalMaximum;
    }

    @JsonProperty(value="NormalMinimum")
    public double getNormalMinimum() {
        return this.normalMinimum;
    }

    public void setNormalMinimum(double normalMinimum) {
        this.normalMinimum = normalMinimum;
    }

    @JsonProperty(value="SensorReading")
    public double getSensorReading() {
        return this.sensorReading;
    }

    public void setSensorReading(double sensorReading) {
        this.sensorReading = sensorReading;
    }

    @JsonProperty(value="SensorMaximumReading")
    public double getSensorMaximumReading() {
        return this.sensorMaximumReading;
    }

    public void setSensorMaximumReading(double sensorMaximumReading) {
        this.sensorMaximumReading = sensorMaximumReading;
    }

    @JsonProperty(value="SensorMinmumReading")
    public double getSensorMinmumReading() {
        return this.sensorMinmumReading;
    }

    public void setSensorMinmumReading(double sensorMinmumReading) {
        this.sensorMinmumReading = sensorMinmumReading;
    }

    @JsonProperty(value="UpperNonRecoverableThreshold")
    public double getUpperNonRecoverableThreshold() {
        return this.upperNonRecoverableThreshold;
    }

    public void setUpperNonRecoverableThreshold(double upperNonRecoverableThreshold) {
        this.upperNonRecoverableThreshold = upperNonRecoverableThreshold;
    }

    @JsonProperty(value="LowerNonRecoverableThreshold")
    public double getLowerNonRecoverableThreshold() {
        return this.lowerNonRecoverableThreshold;
    }

    public void setLowerNonRecoverableThreshold(double lowerNonRecoverableThreshold) {
        this.lowerNonRecoverableThreshold = lowerNonRecoverableThreshold;
    }

    @JsonProperty(value="UpperCriticalThreshold")
    public double getUpperCriticalThreshold() {
        return this.upperCriticalThreshold;
    }

    public void setUpperCriticalThreshold(double upperCriticalThreshold) {
        this.upperCriticalThreshold = upperCriticalThreshold;
    }

    @JsonProperty(value="LowerCriticalThreshold")
    public double getLowerCriticalThreshold() {
        return this.lowerCriticalThreshold;
    }

    public void setLowerCriticalThreshold(double lowerCriticalThreshold) {
        this.lowerCriticalThreshold = lowerCriticalThreshold;
    }

    @JsonProperty(value="UpperNonCriticalThreshold")
    public double getUpperNonCriticalThreshold() {
        return this.upperNonCriticalThreshold;
    }

    public void setUpperNonCriticalThreshold(double upperNonCriticalThreshold) {
        this.upperNonCriticalThreshold = upperNonCriticalThreshold;
    }

    @JsonProperty(value="LowerNonCriticalThreshold")
    public double getLowerNonCriticalThreshold() {
        return this.lowerNonCriticalThreshold;
    }

    public void setLowerNonCriticalThreshold(double lowerNonCriticalThreshold) {
        this.lowerNonCriticalThreshold = lowerNonCriticalThreshold;
    }

    @JsonProperty(value="Name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="SensorUnits1")
    public byte getSensorUnits1() {
        return this.sensorUnits1;
    }

    public void setSensorUnits1(byte sensorUnits1) {
        this.sensorUnits1 = sensorUnits1;
    }

    @JsonProperty(value="Linearization")
    public int getLinearization() {
        return this.linearization;
    }

    public void setLinearization(int linearization) {
        this.linearization = linearization;
    }

    @JsonProperty(value="UpperNonRecoverableThresholdReadable")
    public Boolean isUpperNonRecoverableThresholdReadable() {
        return this.upperNonRecoverableThresholdReadable;
    }

    public void setUpperNonRecoverableThresholdReadable(Boolean upperNonRecoverableThresholdReadable) {
        this.upperNonRecoverableThresholdReadable = upperNonRecoverableThresholdReadable;
    }

    @JsonProperty(value="UpperCriticalThresholdReadable")
    public Boolean isUpperCriticalThresholdReadable() {
        return this.upperCriticalThresholdReadable;
    }

    public void setUpperCriticalThresholdReadable(Boolean upperCriticalThresholdReadable) {
        this.upperCriticalThresholdReadable = upperCriticalThresholdReadable;
    }

    @JsonProperty(value="UpperNonCriticalThresholdReadable")
    public Boolean isUpperNonCriticalThresholdReadable() {
        return this.upperNonCriticalThresholdReadable;
    }

    public void setUpperNonCriticalThresholdReadable(Boolean upperNonCriticalThresholdReadable) {
        this.upperNonCriticalThresholdReadable = upperNonCriticalThresholdReadable;
    }

    @JsonProperty(value="LowerNonRecoverableThresholdReadable")
    public Boolean isLowerNonRecoverableThresholdReadable() {
        return this.lowerNonRecoverableThresholdReadable;
    }

    public void setLowerNonRecoverableThresholdReadable(Boolean lowerNonRecoverableThresholdReadable) {
        this.lowerNonRecoverableThresholdReadable = lowerNonRecoverableThresholdReadable;
    }

    @JsonProperty(value="LowerCriticalThresholdReadable")
    public Boolean isLowerCriticalThresholdReadable() {
        return this.lowerCriticalThresholdReadable;
    }

    public void setLowerCriticalThresholdReadable(Boolean lowerCriticalThresholdReadable) {
        this.lowerCriticalThresholdReadable = lowerCriticalThresholdReadable;
    }

    @JsonProperty(value="LowerNonCriticalThresholdReadable")
    public Boolean isLowerNonCriticalThresholdReadable() {
        return this.lowerNonCriticalThresholdReadable;
    }

    public void setLowerNonCriticalThresholdReadable(Boolean lowerNonCriticalThresholdReadable) {
        this.lowerNonCriticalThresholdReadable = lowerNonCriticalThresholdReadable;
    }

    @JsonProperty(value="SensorReadingCalParameter")
    public byte[] getSensorReadingCalParameter() {
        return this.sensorReadingCalParameter;
    }

    public void setSensorReadingCalParameter(byte[] sensorReadingCalParameter) {
        this.sensorReadingCalParameter = sensorReadingCalParameter;
    }

    @JsonProperty(value="SettableThresholdMask")
    public byte[] getSettableThresholdMask() {
        return this.settableThresholdMask;
    }

    public void setSettableThresholdMask(byte[] settableThresholdMask) {
        this.settableThresholdMask = settableThresholdMask;
    }

    public void thresholdRevision(SdrSensorThresholdReadingData thresholdData) {
        byte readable = thresholdData.getReadableByte();
        if ((TypeConverter.byteToInt(readable) & 0x20) != 0) {
            this.upperNonRecoverableThresholdReadable = true;
            this.setUpperNonRecoverableThreshold(this.calcFormula(TypeConverter.byteToInt(thresholdData.getUpperNonRecoverableThreshold())));
        }
        if ((TypeConverter.byteToInt(readable) & 0x10) != 0) {
            this.upperCriticalThresholdReadable = true;
            this.setUpperCriticalThreshold(this.calcFormula(TypeConverter.byteToInt(thresholdData.getUpperCriticalThreshold())));
        }
        if ((TypeConverter.byteToInt(readable) & 8) != 0) {
            this.upperNonCriticalThresholdReadable = true;
            this.setUpperNonCriticalThreshold(this.calcFormula(TypeConverter.byteToInt(thresholdData.getUpperNonCriticalThreshold())));
        }
        if ((TypeConverter.byteToInt(readable) & 4) != 0) {
            this.lowerNonRecoverableThresholdReadable = true;
            this.setLowerNonRecoverableThreshold(this.calcFormula(TypeConverter.byteToInt(thresholdData.getLowerNonRecoverableThreshold())));
        }
        if ((TypeConverter.byteToInt(readable) & 2) != 0) {
            this.lowerCriticalThresholdReadable = true;
            this.setLowerCriticalThreshold(this.calcFormula(TypeConverter.byteToInt(thresholdData.getLowerCriticalThreshold())));
        }
        if ((TypeConverter.byteToInt(readable) & 1) != 0) {
            this.lowerNonCriticalThresholdReadable = true;
            this.setLowerNonCriticalThreshold(this.calcFormula(TypeConverter.byteToInt(thresholdData.getLowerNonCriticalThreshold())));
        }
    }
}

