/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.SMBIOS;

import Gbt.utility.Common.GbtCommonConverters;
import Gbt.utility.SMBIOS.SmbiosTypeBase;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class SmbiosType17
extends SmbiosTypeBase {
    private static final String SPEED_UNIT = " MHz";
    private String deviceLocator;
    private String bankLocator;
    private String manufacturer;
    private String serialNumber;
    private String assetTag;
    private String partNumber;
    private String size;
    private String speed;
    private byte[] sizeRaw;
    private byte[] extendedSizeRaw;

    public SmbiosType17(byte[] rawData) {
        super(rawData);
    }

    @Override
    public void parser() {
        byte[] physicalMemoryArrayHandle = this.nextBYTES(2);
        byte[] memoryErrorInformationHandle = this.nextBYTES(2);
        byte[] totalWidth = this.nextBYTES(2);
        byte[] dataWidth = this.nextBYTES(2);
        this.sizeRaw = this.nextBYTES(2);
        byte formFactor = this.nextBYTE();
        byte deviceSet = this.nextBYTE();
        this.skipBYTES(2);
        byte memoryType = this.nextBYTE();
        byte[] typeDetail = this.nextBYTES(2);
        byte[] speedRaw = this.nextBYTES(2);
        this.speed = this.parseSpeedString(speedRaw);
        this.skipBYTES(4);
        byte attributes = this.nextBYTE();
        this.extendedSizeRaw = this.nextBYTES(4);
        this.deviceLocator = this.nextString();
        this.bankLocator = this.nextString();
        this.manufacturer = this.nextString();
        this.serialNumber = this.nextString();
        this.assetTag = this.nextString();
        this.partNumber = this.nextString();
        this.size = this.parseSizeString();
    }

    @JsonProperty(value="DeviceLocator")
    public String getDeviceLocator() {
        return this.deviceLocator;
    }

    @JsonProperty(value="BankLocator")
    public String getBankLocator() {
        return this.bankLocator;
    }

    @JsonProperty(value="Manufacturer")
    public String getManufacturer() {
        return this.manufacturer;
    }

    @JsonProperty(value="SerialNumber")
    public String getSerialNumber() {
        return this.serialNumber;
    }

    @JsonProperty(value="AssetTag")
    public String getAssetTag() {
        return this.assetTag;
    }

    @JsonProperty(value="PartNumber")
    public String getPartNumber() {
        return this.partNumber;
    }

    @JsonProperty(value="Size")
    public String getSize() {
        return this.size;
    }

    @JsonProperty(value="Speed")
    public String getSpeed() {
        return this.speed;
    }

    private String parseSizeString() {
        String result = "";
        long size = GbtCommonConverters.ByteArraytoLong(this.sizeRaw);
        long extSize = GbtCommonConverters.ByteArraytoLong(this.extendedSizeRaw);
        result = size == 65535L ? "Unknown" : (size == 32767L ? extSize / 1024L + " GB" : ((size & 0x8000L) == 32768L ? (size >= 1024L ? size / 1024L + " MB" : size + " KB") : (size >= 1024L ? size / 1024L + " GB" : size + " MB")));
        return result;
    }

    private String parseSpeedString(byte[] speedRaw) {
        int speedInt = speedRaw[1] << 8;
        return (speedInt += speedRaw[0]) + SPEED_UNIT;
    }
}

