/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.SMBIOS;

import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.utility.SMBIOS.SmbiosTypeCollection;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY)
public abstract class SmbiosTypeBase
extends AbstractJSONPOJO {
    protected static final int WORD = 2;
    protected static final int DWORD = 4;
    protected static final int QWORD = 8;
    protected static final int DQWORD = 16;
    private final byte[] rawData;
    private final SmbiosTypeCollection smbiosType;
    protected int length;
    private int index;

    public SmbiosTypeBase(byte[] rawData) {
        this.rawData = rawData;
        this.smbiosType = SmbiosTypeCollection.parseType(this.nextBYTE());
        this.length = this.nextBYTE();
        this.nextBYTES(2);
    }

    public abstract void parser();

    @JsonProperty(value="SmbiosType")
    public SmbiosTypeCollection getSmbiosType() {
        return this.smbiosType;
    }

    protected final byte nextBYTE() {
        return this.rawData[this.index++];
    }

    protected final byte[] nextBYTES(int quantity) {
        byte[] bytes = new byte[quantity];
        System.arraycopy(this.rawData, this.index, bytes, 0, quantity);
        this.index += quantity;
        return bytes;
    }

    protected final void skipBYTE() {
        ++this.index;
    }

    protected final void skipBYTES(int i) {
        this.index += i;
    }

    protected final String nextString() {
        StringBuilder targetString = new StringBuilder();
        for (int i = this.length; i < this.rawData.length; ++i) {
            if (this.rawData[this.length] == 0) {
                ++this.length;
                break;
            }
            targetString.append((char)(this.rawData[this.length] & 0xFF));
            ++this.length;
        }
        return targetString.toString();
    }

    protected final String getByteString(byte[] byteArray) {
        StringBuilder sb = new StringBuilder(byteArray.length * 2);
        for (int i = 0; i < byteArray.length; ++i) {
            sb.append(String.format("%02x", byteArray[i] & 0xFF));
            if (i % 2 != 1 || i == byteArray.length - 1) continue;
            sb.append(" ");
        }
        sb.append("h");
        return sb.toString();
    }
}

