/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.Trap;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.commands.GbtCommandBuilders;
import Gbt.core.engines.records.CommandTaskRecords;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.utility.API.GbtUtilityAPI2;
import Gbt.utility.Common.CommonFunction;
import Gbt.utility.Trap.TrapData;
import Gbt.utility.Trap.TrapIPMIOptions;
import Gbt.utility.Trap.TrapIpType;
import Gbt.utility.bmcinfo.BMCInfoJSONData;
import Gbt.utility.bmcinfo.BMCVendor;
import com.veraxsystems.vxipmi.api.async.ConnectionHandle;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;

public final class TrapCommand
extends AbstractCommand<Builder> {
    public static final String COMMAND_NAME = "trap";
    private final GbtIPMICommandReceiver ipmiReceiver;
    private static final int MAX_DESTINATION_SELECTOR = 8;
    private static final byte LAN_CHANNEL_NUMBER = 1;
    private static final byte LAN_PARAMETER_SELECTOR = 19;
    private static final byte PEF_ALERT_POLICY_PARA_SELECTOR = 9;
    private static final byte PEF_CHANNEL_NUMBER = 17;
    private static final byte AVCT_NET_FN = 12;
    private static final byte AVCT_GET_CMD = 10;
    private static final byte[] AVCT_OEM_KEY = new byte[]{94, 43, 0};
    private static final int MAX_DEST_SIZE = 4;
    private static final byte PARAMETER_SELETOR = 3;
    private static final int GET_REQ_SIZE = 9;
    private static final int ADDRESS_POS_IN_BLOCK0 = 13;
    private static final int ADDRESS_POS_IN_BLOCK1 = 8;
    private static final int ADDRESS_POS_IN_BLOCK2 = 8;
    private static final int ADDRESS_LENGTH_IN_BLOCK0 = 11;
    private static final int ADDRESS_LENGTH_IN_BLOCK1 = 16;
    private static final int ADDRESS_LENGTH_IN_BLOCK2 = 12;

    protected TrapCommand(Builder commandArgs) {
        super(commandArgs);
        this.commandID = ((Builder)this.commandArgs).bmcIP + "_" + COMMAND_NAME;
        this.ipmiReceiver = GbtIPMICommandReceiver.getInstance();
    }

    @Override
    public void close() throws Exception {
        ((Builder)this.commandArgs).close();
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDocumentsName() {
        return COMMAND_NAME;
    }

    @Override
    public boolean checkAll() {
        if (!((Builder)this.commandArgs).checkArgs()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Check arguments fail.");
            return false;
        }
        if (this.ipmiReceiver == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI ipmiReceiver is null.");
            return false;
        }
        return true;
    }

    @Override
    public boolean execute() {
        ConnectionHandle handle = this.ipmiReceiver.createIPMIConnection(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, COMMAND_NAME, this.commandID);
        if (handle == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI connection fail.");
            return false;
        }
        CommandTaskRecords report = GbtUtilityAPI2.commonCommand(GbtCommandBuilders.mcinfo(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword));
        AbstractJSONPOJO data = report.getResultData().get(0);
        if (data instanceof NullJSONData) {
            NullJSONData temp = data.castConcreteJSON(NullJSONData.class);
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
            this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
            return false;
        }
        BMCInfoJSONData bmcInfo = data.castConcreteJSON(BMCInfoJSONData.class);
        boolean executeStatus = false;
        if (bmcInfo.isAST2400()) {
            if (((Builder)this.commandArgs).getTrap) {
                if (this.getTrapByStandardCommand(handle, 4)) {
                    executeStatus = this.getTrapIPv6ByOEMCommand(handle);
                }
            } else if (this.setTrapByStandardCommand(handle, ((Builder)this.commandArgs).trapDataList, true)) {
                executeStatus = this.setTrapIPv6ByOEMCommand(handle, ((Builder)this.commandArgs).trapDataList);
                this.commandResults.add(new NullJSONData().setError(!executeStatus).setMessages("Set trap " + (executeStatus ? "success" : "fail")));
            }
        } else {
            int maxDestinationID = bmcInfo.getBmcVendor() == BMCVendor.AMI ? 15 : 8;
            if (((Builder)this.commandArgs).getTrap) {
                executeStatus = this.getTrapByStandardCommand(handle, maxDestinationID);
            } else {
                executeStatus = this.setTrapByStandardCommand(handle, ((Builder)this.commandArgs).trapDataList, false);
                this.commandResults.add(new NullJSONData().setError(!executeStatus).setMessages("Set trap " + (executeStatus ? "success" : "fail")));
            }
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(executeStatus ? GbtLogLevel.INFO : GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + (((Builder)this.commandArgs).getTrap ? "Get" : "Set") + " trap " + (executeStatus ? "success" : "fail") + ".");
        this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
        return executeStatus;
    }

    @Override
    public void cancelHook(Object obj) {
    }

    private boolean getTrapByStandardCommand(ConnectionHandle handle, int maxDestinationID) {
        boolean result = true;
        for (int i = 1; i <= maxDestinationID; ++i) {
            ((Builder)this.commandArgs).setDestinationID(i);
            AbstractJSONPOJO responseData = this.ipmiReceiver.sendIPMIRawCommand(handle, TrapIPMIOptions.GET, this.commandArgs, COMMAND_NAME, this.commandID);
            if (responseData instanceof NullJSONData) {
                NullJSONData temp = responseData.castConcreteJSON(NullJSONData.class);
                if (temp.isError()) {
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Get trap data fail.");
                    result = false;
                    break;
                }
            } else {
                TrapData data = responseData.castConcreteJSON(TrapData.class);
                Boolean enable = this.getTrapAlertEnable(handle, i);
                if (enable == null) {
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Get PEF data fail.");
                    result = false;
                    break;
                }
                data.setEnable(enable);
                this.commandResults.add(data);
            }
            result = true;
        }
        if (!result) {
            this.commandResults.add(new NullJSONData().setError(!result).setMessages("Get trap fail."));
        }
        return result;
    }

    private boolean setTrapByStandardCommand(ConnectionHandle handle, List<TrapData> dataList, boolean isAST2400) {
        boolean result = true;
        for (TrapData data : dataList) {
            if (isAST2400 && data.getIp_type() != TrapIpType.IPv4) continue;
            ((Builder)this.commandArgs).setTrapData(data);
            if (data.getDestination_ip() != null) {
                NullJSONData temp;
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Set dest. " + data.getDestination_id() + " to " + data.getDestination_ip());
                AbstractJSONPOJO responseData = this.ipmiReceiver.sendIPMIRawCommand(handle, TrapIPMIOptions.SET, this.commandArgs, COMMAND_NAME, this.commandID);
                if (responseData instanceof NullJSONData && (temp = responseData.castConcreteJSON(NullJSONData.class)).isError()) {
                    result = false;
                    break;
                }
            }
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Set dest. " + data.getDestination_id() + " to " + data.getEnable());
            result = this.setTrapAlertEnable(handle, data.getDestination_id(), data.getEnable());
            if (result) continue;
            break;
        }
        return result;
    }

    private boolean getTrapIPv6ByOEMCommand(ConnectionHandle handle) {
        boolean result = false;
        byte[] reqData = new byte[9];
        System.arraycopy(AVCT_OEM_KEY, 0, reqData, 0, AVCT_OEM_KEY.length);
        reqData[3] = 12;
        reqData[4] = 10;
        reqData[5] = 1;
        reqData[6] = 3;
        for (int dest = 1; dest <= 4; ++dest) {
            TrapData data = new TrapData();
            ArrayList<Byte> addressByteList = new ArrayList<Byte>();
            reqData[7] = (byte)(dest & 0xFF);
            reqData[8] = 0;
            byte[] resp = this.ipmiReceiver.getTrapIPV6(handle, reqData, COMMAND_NAME, this.commandID);
            if (resp == null) break;
            byte stringLength = resp[9];
            this.addByteArrayToList(addressByteList, Arrays.copyOfRange(resp, 13, resp.length));
            if (stringLength >= 15) {
                reqData[8] = 1;
                resp = this.ipmiReceiver.getTrapIPV6(handle, reqData, COMMAND_NAME, this.commandID);
                if (resp == null) break;
                this.addByteArrayToList(addressByteList, Arrays.copyOfRange(resp, 8, resp.length));
            }
            if (stringLength >= 31) {
                reqData[8] = 2;
                resp = this.ipmiReceiver.getTrapIPV6(handle, reqData, COMMAND_NAME, this.commandID);
                if (resp == null) break;
                this.addByteArrayToList(addressByteList, Arrays.copyOfRange(resp, 8, resp.length));
            }
            byte[] primitiveAddressArray = ArrayUtils.toPrimitive((Byte[])addressByteList.toArray(new Byte[addressByteList.size()]));
            data.setDestination_id(dest);
            data.setDestination_ip(new String(primitiveAddressArray));
            data.setIp_type(TrapIpType.IPv6);
            Boolean enable = this.getTrapAlertEnable(handle, dest + 4);
            if (enable == null) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Get PEF data fail.");
                result = false;
                break;
            }
            data.setEnable(enable);
            this.commandResults.add(data);
            if (dest != 4) continue;
            result = true;
        }
        return result;
    }

    private boolean setTrapIPv6ByOEMCommand(ConnectionHandle handle, List<TrapData> dataList) {
        for (TrapData data : dataList) {
            if (data.getIp_type() != TrapIpType.IPv6) continue;
            if (data.getDestination_ip() != null) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Set dest. " + data.getDestination_id() + " to " + data.getDestination_ip());
                byte[] destAddress = data.getDestination_ip().getBytes(StandardCharsets.US_ASCII);
                byte[] reqData = this.processIPv6OEMCommandReqData(data, 0, destAddress);
                if (!this.ipmiReceiver.setTrapIPV6(handle, reqData, COMMAND_NAME, this.commandID)) {
                    return false;
                }
                reqData = this.processIPv6OEMCommandReqData(data, 1, destAddress);
                if (!this.ipmiReceiver.setTrapIPV6(handle, reqData, COMMAND_NAME, this.commandID)) {
                    return false;
                }
                reqData = this.processIPv6OEMCommandReqData(data, 2, destAddress);
                if (!this.ipmiReceiver.setTrapIPV6(handle, reqData, COMMAND_NAME, this.commandID)) {
                    return false;
                }
            }
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Set dest. " + data.getDestination_id() + " to " + data.getEnable());
            if (this.setTrapAlertEnable(handle, data.getDestination_id() + 4, data.getEnable()).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private byte[] processIPv6OEMCommandReqData(TrapData data, int block, byte[] destAddress) {
        byte[] reqData = null;
        int AVCT_NET_FN = 12;
        int AVCT_SET_CMD = 9;
        Byte[] AVCT_OEM_KEY = new Byte[]{(byte)94, (byte)43, (byte)0};
        ArrayList<Byte> reqDataByteList = new ArrayList<Byte>();
        reqDataByteList.add(AVCT_OEM_KEY[0]);
        reqDataByteList.add(AVCT_OEM_KEY[1]);
        reqDataByteList.add(AVCT_OEM_KEY[2]);
        reqDataByteList.add((byte)12);
        reqDataByteList.add((byte)9);
        reqDataByteList.add((byte)1);
        reqDataByteList.add((byte)3);
        reqDataByteList.add((byte)(data.getDestination_id() & 0xFF));
        reqDataByteList.add((byte)(block & 0xFF));
        if (block == 0) {
            int stringLength = 42;
            reqDataByteList.add((byte)0);
            reqDataByteList.add((byte)(stringLength & 0xFF));
            reqDataByteList.add((byte)0);
            reqDataByteList.add((byte)0);
            reqDataByteList.add((byte)0);
            for (int i = 0; i < 11; ++i) {
                if (i > destAddress.length - 1) {
                    reqDataByteList.add((byte)0);
                    continue;
                }
                reqDataByteList.add(destAddress[i]);
            }
            reqData = ArrayUtils.toPrimitive((Byte[])reqDataByteList.toArray(new Byte[reqDataByteList.size()]));
        } else if (block == 1) {
            for (int i = 11; i < 27; ++i) {
                if (i > destAddress.length - 1) {
                    reqDataByteList.add((byte)0);
                    continue;
                }
                reqDataByteList.add(destAddress[i]);
            }
            reqData = ArrayUtils.toPrimitive((Byte[])reqDataByteList.toArray(new Byte[reqDataByteList.size()]));
        } else if (block == 2) {
            for (int i = 27; i < 39; ++i) {
                if (i > destAddress.length - 1) {
                    reqDataByteList.add((byte)0);
                    continue;
                }
                reqDataByteList.add(destAddress[i]);
            }
            reqData = ArrayUtils.toPrimitive((Byte[])reqDataByteList.toArray(new Byte[reqDataByteList.size()]));
        }
        return reqData;
    }

    private Boolean getTrapAlertEnable(ConnectionHandle handle, int destination) {
        byte[] getPEFReqData = new byte[]{9, (byte)(destination & 0xFF), 0};
        byte[] resp = this.ipmiReceiver.getPEFConfig(handle, getPEFReqData, COMMAND_NAME, this.commandID);
        if (resp == null) {
            return null;
        }
        if ((resp[2] & 8) == 8) {
            return true;
        }
        return false;
    }

    private Boolean setTrapAlertEnable(ConnectionHandle handle, int destination, boolean enable) {
        byte[] alertPolicyReqData = new byte[]{9, (byte)destination, (byte)(enable ? 24 : 16), (byte)(destination + 17 - 1), 0};
        return this.ipmiReceiver.setPEFConfig(handle, alertPolicyReqData, COMMAND_NAME, this.commandID);
    }

    private void addByteArrayToList(List<Byte> byteList, byte[] byteArray) {
        for (byte b : byteArray) {
            byteList.add(b);
        }
    }

    public static final class Builder
    extends AbstractCommandBuilder<Builder> {
        private String bmcIP;
        private String bmcUsername = "admin";
        private String bmcPassword = "password";
        private boolean getTrap = true;
        private List<TrapData> trapDataList;
        private TrapData trapData;
        private int destinationID;

        @Override
        public boolean checkArgs() {
            if (this.bmcIP == null) {
                return false;
            }
            if (this.args != null) {
                if (this.args.length < 2) {
                    return false;
                }
                try {
                    this.getTrap = false;
                    int destinationNum = Integer.parseInt(this.args[0]);
                    List<String> trapIPList = Arrays.asList(Arrays.copyOfRange(this.args, 1, this.args.length));
                    this.trapDataList = new ArrayList<TrapData>();
                    if (destinationNum < 0 || destinationNum > 8) {
                        return false;
                    }
                    if (destinationNum == 0) {
                        if (trapIPList.size() != 8) {
                            System.out.println("Number of trap IP must equal to 8.");
                            return false;
                        }
                        for (int i = 0; i < trapIPList.size(); ++i) {
                            if (this.processReqData(i + 1, trapIPList.get(i))) continue;
                            return false;
                        }
                    } else {
                        if (trapIPList.size() != 1) {
                            System.out.println("Number of trap IP must equal to 1.");
                            return false;
                        }
                        if (!this.processReqData(destinationNum, trapIPList.get(0))) {
                            return false;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
            return true;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public TrapCommand build() {
            return new TrapCommand(this);
        }

        @Override
        public void close() throws Exception {
            this.args = null;
            this.bmcIP = null;
            this.bmcUsername = null;
            this.bmcPassword = null;
            this.trapDataList = null;
            this.loggerWriter.close();
        }

        private boolean processReqData(int destinationNum, String trapIP) {
            try {
                if (CommonFunction.isIPv4(trapIP) && trapIP.contains(".")) {
                    TrapData data = new TrapData();
                    data.setDestination_id(destinationNum);
                    data.setDestination_ip(trapIP);
                    data.setEnable(true);
                    data.setIp_type(TrapIpType.IPv4);
                    this.trapDataList.add(data);
                } else if (CommonFunction.isIPv6(trapIP) && trapIP.contains(":")) {
                    TrapData data = new TrapData();
                    data.setDestination_id(destinationNum);
                    data.setDestination_ip(trapIP);
                    data.setEnable(true);
                    data.setIp_type(TrapIpType.IPv6);
                    this.trapDataList.add(data);
                } else if (trapIP.equals("0")) {
                    TrapData data = new TrapData();
                    data.setDestination_id(destinationNum);
                    data.setDestination_ip(null);
                    data.setEnable(false);
                    data.setIp_type(TrapIpType.IPv4);
                    this.trapDataList.add(data);
                } else if (trapIP.equals("1")) {
                    TrapData data = new TrapData();
                    data.setDestination_id(destinationNum);
                    data.setDestination_ip(null);
                    data.setEnable(true);
                    data.setIp_type(TrapIpType.IPv4);
                    this.trapDataList.add(data);
                } else if (!trapIP.equals("2")) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }

        public Builder setBMCIP(String bmcIP) {
            this.bmcIP = bmcIP;
            return this.getThis();
        }

        public Builder setBMCUsername(String username) {
            this.bmcUsername = username;
            return this.getThis();
        }

        public Builder setBMCPassword(String password) {
            this.bmcPassword = password;
            return this.getThis();
        }

        public Builder setTrapDataList(List<TrapData> trapDataList) {
            this.trapDataList = trapDataList;
            return this.getThis();
        }

        protected int getDestinationID() {
            return this.destinationID;
        }

        private void setDestinationID(int destinationID) {
            this.destinationID = destinationID;
        }

        public Builder setGetTrap(boolean getTrap) {
            this.getTrap = getTrap;
            return this.getThis();
        }

        protected TrapData getTrapData() {
            return this.trapData;
        }

        private void setTrapData(TrapData trapData) {
            this.trapData = trapData;
        }
    }
}

