/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.Update.parsers;

import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.utility.Common.CommonFunction;
import Gbt.utility.Common.GIGABYTEChecksum;
import Gbt.utility.FRU.record.BoardInfo;
import Gbt.utility.FRU.record.ProductInfo;
import Gbt.utility.Update.UpdateType;
import Gbt.utility.Update.fwInfo.BIOSUpdateFWInfo;
import Gbt.utility.Update.parsers.SuitableFwParser;
import Gbt.utility.bmcinfo.BMCInfoJSONData;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.ArrayUtils;

public final class BiosSuitableFwParser
extends SuitableFwParser {
    private boolean skipCheckBiosSubject;
    private boolean ignoreChecksum;

    public BiosSuitableFwParser(AbstractLoggerWriter loggerWriter, String commandName, String commandId, String bmcIpAddress) {
        super(loggerWriter, commandName, commandId, bmcIpAddress);
    }

    @Override
    public BIOSUpdateFWInfo parseSuitableFw(List<File> fwPackages, BoardInfo boardInfo, ProductInfo productInfo, BMCInfoJSONData mcinfo) {
        String boardProduct = boardInfo.getBoardProductName();
        String productName = productInfo.getProductName();
        ArrayList<BIOSUpdateFWInfo> chosenPkgs = new ArrayList<BIOSUpdateFWInfo>();
        for (File fwPkg : fwPackages) {
            String dirPath = FilenameUtils.removeExtension((String)fwPkg.getAbsolutePath());
            List<File> relNotePathList = CommonFunction.searchFilesInDirector(dirPath, ".doc", true);
            relNotePathList.addAll(CommonFunction.searchFilesInDirector(dirPath, ".docx", true));
            relNotePathList.addAll(CommonFunction.searchFilesInDirector(dirPath, ".pdf", true));
            if (relNotePathList.isEmpty()) {
                this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandId, "[" + this.bmcIpAddress + "] Cannot find any BIOS release notes.");
                return null;
            }
            for (File relNotePath : relNotePathList) {
                BIOSUpdateFWInfo biosInfo = new BIOSUpdateFWInfo();
                biosInfo.setBmcVendor(mcinfo.getBmcVendor());
                biosInfo.setTargetBmcIp(this.bmcIpAddress);
                biosInfo.setUpdateType(UpdateType.BIOS);
                biosInfo.setFWFolderPath(dirPath);
                biosInfo.setReleaseNote(relNotePath);
                List<String> lines = CommonFunction.readDocumentsAsLineList(relNotePath.getAbsolutePath());
                String[] subjects = CommonFunction.grepLineMessages(lines, "BIOS Release Notes version").split("BIOS Release Notes version");
                if (subjects.length != 2) {
                    this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandId, "[" + this.bmcIpAddress + "] Cannot read the BIOS subject and version in release notes : " + relNotePath.getName());
                    continue;
                }
                biosInfo.setSupportedBoardProduct(subjects[0].replace("SUBJECT:", "").trim());
                biosInfo.setVersion(subjects[1].trim());
                subjects = CommonFunction.grepLineMessages(lines, "System:", true, "About This Release", false).split(":");
                if (subjects.length != 2) {
                    this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandId, "[" + this.bmcIpAddress + "] Cannot read the BIOS system names in release notes : " + relNotePath.getName());
                    continue;
                }
                biosInfo.setSupportedProductName(subjects[1].trim().replace(" ", ""));
                subjects = CommonFunction.grepLineMessages(lines, "Build Date:").split(":");
                if (subjects.length != 2) {
                    this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandId, "[" + this.bmcIpAddress + "] Cannot read the BIOS build date in release notes : " + relNotePath.getName());
                    continue;
                }
                biosInfo.setReleaseDate(subjects[1].trim());
                subjects = CommonFunction.grepLineMessages(lines, "BIOS Checksum:").split(":")[1].trim().split(",");
                if (subjects.length == 1) {
                    biosInfo.setShortChecksum("0");
                    biosInfo.setLongChecksum(subjects[0].split("\\(")[0].trim());
                } else if (subjects.length == 2) {
                    biosInfo.setShortChecksum(subjects[0].split("\\(")[0].trim());
                    biosInfo.setLongChecksum(subjects[1].split("\\(")[0].trim());
                } else {
                    this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandId, "[" + this.bmcIpAddress + "] Cannot read the BIOS Checksum in release notes : " + relNotePath.getName());
                    continue;
                }
                String imagePath = this.findBIOSFWImgByChecksum(dirPath, ".rbu", biosInfo);
                if (imagePath == null) {
                    this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandId, "[" + this.bmcIpAddress + "] Checksum in release notes : " + relNotePath.getName() + " and RBU image are mismatched.");
                    this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.DEBUG, this.commandId, "[" + this.bmcIpAddress + "] " + biosInfo.toString());
                    continue;
                }
                biosInfo.setImagePath(imagePath);
                if (this.compareBIOSFWProductName(boardProduct, productName, biosInfo, mcinfo)) {
                    chosenPkgs.add(biosInfo);
                    continue;
                }
                this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandId, "[" + this.bmcIpAddress + "] The product name or board product in FRU and release notes : " + relNotePath.getName() + " are mismatched");
                this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.DEBUG, this.commandId, "[" + this.bmcIpAddress + "] " + biosInfo.toString());
            }
        }
        if (chosenPkgs.isEmpty()) {
            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandId, "[" + this.bmcIpAddress + "] Cannot find any suitable BIOS FW.");
            return null;
        }
        long[] longDates = new long[chosenPkgs.size()];
        for (int i = 0; i < chosenPkgs.size(); ++i) {
            longDates[i] = ((BIOSUpdateFWInfo)chosenPkgs.get(i)).getReleaseDate().getTime();
        }
        List<Long> b = Arrays.asList(ArrayUtils.toObject((long[])longDates));
        BIOSUpdateFWInfo finalOutput = (BIOSUpdateFWInfo)chosenPkgs.get(b.indexOf(Collections.max(b)));
        this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.INFO, this.commandId, "[" + this.bmcIpAddress + "] Matched release note : " + finalOutput.getReleaseNote().getAbsolutePath());
        return finalOutput;
    }

    public void setSkipCheckBiosSubject(boolean skipCheckBiosSubject) {
        this.skipCheckBiosSubject = skipCheckBiosSubject;
    }

    public void setIgnoreChecksum(boolean ignoreChecksum) {
        this.ignoreChecksum = ignoreChecksum;
    }

    private String findBIOSFWImgByChecksum(String searchRootPath, String firmwareExtName, BIOSUpdateFWInfo biosInfo) {
        List<File> imgPath = CommonFunction.searchFilesInDirector(searchRootPath, firmwareExtName, true);
        if (imgPath.isEmpty()) {
            return null;
        }
        for (File anImgPath : imgPath) {
            if (this.ignoreChecksum) {
                this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.DEBUG, this.commandId, "[" + this.bmcIpAddress + "] Ignore checksum examing and return the first found RBU file!");
                return anImgPath.getAbsolutePath();
            }
            int imageChecksum = GIGABYTEChecksum.getBIOSChecksum(anImgPath.getAbsolutePath());
            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.DEBUG, this.commandId, "[" + this.bmcIpAddress + "] Checksum of \"" + anImgPath.getAbsolutePath() + "\" is " + imageChecksum);
            if (biosInfo.getLongChecksum() != imageChecksum) continue;
            return anImgPath.getAbsolutePath();
        }
        return null;
    }

    private boolean compareBIOSFWProductName(String boardProduct, String productName, BIOSUpdateFWInfo BIOSFWinfo, BMCInfoJSONData bmcInfoJSONData) {
        String _boardProduct;
        String _releaseNoteBoardProduct;
        if (boardProduct == null && productName == null) {
            return false;
        }
        if (BIOSFWinfo.getSupportedBoardProduct() == null) {
            return false;
        }
        for (String name : BIOSFWinfo.getSupportedProductName()) {
            if (name.equals(productName)) {
                return true;
            }
            if (!name.equals(boardProduct)) continue;
            return true;
        }
        if (this.skipCheckBiosSubject) {
            return true;
        }
        String string = bmcInfoJSONData.isAST2400() ? (BIOSFWinfo.getSupportedBoardProduct().split("-").length == 3 ? BIOSFWinfo.getSupportedBoardProduct() : BIOSFWinfo.getSupportedBoardProduct() + "-XX") : (_releaseNoteBoardProduct = BIOSFWinfo.getSupportedBoardProduct().split("-").length == 3 ? BIOSFWinfo.getSupportedBoardProduct() : BIOSFWinfo.getSupportedBoardProduct() + "-00");
        String string2 = bmcInfoJSONData.isAST2400() ? (boardProduct.split("-").length == 3 ? boardProduct : boardProduct + "-XX") : (_boardProduct = boardProduct.split("-").length == 3 ? boardProduct : boardProduct + "-00");
        if (_releaseNoteBoardProduct.equals(productName)) {
            return true;
        }
        return _releaseNoteBoardProduct.equals(_boardProduct);
    }
}

