/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.bmclanconfig;

import Gbt.core.ipmi.GbtIPMIOptions;
import Gbt.core.ipmi.GbtIpmiCommandResponseData;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.utility.Common.GbtCommonConverters;
import Gbt.utility.bmcinfo.BMCInfoJSONData;
import Gbt.utility.bmcinfo.BMCVendor;
import Gbt.utility.bmclanconfig.BMCARPControlStates;
import Gbt.utility.bmclanconfig.BMCLanConfigAuthType;
import Gbt.utility.bmclanconfig.BMCLanConfigCommand;
import Gbt.utility.bmclanconfig.BMCLanConfigData;
import Gbt.utility.bmclanconfig.BMCLanConfigIPHeaders;
import Gbt.utility.bmclanconfig.BMCLanConfigIPSource;
import Gbt.utility.bmclanconfig.BMCLanProgressStates;
import com.veraxsystems.vxipmi.coding.commands.PrivilegeLevel;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public enum BMCLanConfigIPMIOptions implements GbtIPMIOptions<BMCLanConfigCommand.Builder>
{
    UNKNOWN(0, "Unknown", 12, 0),
    GET_PROGRESS_STATE(0, "Set in Progress", 12, 2),
    GET_AUTH_TYPE_SUPPORT(1, "Auth Type Support", 12, 2),
    GET_AUTH_TYPE_ENABLES(2, "Auth Type Enable", 12, 2),
    GET_IP_ADDRESS(3, "IP Address", 12, 2),
    GET_IP_ADDRESS_SOURCE(4, "IP Address Source", 12, 2),
    GET_MAC_ADDRESS(5, "MAC Address", 12, 2),
    GET_SUBNET_MASK(6, "Subnet Mask", 12, 2),
    GET_IPV4_HEADERS(7, "IPv4 Headers", 12, 2),
    GET_PRIMARY_RMCP_PORT(8, "Primary RMCP Port Number", 12, 2),
    GET_SECONDARY_RMCP_PORT(9, "Secondary RMCP Port Number", 12, 2),
    GET_BMC_ARP_CONTROL(10, "BMC ARP Control", 12, 2),
    GET_GRATUITOUS_ARP_INTERVAL(11, "Gratituous ARP Interval", 12, 2),
    GET_DEFAULT_GATEWAY_IP(12, "Default Gateway Address", 12, 2),
    GET_DEFAULT_GATEWAY_MAC_ADDRESS(13, "Default Gateway MAC Address", 12, 2),
    GET_BACKUP_GATEWAY_IP(14, "Backup Gateway Address", 12, 2),
    GET_BACKUP_GATEWAY_MAC_ADDRESS(15, "Backup Gateway MAC Address", 12, 2),
    GET_COMMUNITY_STRING(16, "Community String", 12, 2),
    GET_IPV6_ENABLE(51, "IPv6 enable", 12, 2),
    GET_IPV6_ADDRESS(56, "IPv6 address", 12, 2),
    GET_AMI_OEM_IPV6_LINK_LOCAL_ADDRESS(207, "IPv6 link local address", 12, 2),
    GET_IPV6_ADDRESS_SOURCE(56, "IPv6 address source", 12, 2),
    GET_IPV6_ROUTER_ADDRESS(65, "IPv6 router address", 12, 2),
    GET_IPV6_ROUTER_ADDRESS_SOURCE(64, "IPv6 router address source", 12, 2),
    GET_OEM_IPV6_ADDRESS(209, "OEM IPv6 address", 46, 33),
    GET_OEM_IPV6_ADDRESS_SOURCE(210, "OEM IPv6 address source", 46, 33),
    GET_OEM_IPV6_STATUS(208, "OEM IPv6 enable", 46, 33),
    GET_OEM_IPV6_ROUTER_ADDRESS(212, "OEM IPv6 router address", 46, 33),
    GET_OEM_IPV6_LINK_LOCAL_ADDRESS(211, "OEM IPv6 link local address", 46, 33),
    SET_PROGRESS_STATE(0, "Set in Progress", 12, 1),
    SET_AUTH_TYPE_SUPPORT(1, "Auth Type Support", 12, 1),
    SET_AUTH_TYPE_ENABLES(2, "Auth Type Enable", 12, 1),
    SET_IP_ADDRESS(3, "IP Address", 12, 1),
    SET_IP_ADDRESS_SOURCE(4, "IP Address Source", 12, 1),
    SET_MAC_ADDRESS(5, "MAC Address", 12, 1),
    SET_SUBNET_MASK(6, "Subnet Mask", 12, 1),
    SET_IPV4_HEADERS(7, "IPv4 Headers", 12, 1),
    SET_PRIMARY_RMCP_PORT(8, "Primary RMCP Port Number", 12, 1),
    SET_SECONDARY_RMCP_PORT(9, "Secondary RMCP Port Number", 12, 1),
    SET_BMC_ARP_CONTROL(10, "BMC ARP Control", 12, 1),
    SET_GRATUITOUS_ARP_INTERVAL(11, "Gratituous ARP Interval", 12, 1),
    SET_DEFAULT_GATEWAY_IP(12, "Default Gateway Address", 12, 1),
    SET_DEFAULT_GATEWAY_MAC_ADDRESS(13, "Default Gateway MAC Address", 12, 1),
    SET_BACKUP_GATEWAY_IP(14, "Backup Gateway Address", 12, 1),
    SET_BACKUP_GATEWAY_MAC_ADDRESS(15, "Backup Gateway MAC Address", 12, 1),
    SET_COMMUNITY_STRING(16, "Community String", 12, 1),
    SET_IPV6_ENABLE(51, "IPv6 enable", 12, 1),
    SET_IPV6_ADDRESS(56, "IPv6 address", 12, 1),
    SET_IPV6_ADDRESS_SOURCE(56, "IPv6 address source", 12, 1),
    SET_IPV6_ROUTER_ADDRESS(65, "IPv6 router address", 12, 1),
    SET_IPV6_ROUTER_ADDRESS_SOURCE(64, "IPv6 router address source", 12, 1),
    SET_OEM_IPV6_ADDRESS(209, "OEM IPv6 address", 46, 32),
    SET_OEM_IPV6_ADDRESS_SOURCE(210, "OEM IPv6 address source", 46, 32),
    SET_OEM_IPV6_STATUS(208, "OEM IPv6 enable", 46, 32),
    SET_OEM_IPV6_ROUTER_ADDRESS(212, "OEM IPv6 router address", 46, 32);

    private static final String PROGRESS_STATE_ITEM = "Set in Progress";
    private static final String AUTH_TYPE_SUPPORT_ITEM = "Auth Type Support";
    private static final String AUTH_TYPE_ENABLES_ITEM = "Auth Type Enable";
    private static final String IP_ADDRESS_ITEM = "IP Address";
    private static final String IP_ADDRESS_SOURCE_ITEM = "IP Address Source";
    private static final String MAC_ADDRESS_ITEM = "MAC Address";
    private static final String SUBNET_MASK_ITEM = "Subnet Mask";
    private static final String IPv4_HEADERS_ITEM = "IPv4 Headers";
    private static final String PRIMARY_RMCP_PORT_ITEM = "Primary RMCP Port Number";
    private static final String SECONDARY_RMCP_PORT_ITEM = "Secondary RMCP Port Number";
    private static final String BMC_ARP_CONTROL_ITEM = "BMC ARP Control";
    private static final String GRATUITOUS_ARP_INTERVAL_ITEM = "Gratituous ARP Interval";
    private static final String DEFAULT_GATEWAY_IP_ITEM = "Default Gateway Address";
    private static final String DEFAULT_GATEWAY_MAC_ADDRESS_ITEM = "Default Gateway MAC Address";
    private static final String BACKUP_GATEWAY_IP_ITEM = "Backup Gateway Address";
    private static final String BACKUP_GATEWAY_MAC_ADDRESS_ITEM = "Backup Gateway MAC Address";
    private static final String COMMUNITY_STRING_ITEM = "Community String";
    private static final String IPV6_ENABLE_ITEM = "IPv6 enable";
    private static final String IPV6_ADDRESS_ITEM = "IPv6 address";
    private static final String IPV6_ADDRESS_SOURCE_ITEM = "IPv6 address source";
    private static final String IPV6_LINK_LOCAL_ADDRESS_ITEM = "IPv6 link local address";
    private static final String IPV6_ROUTER_ADDRESS_ITEM = "IPv6 router address";
    private static final String IPV6_ROUTER_ADDRESS_SOURCE_ITEM = "IPv6 router address source";
    private static final String OEM_IPV6_ENABLE_ITEM = "OEM IPv6 enable";
    private static final String OEM_IPV6_ADDRESS_ITEM = "OEM IPv6 address";
    private static final String OEM_IPV6_ADDRESS_SOURCE_ITEM = "OEM IPv6 address source";
    private static final String OEM_IPV6_LINK_LOCAL_ADDRESS_ITEM = "OEM IPv6 link local address";
    private static final String OEM_IPV6_ROUTER_ADDRESS_ITEM = "OEM IPv6 router address";
    private static final int PROGRESS_STATE_CODE = 0;
    private static final int AUTH_TYPE_SUPPORT_CODE = 1;
    private static final int AUTH_TYPE_ENABLES_CODE = 2;
    private static final int IP_ADDRESS_CODE = 3;
    private static final int IP_ADDRESS_SOURCE_CODE = 4;
    private static final int MAC_ADDRESS_CODE = 5;
    private static final int SUBNET_MASK_CODE = 6;
    private static final int IPv4_HEADERS_CODE = 7;
    private static final int PRIMARY_RMCP_PORT_CODE = 8;
    private static final int SECONDARY_RMCP_PORT_CODE = 9;
    private static final int BMC_ARP_CONTROL_CODE = 10;
    private static final int GRATUITOUS_ARP_INTERVAL_CODE = 11;
    private static final int DEFAULT_GATEWAY_IP_CODE = 12;
    private static final int DEFAULT_GATEWAY_MAC_ADDRESS_CODE = 13;
    private static final int BACKUP_GATEWAY_IP_CODE = 14;
    private static final int BACKUP_GATEWAY_MAC_ADDRESS_CODE = 15;
    private static final int COMMUNITY_STRING_CODE = 16;
    private static final int IPV6_ENABLE_CODE = 51;
    private static final int IPV6_ADDRESS_CODE = 56;
    private static final int IPV6_ADDRESS_SOURCE_CODE = 56;
    private static final int IPV6_ROUTER_ADDRESS_SOURCE_CODE = 64;
    private static final int IPV6_ROUTER_ADDRESS_CODE = 65;
    private static final int IPV6_LINK_LOCAL_ADDRESS_CODE = 207;
    private static final int OEM_IPV6_ENABLE_CODE = 208;
    private static final int OEM_IPV6_ADDRESS_CODE = 209;
    private static final int OEM_IPV6_ADDRESS_SOURCE_CODE = 210;
    private static final int OEM_IPV6_LINK_LOCAL_ADDRESS_CODE = 211;
    private static final int OEM_IPV6_ROUTER_ADDRESS_CODE = 212;
    private static final byte NET_FN = 12;
    private static final byte SET_CMD = 1;
    private static final byte GET_CMD = 2;
    private static final byte OEM_NET_FN = 46;
    private static final byte OEM_SET_CMD = 32;
    private static final byte OEM_GET_CMD = 33;
    private final int optionCode;
    private final String item;
    private final byte netFn;
    private final byte commandCode;

    private BMCLanConfigIPMIOptions(int optionCode, String item, byte netFn, byte commandCode) {
        this.optionCode = optionCode;
        this.item = item;
        this.netFn = netFn;
        this.commandCode = commandCode;
    }

    @Override
    public int getOptionCode() {
        return this.optionCode;
    }

    @Override
    public String getItem() {
        return this.item;
    }

    @Override
    public byte getNetFn() {
        return this.netFn;
    }

    @Override
    public byte getCommandCode() {
        return this.commandCode;
    }

    @Override
    public byte[] rebuildRequestData(BMCLanConfigCommand.Builder commandArgs) {
        switch (this) {
            case GET_PROGRESS_STATE: {
                return new byte[]{commandArgs.getChannel(), (byte)this.optionCode, 0, 0};
            }
            case GET_AUTH_TYPE_SUPPORT: {
                return new byte[]{commandArgs.getChannel(), (byte)this.optionCode, 0, 0};
            }
            case GET_AUTH_TYPE_ENABLES: {
                return new byte[]{commandArgs.getChannel(), (byte)this.optionCode, 0, 0};
            }
            case GET_IP_ADDRESS: {
                return new byte[]{commandArgs.getChannel(), (byte)this.optionCode, 0, 0};
            }
            case GET_IP_ADDRESS_SOURCE: {
                return new byte[]{commandArgs.getChannel(), (byte)this.optionCode, 0, 0};
            }
            case GET_MAC_ADDRESS: {
                return new byte[]{commandArgs.getChannel(), (byte)this.optionCode, 0, 0};
            }
            case GET_SUBNET_MASK: {
                return new byte[]{commandArgs.getChannel(), (byte)this.optionCode, 0, 0};
            }
            case GET_IPV4_HEADERS: {
                return new byte[]{commandArgs.getChannel(), (byte)this.optionCode, 0, 0};
            }
            case GET_PRIMARY_RMCP_PORT: {
                return new byte[]{commandArgs.getChannel(), (byte)this.optionCode, 0, 0};
            }
            case GET_SECONDARY_RMCP_PORT: {
                return new byte[]{commandArgs.getChannel(), (byte)this.optionCode, 0, 0};
            }
            case GET_BMC_ARP_CONTROL: {
                return new byte[]{commandArgs.getChannel(), (byte)this.optionCode, 0, 0};
            }
            case GET_GRATUITOUS_ARP_INTERVAL: {
                return new byte[]{commandArgs.getChannel(), (byte)this.optionCode, 0, 0};
            }
            case GET_DEFAULT_GATEWAY_IP: {
                return new byte[]{commandArgs.getChannel(), (byte)this.optionCode, 0, 0};
            }
            case GET_DEFAULT_GATEWAY_MAC_ADDRESS: {
                return new byte[]{commandArgs.getChannel(), (byte)this.optionCode, 0, 0};
            }
            case GET_BACKUP_GATEWAY_IP: {
                return new byte[]{commandArgs.getChannel(), (byte)this.optionCode, 0, 0};
            }
            case GET_BACKUP_GATEWAY_MAC_ADDRESS: {
                return new byte[]{commandArgs.getChannel(), (byte)this.optionCode, 0, 0};
            }
            case GET_COMMUNITY_STRING: {
                return new byte[]{commandArgs.getChannel(), (byte)this.optionCode, 0, 0};
            }
            case GET_IPV6_ENABLE: {
                return new byte[]{commandArgs.getChannel(), (byte)this.optionCode, 0, 0};
            }
            case GET_IPV6_ADDRESS: {
                return new byte[]{commandArgs.getChannel(), (byte)this.optionCode, 0, 0};
            }
            case GET_AMI_OEM_IPV6_LINK_LOCAL_ADDRESS: {
                return new byte[]{commandArgs.getChannel(), (byte)this.optionCode, 0, 0};
            }
            case GET_IPV6_ADDRESS_SOURCE: {
                return new byte[]{commandArgs.getChannel(), (byte)this.optionCode, 0, 0};
            }
            case GET_IPV6_ROUTER_ADDRESS: {
                return new byte[]{commandArgs.getChannel(), (byte)this.optionCode, 0, 0};
            }
            case GET_IPV6_ROUTER_ADDRESS_SOURCE: {
                return new byte[]{commandArgs.getChannel(), (byte)this.optionCode, 0, 0};
            }
            case GET_OEM_IPV6_STATUS: {
                return new byte[]{10, 60, 0, 4, 0};
            }
            case GET_OEM_IPV6_ADDRESS: {
                return new byte[]{10, 60, 0, 4, 2};
            }
            case GET_OEM_IPV6_ADDRESS_SOURCE: {
                return new byte[]{10, 60, 0, 4, 1};
            }
            case GET_OEM_IPV6_LINK_LOCAL_ADDRESS: {
                return new byte[]{10, 60, 0, 4, 4};
            }
            case GET_OEM_IPV6_ROUTER_ADDRESS: {
                return new byte[]{10, 60, 0, 4, 3};
            }
            case SET_IP_ADDRESS_SOURCE: {
                return new byte[]{commandArgs.getChannel(), (byte)this.optionCode, commandArgs.getBmcLanConfigData().getIpAddressSource().getMatchByte()};
            }
            case SET_DEFAULT_GATEWAY_IP: {
                byte[] temp = GbtCommonConverters.ipv4ToBytes(commandArgs.getBmcLanConfigData().getDefaultGatewayIPAddress());
                byte[] reqData = new byte[2 + temp.length];
                reqData[0] = commandArgs.getChannel();
                reqData[1] = (byte)this.optionCode;
                System.arraycopy(temp, 0, reqData, 2, temp.length);
                return reqData;
            }
            case SET_IP_ADDRESS: {
                byte[] temp = GbtCommonConverters.ipv4ToBytes(commandArgs.getBmcLanConfigData().getIpAddress());
                byte[] reqData = new byte[2 + temp.length];
                reqData[0] = commandArgs.getChannel();
                reqData[1] = (byte)this.optionCode;
                System.arraycopy(temp, 0, reqData, 2, temp.length);
                return reqData;
            }
            case SET_SUBNET_MASK: {
                byte[] temp = GbtCommonConverters.ipv4ToBytes(commandArgs.getBmcLanConfigData().getSubnetMask());
                byte[] reqData = new byte[2 + temp.length];
                reqData[0] = commandArgs.getChannel();
                reqData[1] = (byte)this.optionCode;
                System.arraycopy(temp, 0, reqData, 2, temp.length);
                return reqData;
            }
            case SET_IPV6_ENABLE: {
                byte[] reqData = new byte[]{commandArgs.getChannel(), (byte)this.optionCode, commandArgs.getBmcLanConfigData().getIpv6Enable() != false ? (byte)2 : 0};
                return reqData;
            }
            case SET_IPV6_ADDRESS: {
                byte[] temp = GbtCommonConverters.ipv6ToBytes(commandArgs.getBmcLanConfigData().getIpv6Address());
                byte[] reqData = new byte[22];
                reqData[0] = commandArgs.getChannel();
                reqData[1] = (byte)this.optionCode;
                reqData[2] = 0;
                reqData[3] = -128;
                System.arraycopy(temp, 0, reqData, 4, temp.length);
                if (commandArgs.getBmcLanConfigData().getIpv6Prefix() == null) {
                    reqData[20] = 64;
                } else {
                    reqData[20] = commandArgs.getBmcLanConfigData().getIpv6Prefix().byteValue();
                    reqData[21] = 0;
                }
                return reqData;
            }
            case SET_IPV6_ADDRESS_SOURCE: {
                byte[] reqData = new byte[22];
                for (int i = 0; i < reqData.length; ++i) {
                    reqData[i] = 0;
                }
                reqData[0] = commandArgs.getChannel();
                reqData[1] = (byte)this.optionCode;
                reqData[2] = 0;
                reqData[3] = commandArgs.getBmcLanConfigData().getIpv6AddressSource() == BMCLanConfigIPSource.DHCPAddress ? 0 : -128;
                return reqData;
            }
            case SET_IPV6_ROUTER_ADDRESS: {
                byte[] temp = GbtCommonConverters.ipv6ToBytes(commandArgs.getBmcLanConfigData().getIpv6RouterAddress());
                byte[] reqData = new byte[18];
                reqData[0] = commandArgs.getChannel();
                reqData[1] = (byte)this.optionCode;
                System.arraycopy(temp, 0, reqData, 2, temp.length);
                return reqData;
            }
            case SET_IPV6_ROUTER_ADDRESS_SOURCE: {
                byte control = 0;
                if (commandArgs.getBmcLanConfigData().getIpv6DynamicRouterAddressControl().booleanValue()) {
                    control = (byte)(control | 2);
                }
                if (commandArgs.getBmcLanConfigData().getIpv6StaticRouterAddressControl().booleanValue()) {
                    control = (byte)(control | 1);
                }
                byte[] reqData = new byte[]{commandArgs.getChannel(), (byte)this.optionCode, control};
                return reqData;
            }
            case SET_OEM_IPV6_ADDRESS: {
                byte[] temp = commandArgs.getBmcLanConfigData().getIpv6Address().getBytes(StandardCharsets.US_ASCII);
                BigInteger prefix = commandArgs.getBmcLanConfigData().getIpv6Prefix() == null ? new BigInteger("64") : commandArgs.getBmcLanConfigData().getIpv6Prefix();
                byte[] prefixByteArray = Integer.toString(prefix.intValue()).getBytes(StandardCharsets.US_ASCII);
                byte[] reqData = new byte[temp.length + prefixByteArray.length + 1 + 5];
                reqData[0] = 10;
                reqData[1] = 60;
                reqData[2] = 0;
                reqData[3] = 4;
                reqData[4] = 1;
                System.arraycopy(temp, 0, reqData, 5, temp.length);
                reqData[temp.length + 5] = 47;
                System.arraycopy(prefixByteArray, 0, reqData, temp.length + 6, prefixByteArray.length);
                return reqData;
            }
            case SET_OEM_IPV6_ADDRESS_SOURCE: {
                return new byte[]{10, 60, 0, 4, 3};
            }
            case SET_OEM_IPV6_STATUS: {
                return new byte[]{10, 60, 0, 4, commandArgs.getBmcLanConfigData().getIpv6Enable() == Boolean.TRUE ? (byte)1 : 0};
            }
            case SET_OEM_IPV6_ROUTER_ADDRESS: {
                byte[] temp = commandArgs.getBmcLanConfigData().getIpv6RouterAddress().getBytes(StandardCharsets.US_ASCII);
                byte[] reqData = new byte[temp.length + 5];
                reqData[0] = 10;
                reqData[1] = 60;
                reqData[2] = 0;
                reqData[3] = 4;
                reqData[4] = 2;
                System.arraycopy(temp, 0, reqData, 5, temp.length);
                return reqData;
            }
        }
        return new byte[0];
    }

    @Override
    public AbstractJSONPOJO parserResponseData(GbtIpmiCommandResponseData gbtResponseData) {
        BMCLanConfigData bmcLanConfigData = new BMCLanConfigData();
        switch (this) {
            case GET_PROGRESS_STATE: {
                bmcLanConfigData.setLanProgressStates(BMCLanProgressStates.parseByByte(gbtResponseData.getResponseData(1)));
                return bmcLanConfigData;
            }
            case GET_AUTH_TYPE_SUPPORT: {
                bmcLanConfigData.setAuthTypeSupports(BMCLanConfigAuthType.parseSupportedTypesByRawByte(gbtResponseData.getResponseData(1)));
                return bmcLanConfigData;
            }
            case GET_AUTH_TYPE_ENABLES: {
                HashMap<PrivilegeLevel, List<BMCLanConfigAuthType>> enableMap = new HashMap<PrivilegeLevel, List<BMCLanConfigAuthType>>();
                enableMap.put(PrivilegeLevel.Callback, BMCLanConfigAuthType.parseSupportedTypesByRawByte(gbtResponseData.getResponseData(1)));
                enableMap.put(PrivilegeLevel.User, BMCLanConfigAuthType.parseSupportedTypesByRawByte(gbtResponseData.getResponseData(2)));
                enableMap.put(PrivilegeLevel.Operator, BMCLanConfigAuthType.parseSupportedTypesByRawByte(gbtResponseData.getResponseData(3)));
                enableMap.put(PrivilegeLevel.Administrator, BMCLanConfigAuthType.parseSupportedTypesByRawByte(gbtResponseData.getResponseData(4)));
                enableMap.put(PrivilegeLevel.OEM, BMCLanConfigAuthType.parseSupportedTypesByRawByte(gbtResponseData.getResponseData(5)));
                bmcLanConfigData.setAuthTypeEnables(enableMap);
                return bmcLanConfigData;
            }
            case GET_IP_ADDRESS: {
                byte[] rawIP = new byte[4];
                System.arraycopy(gbtResponseData.getAllResponseData(), 1, rawIP, 0, rawIP.length);
                bmcLanConfigData.setIpAddress(GbtCommonConverters.bytesToIPv4Address(rawIP));
                return bmcLanConfigData;
            }
            case GET_IP_ADDRESS_SOURCE: {
                bmcLanConfigData.setIpAddressSource(BMCLanConfigIPSource.parseByByte(gbtResponseData.getResponseData(1)));
                return bmcLanConfigData;
            }
            case GET_MAC_ADDRESS: {
                byte[] rawMac = new byte[6];
                System.arraycopy(gbtResponseData.getAllResponseData(), 1, rawMac, 0, rawMac.length);
                bmcLanConfigData.setMacAddress(GbtCommonConverters.bytesToMacAddressPure(rawMac));
                return bmcLanConfigData;
            }
            case GET_SUBNET_MASK: {
                byte[] rawSubmask = new byte[4];
                System.arraycopy(gbtResponseData.getAllResponseData(), 1, rawSubmask, 0, rawSubmask.length);
                bmcLanConfigData.setSubnetMask(GbtCommonConverters.bytesToIPv4Address(rawSubmask));
                return bmcLanConfigData;
            }
            case GET_IPV4_HEADERS: {
                BMCLanConfigIPHeaders headers = new BMCLanConfigIPHeaders();
                headers.setTTL(GbtCommonConverters.bytesToHex(gbtResponseData.getResponseData(1)));
                headers.setFlags(GbtCommonConverters.bytesToHex(gbtResponseData.getResponseData(2)));
                headers.setPrecedence(GbtCommonConverters.bytesToHex((byte)(gbtResponseData.getResponseData(3) & 0xFFFFFFE0)));
                headers.setTOS(GbtCommonConverters.bytesToHex((byte)(gbtResponseData.getResponseData(3) & 0x1F)));
                bmcLanConfigData.setIpHeaders(headers);
                return bmcLanConfigData;
            }
            case GET_PRIMARY_RMCP_PORT: {
                byte[] priPort = new byte[]{gbtResponseData.getResponseData(2), gbtResponseData.getResponseData(1)};
                bmcLanConfigData.setPrimaryRMCPPort(new BigInteger(priPort));
                return bmcLanConfigData;
            }
            case GET_SECONDARY_RMCP_PORT: {
                byte[] secPort = new byte[]{gbtResponseData.getResponseData(2), gbtResponseData.getResponseData(1)};
                bmcLanConfigData.setSecondaryRMCPPort(new BigInteger(secPort));
                return bmcLanConfigData;
            }
            case GET_BMC_ARP_CONTROL: {
                BMCARPControlStates states = new BMCARPControlStates();
                states.setBMCARPResponsesEnable((gbtResponseData.getResponseData(1) & 2) == 0 ? Boolean.FALSE : Boolean.TRUE);
                states.setGratuitousARPsEnable((gbtResponseData.getResponseData(1) & 1) == 0 ? Boolean.FALSE : Boolean.TRUE);
                bmcLanConfigData.setBmcARPControl(states);
                return bmcLanConfigData;
            }
            case GET_GRATUITOUS_ARP_INTERVAL: {
                byte[] interval = new byte[]{gbtResponseData.getResponseData(1)};
                bmcLanConfigData.setGratuitousARPInterval(new BigInteger(interval));
                return bmcLanConfigData;
            }
            case GET_DEFAULT_GATEWAY_IP: {
                byte[] rawDefaultGatewayIp = new byte[4];
                System.arraycopy(gbtResponseData.getAllResponseData(), 1, rawDefaultGatewayIp, 0, rawDefaultGatewayIp.length);
                bmcLanConfigData.setDefaultGatewayIPAddress(GbtCommonConverters.bytesToIPv4Address(rawDefaultGatewayIp));
                return bmcLanConfigData;
            }
            case GET_DEFAULT_GATEWAY_MAC_ADDRESS: {
                byte[] defMac = new byte[6];
                System.arraycopy(gbtResponseData.getAllResponseData(), 1, defMac, 0, defMac.length);
                bmcLanConfigData.setDefaultGatewayMAC(GbtCommonConverters.bytesToMacAddressPure(defMac));
                return bmcLanConfigData;
            }
            case GET_BACKUP_GATEWAY_IP: {
                byte[] backIP = new byte[4];
                System.arraycopy(gbtResponseData.getAllResponseData(), 1, backIP, 0, backIP.length);
                bmcLanConfigData.setBackupGatewayIPAddress(GbtCommonConverters.bytesToIPv4Address(backIP));
                return bmcLanConfigData;
            }
            case GET_BACKUP_GATEWAY_MAC_ADDRESS: {
                byte[] backMac = new byte[6];
                System.arraycopy(gbtResponseData.getAllResponseData(), 1, backMac, 0, backMac.length);
                bmcLanConfigData.setBackupGatewayMAC(GbtCommonConverters.bytesToMacAddressPure(backMac));
                return bmcLanConfigData;
            }
            case GET_COMMUNITY_STRING: {
                byte[] communityStrings = new byte[18];
                System.arraycopy(gbtResponseData.getAllResponseData(), 1, communityStrings, 0, communityStrings.length);
                bmcLanConfigData.setCommunityStrings(GbtCommonConverters.asciiBytesToString(communityStrings));
                return bmcLanConfigData;
            }
            case GET_IPV6_ENABLE: {
                if (gbtResponseData.getAllResponseData()[1] == 1 || gbtResponseData.getAllResponseData()[1] == 2) {
                    bmcLanConfigData.setIpv6Enable(true);
                } else {
                    bmcLanConfigData.setIpv6Enable(false);
                }
                return bmcLanConfigData;
            }
            case GET_IPV6_ADDRESS: {
                byte[] ipv6Addr = new byte[16];
                System.arraycopy(gbtResponseData.getAllResponseData(), 3, ipv6Addr, 0, ipv6Addr.length);
                bmcLanConfigData.setIpv6Address(GbtCommonConverters.bytesToIPv6Address(ipv6Addr));
                bmcLanConfigData.setIpv6Prefix(new BigInteger(Byte.toString(gbtResponseData.getAllResponseData()[19])));
                return bmcLanConfigData;
            }
            case GET_AMI_OEM_IPV6_LINK_LOCAL_ADDRESS: {
                byte[] ipv6LocalAddr = new byte[16];
                System.arraycopy(gbtResponseData.getAllResponseData(), 1, ipv6LocalAddr, 0, ipv6LocalAddr.length);
                bmcLanConfigData.setIpv6LinkLocalAddress(GbtCommonConverters.bytesToIPv6Address(ipv6LocalAddr));
                return bmcLanConfigData;
            }
            case GET_IPV6_ADDRESS_SOURCE: {
                if ((gbtResponseData.getAllResponseData()[2] & 0x80) == 128) {
                    bmcLanConfigData.setIpv6AddressSource(BMCLanConfigIPSource.StaticAddress);
                } else {
                    bmcLanConfigData.setIpv6AddressSource(BMCLanConfigIPSource.DHCPAddress);
                }
                return bmcLanConfigData;
            }
            case GET_IPV6_ROUTER_ADDRESS: {
                byte[] ipv6Router = new byte[16];
                System.arraycopy(gbtResponseData.getAllResponseData(), 1, ipv6Router, 0, ipv6Router.length);
                bmcLanConfigData.setIpv6RouterAddress(GbtCommonConverters.bytesToIPv6Address(ipv6Router));
                return bmcLanConfigData;
            }
            case GET_IPV6_ROUTER_ADDRESS_SOURCE: {
                if ((gbtResponseData.getAllResponseData()[1] & 1) == 1) {
                    bmcLanConfigData.setIpv6StaticRouterAddressControl(true);
                } else {
                    bmcLanConfigData.setIpv6StaticRouterAddressControl(false);
                }
                if ((gbtResponseData.getAllResponseData()[1] & 2) == 2) {
                    bmcLanConfigData.setIpv6DynamicRouterAddressControl(true);
                } else {
                    bmcLanConfigData.setIpv6DynamicRouterAddressControl(false);
                }
                return bmcLanConfigData;
            }
            case GET_OEM_IPV6_STATUS: {
                bmcLanConfigData.setIpv6Enable(gbtResponseData.getAllResponseData()[3] == 2);
                return bmcLanConfigData;
            }
            case GET_OEM_IPV6_ADDRESS: {
                int addressLength = gbtResponseData.getAllResponseData()[3] & 0xFF;
                byte[] address = new byte[addressLength];
                System.arraycopy(gbtResponseData.getAllResponseData(), 4, address, 0, addressLength);
                bmcLanConfigData.setIpv6Address(new String(address));
                return bmcLanConfigData;
            }
            case GET_OEM_IPV6_ADDRESS_SOURCE: {
                bmcLanConfigData.setIpv6AddressSource((gbtResponseData.getAllResponseData()[3] & 0x30) == 48 ? BMCLanConfigIPSource.DHCPAddress : BMCLanConfigIPSource.StaticAddress);
                return bmcLanConfigData;
            }
            case GET_OEM_IPV6_LINK_LOCAL_ADDRESS: {
                int localAddressLength = gbtResponseData.getAllResponseData()[3] & 0xFF;
                byte[] localAddress = new byte[localAddressLength];
                System.arraycopy(gbtResponseData.getAllResponseData(), 4, localAddress, 0, localAddressLength);
                bmcLanConfigData.setIpv6LinkLocalAddress(new String(localAddress));
                return bmcLanConfigData;
            }
            case GET_OEM_IPV6_ROUTER_ADDRESS: {
                int gatewayLength = gbtResponseData.getAllResponseData()[3] & 0xFF;
                byte[] gateway = new byte[gatewayLength];
                System.arraycopy(gbtResponseData.getAllResponseData(), 4, gateway, 0, gatewayLength);
                bmcLanConfigData.setIpv6RouterAddress(new String(gateway));
                return bmcLanConfigData;
            }
            case SET_IP_ADDRESS: {
                return new NullJSONData().setMessages("Set " + this.getItem() + " success.").setError(false);
            }
            case SET_IP_ADDRESS_SOURCE: {
                return new NullJSONData().setMessages("Set " + this.getItem() + " success.").setError(false);
            }
            case SET_SUBNET_MASK: {
                return new NullJSONData().setMessages("Set " + this.getItem() + " success.").setError(false);
            }
            case SET_DEFAULT_GATEWAY_IP: {
                return new NullJSONData().setMessages("Set " + this.getItem() + " success.").setError(false);
            }
            case SET_BACKUP_GATEWAY_IP: {
                return new NullJSONData().setMessages("Set " + this.getItem() + " success.").setError(false);
            }
            case SET_IPV6_ENABLE: {
                return new NullJSONData().setMessages("Set " + this.getItem() + " success.").setError(false);
            }
            case SET_IPV6_ADDRESS: {
                return new NullJSONData().setMessages("Set " + this.getItem() + " success.").setError(false);
            }
            case SET_IPV6_ADDRESS_SOURCE: {
                return new NullJSONData().setMessages("Set " + this.getItem() + " success.").setError(false);
            }
            case SET_IPV6_ROUTER_ADDRESS: {
                return new NullJSONData().setMessages("Set " + this.getItem() + " success.").setError(false);
            }
            case SET_OEM_IPV6_STATUS: {
                return new NullJSONData().setMessages("Set " + this.getItem() + " success.").setError(false);
            }
            case SET_OEM_IPV6_ADDRESS: {
                return new NullJSONData().setMessages("Set " + this.getItem() + " success.").setError(false);
            }
            case SET_OEM_IPV6_ADDRESS_SOURCE: {
                return new NullJSONData().setMessages("Set " + this.getItem() + " success.").setError(false);
            }
            case SET_OEM_IPV6_ROUTER_ADDRESS: {
                return new NullJSONData().setMessages("Set " + this.getItem() + " success.").setError(false);
            }
        }
        return bmcLanConfigData;
    }

    public static final BMCLanConfigIPMIOptions parseOptionByCode(int optionCode, boolean isSetOption) {
        if (isSetOption) {
            switch (optionCode) {
                case 0: {
                    return SET_PROGRESS_STATE;
                }
                case 1: {
                    return SET_AUTH_TYPE_SUPPORT;
                }
                case 2: {
                    return SET_AUTH_TYPE_ENABLES;
                }
                case 3: {
                    return SET_IP_ADDRESS;
                }
                case 4: {
                    return SET_IP_ADDRESS_SOURCE;
                }
                case 5: {
                    return SET_MAC_ADDRESS;
                }
                case 6: {
                    return SET_SUBNET_MASK;
                }
                case 7: {
                    return SET_IPV4_HEADERS;
                }
                case 8: {
                    return SET_PRIMARY_RMCP_PORT;
                }
                case 9: {
                    return SET_SECONDARY_RMCP_PORT;
                }
                case 10: {
                    return SET_BMC_ARP_CONTROL;
                }
                case 11: {
                    return SET_GRATUITOUS_ARP_INTERVAL;
                }
                case 12: {
                    return SET_DEFAULT_GATEWAY_IP;
                }
                case 13: {
                    return SET_DEFAULT_GATEWAY_MAC_ADDRESS;
                }
                case 14: {
                    return SET_BACKUP_GATEWAY_IP;
                }
                case 15: {
                    return SET_BACKUP_GATEWAY_MAC_ADDRESS;
                }
                case 16: {
                    return SET_COMMUNITY_STRING;
                }
            }
            return UNKNOWN;
        }
        switch (optionCode) {
            case 0: {
                return GET_PROGRESS_STATE;
            }
            case 1: {
                return GET_AUTH_TYPE_SUPPORT;
            }
            case 2: {
                return GET_AUTH_TYPE_ENABLES;
            }
            case 3: {
                return GET_IP_ADDRESS;
            }
            case 4: {
                return GET_IP_ADDRESS_SOURCE;
            }
            case 5: {
                return GET_MAC_ADDRESS;
            }
            case 6: {
                return GET_SUBNET_MASK;
            }
            case 7: {
                return GET_IPV4_HEADERS;
            }
            case 8: {
                return GET_PRIMARY_RMCP_PORT;
            }
            case 9: {
                return GET_SECONDARY_RMCP_PORT;
            }
            case 10: {
                return GET_BMC_ARP_CONTROL;
            }
            case 11: {
                return GET_GRATUITOUS_ARP_INTERVAL;
            }
            case 12: {
                return GET_DEFAULT_GATEWAY_IP;
            }
            case 13: {
                return GET_DEFAULT_GATEWAY_MAC_ADDRESS;
            }
            case 14: {
                return GET_BACKUP_GATEWAY_IP;
            }
            case 15: {
                return GET_BACKUP_GATEWAY_MAC_ADDRESS;
            }
            case 16: {
                return GET_COMMUNITY_STRING;
            }
        }
        return UNKNOWN;
    }

    public static final List<BMCLanConfigIPMIOptions> getFullOptions(boolean getConfig, BMCInfoJSONData bmcInfoJSONData, BMCLanConfigData bmcLanConfigData) {
        ArrayList<BMCLanConfigIPMIOptions> options = new ArrayList<BMCLanConfigIPMIOptions>();
        if (getConfig) {
            for (int i = 0; i < 17; ++i) {
                if (i == 9) continue;
                options.add(BMCLanConfigIPMIOptions.parseOptionByCode(i, !getConfig));
            }
            switch (bmcInfoJSONData.getBmcVendor()) {
                case AMI: {
                    options.add(GET_IPV6_ENABLE);
                    options.add(GET_IPV6_ADDRESS_SOURCE);
                    options.add(GET_IPV6_ADDRESS);
                    options.add(GET_IPV6_ROUTER_ADDRESS);
                    options.add(GET_IPV6_ROUTER_ADDRESS_SOURCE);
                    options.add(GET_AMI_OEM_IPV6_LINK_LOCAL_ADDRESS);
                    break;
                }
                case VERTIV: {
                    if (bmcInfoJSONData.isAST2400() || bmcInfoJSONData.isCMC()) {
                        options.add(GET_OEM_IPV6_STATUS);
                        options.add(GET_OEM_IPV6_ADDRESS_SOURCE);
                        options.add(GET_OEM_IPV6_ADDRESS);
                        options.add(GET_OEM_IPV6_ROUTER_ADDRESS);
                        break;
                    }
                    options.add(GET_IPV6_ENABLE);
                    options.add(GET_IPV6_ADDRESS_SOURCE);
                    options.add(GET_IPV6_ADDRESS);
                    options.add(GET_IPV6_ROUTER_ADDRESS);
                    options.add(GET_IPV6_ROUTER_ADDRESS_SOURCE);
                    options.add(GET_OEM_IPV6_LINK_LOCAL_ADDRESS);
                    break;
                }
                case OPENBMC: {
                    options.add(GET_IPV6_ENABLE);
                    options.add(GET_IPV6_ADDRESS_SOURCE);
                    options.add(GET_IPV6_ADDRESS);
                    options.add(GET_IPV6_ROUTER_ADDRESS);
                    options.add(GET_IPV6_ROUTER_ADDRESS_SOURCE);
                }
            }
        } else {
            if (bmcLanConfigData.getIpAddressSource() != null) {
                options.add(SET_IP_ADDRESS_SOURCE);
            }
            if (bmcLanConfigData.getIpAddress() != null) {
                options.add(SET_IP_ADDRESS);
            }
            if (bmcLanConfigData.getSubnetMask() != null) {
                options.add(SET_SUBNET_MASK);
            }
            if (bmcLanConfigData.getDefaultGatewayIPAddress() != null) {
                options.add(SET_DEFAULT_GATEWAY_IP);
            }
            if (bmcInfoJSONData.isAST2400()) {
                if (bmcLanConfigData.getIpv6Enable() != null) {
                    options.add(SET_OEM_IPV6_STATUS);
                }
                if (bmcLanConfigData.getIpv6AddressSource() != null && bmcLanConfigData.getIpv6AddressSource() == BMCLanConfigIPSource.DHCPAddress) {
                    options.add(SET_OEM_IPV6_ADDRESS_SOURCE);
                }
                if (bmcLanConfigData.getIpv6Address() != null) {
                    options.add(SET_OEM_IPV6_ADDRESS);
                }
                if (bmcLanConfigData.getIpv6RouterAddress() != null) {
                    options.add(SET_OEM_IPV6_ROUTER_ADDRESS);
                }
            } else if (bmcInfoJSONData.getBmcVendor() == BMCVendor.VERTIV && bmcInfoJSONData.isCMC()) {
                if (bmcLanConfigData.getIpv6Enable() != null) {
                    options.add(SET_OEM_IPV6_STATUS);
                }
                if (bmcLanConfigData.getIpv6AddressSource() != null && bmcLanConfigData.getIpv6AddressSource() == BMCLanConfigIPSource.DHCPAddress) {
                    options.add(SET_OEM_IPV6_ADDRESS_SOURCE);
                }
                if (bmcLanConfigData.getIpv6Address() != null) {
                    options.add(SET_OEM_IPV6_ADDRESS);
                }
                if (bmcLanConfigData.getIpv6RouterAddress() != null) {
                    options.add(SET_OEM_IPV6_ROUTER_ADDRESS);
                }
            } else {
                if (bmcLanConfigData.getIpv6Enable() != null) {
                    options.add(SET_IPV6_ENABLE);
                }
                if (bmcLanConfigData.getIpv6AddressSource() != null) {
                    options.add(SET_IPV6_ADDRESS_SOURCE);
                }
                if (bmcLanConfigData.getIpv6Address() != null) {
                    options.add(SET_IPV6_ADDRESS);
                }
                if (bmcLanConfigData.getIpv6RouterAddress() != null) {
                    options.add(SET_IPV6_ROUTER_ADDRESS);
                }
            }
        }
        return options;
    }
}

