/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.bootoptions;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.utility.bootoptions.BootOptionCmdResults;
import Gbt.utility.bootoptions.BootOptions;
import com.veraxsystems.vxipmi.api.async.ConnectionHandle;

public final class SetBootOptionCommand
extends AbstractCommand<Builder> {
    public static final String COMMAND_NAME = "boot";
    private final GbtIPMICommandReceiver ipmiReceiver;

    protected SetBootOptionCommand(Builder commandArgs) {
        super(commandArgs);
        this.commandID = ((Builder)this.commandArgs).bmcIP + "_" + COMMAND_NAME;
        this.ipmiReceiver = GbtIPMICommandReceiver.getInstance();
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDocumentsName() {
        return COMMAND_NAME;
    }

    @Override
    public boolean checkAll() {
        if (!((Builder)this.commandArgs).checkArgs()) {
            return false;
        }
        if (this.ipmiReceiver == null) {
            return false;
        }
        return ((Builder)this.commandArgs).bmcIP != null;
    }

    @Override
    public boolean execute() {
        BootOptionCmdResults bootOptionCmdResults = new BootOptionCmdResults();
        this.commandResults.add(bootOptionCmdResults);
        bootOptionCmdResults.setBootOption(((Builder)this.commandArgs).bootOptions);
        bootOptionCmdResults.setUefiMode(((Builder)this.commandArgs).uefiMode);
        ConnectionHandle handle = this.ipmiReceiver.createIPMIConnection(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, COMMAND_NAME, this.commandID);
        if (handle == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI connection fail.");
            bootOptionCmdResults.setSuccess(Boolean.FALSE);
            return false;
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start to set boot option.");
        boolean ok = this.ipmiReceiver.setBootOption(handle, ((Builder)this.commandArgs).bootOptions, ((Builder)this.commandArgs).uefiMode, COMMAND_NAME, this.commandID);
        this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
        bootOptionCmdResults.setSuccess(ok);
        return ok;
    }

    @Override
    public void cancelHook(Object obj) {
    }

    @Override
    public void close() throws Exception {
        ((Builder)this.commandArgs).close();
    }

    public static final class Builder
    extends AbstractCommandBuilder<Builder> {
        private String bmcIP;
        protected String bmcUsername = "admin";
        protected String bmcPassword = "password";
        private BootOptions bootOptions = BootOptions.None;
        private boolean uefiMode = false;

        @Override
        public boolean checkArgs() {
            if (this.args != null) {
                if (this.args.length != 2) {
                    return false;
                }
                this.bootOptions = BootOptions.parserOptions(this.args[0]);
                switch (this.args[1]) {
                    case "uefi": {
                        this.uefiMode = true;
                        break;
                    }
                    case "legacy": {
                        this.uefiMode = false;
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            }
            return this.bootOptions != BootOptions.None;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public SetBootOptionCommand build() {
            return new SetBootOptionCommand(this);
        }

        public Builder setBMCIP(String bmcIP) {
            this.bmcIP = bmcIP;
            return this.getThis();
        }

        public Builder setBMCUsername(String username) {
            this.bmcUsername = username;
            return this.getThis();
        }

        public Builder setBMCPassword(String password) {
            this.bmcPassword = password;
            return this.getThis();
        }

        public Builder setBootOption(BootOptions bootOptions) {
            this.bootOptions = bootOptions;
            return this.getThis();
        }

        public Builder setUEFIMode(boolean uefiMode) {
            this.uefiMode = uefiMode;
            return this.getThis();
        }

        @Override
        public void close() throws Exception {
            this.args = null;
            this.bmcIP = null;
            this.bmcUsername = null;
            this.bmcPassword = null;
            this.loggerWriter.close();
        }
    }
}

