/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.redfish.services;

import Gbt.core.jsonapi.JacksonCommonUtil;
import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.redfish.RedfishApiPayload;
import Gbt.core.redfish.RedfishApiService;
import Gbt.core.rest.RESTException;
import Gbt.core.rest.RESTHttpMethods;
import Gbt.core.rest.RESTRequest;
import Gbt.core.rest.RESTRequestImpl;
import Gbt.utility.redfish.RestFullResponseData;
import Gbt.utility.redfish.factories.RedfishApiMenu;
import Gbt.utility.redfish.options.EthernetApiOptions;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Response;

public final class EthernetApi
extends RedfishApiService<PayLoad> {
    protected EthernetApi(PayLoad servicePayload) {
        super(servicePayload);
    }

    @Override
    public String getServiceName() {
        return RedfishApiMenu.ETHERNET.getApiName();
    }

    @Override
    protected boolean checkRawArgs() {
        if (((PayLoad)this.servicePayload).getRestRawArgs().length == 0) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((PayLoad)this.servicePayload).getIpAddress() + "] The input arguments not enough.");
            return false;
        }
        ((PayLoad)this.servicePayload).setServiceOption(EthernetApiOptions.parse(((PayLoad)this.servicePayload).getRestRawArgs()[0]));
        switch ((EthernetApiOptions)((PayLoad)this.servicePayload).getServiceOption()) {
            case LIST: {
                if (((PayLoad)this.servicePayload).getRestRawArgs().length == 2) {
                    ((PayLoad)this.servicePayload).setManagerId(((PayLoad)this.servicePayload).getRestRawArgs()[1]);
                }
                return true;
            }
            case GET: {
                switch (((PayLoad)this.servicePayload).getRestRawArgs().length) {
                    case 2: {
                        ((PayLoad)this.servicePayload).setEthernetId(((PayLoad)this.servicePayload).getRestRawArgs()[1]);
                        return true;
                    }
                    case 3: {
                        ((PayLoad)this.servicePayload).setManagerId(((PayLoad)this.servicePayload).getRestRawArgs()[1]);
                        ((PayLoad)this.servicePayload).setEthernetId(((PayLoad)this.servicePayload).getRestRawArgs()[2]);
                        return true;
                    }
                }
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((EthernetApiOptions)((PayLoad)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                return false;
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((EthernetApiOptions)((PayLoad)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
        return false;
    }

    @Override
    protected boolean checkPayLoad() {
        switch ((EthernetApiOptions)((PayLoad)this.servicePayload).getServiceOption()) {
            case LIST: {
                return true;
            }
            case GET: {
                if (((PayLoad)this.servicePayload).getEthernetId() == null) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((EthernetApiOptions)((PayLoad)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                    return false;
                }
                return true;
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((EthernetApiOptions)((PayLoad)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        Client client = null;
        try {
            client = this.restReceiver.createHttpsClient(((PayLoad)this.servicePayload).getUsername(), ((PayLoad)this.servicePayload).getPassword(), ((PayLoad)this.servicePayload).isDebug());
        }
        catch (RESTException re) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((PayLoad)this.servicePayload).getIpAddress() + "] Create HTTPS client fail.");
            return false;
        }
        if (((PayLoad)this.servicePayload).getManagerId() == null) {
            ((PayLoad)this.servicePayload).setManagerId("Self");
        }
        switch ((EthernetApiOptions)((PayLoad)this.servicePayload).getServiceOption()) {
            case LIST: {
                try {
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((PayLoad)this.servicePayload).getIpAddress())).setProtocolHeader(((PayLoad)this.servicePayload).getProtocolHeader())).setPort(((PayLoad)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.GET)).setContentType("application/json")).setServiceURI(((EthernetApiOptions)((PayLoad)this.servicePayload).getServiceOption()).getMainUri().replace("<id>", ((PayLoad)this.servicePayload).getManagerId())).build();
                    Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
                    RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
                    this.responseData.add(desResp);
                    if (desResp.isRedfishErrorResponse()) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, desResp.toString());
                        boolean bl = false;
                        return bl;
                    }
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, this.serviceLogsId, "[" + ((PayLoad)this.servicePayload).getIpAddress() + "] Ethernet interfaces : ");
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, this.serviceLogsId, JacksonCommonUtil.getUtil().getPrettyPrintString(desResp.getMembersOdataId()));
                    boolean bl = true;
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getMessage());
                    if (re.getUnexpectedBody() != null) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getUnexpectedBody());
                    }
                    boolean response = false;
                    return response;
                }
                finally {
                    client.close();
                }
            }
            case GET: {
                try {
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((PayLoad)this.servicePayload).getIpAddress())).setProtocolHeader(((PayLoad)this.servicePayload).getProtocolHeader())).setPort(((PayLoad)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.GET)).setContentType("application/json")).setServiceURI(((EthernetApiOptions)((PayLoad)this.servicePayload).getServiceOption()).getMainUri().replace("<id>", ((PayLoad)this.servicePayload).getManagerId())).setServiceId(((PayLoad)this.servicePayload).getEthernetId()).build();
                    Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
                    RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
                    this.responseData.add(desResp);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(desResp.isRedfishErrorResponse() ? GbtLogLevel.ERROR : GbtLogLevel.INFO, this.serviceLogsId, desResp.toString());
                    boolean bl = !desResp.isRedfishErrorResponse();
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getMessage());
                    if (re.getUnexpectedBody() != null) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getUnexpectedBody());
                    }
                    boolean bl = false;
                    return bl;
                }
                finally {
                    client.close();
                }
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((EthernetApiOptions)((PayLoad)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
        client.close();
        return false;
    }

    public static final class PayLoad
    extends RedfishApiPayload<PayLoad, EthernetApiOptions> {
        private String managerId;
        private String ethernetId;

        public PayLoad(String ipAddress, AbstractLoggerWriter loggerWriter) {
            super(ipAddress, loggerWriter);
            this.setServiceOption(EthernetApiOptions.UNKNOWN);
        }

        public PayLoad(String ipAddress, String username, String password, AbstractLoggerWriter loggerWriter) {
            super(ipAddress, username, password, loggerWriter);
            this.setServiceOption(EthernetApiOptions.UNKNOWN);
        }

        @Override
        protected PayLoad getThis() {
            return this;
        }

        public EthernetApi build() {
            return new EthernetApi(this);
        }

        public String getManagerId() {
            return this.managerId;
        }

        public PayLoad setManagerId(String managerId) {
            this.managerId = managerId;
            return this.getThis();
        }

        public String getEthernetId() {
            return this.ethernetId;
        }

        public PayLoad setEthernetId(String ethernetId) {
            this.ethernetId = ethernetId;
            return this.getThis();
        }
    }
}

