/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.redfish.services;

import Gbt.core.jsonapi.JacksonCommonUtil;
import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.redfish.RedfishApiPayload;
import Gbt.core.redfish.RedfishApiService;
import Gbt.core.redfish.RedfishResourceTypes;
import Gbt.core.rest.RESTException;
import Gbt.core.rest.RESTHttpMethods;
import Gbt.core.rest.RESTRequest;
import Gbt.core.rest.RESTRequestImpl;
import Gbt.utility.Common.GbtCommonConverters;
import Gbt.utility.redfish.RestFullResponseData;
import Gbt.utility.redfish.factories.RedfishApiMenu;
import Gbt.utility.redfish.models.common.logs.ClearTypes;
import Gbt.utility.redfish.models.common.logs.LogServiceClearLogAction;
import Gbt.utility.redfish.models.common.logs.LogServiceResource;
import Gbt.utility.redfish.options.LogServiceApiOptions;
import Gbt.utility.redfish.options.LogServiceLocation;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Response;

public final class LogServiceApi
extends RedfishApiService<Payload> {
    protected LogServiceApi(Payload servicePayload) {
        super(servicePayload);
    }

    @Override
    public String getServiceName() {
        return RedfishApiMenu.LOGSERVICE.getApiName();
    }

    @Override
    protected boolean checkRawArgs() {
        if (((Payload)this.servicePayload).getRestRawArgs().length < 2) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] The input arguments is empty.");
            return false;
        }
        ((Payload)this.servicePayload).setServiceType(LogServiceLocation.parse(((Payload)this.servicePayload).getRestRawArgs()[0]));
        if (((Payload)this.servicePayload).getServiceType() == LogServiceLocation.UNKNOWN) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] Unknown main resource target of log service.");
            return false;
        }
        if (LogServiceApiOptions.parse(((Payload)this.servicePayload).getRestRawArgs()[1]) == LogServiceApiOptions.UNKNOWN) {
            if (((Payload)this.servicePayload).getRestRawArgs().length < 3) {
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] The input arguments not enough.");
                return false;
            }
            ((Payload)this.servicePayload).setServiceId(((Payload)this.servicePayload).getRestRawArgs()[1]);
            ((Payload)this.servicePayload).setServiceOption(LogServiceApiOptions.parse(((Payload)this.servicePayload).getRestRawArgs()[2]));
        } else {
            ((Payload)this.servicePayload).setServiceOption(LogServiceApiOptions.parse(((Payload)this.servicePayload).getRestRawArgs()[1]));
        }
        switch ((LogServiceApiOptions)((Payload)this.servicePayload).getServiceOption()) {
            case LIST: {
                return true;
            }
            case GET: {
                switch (((Payload)this.servicePayload).getRestRawArgs().length) {
                    case 3: {
                        ((Payload)this.servicePayload).setLogId(((Payload)this.servicePayload).getRestRawArgs()[2]);
                        return true;
                    }
                    case 4: {
                        ((Payload)this.servicePayload).setLogId(((Payload)this.servicePayload).getRestRawArgs()[3]);
                        return true;
                    }
                }
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((LogServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                return false;
            }
            case MODIFY: {
                switch (((Payload)this.servicePayload).getRestRawArgs().length) {
                    case 4: {
                        ((Payload)this.servicePayload).setLogId(((Payload)this.servicePayload).getRestRawArgs()[2]);
                        ((Payload)this.servicePayload).setUploadJsonFile(GbtCommonConverters.stringToJavaIoFile(((Payload)this.servicePayload).getRestRawArgs()[3]));
                        return this.uploadFileValidation(RedfishResourceTypes.LogService);
                    }
                    case 5: {
                        ((Payload)this.servicePayload).setLogId(((Payload)this.servicePayload).getRestRawArgs()[3]);
                        ((Payload)this.servicePayload).setUploadJsonFile(GbtCommonConverters.stringToJavaIoFile(((Payload)this.servicePayload).getRestRawArgs()[4]));
                        return this.uploadFileValidation(RedfishResourceTypes.LogService);
                    }
                }
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((LogServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                return false;
            }
            case LOG: {
                switch (((Payload)this.servicePayload).getRestRawArgs().length) {
                    case 3: {
                        ((Payload)this.servicePayload).setLogId(((Payload)this.servicePayload).getRestRawArgs()[2]);
                        return true;
                    }
                    case 4: {
                        ((Payload)this.servicePayload).setLogId(((Payload)this.servicePayload).getRestRawArgs()[3]);
                        return true;
                    }
                }
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((LogServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                return false;
            }
            case CLEAR: {
                LogServiceClearLogAction action = new LogServiceClearLogAction();
                action.setClearType(ClearTypes.ClearAll);
                switch (((Payload)this.servicePayload).getRestRawArgs().length) {
                    case 3: {
                        ((Payload)this.servicePayload).setLogId(((Payload)this.servicePayload).getRestRawArgs()[2]);
                        return this.uploadDataValidation(RedfishResourceTypes.Ignore, action);
                    }
                    case 4: {
                        ((Payload)this.servicePayload).setLogId(((Payload)this.servicePayload).getRestRawArgs()[3]);
                        return this.uploadDataValidation(RedfishResourceTypes.Ignore, action);
                    }
                }
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((LogServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                return false;
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((LogServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
        return false;
    }

    @Override
    protected boolean checkPayLoad() {
        if (((Payload)this.servicePayload).getServiceType() == LogServiceLocation.UNKNOWN) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] The input arguments not enough.");
            return false;
        }
        switch ((LogServiceApiOptions)((Payload)this.servicePayload).getServiceOption()) {
            case LIST: {
                return true;
            }
            case GET: {
                if (((Payload)this.servicePayload).getLogId() == null) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] The input arguments not enough.");
                    return false;
                }
                return true;
            }
            case MODIFY: {
                if (((Payload)this.servicePayload).getLogId() == null) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] The input arguments not enough.");
                    return false;
                }
                if (((Payload)this.servicePayload).getUploadJsonFile() != null) {
                    return this.uploadFileValidation(RedfishResourceTypes.LogService);
                }
                if (((Payload)this.servicePayload).getLogServiceConfig() != null) {
                    return this.uploadDataValidation(RedfishResourceTypes.LogService, ((Payload)this.servicePayload).getLogServiceConfig());
                }
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] The input arguments not enough.");
                return false;
            }
            case LOG: {
                if (((Payload)this.servicePayload).getLogId() == null) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] The input arguments not enough.");
                    return false;
                }
                return true;
            }
            case CLEAR: {
                if (((Payload)this.servicePayload).getLogId() == null) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] The input arguments not enough.");
                    return false;
                }
                LogServiceClearLogAction action = new LogServiceClearLogAction();
                action.setClearType(ClearTypes.ClearAll);
                return this.uploadDataValidation(RedfishResourceTypes.Ignore, action);
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((LogServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        Client client = null;
        try {
            client = this.restReceiver.createHttpsClient(((Payload)this.servicePayload).getUsername(), ((Payload)this.servicePayload).getPassword(), ((Payload)this.servicePayload).isDebug());
        }
        catch (RESTException re) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] Create HTTPS client fail.");
            return false;
        }
        if (((Payload)this.servicePayload).getServiceId() == null) {
            ((Payload)this.servicePayload).setServiceId("Self");
        }
        switch ((LogServiceApiOptions)((Payload)this.servicePayload).getServiceOption()) {
            case LIST: {
                try {
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((Payload)this.servicePayload).getIpAddress())).setProtocolHeader(((Payload)this.servicePayload).getProtocolHeader())).setPort(((Payload)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.GET)).setContentType("application/json")).setServiceURI(((LogServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getFullUri(((Payload)this.servicePayload).getServiceType(), ((Payload)this.servicePayload).getServiceId(), ((Payload)this.servicePayload).getLogId())).build();
                    Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
                    RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
                    this.responseData.add(desResp);
                    if (desResp.isRedfishErrorResponse()) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, desResp.toString());
                        boolean bl = false;
                        return bl;
                    }
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] Log service list : ");
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, this.serviceLogsId, JacksonCommonUtil.getUtil().getPrettyPrintString(desResp.getMembersOdataId()));
                    boolean bl = true;
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getMessage());
                    if (re.getUnexpectedBody() != null) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getUnexpectedBody());
                    }
                    boolean response = false;
                    return response;
                }
                finally {
                    client.close();
                }
            }
            case GET: {
                try {
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((Payload)this.servicePayload).getIpAddress())).setProtocolHeader(((Payload)this.servicePayload).getProtocolHeader())).setPort(((Payload)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.GET)).setContentType("application/json")).setServiceURI(((LogServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getFullUri(((Payload)this.servicePayload).getServiceType(), ((Payload)this.servicePayload).getServiceId(), ((Payload)this.servicePayload).getLogId())).build();
                    Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
                    RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
                    this.responseData.add(desResp);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(desResp.isRedfishErrorResponse() ? GbtLogLevel.ERROR : GbtLogLevel.INFO, this.serviceLogsId, desResp.toString());
                    boolean bl = !desResp.isRedfishErrorResponse();
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getMessage());
                    if (re.getUnexpectedBody() != null) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getUnexpectedBody());
                    }
                    boolean response = false;
                    return response;
                }
                finally {
                    client.close();
                }
            }
            case MODIFY: {
                try {
                    String etag = this.getETag(((Payload)this.servicePayload).getProtocolHeader(), client, ((LogServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getFullUri(((Payload)this.servicePayload).getServiceType(), ((Payload)this.servicePayload).getServiceId(), ((Payload)this.servicePayload).getLogId()));
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((Payload)this.servicePayload).getIpAddress())).setProtocolHeader(((Payload)this.servicePayload).getProtocolHeader())).setPort(((Payload)this.servicePayload).getPort())).setHeaders("If-Match", etag)).setHttpMethods(RESTHttpMethods.PATCH)).setContentType("application/json")).setRawJsonData(this.requestBody)).setServiceURI(((LogServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getFullUri(((Payload)this.servicePayload).getServiceType(), ((Payload)this.servicePayload).getServiceId(), ((Payload)this.servicePayload).getLogId())).build();
                    Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
                    RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
                    this.responseData.add(desResp);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(desResp.isRedfishErrorResponse() ? GbtLogLevel.ERROR : GbtLogLevel.INFO, this.serviceLogsId, desResp.toString());
                    boolean bl = !desResp.isRedfishErrorResponse();
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getMessage());
                    if (re.getUnexpectedBody() != null) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getUnexpectedBody());
                    }
                    boolean request = false;
                    return request;
                }
                finally {
                    client.close();
                }
            }
            case LOG: {
                try {
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((Payload)this.servicePayload).getIpAddress())).setProtocolHeader(((Payload)this.servicePayload).getProtocolHeader())).setPort(((Payload)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.GET)).setContentType("application/json")).setServiceURI(((LogServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getFullUri(((Payload)this.servicePayload).getServiceType(), ((Payload)this.servicePayload).getServiceId(), ((Payload)this.servicePayload).getLogId())).build();
                    Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
                    RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
                    this.responseData.add(desResp);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(desResp.isRedfishErrorResponse() ? GbtLogLevel.ERROR : GbtLogLevel.INFO, this.serviceLogsId, desResp.toString());
                    boolean bl = !desResp.isRedfishErrorResponse();
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getMessage());
                    if (re.getUnexpectedBody() != null) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getUnexpectedBody());
                    }
                    boolean response = false;
                    return response;
                }
                finally {
                    client.close();
                }
            }
            case CLEAR: {
                try {
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((Payload)this.servicePayload).getIpAddress())).setProtocolHeader(((Payload)this.servicePayload).getProtocolHeader())).setPort(((Payload)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.POST)).setContentType("application/json")).setRawJsonData(this.requestBody)).setServiceURI(((LogServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getFullUri(((Payload)this.servicePayload).getServiceType(), ((Payload)this.servicePayload).getServiceId(), ((Payload)this.servicePayload).getLogId())).build();
                    Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
                    RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
                    this.responseData.add(desResp);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(desResp.isRedfishErrorResponse() ? GbtLogLevel.ERROR : GbtLogLevel.INFO, this.serviceLogsId, desResp.toString());
                    boolean bl = !desResp.isRedfishErrorResponse();
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getMessage());
                    if (re.getUnexpectedBody() != null) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getUnexpectedBody());
                    }
                    boolean bl = false;
                    return bl;
                }
                finally {
                    client.close();
                }
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((LogServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
        client.close();
        return false;
    }

    public static final class Payload
    extends RedfishApiPayload<Payload, LogServiceApiOptions> {
        private LogServiceLocation serviceType;
        private String serviceId;
        private String logId;
        private LogServiceResource logServiceConfig;

        public Payload(String ipAddress, AbstractLoggerWriter loggerWriter) {
            super(ipAddress, loggerWriter);
            this.setServiceOption(LogServiceApiOptions.UNKNOWN);
            this.setServiceType(LogServiceLocation.UNKNOWN);
        }

        public Payload(String ipAddress, String username, String password, AbstractLoggerWriter loggerWriter) {
            super(ipAddress, username, password, loggerWriter);
            this.setServiceOption(LogServiceApiOptions.UNKNOWN);
            this.setServiceType(LogServiceLocation.UNKNOWN);
        }

        @Override
        protected Payload getThis() {
            return this;
        }

        public LogServiceApi build() {
            return new LogServiceApi(this);
        }

        public LogServiceLocation getServiceType() {
            return this.serviceType;
        }

        public Payload setServiceType(LogServiceLocation serviceType) {
            this.serviceType = serviceType;
            return this.getThis();
        }

        public String getServiceId() {
            return this.serviceId;
        }

        public Payload setServiceId(String serviceId) {
            this.serviceId = serviceId;
            return this.getThis();
        }

        public String getLogId() {
            return this.logId;
        }

        public Payload setLogId(String logId) {
            this.logId = logId;
            return this.getThis();
        }

        public LogServiceResource getLogServiceConfig() {
            return this.logServiceConfig;
        }

        public Payload setLogServiceConfig(LogServiceResource logServiceConfig) {
            this.logServiceConfig = logServiceConfig;
            return this.getThis();
        }
    }
}

