/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.redfish.services;

import Gbt.core.jsonapi.JacksonCommonUtil;
import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.redfish.RedfishApiPayload;
import Gbt.core.redfish.RedfishApiService;
import Gbt.core.rest.RESTException;
import Gbt.core.rest.RESTHttpMethods;
import Gbt.core.rest.RESTRequest;
import Gbt.core.rest.RESTRequestImpl;
import Gbt.utility.redfish.RestFullResponseData;
import Gbt.utility.redfish.factories.RedfishApiMenu;
import Gbt.utility.redfish.options.RolesApiOptions;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Response;

public final class RolesApi
extends RedfishApiService<PayLoad> {
    protected RolesApi(PayLoad servicePayload) {
        super(servicePayload);
    }

    @Override
    public String getServiceName() {
        return RedfishApiMenu.ROLES.getApiName();
    }

    @Override
    protected boolean checkRawArgs() {
        if (((PayLoad)this.servicePayload).getRestRawArgs().length == 0) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((PayLoad)this.servicePayload).getIpAddress() + "] The input arguments not enough.");
            return false;
        }
        ((PayLoad)this.servicePayload).setServiceOption(RolesApiOptions.parse(((PayLoad)this.servicePayload).getRestRawArgs()[0]));
        switch ((RolesApiOptions)((PayLoad)this.servicePayload).getServiceOption()) {
            case GET: {
                if (((PayLoad)this.servicePayload).getRestRawArgs().length == 2) {
                    ((PayLoad)this.servicePayload).setRoleId(((PayLoad)this.servicePayload).getRestRawArgs()[1]);
                    return true;
                }
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((RolesApiOptions)((PayLoad)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                return false;
            }
            case LIST: {
                return true;
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((RolesApiOptions)((PayLoad)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
        return false;
    }

    @Override
    protected boolean checkPayLoad() {
        if (!(((PayLoad)this.servicePayload).getServiceOption() instanceof RolesApiOptions)) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((PayLoad)this.servicePayload).getIpAddress() + "] Invalid service API option of " + this.getServiceName() + ".");
            return false;
        }
        switch ((RolesApiOptions)((PayLoad)this.servicePayload).getServiceOption()) {
            case GET: {
                if (((PayLoad)this.servicePayload).getRoleId() == null) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((RolesApiOptions)((PayLoad)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                    return false;
                }
                return true;
            }
            case LIST: {
                return true;
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((RolesApiOptions)((PayLoad)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        Client client = null;
        String folderPath = "redfish";
        try {
            client = this.restReceiver.createHttpsClient(((PayLoad)this.servicePayload).getUsername(), ((PayLoad)this.servicePayload).getPassword(), ((PayLoad)this.servicePayload).isDebug());
        }
        catch (RESTException re) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((PayLoad)this.servicePayload).getIpAddress() + "] Create HTTPS client fail.");
            return false;
        }
        switch ((RolesApiOptions)((PayLoad)this.servicePayload).getServiceOption()) {
            case GET: {
                try {
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((PayLoad)this.servicePayload).getIpAddress())).setProtocolHeader(((PayLoad)this.servicePayload).getProtocolHeader())).setPort(((PayLoad)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.GET)).setServiceURI(((RolesApiOptions)((PayLoad)this.servicePayload).getServiceOption()).getMainUri()).setServiceId(((PayLoad)this.servicePayload).getRoleId()).setContentType("application/json")).build();
                    Response response = this.restReceiver.syncInvoke(client, request, "redfish", this.serviceLogsId);
                    RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
                    this.responseData.add(desResp);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(desResp.isRedfishErrorResponse() ? GbtLogLevel.ERROR : GbtLogLevel.INFO, this.serviceLogsId, desResp.toString());
                    boolean bl = !desResp.isRedfishErrorResponse();
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getMessage());
                    if (re.getUnexpectedBody() != null) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getUnexpectedBody());
                    }
                    boolean response = false;
                    return response;
                }
                finally {
                    client.close();
                }
            }
            case LIST: {
                try {
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((PayLoad)this.servicePayload).getIpAddress())).setProtocolHeader(((PayLoad)this.servicePayload).getProtocolHeader())).setPort(((PayLoad)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.GET)).setServiceURI(((RolesApiOptions)((PayLoad)this.servicePayload).getServiceOption()).getMainUri()).setContentType("application/json")).build();
                    Response response = this.restReceiver.syncInvoke(client, request, "redfish", this.serviceLogsId);
                    RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
                    if (desResp.isRedfishErrorResponse()) {
                        this.responseData.add(desResp);
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, desResp.toString());
                        boolean bl = false;
                        return bl;
                    }
                    this.responseData.add(desResp);
                    List<String> roles = desResp.getMembersOdataId();
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, this.serviceLogsId, "[" + ((PayLoad)this.servicePayload).getIpAddress() + "] Roles:");
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, this.serviceLogsId, JacksonCommonUtil.getUtil().getPrettyPrintString(roles));
                    boolean bl = true;
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getMessage());
                    if (re.getUnexpectedBody() != null) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getUnexpectedBody());
                    }
                    boolean bl = false;
                    return bl;
                }
                finally {
                    client.close();
                }
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((RolesApiOptions)((PayLoad)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
        client.close();
        return false;
    }

    public static final class PayLoad
    extends RedfishApiPayload<PayLoad, RolesApiOptions> {
        private String roleId;

        public PayLoad(String ipAddress, AbstractLoggerWriter loggerWriter) {
            super(ipAddress, loggerWriter);
            this.setServiceOption(RolesApiOptions.UNKNOWN);
        }

        public PayLoad(String ipAddress, String username, String password, AbstractLoggerWriter loggerWriter) {
            super(ipAddress, username, password, loggerWriter);
            this.setServiceOption(RolesApiOptions.UNKNOWN);
        }

        @Override
        protected PayLoad getThis() {
            return this;
        }

        public RolesApi build() {
            return new RolesApi(this);
        }

        public PayLoad setRoleId(String roleId) {
            this.roleId = roleId;
            return this.getThis();
        }

        public String getRoleId() {
            return this.roleId;
        }
    }
}

