/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.rest.services;

import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.rest.RESTException;
import Gbt.core.rest.RESTHttpMethods;
import Gbt.core.rest.RESTRequest;
import Gbt.core.rest.RESTRequestImpl;
import Gbt.core.rest.RESTServices;
import Gbt.core.rest.RESTServicesOptions;
import Gbt.utility.rest.models.AMIRestPreserveConfig;
import java.io.File;
import java.util.List;
import javax.ws.rs.core.Response;

public final class LoadDefaultService
extends RESTServices {
    public static final String SERVICE_NAME = "loaddefault";
    private static final String PRESERVE_CONFIG_URI = "/api/maintenance/preserve";
    private static final String LOAD_DEFAULT_RESOURCE_URI = "/api/maintenance/restore_defaults";

    public LoadDefaultService(AbstractLoggerWriter loggerWriter) {
        super(loggerWriter);
    }

    @Override
    public String getServiceName() {
        return SERVICE_NAME;
    }

    @Override
    public boolean readJsonData(AbstractJSONPOJO jsonData, RESTServicesOptions restServicesOptions) {
        return true;
    }

    @Override
    public boolean readJsonFiles(List<File> dataFiles, RESTServicesOptions restServicesOptions) {
        return true;
    }

    @Override
    public boolean uploadFiles(List<File> uploadFiles, RESTServicesOptions restServicesOptions) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String ipAddress, RESTServicesOptions servicesOptions) {
        String logName = ipAddress + "_" + this.logDirPath + "_" + this.getServiceName();
        RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHttpMethods(RESTHttpMethods.GET)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(PRESERVE_CONFIG_URI).setCookies(this.sessionData)).setContentType("application/json")).build();
        AMIRestPreserveConfig preserveConfig = null;
        try (Response response = null;){
            response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
            preserveConfig = this.clientReceiver.deserialize(response, AMIRestPreserveConfig.class);
        }
        request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHttpMethods(RESTHttpMethods.PUT)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(LOAD_DEFAULT_RESOURCE_URI).setCookies(this.sessionData)).setRawJsonData(preserveConfig)).setContentType("application/json")).build();
        try {
            response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
            this.jsonResults.add(this.clientReceiver.deserialize(response, AMIRestPreserveConfig.class));
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Load default success.");
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, preserveConfig.toString());
            boolean re = true;
            return re;
        }
        catch (RESTException re) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Load default fail.");
            this.restExceptionMessages(re, ipAddress, logName);
            this.jsonResults.add(new NullJSONData().setError(true).setMessages("Set Load Default request fail."));
            boolean bl = false;
            return bl;
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }
}

