/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.rest.services;

import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.JacksonCommonUtil;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.rest.RESTException;
import Gbt.core.rest.RESTHttpMethods;
import Gbt.core.rest.RESTProtocolHeaders;
import Gbt.core.rest.RESTRequest;
import Gbt.core.rest.RESTRequestImpl;
import Gbt.core.rest.RESTServices;
import Gbt.core.rest.RESTServicesOptions;
import Gbt.utility.rest.models.vmcli.AMIRestVmcliImages;
import Gbt.utility.rest.models.vmcli.AMIRestVmcliMedia;
import Gbt.utility.rest.models.vmcli.RestVmcliGeneralConfig;
import Gbt.utility.rest.options.VmcliServiceOptions;
import java.io.File;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;

public final class VmcliUtilService
extends RESTServices {
    public static final String SERVICE_NAME = "vmcli";
    private static final String GENERAL_SETTINGS_URI = "/api/settings/media/general";
    private static final String REMOTE_IMAGES_LIST_URI = "/api/settings/media/remote/images";
    private static final String START_MEDIA_URI = "/api/settings/media/remote/start-media";
    private static final String STOP_MEDIA_URI = "/api/settings/media/remote/stop-media";
    private static final String REMOTE_MEDIA_CONFIG_URI = "/api/settings/media/remote/configurations";
    private RestVmcliGeneralConfig vmcliConfigUploadData;
    private AMIRestVmcliImages vmcliImgUploadData;

    public VmcliUtilService(AbstractLoggerWriter loggerWriter) {
        super(loggerWriter);
    }

    @Override
    public String getServiceName() {
        return SERVICE_NAME;
    }

    @Override
    public boolean readJsonData(AbstractJSONPOJO jsonData, RESTServicesOptions restServicesOptions) {
        return true;
    }

    @Override
    public boolean readJsonFiles(List<File> dataFiles, RESTServicesOptions servicesOptions) {
        switch (servicesOptions.getOptionName()) {
            case "set": {
                try {
                    this.vmcliConfigUploadData = JacksonCommonUtil.getUtil().readJSONFile(dataFiles.get(0), RestVmcliGeneralConfig.class);
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
            case "mount": {
                try {
                    this.vmcliImgUploadData = JacksonCommonUtil.getUtil().readJSONFile(dataFiles.get(0), AMIRestVmcliImages.class);
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
            case "unmount": {
                try {
                    this.vmcliImgUploadData = JacksonCommonUtil.getUtil().readJSONFile(dataFiles.get(0), AMIRestVmcliImages.class);
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean uploadFiles(List<File> uploadFiles, RESTServicesOptions restServicesOptions) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String ipAddress, RESTServicesOptions servicesOptions) {
        String logName = ipAddress + "_" + this.logDirPath + "_" + this.getServiceName();
        if (!(servicesOptions instanceof VmcliServiceOptions)) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Unknown option of " + this.getServiceName() + " service.");
            this.jsonResults.add(new NullJSONData().setError(true).setMessages("Unknown option of " + this.getServiceName() + " service."));
            return false;
        }
        VmcliServiceOptions options = (VmcliServiceOptions)servicesOptions;
        RESTRequestImpl request = null;
        Response response = null;
        switch (options) {
            case GET_GENERAL_CONFIG: {
                request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setProtocolHeader(RESTProtocolHeaders.HTTPS)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(GENERAL_SETTINGS_URI).setHttpMethods(RESTHttpMethods.GET)).setCookies(this.sessionData)).setContentType("application/json")).build();
                try {
                    response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
                    RestVmcliGeneralConfig respData = this.clientReceiver.deserialize(response, new GenericType<RestVmcliGeneralConfig>(){});
                    this.jsonResults.add(respData);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Get remote media configurations success.");
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, respData.toString());
                    boolean bl = true;
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Get remote media configurations fail.");
                    this.restExceptionMessages(re, ipAddress, logName);
                    this.jsonResults.add(new NullJSONData().setError(true).setMessages("Get vmcli config fail."));
                    boolean bl = false;
                    return bl;
                }
                finally {
                    response.close();
                }
            }
            case SET_GENERAL_CONFIG: {
                request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setProtocolHeader(RESTProtocolHeaders.HTTPS)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(GENERAL_SETTINGS_URI).setHttpMethods(RESTHttpMethods.PUT)).setRawJsonData(this.vmcliConfigUploadData)).setCookies(this.sessionData)).setContentType("application/json")).build();
                try {
                    response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
                    RestVmcliGeneralConfig respData = this.clientReceiver.deserialize(response, new GenericType<RestVmcliGeneralConfig>(){});
                    this.jsonResults.add(respData);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Set remote media configurations success.");
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, respData.toString());
                    boolean bl = true;
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Set remote media configurations fail.");
                    this.restExceptionMessages(re, ipAddress, logName);
                    this.jsonResults.add(new NullJSONData().setError(true).setMessages("Set vmcli config fail."));
                    boolean bl = false;
                    return bl;
                }
                finally {
                    response.close();
                }
            }
            case LIST_IMAGE: {
                request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setProtocolHeader(RESTProtocolHeaders.HTTPS)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(REMOTE_IMAGES_LIST_URI).setHttpMethods(RESTHttpMethods.GET)).setCookies(this.sessionData)).setContentType("application/json")).build();
                try {
                    response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
                    this.jsonResults.addAll((Collection)this.clientReceiver.deserialize(response, new GenericType<List<AMIRestVmcliImages>>(){}));
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Get remote accessible image list success.");
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, this.getJsonResultsPrettyPrintString());
                    boolean re = true;
                    return re;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Get remote accessible image list fail.");
                    this.restExceptionMessages(re, ipAddress, logName);
                    this.jsonResults.add(new NullJSONData().setError(true).setMessages("Get vmcli image list fail."));
                    boolean bl = false;
                    return bl;
                }
                finally {
                    response.close();
                }
            }
            case MOUNT: {
                request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setProtocolHeader(RESTProtocolHeaders.HTTPS)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(START_MEDIA_URI).setHttpMethods(RESTHttpMethods.POST)).setRawJsonData(this.vmcliImgUploadData)).setCookies(this.sessionData)).setContentType("application/json")).build();
                try {
                    response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
                    AMIRestVmcliImages respData = this.clientReceiver.deserialize(response, new GenericType<AMIRestVmcliImages>(){});
                    this.jsonResults.add(respData);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Mount images success.");
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, respData.toString());
                    boolean bl = true;
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Mount images fail.");
                    this.restExceptionMessages(re, ipAddress, logName);
                    this.jsonResults.add(new NullJSONData().setError(true).setMessages("Vmcli mount images fail."));
                    boolean bl = false;
                    return bl;
                }
                finally {
                    response.close();
                }
            }
            case UNMOUNT: {
                request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setProtocolHeader(RESTProtocolHeaders.HTTPS)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(STOP_MEDIA_URI).setHttpMethods(RESTHttpMethods.POST)).setRawJsonData(this.vmcliImgUploadData)).setCookies(this.sessionData)).setContentType("application/json")).build();
                try {
                    response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
                    AMIRestVmcliImages respData = this.clientReceiver.deserialize(response, new GenericType<AMIRestVmcliImages>(){});
                    this.jsonResults.add(respData);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Unmount images success.");
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, respData.toString());
                    boolean bl = true;
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Unmount images fail.");
                    this.restExceptionMessages(re, ipAddress, logName);
                    this.jsonResults.add(new NullJSONData().setError(true).setMessages("Vmcli unmount images fail."));
                    boolean bl = false;
                    return bl;
                }
                finally {
                    response.close();
                }
            }
            case SHOW_MEDIA: {
                request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setProtocolHeader(RESTProtocolHeaders.HTTPS)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(REMOTE_MEDIA_CONFIG_URI).setHttpMethods(RESTHttpMethods.GET)).setCookies(this.sessionData)).setContentType("application/json")).build();
                try {
                    response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
                    this.jsonResults.addAll((Collection)this.clientReceiver.deserialize(response, new GenericType<List<AMIRestVmcliMedia>>(){}));
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Get all current remote media devices success.");
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, this.getJsonResultsPrettyPrintString());
                    boolean re = true;
                    return re;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Get all current remote media devices fail.");
                    this.restExceptionMessages(re, ipAddress, logName);
                    this.jsonResults.add(new NullJSONData().setError(true).setMessages("Get vmcli media list fail."));
                    boolean bl = false;
                    return bl;
                }
                finally {
                    response.close();
                }
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Unknown option of " + this.getServiceName() + " service.");
        this.jsonResults.add(new NullJSONData().setError(true).setMessages("Unknown option of " + this.getServiceName() + " service."));
        return false;
    }

    public RestVmcliGeneralConfig getVmcliConfigUploadData() {
        return this.vmcliConfigUploadData;
    }

    public AMIRestVmcliImages getVmcliImgUploadData() {
        return this.vmcliImgUploadData;
    }
}

