/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.scan;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.engines.DefaultTaskManager;
import Gbt.core.engines.EngineThreadPoolFactory;
import Gbt.core.engines.EngineThreadPoolTypes;
import Gbt.core.engines.records.EngineRecords;
import Gbt.core.engines.records.RmcpPingRecords;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.utility.Common.CommonFunction;
import Gbt.utility.Common.GbtCommonConverters;
import Gbt.utility.scan.RmcpPingTask;
import Gbt.utility.scan.ScanResultsData;
import Gbt.utility.scan.upnpimpl.GbtUpnpServiceConfig;
import Gbt.utility.scan.upnpimpl.UpnpScanRegistryListener;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.fourthline.cling.UpnpServiceConfiguration;
import org.fourthline.cling.UpnpServiceImpl;
import org.fourthline.cling.model.message.header.STAllHeader;
import org.fourthline.cling.model.message.header.UpnpHeader;
import org.fourthline.cling.registry.RegistryListener;

public final class ScanCommand
extends AbstractCommand<Builder> {
    private static final SimpleDateFormat STD_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    public static final String NODE_LIST_NAME = "Nodelist";
    public static final String COMMAND_NAME = "scan";
    private final GbtIPMICommandReceiver ipmiReceiver;

    protected ScanCommand(Builder commandArgs) {
        super(commandArgs);
        this.commandID = NODE_LIST_NAME;
        this.ipmiReceiver = GbtIPMICommandReceiver.getInstance();
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDocumentsName() {
        return COMMAND_NAME;
    }

    @Override
    public boolean checkAll() {
        if (this.ipmiReceiver == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "IPMI command receiver is null.");
            return false;
        }
        if (!((Builder)this.commandArgs).checkArgs()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "Scan arguments check fail.");
            return false;
        }
        return true;
    }

    @Override
    public boolean execute() {
        switch (((Builder)this.commandArgs).scanType) {
            case RMCP: {
                return this.rmcpScan();
            }
            case SSDP: {
                return this.ssdpScan();
            }
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "Unsupport scan protocol.");
        return false;
    }

    @Override
    public void cancelHook(Object obj) {
    }

    @Override
    public void close() throws Exception {
        ((Builder)this.commandArgs).close();
    }

    public static final String getNodeList() {
        return "results/" + STD_FORMAT.format(new Date()) + "/" + COMMAND_NAME + "/" + NODE_LIST_NAME + ".log";
    }

    private boolean rmcpScan() {
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "Scan RMCP supported IP by given range (From " + ((Builder)this.commandArgs).startIP + " to " + ((Builder)this.commandArgs).endIP + ").");
        BigInteger start = GbtCommonConverters.ipToBigInteger(((Builder)this.commandArgs).startIP);
        BigInteger end = GbtCommonConverters.ipToBigInteger(((Builder)this.commandArgs).endIP);
        BigInteger counter = new BigInteger("1");
        if (start.intValue() > end.intValue()) {
            int numb = end.intValue() - start.intValue();
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "Get the negative IP numbers (" + numb + ") from given invalid IP ranges.");
            this.getElapsedTimes();
            return false;
        }
        int poolSize = Runtime.getRuntime().availableProcessors() * 3;
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName(COMMAND_NAME)).setPoolType(EngineThreadPoolTypes.FIXED)).setThreadNumber(poolSize)).setPriority(5)).build();
        DefaultTaskManager rmcpPingTasksPool = new DefaultTaskManager(factory);
        while (start.compareTo(end) <= 0) {
            String currentIP = GbtCommonConverters.BigIntegerToIp(start);
            rmcpPingTasksPool.addEngineTask(new RmcpPingTask.Builder().setBmcIP(currentIP).setUsername(((Builder)this.commandArgs).username).setPassword(((Builder)this.commandArgs).password).setPingOnly(((Builder)this.commandArgs).isPingOnly).build());
            start = start.add(counter);
        }
        rmcpPingTasksPool.executeTasks();
        for (String taskID : rmcpPingTasksPool.getAllResults().keySet()) {
            ScanResultsData scanResultsData;
            RmcpPingRecords records = ((EngineRecords)rmcpPingTasksPool.getSingleResult(taskID)).castSubRecords(RmcpPingRecords.class);
            if (records.getStates().isPass()) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, records.getBMCIP());
                scanResultsData = new ScanResultsData();
                scanResultsData.setBmcIpAddress(records.getBMCIP());
                scanResultsData.setBmcUsername(records.getUsername());
                scanResultsData.setBmcPassword(records.getPassword());
                scanResultsData.setBmcMacAddress(records.getMacAddress());
                scanResultsData.setAccountPassCorrect(records.getIsAccountPassCorrect());
                this.commandResults.add(scanResultsData);
                continue;
            }
            if (records.getIsAccountPassCorrect() == null || records.getIsAccountPassCorrect().booleanValue()) continue;
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, records.getBMCIP());
            scanResultsData = new ScanResultsData();
            scanResultsData.setBmcIpAddress(records.getBMCIP());
            scanResultsData.setBmcUsername(records.getUsername());
            scanResultsData.setBmcPassword(records.getPassword());
            scanResultsData.setAccountPassCorrect(records.getIsAccountPassCorrect());
            this.commandResults.add(scanResultsData);
        }
        System.out.println("Total activate nodes : " + this.commandResults.size());
        try {
            rmcpPingTasksPool.close();
            rmcpPingTasksPool = null;
            factory = null;
        }
        catch (Exception e) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "Task manager close fail.", e);
            this.getElapsedTimes();
            return false;
        }
        System.out.println("* Notice : node list at " + ScanCommand.getNodeList());
        this.getElapsedTimes();
        return true;
    }

    private boolean ssdpScan() {
        UpnpScanRegistryListener listener = new UpnpScanRegistryListener();
        GbtUpnpServiceConfig config = new GbtUpnpServiceConfig(1900);
        System.out.println("Starting SSDP scan ...");
        UpnpServiceImpl upnpService = new UpnpServiceImpl((UpnpServiceConfiguration)config, new RegistryListener[]{listener});
        upnpService.getControlPoint().search((UpnpHeader)new STAllHeader());
        try {
            Thread.sleep(((Builder)this.commandArgs).ssdpTimeout);
        }
        catch (InterruptedException ie) {
            this.getElapsedTimes();
            return false;
        }
        System.out.println("Stoping SSDP scan ...");
        upnpService.shutdown();
        if (listener.getAvailableIPList().isEmpty()) {
            this.getElapsedTimes();
            return false;
        }
        System.out.println("* Notice : node list at " + ScanCommand.getNodeList() + "\n");
        this.getElapsedTimes();
        return true;
    }

    public static enum ScanType {
        None(0, "None"),
        RMCP(1, "RMCP"),
        SSDP(2, "SSDP");

        private final int code;
        private final String item;

        private ScanType(int code, String item) {
            this.code = code;
            this.item = item;
        }

        public int getCode() {
            return this.code;
        }

        public static final ScanType parserByString(String type) {
            switch (type) {
                case "rmcp": {
                    return RMCP;
                }
                case "ssdp": {
                    return SSDP;
                }
            }
            return None;
        }

        public String toString() {
            return this.item;
        }
    }

    public static final class Builder
    extends AbstractCommandBuilder<Builder> {
        private String startIP;
        private String endIP;
        private String username = "admin";
        private String password = "password";
        private ScanType scanType = ScanType.RMCP;
        private boolean isPingOnly = false;
        private int ssdpTimeout = 6000;

        @Override
        public boolean checkArgs() {
            if (this.args != null) {
                switch (this.args.length) {
                    case 1: {
                        this.scanType = ScanType.parserByString(this.args[0]);
                        break;
                    }
                    case 2: {
                        this.scanType = ScanType.parserByString(this.args[0]);
                        this.ssdpTimeout = Integer.parseInt(this.args[1], 10);
                        break;
                    }
                    case 3: {
                        this.scanType = ScanType.parserByString(this.args[0]);
                        this.startIP = this.args[1];
                        this.endIP = this.args[2];
                        break;
                    }
                    default: {
                        this.loggerWriter.appendPath(ScanCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, ScanCommand.NODE_LIST_NAME, "Invalid arguments length.");
                        return false;
                    }
                }
            }
            switch (this.scanType) {
                case None: {
                    this.loggerWriter.appendPath(ScanCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, ScanCommand.NODE_LIST_NAME, "Invalid scan type.");
                    return false;
                }
                case RMCP: {
                    return this.checkRMCPScanArgs();
                }
                case SSDP: {
                    return true;
                }
            }
            return false;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public ScanCommand build() {
            return new ScanCommand(this);
        }

        @Override
        public void close() throws Exception {
            this.args = null;
            this.startIP = null;
            this.endIP = null;
            this.scanType = null;
            this.loggerWriter.close();
        }

        public Builder setStartIP(String startIP) {
            this.startIP = startIP;
            return this.getThis();
        }

        public Builder setEndIP(String endIP) {
            this.endIP = endIP;
            return this.getThis();
        }

        public Builder setUsername(String username) {
            this.username = username;
            return this.getThis();
        }

        public Builder setPassword(String password) {
            this.password = password;
            return this.getThis();
        }

        public Builder setScanType(ScanType scanType) {
            this.scanType = scanType;
            return this.getThis();
        }

        public Builder isPingOnly(boolean isPingOnly) {
            this.isPingOnly = isPingOnly;
            return this.getThis();
        }

        public Builder setSsdpTimeout(int ssdpTimeout) {
            this.ssdpTimeout = ssdpTimeout;
            return this.getThis();
        }

        private boolean checkRMCPScanArgs() {
            if (this.startIP == null || this.endIP == null) {
                return false;
            }
            if (!CommonFunction.isValidateIP(this.startIP)) {
                this.loggerWriter.appendPath(ScanCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, ScanCommand.NODE_LIST_NAME, "Unknown host of start point IP address : " + this.startIP);
                return false;
            }
            if (!CommonFunction.isValidateIP(this.endIP)) {
                this.loggerWriter.appendPath(ScanCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, ScanCommand.NODE_LIST_NAME, "Unknown host of end point IP address : " + this.endIP);
                return false;
            }
            return true;
        }
    }
}

