/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.coding.commands.session;

import com.veraxsystems.vxipmi.coding.commands.IpmiCommandCoder;
import com.veraxsystems.vxipmi.coding.commands.IpmiVersion;
import com.veraxsystems.vxipmi.coding.commands.PrivilegeLevel;
import com.veraxsystems.vxipmi.coding.commands.ResponseData;
import com.veraxsystems.vxipmi.coding.commands.session.Rakp1ResponseData;
import com.veraxsystems.vxipmi.coding.payload.CompletionCode;
import com.veraxsystems.vxipmi.coding.payload.IpmiPayload;
import com.veraxsystems.vxipmi.coding.payload.PlainMessage;
import com.veraxsystems.vxipmi.coding.payload.lan.IPMIException;
import com.veraxsystems.vxipmi.coding.payload.lan.NetworkFunction;
import com.veraxsystems.vxipmi.coding.protocol.AuthenticationType;
import com.veraxsystems.vxipmi.coding.protocol.IpmiMessage;
import com.veraxsystems.vxipmi.coding.protocol.Ipmiv20Message;
import com.veraxsystems.vxipmi.coding.protocol.PayloadType;
import com.veraxsystems.vxipmi.coding.security.CipherSuite;
import com.veraxsystems.vxipmi.coding.security.ConfidentialityNone;
import com.veraxsystems.vxipmi.common.Randomizer;
import com.veraxsystems.vxipmi.common.TypeConverter;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;

public class Rakp1
extends IpmiCommandCoder {
    private int managedSystemSessionId;
    private byte[] consoleRandomNumber;
    private PrivilegeLevel requestedMaximumPrivilegeLevel;
    private String username;
    private String password;
    private byte[] bmcKey;

    public void setManagedSystemSessionId(int managedSystemSessionId) {
        this.managedSystemSessionId = managedSystemSessionId;
    }

    public int getManagedSystemSessionId() {
        return this.managedSystemSessionId;
    }

    public void setRequestedMaximumPrivilegeLevel(PrivilegeLevel requestedMaximumPrivilegeLevel) {
        this.requestedMaximumPrivilegeLevel = requestedMaximumPrivilegeLevel;
    }

    public PrivilegeLevel getRequestedMaximumPrivilegeLevel() {
        return this.requestedMaximumPrivilegeLevel;
    }

    public void setUsername(String username) {
        if (username.length() > 16) {
            throw new IllegalArgumentException("Username is too long. It's length cannot exceed 16");
        }
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    private void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    private void setConsoleRandomNumber(byte[] randomNumber) {
        this.consoleRandomNumber = randomNumber;
    }

    public byte[] getConsoleRandomNumber() {
        return this.consoleRandomNumber;
    }

    private void setBmcKey(byte[] bmcKey) {
        this.bmcKey = bmcKey;
    }

    public byte[] getBmcKey() {
        return this.bmcKey;
    }

    public Rakp1(int managedSystemSessionId, PrivilegeLevel privilegeLevel, String username, String password, byte[] bmcKey, CipherSuite cipherSuite) {
        super(IpmiVersion.V20, cipherSuite, AuthenticationType.RMCPPlus);
        this.setManagedSystemSessionId(managedSystemSessionId);
        this.setRequestedMaximumPrivilegeLevel(privilegeLevel);
        this.setUsername(username);
        this.setPassword(password);
        this.setBmcKey(bmcKey);
        byte[] random = new byte[16];
        for (int i = 0; i < 4; ++i) {
            byte[] rand = TypeConverter.intToLittleEndianByteArray(Randomizer.getInt());
            System.arraycopy(rand, 0, random, 4 * i, 4);
        }
        this.setConsoleRandomNumber(random);
    }

    @Override
    public IpmiMessage encodePayload(int messageSequenceNumber, int sessionSequenceNumber, int sessionId) {
        if (sessionId != 0) {
            throw new IllegalArgumentException("Session ID must be 0");
        }
        Ipmiv20Message message = new Ipmiv20Message(new ConfidentialityNone());
        message.setPayloadType(PayloadType.Rakp1);
        message.setSessionID(0);
        message.setSessionSequenceNumber(0);
        message.setAuthenticationType(this.getAuthenticationType());
        message.setPayloadAuthenticated(false);
        message.setPayloadEncrypted(false);
        message.setPayload(this.preparePayload(messageSequenceNumber));
        return message;
    }

    @Override
    protected IpmiPayload preparePayload(int sequenceNumber) {
        byte[] payload = null;
        if (this.getUsername() == null) {
            this.setUsername("");
        }
        payload = new byte[28 + this.getUsername().length()];
        payload[0] = TypeConverter.intToByte(sequenceNumber);
        payload[1] = 0;
        payload[2] = 0;
        payload[3] = 0;
        byte[] sId = TypeConverter.intToLittleEndianByteArray(this.getManagedSystemSessionId());
        System.arraycopy(sId, 0, payload, 4, 4);
        System.arraycopy(this.consoleRandomNumber, 0, payload, 8, 16);
        payload[24] = TypeConverter.intToByte(this.encodePrivilegeLevel(this.requestedMaximumPrivilegeLevel) | 0x10);
        payload[25] = 0;
        payload[26] = 0;
        payload[27] = TypeConverter.intToByte(this.getUsername().length());
        if (this.getUsername().length() > 0) {
            System.arraycopy(this.getUsername().getBytes(), 0, payload, 28, this.getUsername().length());
        }
        return new PlainMessage(payload);
    }

    @Override
    public byte getCommandCode() {
        return 0;
    }

    @Override
    public NetworkFunction getNetworkFunction() {
        return null;
    }

    @Override
    public ResponseData getResponseData(IpmiMessage message) throws IPMIException, NoSuchAlgorithmException, InvalidKeyException {
        if (!this.isCommandResponse(message)) {
            throw new IllegalArgumentException("This is not RAKP 2 message!");
        }
        byte[] payload = message.getPayload().getPayloadData();
        Rakp1ResponseData data = new Rakp1ResponseData();
        data.setMessageTag(payload[0]);
        data.setStatusCode(payload[1]);
        if (payload[1] != 0) {
            throw new IPMIException(CompletionCode.parseInt(TypeConverter.byteToInt(payload[1])));
        }
        if (payload.length < 40) {
            throw new IllegalArgumentException("Invalid payload length");
        }
        byte[] buffer = new byte[4];
        System.arraycopy(payload, 4, buffer, 0, 4);
        data.setRemoteConsoleSessionId(TypeConverter.littleEndianByteArrayToInt(buffer));
        byte[] managedSystemGuid = new byte[16];
        System.arraycopy(payload, 24, managedSystemGuid, 0, 16);
        data.setManagedSystemGuid(managedSystemGuid);
        byte[] managedSystemRandomNumber = new byte[16];
        System.arraycopy(payload, 8, managedSystemRandomNumber, 0, 16);
        data.setManagedSystemRandomNumber(managedSystemRandomNumber);
        byte[] key = null;
        int length = this.getCipherSuite().getAuthenticationAlgorithm().getKeyLength();
        if (length > 0) {
            key = new byte[length];
            System.arraycopy(payload, 40, key, 0, length);
        }
        if (!this.getCipherSuite().getAuthenticationAlgorithm().checkKeyExchangeAuthenticationCode(this.prepareKeyExchangeAuthenticationCodeBase(data), key, this.getPassword())) {
            throw new IllegalArgumentException("Authentication check failed");
        }
        return data;
    }

    private byte[] prepareKeyExchangeAuthenticationCodeBase(Rakp1ResponseData responseData) {
        int length = 58;
        if (this.getUsername() != null) {
            length += this.getUsername().length();
        }
        byte[] keac = new byte[length];
        byte[] rSID = TypeConverter.intToLittleEndianByteArray(responseData.getRemoteConsoleSessionId());
        System.arraycopy(rSID, 0, keac, 0, 4);
        byte[] mSID = TypeConverter.intToLittleEndianByteArray(this.getManagedSystemSessionId());
        System.arraycopy(mSID, 0, keac, 4, 4);
        System.arraycopy(this.getConsoleRandomNumber(), 0, keac, 8, 16);
        System.arraycopy(responseData.getManagedSystemRandomNumber(), 0, keac, 24, 16);
        System.arraycopy(responseData.getManagedSystemGuid(), 0, keac, 40, 16);
        keac[56] = TypeConverter.intToByte(this.encodePrivilegeLevel(this.requestedMaximumPrivilegeLevel) | 0x10);
        if (this.getUsername() != null) {
            keac[57] = TypeConverter.intToByte(this.getUsername().length());
            if (this.getUsername().length() > 0) {
                System.arraycopy(this.getUsername().getBytes(), 0, keac, 58, this.getUsername().length());
            }
        } else {
            keac[57] = 0;
        }
        return keac;
    }

    public byte[] calculateSik(Rakp1ResponseData responseData) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] key = null;
        key = this.getBmcKey() == null || this.getBmcKey().length <= 0 ? this.getPassword().getBytes() : this.getBmcKey();
        return this.getCipherSuite().getAuthenticationAlgorithm().getKeyExchangeAuthenticationCode(this.prepareSikBase(responseData), new String(key));
    }

    private byte[] prepareSikBase(Rakp1ResponseData responseData) {
        int length = 34;
        if (this.getUsername() != null) {
            length += this.getUsername().length();
        }
        byte[] sikBase = new byte[length];
        System.arraycopy(this.getConsoleRandomNumber(), 0, sikBase, 0, 16);
        System.arraycopy(responseData.getManagedSystemRandomNumber(), 0, sikBase, 16, 16);
        sikBase[32] = TypeConverter.intToByte(this.encodePrivilegeLevel(this.requestedMaximumPrivilegeLevel) | 0x10);
        if (this.getUsername() != null) {
            sikBase[33] = TypeConverter.intToByte(this.getUsername().length());
            if (this.getUsername().length() > 0) {
                System.arraycopy(this.getUsername().getBytes(), 0, sikBase, 34, this.getUsername().length());
            }
        } else {
            sikBase[33] = 0;
        }
        return sikBase;
    }

    @Override
    public boolean isCommandResponse(IpmiMessage message) {
        return message instanceof Ipmiv20Message && ((Ipmiv20Message)message).getPayloadType() == PayloadType.Rakp2;
    }
}

