/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.coding.payload.lan;

import com.veraxsystems.vxipmi.coding.payload.lan.IpmiLanMessage;
import com.veraxsystems.vxipmi.coding.payload.lan.NetworkFunction;
import com.veraxsystems.vxipmi.common.TypeConverter;

public class IpmiLanRequest
extends IpmiLanMessage {
    public IpmiLanRequest(NetworkFunction networkFunction, byte commandCode, byte[] requestData, byte sequenceNumber) {
        this(networkFunction, commandCode, requestData, sequenceNumber, TypeConverter.intToByte(0));
    }

    public IpmiLanRequest(NetworkFunction networkFunction, byte commandCode, byte[] requestData, byte sequenceNumber, byte lun) {
        if (lun < 0 || lun > 3) {
            throw new IllegalArgumentException("Invalid LUN");
        }
        this.setResponderAddress((byte)32);
        this.setNetworkFunction(networkFunction);
        this.setResponderLogicalUnitNumber(TypeConverter.intToByte(lun));
        this.setRequesterAddress((byte)-127);
        this.setRequesterLogicalUnitNumber(TypeConverter.intToByte(0));
        this.setSequenceNumber(sequenceNumber);
        this.setData(requestData);
        this.setCommand(commandCode);
    }

    @Override
    public int getPayloadLength() {
        int length = 7;
        if (this.getData() != null) {
            length += this.getData().length;
        }
        return length;
    }

    @Override
    public byte[] getPayloadData() {
        byte[] message = new byte[this.getPayloadLength()];
        message[0] = this.getResponderAddress();
        message[1] = TypeConverter.intToByte(this.networkFunction << 2 | this.getResponderLogicalUnitNumber());
        message[2] = this.getChecksum1(message);
        message[3] = this.getRequesterAddress();
        message[4] = TypeConverter.intToByte((this.getSequenceNumber() & 0x3F) << 2 | this.getResponderLogicalUnitNumber());
        message[5] = this.getCommand();
        if (this.getData() != null) {
            System.arraycopy(this.getData(), 0, message, 6, this.getData().length);
        }
        message[message.length - 1] = this.getChecksum2(message);
        return message;
    }
}

