/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.model.message;

import java.io.ByteArrayInputStream;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.fourthline.cling.model.message.header.UpnpHeader;
import org.seamless.http.Headers;

public class UpnpHeaders
extends Headers {
    private static final Logger log = Logger.getLogger(UpnpHeaders.class.getName());
    protected Map<UpnpHeader.Type, List<UpnpHeader>> parsedHeaders;

    public UpnpHeaders() {
    }

    public UpnpHeaders(Map<String, List<String>> headers) {
        super(headers);
    }

    public UpnpHeaders(ByteArrayInputStream inputStream) {
        super(inputStream);
    }

    public UpnpHeaders(boolean normalizeHeaders) {
        super(normalizeHeaders);
    }

    protected void parseHeaders() {
        this.parsedHeaders = new LinkedHashMap<UpnpHeader.Type, List<UpnpHeader>>();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Parsing all HTTP headers for known UPnP headers: " + this.size());
        }
        for (Map.Entry entry : this.entrySet()) {
            if (entry.getKey() == null) continue;
            UpnpHeader.Type type = UpnpHeader.Type.getByHttpName((String)entry.getKey());
            if (type == null) {
                if (!log.isLoggable(Level.FINE)) continue;
                log.fine("Ignoring non-UPNP HTTP header: " + (String)entry.getKey());
                continue;
            }
            for (String value : (List)entry.getValue()) {
                UpnpHeader upnpHeader = UpnpHeader.newInstance(type, value);
                if (upnpHeader == null || upnpHeader.getValue() == null) {
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.fine("Ignoring known but irrelevant header (value violates the UDA specification?) '" + type.getHttpName() + "': " + value);
                    continue;
                }
                this.addParsedValue(type, upnpHeader);
            }
        }
    }

    protected void addParsedValue(UpnpHeader.Type type, UpnpHeader value) {
        List<UpnpHeader> list;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Adding parsed header: " + value);
        }
        if ((list = this.parsedHeaders.get((Object)type)) == null) {
            list = new LinkedList<UpnpHeader>();
            this.parsedHeaders.put(type, list);
        }
        list.add(value);
    }

    public List<String> put(String key, List<String> values) {
        this.parsedHeaders = null;
        return super.put(key, values);
    }

    public void add(String key, String value) {
        this.parsedHeaders = null;
        super.add(key, value);
    }

    public List<String> remove(Object key) {
        this.parsedHeaders = null;
        return super.remove(key);
    }

    public void clear() {
        this.parsedHeaders = null;
        super.clear();
    }

    public boolean containsKey(UpnpHeader.Type type) {
        if (this.parsedHeaders == null) {
            this.parseHeaders();
        }
        return this.parsedHeaders.containsKey((Object)type);
    }

    public List<UpnpHeader> get(UpnpHeader.Type type) {
        if (this.parsedHeaders == null) {
            this.parseHeaders();
        }
        return this.parsedHeaders.get((Object)type);
    }

    public void add(UpnpHeader.Type type, UpnpHeader value) {
        super.add(type.getHttpName(), value.getString());
        if (this.parsedHeaders != null) {
            this.addParsedValue(type, value);
        }
    }

    public void remove(UpnpHeader.Type type) {
        super.remove((Object)type.getHttpName());
        if (this.parsedHeaders != null) {
            this.parsedHeaders.remove((Object)type);
        }
    }

    public UpnpHeader[] getAsArray(UpnpHeader.Type type) {
        if (this.parsedHeaders == null) {
            this.parseHeaders();
        }
        return this.parsedHeaders.get((Object)type) != null ? this.parsedHeaders.get((Object)type).toArray(new UpnpHeader[this.parsedHeaders.get((Object)type).size()]) : new UpnpHeader[]{};
    }

    public UpnpHeader getFirstHeader(UpnpHeader.Type type) {
        return this.getAsArray(type).length > 0 ? this.getAsArray(type)[0] : null;
    }

    public <H extends UpnpHeader> H getFirstHeader(UpnpHeader.Type type, Class<H> subtype) {
        UpnpHeader[] headers = this.getAsArray(type);
        if (headers.length == 0) {
            return null;
        }
        for (UpnpHeader header : headers) {
            if (!subtype.isAssignableFrom(header.getClass())) continue;
            return (H)header;
        }
        return null;
    }

    public String getFirstHeaderString(UpnpHeader.Type type) {
        UpnpHeader header = this.getFirstHeader(type);
        return header != null ? header.getString() : null;
    }

    public void log() {
        if (log.isLoggable(Level.FINE)) {
            log.fine("############################ RAW HEADERS ###########################");
            for (Map.Entry entry : this.entrySet()) {
                log.fine("=== NAME : " + (String)entry.getKey());
                for (String v : (List)entry.getValue()) {
                    log.fine("VALUE: " + v);
                }
            }
            if (this.parsedHeaders != null && this.parsedHeaders.size() > 0) {
                log.fine("########################## PARSED HEADERS ##########################");
                for (Map.Entry entry : this.parsedHeaders.entrySet()) {
                    log.fine("=== TYPE: " + entry.getKey());
                    for (UpnpHeader upnpHeader : (List)entry.getValue()) {
                        log.fine("HEADER: " + upnpHeader);
                    }
                }
            }
            log.fine("####################################################################");
        }
    }
}

