/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.model.message.header;

import java.net.URI;
import org.fourthline.cling.model.message.header.InvalidHeaderException;
import org.fourthline.cling.model.message.header.UpnpHeader;
import org.fourthline.cling.model.types.SoapActionType;

public class SoapActionHeader
extends UpnpHeader<SoapActionType> {
    public SoapActionHeader() {
    }

    public SoapActionHeader(URI uri) {
        this.setValue(SoapActionType.valueOf(uri.toString()));
    }

    public SoapActionHeader(SoapActionType value) {
        this.setValue(value);
    }

    public SoapActionHeader(String s) throws InvalidHeaderException {
        this.setString(s);
    }

    @Override
    public void setString(String s) throws InvalidHeaderException {
        try {
            if (!s.startsWith("\"") && s.endsWith("\"")) {
                throw new InvalidHeaderException("Invalid SOAP action header, must be enclosed in doublequotes:" + s);
            }
            SoapActionType t = SoapActionType.valueOf(s.substring(1, s.length() - 1));
            this.setValue(t);
        }
        catch (RuntimeException ex) {
            throw new InvalidHeaderException("Invalid SOAP action header value, " + ex.getMessage());
        }
    }

    @Override
    public String getString() {
        return "\"" + ((SoapActionType)this.getValue()).toString() + "\"";
    }
}

