/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.model.types;

import java.lang.reflect.ParameterizedType;
import org.fourthline.cling.model.types.CustomDatatype;
import org.fourthline.cling.model.types.Datatype;
import org.fourthline.cling.model.types.InvalidValueException;

public abstract class AbstractDatatype<V>
implements Datatype<V> {
    private Datatype.Builtin builtin;

    protected Class<V> getValueType() {
        return (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    @Override
    public boolean isHandlingJavaType(Class type) {
        return this.getValueType().isAssignableFrom(type);
    }

    @Override
    public V valueOf(String s) throws InvalidValueException {
        return null;
    }

    @Override
    public Datatype.Builtin getBuiltin() {
        return this.builtin;
    }

    public void setBuiltin(Datatype.Builtin builtin) {
        this.builtin = builtin;
    }

    @Override
    public String getString(V value) throws InvalidValueException {
        if (value == null) {
            return "";
        }
        if (!this.isValid(value)) {
            throw new InvalidValueException("Value is not valid: " + value);
        }
        return value.toString();
    }

    @Override
    public boolean isValid(V value) {
        return value == null || this.getValueType().isAssignableFrom(value.getClass());
    }

    public String toString() {
        return "(" + this.getClass().getSimpleName() + ")";
    }

    @Override
    public String getDisplayString() {
        if (this instanceof CustomDatatype) {
            return ((CustomDatatype)this).getName();
        }
        if (this.getBuiltin() != null) {
            return this.getBuiltin().getDescriptorName();
        }
        return this.getValueType().getSimpleName();
    }
}

