/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.protocol.sync;

import java.util.logging.Logger;
import org.fourthline.cling.UpnpService;
import org.fourthline.cling.model.gena.CancelReason;
import org.fourthline.cling.model.gena.RemoteGENASubscription;
import org.fourthline.cling.model.message.StreamRequestMessage;
import org.fourthline.cling.model.message.StreamResponseMessage;
import org.fourthline.cling.model.message.UpnpResponse;
import org.fourthline.cling.model.message.gena.IncomingSubscribeResponseMessage;
import org.fourthline.cling.model.message.gena.OutgoingRenewalRequestMessage;
import org.fourthline.cling.model.meta.RemoteService;
import org.fourthline.cling.protocol.SendingSync;
import org.fourthline.cling.transport.RouterException;

public class SendingRenewal
extends SendingSync<OutgoingRenewalRequestMessage, IncomingSubscribeResponseMessage> {
    private static final Logger log = Logger.getLogger(SendingRenewal.class.getName());
    protected final RemoteGENASubscription subscription;

    public SendingRenewal(UpnpService upnpService, RemoteGENASubscription subscription) {
        super(upnpService, new OutgoingRenewalRequestMessage(subscription, upnpService.getConfiguration().getEventSubscriptionHeaders((RemoteService)subscription.getService())));
        this.subscription = subscription;
    }

    @Override
    protected IncomingSubscribeResponseMessage executeSync() throws RouterException {
        StreamResponseMessage response;
        log.fine("Sending subscription renewal request: " + this.getInputMessage());
        try {
            response = this.getUpnpService().getRouter().send((StreamRequestMessage)this.getInputMessage());
        }
        catch (RouterException ex) {
            this.onRenewalFailure();
            throw ex;
        }
        if (response == null) {
            this.onRenewalFailure();
            return null;
        }
        final IncomingSubscribeResponseMessage responseMessage = new IncomingSubscribeResponseMessage(response);
        if (((UpnpResponse)response.getOperation()).isFailed()) {
            log.fine("Subscription renewal failed, response was: " + response);
            this.getUpnpService().getRegistry().removeRemoteSubscription(this.subscription);
            this.getUpnpService().getConfiguration().getRegistryListenerExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    SendingRenewal.this.subscription.end(CancelReason.RENEWAL_FAILED, (UpnpResponse)responseMessage.getOperation());
                }
            });
        } else if (!responseMessage.isValidHeaders()) {
            log.severe("Subscription renewal failed, invalid or missing (SID, Timeout) response headers");
            this.getUpnpService().getConfiguration().getRegistryListenerExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    SendingRenewal.this.subscription.end(CancelReason.RENEWAL_FAILED, (UpnpResponse)responseMessage.getOperation());
                }
            });
        } else {
            log.fine("Subscription renewed, updating in registry, response was: " + response);
            this.subscription.setActualSubscriptionDurationSeconds(responseMessage.getSubscriptionDurationSeconds());
            this.getUpnpService().getRegistry().updateRemoteSubscription(this.subscription);
        }
        return responseMessage;
    }

    protected void onRenewalFailure() {
        log.fine("Subscription renewal failed, removing subscription from registry");
        this.getUpnpService().getRegistry().removeRemoteSubscription(this.subscription);
        this.getUpnpService().getConfiguration().getRegistryListenerExecutor().execute(new Runnable(){

            @Override
            public void run() {
                SendingRenewal.this.subscription.end(CancelReason.RENEWAL_FAILED, null);
            }
        });
    }
}

