/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.processors.build;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.processing.Processor;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.util.Dictionary;
import com.github.fge.jsonschema.keyword.validator.KeywordValidator;
import com.github.fge.jsonschema.library.Library;
import com.github.fge.jsonschema.processors.data.SchemaDigest;
import com.github.fge.jsonschema.processors.data.ValidatorList;
import com.google.common.collect.Maps;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.TreeMap;

public final class ValidatorBuilder
implements Processor<SchemaDigest, ValidatorList> {
    private static final String ERRMSG = "failed to build keyword validator";
    private final Map<String, Constructor<? extends KeywordValidator>> constructors;

    public ValidatorBuilder(Library library) {
        this.constructors = library.getValidators().entries();
    }

    public ValidatorBuilder(Dictionary<Constructor<? extends KeywordValidator>> dict) {
        this.constructors = dict.entries();
    }

    public ValidatorList process(ProcessingReport report, SchemaDigest input) throws ProcessingException {
        TreeMap map = Maps.newTreeMap();
        for (Map.Entry<String, JsonNode> entry : input.getDigests().entrySet()) {
            String keyword = entry.getKey();
            JsonNode digest = entry.getValue();
            Constructor<? extends KeywordValidator> constructor = this.constructors.get(keyword);
            KeywordValidator validator = ValidatorBuilder.buildKeyword(constructor, digest);
            map.put(keyword, validator);
        }
        return new ValidatorList(input.getContext(), map.values());
    }

    private static KeywordValidator buildKeyword(Constructor<? extends KeywordValidator> constructor, JsonNode node) throws ProcessingException {
        try {
            return constructor.newInstance(node);
        }
        catch (InstantiationException e) {
            throw new ProcessingException(ERRMSG, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ProcessingException(ERRMSG, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ProcessingException(ERRMSG, (Throwable)e);
        }
    }

    public String toString() {
        return "validator builder";
    }
}

