<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib prefix="x" uri="http://java.sun.com/jsp/jstl/xml" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
	<link rel="shortcut icon" href="https://www.gigabyte.com/Images/favicon_b.ico" type="image/x-icon" />
	<head>
		<title>GSM Server</title>
		
		<!-- meta -->
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		
		<!-- CSS -->
		<link href="<c:url value="/resources/css/bootstrap/dataTables.bootstrap.css" />" rel="stylesheet">
		<link href="<c:url value="/resources/css/bootstrap/dataTables.responsive.css" />" rel="stylesheet">
		<link href="<c:url value="/resources/css/bootstrap/bootstrap-datetimepicker.css" />" rel="stylesheet">
		<link href="<c:url value="/resources/css/bootstrap/bootstrap.min.css" />" rel="stylesheet">
		<link href="<c:url value="/resources/css/bootstrap/metisMenu.min.css" />" rel="stylesheet">
		<link href="<c:url value="/resources/css/bootstrap/sb-admin.css" />" rel="stylesheet">
		<link href="<c:url value="/resources/css/font-awesome/css/font-awesome.min.css" />" rel="stylesheet">
		<link href="<c:url value="/resources/css/bootstrap/style_2016.css" />" rel="stylesheet">
		
		<!-- Java Script -->
		<script src="<c:url value="/resources/js/bootstrap/jquery.js" />"></script>
		<script src="<c:url value="/resources/js/bootstrap/bootstrap.min.js" />"></script>
		<script src="<c:url value="/resources/js/bootstrap/moment.js" />"></script>
		<script src="<c:url value="/resources/js/bootstrap/bootstrap-datetimepicker.js" />"></script>
		<script src="<c:url value="/resources/js/bootstrap/jquery.dataTables.min.js"/>"></script>
		<script src="<c:url value="/resources/js/bootstrap/dataTables.bootstrap.min.js"/>"></script>
		<script src="<c:url value="/resources/js/gsm_main.js" />"></script>
		
		<style>
			#loading_modal>.modal-dialog {
	    		margin-top: 260px !important;
				width: 95px !important;
			}
			#loading_modal .alert {
				margin-bottom: 0px !important;
		    }
			#advancedSearch_modal>.modal-dialog {
 				margin-top: 5% !important;
 				width: 70%;
			}
			#advancedSearch_modal .modal-footer {
				text-align: left;
			}
			#advancedSearch_modal i {
				margin-top: 4px;
			}
			.datepicker>.datepicker-days>.table-condensed th {
				padding-left: 5px;
    			padding-right: 5px;
			}
			#dataTables_nodelist>tbody tr:active {
				background-color: #b2b2b3;
			}
			#alertCount.badge {
				padding: 1px 4px;
			    font-weight: 500;
			    background-color: red;
			}

			/* The whole thing */
			#RightClickMenu {
				display: none;
				z-index: 1000;
				position: absolute;
				overflow: hidden;
				border: 1px solid #CCC;
				white-space: nowrap;
				font-family: sans-serif;
				background: #FFF;
				color: #333;
				border-radius: 5px;
				padding: 0;
			}
			/* Each of the items in the list */
			#RightClickMenu li {
				padding: 8px 12px;
				cursor: pointer;
				list-style-type: none;
				transition: all .3s ease;
				user-select: none;
			}
			#RightClickMenu li:hover {
				background-color: #DEF;
			}

		</style>
	</head>
	
	<body id="header-body">
		<div id="wrapper">
			<!-- Navigation -->
			<nav class="navbar navbar-inverse navbar-fixed-top">
				<div class="container-fluid">
					<div class="navbar-header">
						<table border="0">
							<tr>
								<td class="topbar-logo">
									<a class="navbar-brand" rel="home" href="MainDashboard" title="Gigabyte">
										<img src="/GSM/GSMLogo_Get/gsm_logo.png">
									</a>
								</td>
								<!-- Top Bar -->
								<td class="topbar-button">
									<ul class="nav navbar-nav topbar-nav">
										<!-- Iris, 09-05-2017, Modify main menu use the language format -->
										<li id="SystemManager"> <a id="SystemManager" href="javascript:"><img id="SystemManager" style="max-width:13px;" src="/GSM/resources/img/mainmenu_SystemManager_gray.png">&nbsp;&nbsp;<spring:message code="nav1"/></a></li>
										<sec:authorize access="hasAnyRole(${Access_Configuration})">
										<li id="GroupManager"> <a id="GroupManager" href="javascript:"><img id="GroupManager" style="max-width:13px;" src="/GSM/resources/img/mainmenu_GroupManager_gray.png">&nbsp;&nbsp;<spring:message code="nav2"/></a></li>
										</sec:authorize>
										<sec:authorize access="hasAnyRole(${Access_Configuration})">
										<li id="Deployment"> <a id="Deployment" href="javascript:"><img id="Deployment" style="max-width:13px;" src="/GSM/resources/img/mainmenu_GroupManager_gray.png">&nbsp;&nbsp;<spring:message code="nav8"/></a></li>
										</sec:authorize>
										<sec:authorize access="hasAnyRole(${Access_GetInfo})">
						                <li id="Alert"> <a id="Alert" href="javascript:"><img id="Alert" style="max-width:13px;" src="/GSM/resources/img/mainmenu_Alert_gray.png">&nbsp;&nbsp;<spring:message code="nav3"/>&nbsp;<span id="alertCount" class="badge" style="display: none;"></span></a></li>
						                </sec:authorize>
						                <sec:authorize access="hasAnyRole(${Access_AccountManage})">
										<li id="Account"> <a id="Account" href="javascript:"><img id="Account" style="max-width:11px;" src="/GSM/resources/img/mainmenu_Account_gray.png">&nbsp;&nbsp;<spring:message code="nav4"/></a></li>
										</sec:authorize>
										<li id="Preference"> <a id="Preference" href="javascript:"><img id="Preference" style="max-width:14px;" src="/GSM/resources/img/mainmenu_Preference_gray.png">&nbsp;&nbsp;<spring:message code="nav6"/></a></li>
						                <li id="Help"> <a id="Help" href="javascript:"><img id="Help" style="max-width:7px;" src="/GSM/resources/img/mainmenu_Help_gray.png">&nbsp;&nbsp;<spring:message code="nav5"/></a></li>
						            </ul>
						            <ul class="nav navbar-nav topbar-nav" style="float: right;">
						                <li id="Logout"> <a id="Logout" href="javascript:"><i class="fa fa-sign-out"></i>&nbsp;&nbsp;<spring:message code="nav7"/></a></li>
									</ul>
								</td>
								<!-- Top Bar -->
							</tr>
						</table>
					</div>
					
					<div class="collapse navbar-collapse" id="navbar">
						<div class="navbar-ex1-collapse" onclick="marknodelistclick();">
							<!-- Tab Bar -->
							<div class="nav navbar-nav side-nav tabbar">
								<table border="0">
									<tr>
										<td class="tabbar-filter">
											<!-- Iris, 09-06-2017, Modify filter tab bar use the language format in System Manager -->
											<div class="tabbar-filter-title">
												<img src="<c:url value="/resources/img/mainmenu_nodelist_filter.png" />">
												&nbsp;<spring:message code="Nodelist10"/>:
											</div>
											
											<select id="nodeListFilter">
											    <option value="All"><spring:message code="FilterList1"/></option>
										        <option value="StandardSystem"><spring:message code="FilterList2"/></option>
	                                            <option value="MultiNodeSystem"><spring:message code="FilterList3"/></option>
	                                            <!-- <option value="RackList"><spring:message code="FilterList4"/></option> -->
	                                            <option value="Storage"><spring:message code="FilterList10"/></option>
	                                            <option value="VirtualMachine"><spring:message code="FilterList26"/></option>
	                                            <option value="GroupList"><spring:message code="FilterList5"/></option>
	                                            <option style="color: #B5B5B6;" disabled>─────────────────</option>
	                                            <option value="Critical"><spring:message code="FilterList6"/></option>
	                                            <option value="Non-Critical"><spring:message code="FilterList7"/></option>
	                                            <option value="Unknown"><spring:message code="FilterList8"/></option>
	                                            <option value="Health"><spring:message code="FilterList9"/></option>
	                                            <option value="Non-Connected"><spring:message code="FilterList22"/></option>
										    </select>
									    </td>
									    <td class="tabbar-tab-option">
									    	<!-- Iris, 09-05-2017, Modify drop down menu of each main menu use the language format -->
									    	<select id="tabMenuSelect_SystemManager">
										        <option id="NodeInformation" value="NodeInformation"><spring:message code="Information"/></option>
										        <sec:authorize access="hasAnyRole(${Access_GetInfo})">
										        <option id="NodeMonitoring" value="NodeMonitoring"><spring:message code="NodeDetail1"/></option>
										        </sec:authorize>
										        <sec:authorize access="hasAnyRole(${Access_GetInfo}, ${Access_VirtualMedia})">
										        <option id="NodeRemoteAccess" value="NodeRemoteAccess"><spring:message code="NodeDetail2"/></option>
										        </sec:authorize>
										        <sec:authorize access="hasAnyRole(${Access_Configuration})">
										        <option id="NodeNetworkConfiguration" value="NodeNetworkConfiguration"><spring:message code="NodeDetail3"/></option>
										        </sec:authorize>
										        <sec:authorize access="hasAnyRole(${Access_GetInfo})">
										        <option id="NodeEventLog" value="NodeEventLog"><spring:message code="NodeDetail4"/></option>
										        </sec:authorize>
										        <sec:authorize access="hasAnyRole(${Access_Configuration})">
										        <option id="NodeAlertManagement" value="NodeAlertManagement"><spring:message code="NodeDetail5"/></option>
										        </sec:authorize>
										        <sec:authorize access="hasAnyRole(${Access_Configuration})">
										        <option id="NodeUpdate" value="NodeUpdate"><spring:message code="NodeDetail6"/></option>
										        </sec:authorize>
										        <sec:authorize access="hasAnyRole(${Access_GetInfo})">
										        <option id="NodePowerConsumption" value="NodePowerConsumption"><spring:message code="NodeDetail7"/></option>
										        </sec:authorize>
										        <sec:authorize access="hasAnyRole(${Access_Configuration})">
										        <option id="NodeSol" value="NodeSol"><spring:message code="NodeDetail18"/></option>
										        </sec:authorize>
										        <sec:authorize access="hasAnyRole(${Access_GetInfo})">
										        <option id="NodeSoftware" value="NodeSoftware"><spring:message code="NodeDetail8"/></option>
										        </sec:authorize>
										        <sec:authorize access="hasAnyRole(${Access_Configuration})">
										        <option id="NodeRemoteBIOSSetup" value="NodeRemoteBIOSSetup"><spring:message code="NodeDetail19"/></option>
										        </sec:authorize>
										        <option id="NodeVirtualMachine" value="NodeVirtualMachine">Virtual Machine</option>
									    	</select>
										    <select id="tabMenuSelect_GroupManager" style="display:none;" disabled>
										        <option value="Group Setting"><spring:message code="NodeDetail9"/></option>
									    	</select>
										    <select id="tabMenuSelect_Group" style="display:none;">
										        <option value="GroupDashboard"><spring:message code="Information"/></option>
										        <sec:authorize access="hasAnyRole(${Access_GetInfo})">
										        <option id="GroupRemoteAccess" value="GroupRemoteAccess"><spring:message code="NodeDetail2"/></option>
										        </sec:authorize>
										        <sec:authorize access="hasAnyRole(${Access_Configuration})">
									    		<option id="GroupUpdate" value="GroupUpdate"><spring:message code="NodeDetail6"/></option>
									    		</sec:authorize>
									    		<sec:authorize access="hasAnyRole(${Access_GetInfo})">
									    		<option value="GroupLog"><spring:message code="NodeDetail4"/></option>
									    		</sec:authorize>
									    		<sec:authorize access="hasAnyRole(${Access_GetInfo})">
									    		<option id="GroupPowerConsumption" value="GroupPowerConsumption"><spring:message code="NodeDetail7"/></option>
									    		</sec:authorize>
									    		<sec:authorize access="hasAnyRole(${Access_Configuration})">
									    		<option id="GroupNetworkConfig" value="GroupNetworkConfig"><spring:message code="NodeDetail3"/></option>
									    		</sec:authorize>
									    		<sec:authorize access="hasAnyRole(${Access_Configuration})">
									    		<option id="GroupAlertManagement" value="GroupAlertManagement"><spring:message code="NodeDetail5"/></option>
									    		</sec:authorize>
									    	</select>
										    <select id="tabMenuSelect_Deployment" style="display:none;" disabled>
										        <option value="Deployment"><spring:message code="nav8"/></option>
									    	</select>
										    <select id="tabMenuSelect_Alert" style="display:none;" disabled>
										        <option value="NodeStatus"><spring:message code="NodeDetail10"/></option>
									    	</select>
									    	<select id="tabMenuSelect_Account" style="display:none;" disabled>
										        <option value="User privileges"><spring:message code="NodeDetail11"/></option>
									    	</select>
									    	<select id="tabMenuSelect_Preference" style="display:none;">
									    		<sec:authorize access="hasAnyRole(${Access_Configuration})">
										        <option value="GSMDashboard"><spring:message code="NodeDetail12"/></option>
										        </sec:authorize>
										        <sec:authorize access="hasAnyRole(${Access_GetInfo})">
										        <option value="GSMLog"><spring:message code="NodeDetail4"/></option>
										        </sec:authorize>
										        <sec:authorize access="hasAnyRole(${Access_Configuration})">
										        <option value="GSMAlertManagement"><spring:message code="NodeDetail5"/></option>
										        </sec:authorize>
										        <sec:authorize access="hasAnyRole(${Access_GetInfo})">
										        <option value="GSMDBUpdate"><spring:message code="SettingGSM3"/></option>
										        </sec:authorize>
										        <sec:authorize access="hasAnyRole(${Access_Configuration})">
										        <option value="GSMProperties"><spring:message code="NodeDetail13"/></option>
										        </sec:authorize>
										        <sec:authorize access="hasAnyRole(${Access_Diagnossic})">
										        <option value="GSMInteractiveUtility"><spring:message code="NodeDetail16"/></option>
										        </sec:authorize>
										        <sec:authorize access="hasAnyRole(${Access_Configuration})">
										        <option value="SettingUpdate"><spring:message code="NodeDetail6"/></option>
										        </sec:authorize>
										        <option value="GSMLanguage"><spring:message code="Language"/></option>
									    	</select>
										    <select id="tabMenuSelect_Help" style="display:none;" disabled>
										        <option value="User menu description"><spring:message code="NodeDetail14"/></option>
									    	</select>
									    </td>
									</tr>
								</table>
							</div>
							<!-- Tab Bar -->
							
							<!-- Side Bar -->
							<div class="nav navbar-nav side-nav searchbox">
								<input type="search" id="searchbox" placeholder='<spring:message code="Search"/>' onClick="this.setSelectionRange(0, this.value.length)" class="form-control">
								<i class="fa fa-search form-control-feedback" aria-hidden="true"></i>
								<a id="advancedSearch" href="javascript:" class="form-control-feedback">
									<i class="fa fa-bars form-control-feedback" aria-hidden="true"></i>
								</a>
							</div>
							<div id="Side_Bar_NodeList">
								<!-- Iris, 09-08-2017, Modify filter result list use the language format -->
								<ul id="NodeList_All" class="nav navbar-nav side-nav">
									<li nodelisttag="empty"><a><b><spring:message code="FilterList11"/></b></a></li>
								</ul>
								<ul id="NodeList_StandardSystem" class="nav navbar-nav side-nav" style="display:none;">
									<li nodelisttag="empty"><a><b><spring:message code="FilterList12"/></b></a></li>
								</ul>
								<ul id="NodeList_MultiNodeSystem" class="nav navbar-nav side-nav" style="display:none;">
									<li nodelisttag="empty"><a><b><spring:message code="FilterList13"/></b></a></li>
								</ul>
								<!-- <ul id="NodeList_RackList" class="nav navbar-nav side-nav" style="display:none;">
									<li nodelisttag="empty"><a><b><spring:message code="FilterList14"/></b></a></li>
								</ul> -->
								<ul id="NodeList_Storage" class="nav navbar-nav side-nav" style="display:none;">
									<li nodelisttag="empty"><a><b><spring:message code="FilterList15"/></b></a></li>
								</ul>
								<ul id="NodeList_VirtualMachine" class="nav navbar-nav side-nav" style="display:none;">
									<li nodelisttag="empty"><a><b><spring:message code="FilterList16"/></b></a></li>
								</ul>
								<ul id="NodeList_GroupList" class="nav navbar-nav side-nav" style="display:none;">
									<li nodelisttag="empty"><a><b><spring:message code="FilterList17"/></b></a></li>
								</ul>
								<ul id="NodeList_Critical" class="nav navbar-nav side-nav" style="display:none;">
									<li nodelisttag="empty"><a><b><spring:message code="FilterList18"/></b></a></li>
								</ul>
								<ul id="NodeList_Non-Critical" class="nav navbar-nav side-nav" style="display:none;">
									<li nodelisttag="empty"><a><b><spring:message code="FilterList19"/></b></a></li>
								</ul>
								<ul id="NodeList_Unknown" class="nav navbar-nav side-nav" style="display:none;">
									<li nodelisttag="empty"><a><b><spring:message code="FilterList20"/></b></a></li>
								</ul>
								<ul id="NodeList_Health" class="nav navbar-nav side-nav" style="display:none;">
									<li nodelisttag="empty"><a><b><spring:message code="FilterList21"/></b></a></li>
								</ul>
								<ul id="NodeList_Non-Connected" class="nav navbar-nav side-nav" style="display:none;">
									<li nodelisttag="empty"><a><b><spring:message code="FilterList23"/></b></a></li>
								</ul>

								<sec:authorize access="hasAnyRole(${Access_DeleteNode})">
	 							<ul id="RightClickMenu" class="RightClickMenu">
									<li data-action="Delete_Node"><spring:message code="DeleteNode"/></li>
								</ul>
								</sec:authorize>
							</div>
							<!-- Side Bar -->
						</div>
					</div>
				</div>
			</nav>
		</div>
		
		<div class="modal fade" id="loading_modal" tabindex="-1" role="dialog" data-backdrop="static" data-keyboard="false">
			<div class="modal-dialog" role="document">
				<div class="modal-content">
					<div class="alert">
						<i class="fa fa-circle-o-notch fa-spin fa-3x fa-fw"></i>
					</div>
				</div>
			</div>
		</div>
		
		<div class="modal fade" id="advancedSearch_modal" tabindex="-1" role="dialog">
			<div class="modal-dialog" role="document">
				<div class="modal-content">
					<div class="modal-header">
						<button type="button" class="close" data-dismiss="modal">&times;</button>
						<h4 class="modal-title"><spring:message code="mainMenu11"/></h4>
					</div>
					<div id="advancedSearch_modalBody" class="modal-body">
						<table id="dataTables_filter" class="table table-striped table-bordered table-hover">
							<thead>
								<tr>
									<th><spring:message code="Select"/></th>
									<th><spring:message code="Logic"/></th>
									<th><spring:message code="Option"/></th>
									<th><spring:message code="Judgment"/></th>
									<th><spring:message code="Content"/></th>
									<th></th>
								</tr>
							</thead>
							<tbody>
							</tbody>
						</table>
						
						<div style="text-align: center;">
							<div style="text-align: left; display: inline-block; width:calc(50% - 5px);">
								<a id="addFilter" href="javascript:"><i class="fa fa-plus-circle fa-2x"></i></a>
							</div>
							<div style="text-align: right; display: inline-block; width:calc(50% - 5px);">
								<button id="searchFilter" type="button" class="btn btn-primary"><spring:message code="Search"/></button>
								<button id="resetFilter" type="button" class="btn btn-primary"><spring:message code="Reset"/></button>
							</div>
						</div>
					</div>
					<div class="modal-footer">
						<table id="dataTables_nodelist" class="table table-striped table-bordered table-hover">
							<thead>
								<tr>
									<th><spring:message code="Nodelist2"/></th>
									<th><spring:message code="Nodelist3"/></th>
									<th><spring:message code="Nodelist4"/></th>
									<th><spring:message code="Nodelist8"/></th>
									<th><spring:message code="Nodelist5"/></th>
								</tr>
							</thead>
							<tbody>
								<!-- <tr>
									<td colspan="5" style="text-align: center; padding-left:8px;"><i class="fa fa-circle-o-notch fa-spin fa-2x fa-fw"></i></td>
									<td style="display:none;"></td><td style="display:none;"></td><td style="display:none;"></td><td style="display:none;"></td>
								</tr> -->
							</tbody>
						</table>
					</div>
				</div>
			</div>
		</div>
		
		<div class="modal fade" id="loading_modal" tabindex="-1" role="dialog" data-backdrop="static" data-keyboard="false">
			<div class="modal-dialog" role="document">
				<div class="modal-content">
					<div class="alert">
						<i class="fa fa-circle-o-notch fa-spin fa-3x fa-fw"></i>
					</div>
				</div>
			</div>
		</div>
		<div class="modal fade" id="updateGSM" tabindex="-1" role="dialog" data-backdrop="static" aria-labelledby="myModalLabel">
			<div class="modal-dialog" role="document">
				<div class="modal-content">
					<div class="modal-header">
						<h4 class="modal-title" id="myModalLabel">New version</h4>
					</div>
				
					<div class="modal-body">
						<p>New version of GSM has been released.</p>
						<p>Do you want to update now?</p>
						<h3><span id="countTime" style="font-weight: bold; visibility: hidden"></span></h3>
					</div>
				
					<div class="modal-footer">
						<button id="startUpdate" type="button" class="btn btn-primary"><spring:message code="Yes"/></button>
						<button id="noUpdate" type="button" class="btn btn-primary" data-dismiss="modal"><spring:message code="No"/></button>
						<button id="remindLater" type="button" class="btn btn-primary" data-dismiss="modal"><spring:message code="RemindLater"/></button>
					</div>
				</div>
			</div>
		</div>
		
		<!-- Content Page -->
		<div class="content">
			<iframe id="gsmiframe" class="gsmiframe" src="" frameborder="0">
		        Browser not support iframe.
		    </iframe>
		</div>
		<!-- Content Page -->
		
		<script>
			var idleTime = 0;
			var gsmiframe_load_run = "";
			var gsmFileUrl = "";
			var timeCount = 150;
			
			//Monitor user actions in web page, if is no action for a long time then redirects to login page.
		    var resetIdleTime = function(e) {
		    	idleTime = 0;
		    };
		    var timerIncrement = function() {
				idleTime = idleTime + 1;
				if (idleTime > 6){
					window.location.href = "./Logout";	
				}
			};
			
			var checkServerStatus = function() {
				var img = document.body.appendChild(document.createElement("img"));

		        img.onload = function() {
		           timeCount = 0;
		        };
		      
		        img.src = window.location.protocol + "//" + window.location.host + "/GSM/GetGSMLogo/gsm_logo.png?" + new Date().getTime();
			};
			
			var countdown = function() {
				$("#countTime").css("visibility", "visible");
				$("#countTime").html('<spring:message code="GSMUpdateProcess"/> ' + timeCount--);
				
				var timeOut = setTimeout(countdown, 1000);
				
				if (timeCount < 0) {
					clearTimeout(timeOut);
					window.location.reload();
				}
				
				if (timeCount < 130)
					checkServerStatus();
			};
			
			$(document).ready(function() {
				var idleInterval;
				
				var combineOptionString = function(itemArray) {
					var optionString = "";
					itemArray.forEach(function(item) {
						var value = item.replace(/\s+/g, '');
						
						//convert special value
						if(item === "BMC")
							value = "SMC";
						
						if(item.indexOf("─────") >= 0)
							optionString += "<option value=\"" + value + "\" style=\"color: #B5B5B6;\" disabled>" + item + "</option>";
						else
							optionString += "<option value=\"" + value + "\">" + item + "</option>";
					});
					return optionString;
				};
				
				/*William 2018/12/14: Add a advanced search item for Node Description.*/
				var filterLogic  = ["AND", "OR", "AND NOT", "OR NOT"];
				var filterOption = ["IP Address", "MAC Address", "Node Description", 
									"───────────FRU───────────", 
									"Board Product Name", "Board Serial Number", "Board Manufacturer", "Board Manufacturing Date", 
									"Product Serial Number", "Product Asset Tag", "Product Manufacturer Name", "Product Name", 
									"───────────BMC───────────", 
									"BMC Type", "BMC Firmware Type", "ASIC Type", 
									"Product ID", "BMC Product Name", "Firmware Revision", 
									"───────────BIOS───────────", 
									"Vendor", "BIOS Version", "BIOS Release Date"];
				var filterJudge  = ["Equals", "Contains", "Start with", "End with"];
				var filterJudge_number  = ["Equals", "Greater than", "Less than"];
				var filterLogicString  = combineOptionString(filterLogic);
				var filterOptionString = combineOptionString(filterOption);
				var filterJudgeString  = combineOptionString(filterJudge);
				var filterJudgeString_number  = combineOptionString(filterJudge_number);
				var filterMaxNumber = 5;
				
				var filterObjectString = "<tr>" + 
										 "<td><input name=\"select\" type=\"checkbox\" class=\"form-control\" checked></td>" + 
										 "<td><select name=\"logic\" class=\"form-control\">" + filterLogicString  + "</select></td>" + 
										 "<td><select name=\"option\" class=\"form-control\">" + filterOptionString + "</select></td>" + 
										 "<td><select name=\"judge\" class=\"form-control\">" + filterJudgeString  + "</select></td>" + 
										 "<td><input name=\"content\" contentType=\"text\" type=\"text\" class=\"form-control\"></td>" + 
										 "<td><a name=\"removeFilter\" href=\"javascript:\"><i class=\"fa fa-minus-circle fa-2x\"></i></a></td>" + 
										 "</tr>";
				
				var searchNodeListDataTable;
				
				var initFilter = function() {
					$('#dataTables_filter>tbody').html(filterObjectString);
					$('#dataTables_filter>tbody>tr select[name="logic"]').html(combineOptionString(["", "NOT"]));
					$('#dataTables_filter>tbody>tr a[name="removeFilter"]').remove();
				};
				
				var searchNodeListLoading = function(start, dataArray) {
					if(start) {
						$("#advancedSearch_modalBody").attr("disabled", "disabled");
						$("#advancedSearch_modalBody").css("pointer-events", "none");
						$("#advancedSearch_modalBody").css("opacity", ".65");
						$("#dataTables_nodelist>tbody").html("<tr><td colspan='5' style='text-align: center; padding-left:8px !important;'><i class='fa fa-circle-o-notch fa-spin fa-2x fa-fw'></i></td></tr>");
					}
					else {
						setTimeout(function(){
							$("#advancedSearch_modalBody").removeAttr("disabled");
							$("#advancedSearch_modalBody").css("pointer-events", "");
							$("#advancedSearch_modalBody").css("opacity", "");
							searchNodeListDataTable.clear().draw(false);
							if(dataArray !== null)
					        	searchNodeListDataTable.rows.add(dataArray).draw(false);
						}, 1000);
					}
				};
				
				var checkGSMVersion = function() {
					$.ajax({
						url: 'checkGSMVersion',
						data: {},
						dataType: 'json',
						success: function(data) {
							if (data.newVerRelease) {
								gsmFileUrl = data.newVerFileUrl;
								$("#updateGSM").modal("show");
							}
						},
						error: function(xhr, status, error) {
							alert("Check GSM version failed: [" + xhr.status + "] " + xhr.statusText);
						}
					});
				};
				
				var checkNodeInfo = function(ip, id) {
					$('#loading_modal').modal('show');
					
					var formData = new FormData();
					formData.append('IP', ip);
					$.ajax({
			    		url: 'checkNodeInfo',
			        	type: 'POST',
			        	data: formData,
			        	dataType: 'json',
			        	//Terry, show icon_status_3.png when the product's name is "Unknown"
			        	success: function(_data, status, xhr) {
			        		$('#loading_modal').modal('hide');
			        		
			        		if(_data.status === "Success"){
			        			if(id != null) {
			        				/* Brian 2019/07/23: First use host name, if unknown or empty then use product name */
			        				_data.nodeName = _data.hostName;
			        				if((_data.nodeName == "") || (_data.nodeName == "Unknown")) {
			        					_data.nodeName = _data.productName;
			        				}
			        				//alert(_data.nodeName);
				        			if (_data.nodeName !== "Unknown") {
				        				$("li[nodelisttag='node-control'][id='" + id + "']").find("a").html("<img nodelisttag=\"node-status\" src=\"/GSM/resources/img/icon_status_4.png\">"+
				        					            	"&nbsp;&nbsp;&nbsp;"+ _data.nodeName + "&nbsp;(" + ip + ")");
				        			} else {
				        				$("li[nodelisttag='node-control'][id='" + id + "']").find("a").html("<img nodelisttag=\"node-status\" src=\"/GSM/resources/img/icon_status_3.png\">"+
		        				            	"&nbsp;&nbsp;&nbsp;"+ _data.nodeName + "&nbsp;(" + ip + ")");
				        			}
				        		}
				        		
			        			linkPage(ip);
			        		}
			        		else if(_data.status === "Failed"){
			        			console.log(_data.reason);
			        			alert("<spring:message code="webAlert3"/>");
			        			linkPage(ip);
			        		}
						},
						error: function(xhr, status, error) {
							$('#loading_modal').modal('hide');
							console.log("Check node info failed: [" + xhr.status + "] " + xhr.statusText);
						},
			        	cache: false,
			        	contentType: false,
			        	processData: false
			    	});
				}
				
				checkBrowser();
				checkGSMAlertCount();
				checkGSMVersion();
				
				defaultPageJSON = '${defaultPageJSON}';
				connectionInterface = '${connectionInterface}';
				groupControl_name='<spring:message code="nav2"/>';
				webAlert_4='<spring:message code="webAlert4"/>';
				webAlert_5='<spring:message code="webAlert5"/>';
				//Get the group list and node list, and update automatically every 5 minutes.
				setTimeout(function() {getGroupList("first");}, 50);
				
				//Jump to login page when user idle over 5 mins.
				idleInterval = setInterval(timerIncrement, 300000);
				$(this).mousemove(function (e) {
					resetIdleTime(e);
			    });
			    $(this).keypress(function (e) {
			    	resetIdleTime(e);
			    });
			    
				//Select action of the Top bar.
				$("#" + topMenuSelected).addClass("active");
				$("#" + topMenuSelected).find("img").attr("src", "/GSM/resources/img/mainmenu_" + topMenuSelected + "_white.png");
				$(".topbar-nav>li>a").on("mousedown", function(){
					topMenuSelected = $(this).attr('id');
					
					$(this).parent().addClass("active");
					
					$(".topbar-nav li").not("#" + $(this).attr('id')).removeClass("active");
					$(".topbar-nav img").not("#" + $(this).attr('id')).attr("src", function() {return $(this).attr("src").replace("white", "gray");});
					
					if(topMenuSelected !== "SystemManager")
						$("ul[nodelisttag='group-list']").collapse('hide');
					$("li[nodelisttag='node-control']").removeClass("active");
					$("li[nodelisttag='group-control']").removeClass("active");
					
					//Default the settings.
					$("#tabMenuSelect_" + topMenuSelected).prop('selectedIndex',0);
					tabMenuSelected = $("#tabMenuSelect_" + topMenuSelected).val();
					sideMenuSelected = firstNode;
					
					$("select[id^=tabMenuSelect_]").hide();
					$("#tabMenuSelect_" + topMenuSelected).show();
					
					linkPage("top");
				});
				$(".topbar-nav>li>a").on("mouseenter focusin", function(){
					$(this).find("img").attr("src", "/GSM/resources/img/mainmenu_" + $(this).attr('id') + "_white.png");
				});
				$(".topbar-nav>li>a").on("mouseleave focusout", function(){
					if(("${topMenu}" !== $(this).attr('id')) && (topMenuSelected !== $(this).attr('id')) && !$(this).is(":focus"))
						$(this).find("img").attr("src", "/GSM/resources/img/mainmenu_" + $(this).attr('id') + "_gray.png");
				});
				
				//Select action of the Filter bar.
				$("#nodeListFilter").on("change", function(){
					$("ul[id^=NodeList_]").hide();
					filterMenuSelected = $("#nodeListFilter").val();
					
					$("#NodeList_" + filterMenuSelected.replace(/ /g,'')).show();
				});
				
				//Select action of the Tab bar.
				$("select[id^=tabMenuSelect_]").on("change", function() {
					tabMenuSelected = $(this).val();
					linkPage("tab");
				});
				
				//Search the node list.
				$("#searchbox").on("keyup change", function(key) {
					var nowSearchBoxText = searchBoxText;
					
					if(searchBoxText !== $(this).val()) {
						searchBoxText = $(this).val();
					}
					
					if(key.which === 13) {
						$(this).blur();
					}
					
					//key.which >= 65 for not contains controll button ([Ctrl], [Alt]...etc.).
					//key.which == 8 is [Backspce], key.which == 46 is [Delete], 48 <= key.which <= 57 is 0~9 in Alphanumeric Keys Part.
					if(!searchBoxChecking && ((key.which >= 65) || (key.which === 8) || (key.which === 46) || ((48 <= key.which) && (key.which <= 57)))) {
						setTimeout(function() {checkSearchBoxFinished(nowSearchBoxText);}, 500);
						searchBoxChecking = true;
					}
				})
				//Sean, add dialog progress when user click the node of incomplete data
				$("ul").delegate("li[nodelisttag='node-control']",'click',function(){
					//console.log(this.id.replace(/\_/g, "."));
					var id = this.id;
					var ip = convertIDtoIP(id);
					
					if ($("li[nodelisttag='node-control'][id='" + id + "']").attr("isconn") == "true") {
						checkNodeInfo(ip, id);
					}
				});
				
				$("#tabMenuSelect_SystemManager").on("change", function() {
					if($(this).val() === "NodeVirtualMachine") {
						checkNodeInfo(sideMenuSelected);
					}
				});
				
				//Advanced Search
				initFilter();
				
				$('#dataTables_filter').DataTable({
					"paging": false,
					"bInfo": false,
					"responsive": true,
					"searching": false,
					"aoColumns": [{ "bSortable": false },
								  { "bSortable": false },
								  { "bSortable": false },
								  { "bSortable": false },
								  { "bSortable": false },
								  { "bSortable": false }]
				});
				
				searchNodeListDataTable = $('#dataTables_nodelist').DataTable({
					"aaSorting": [[ 1, "asc" ]],
					"pagingType": "full_numbers",
					"responsive": true,
					"searching": false,
					"createdRow": function( row, data, dataIndex ) {
						$( row ).css("cursor", "pointer");
					}
				});
				
				$("#advancedSearch").on("click", function() {
					$('#advancedSearch_modal').modal("show");
				});
				
				$("#addFilter").on("click", function() {
					if($("#dataTables_filter>tbody>tr").length < filterMaxNumber) {
						$('#dataTables_filter>tbody').append(filterObjectString);
						
						if($("#dataTables_filter>tbody>tr").length >= filterMaxNumber) {
							$("#addFilter").css("pointer-events", "none");
							$("#addFilter").css("opacity", ".65");
						}
					}
				});
				
				$("#resetFilter").on("click", function() {
					initFilter();
				});
				
				$("#searchFilter").on("click", function() {
					var objArray = [];
					
					$("#dataTables_filter>tbody>tr").each(function() {
						var logic = $(this).find("select[name=logic]").val();
						var option = $(this).find("select[name=option]").val();
						var judge = $(this).find("select[name=judge]").val();
						var content = $(this).find("input[name=content]").val();
						
						var newObj = new Object();
						
						if(!$(this).find("input[name=select]").is(':checked'))
							return;
						
						if(!logic) //First filter
							logic = "";
						
						if(!content) //Content is select option element
							content = $(this).find("select[name=content]").val();
						
						if(!content)
							return;
						
						newObj["logic"]   = logic;
						newObj["option"]  = option;
						newObj["judge"]   = judge;
						newObj["content"] = content;
						objArray.push(newObj);
					});
					
					if(objArray.length === 0)
						return;
					
					searchNodeListLoading(true);
					
					$.ajax({
				    	url: 'advancedSearchNode',
				        type: 'GET',
				        data: {
				        	jsonArray:JSON.stringify(objArray)
				        },
				        dataType: 'json',
				        success: function(_data, status, xhr) {
				        	var nodelistArray = [];
				        	
				        	for(var i=0 ; i<_data.length ; i++) {
				        		nodelistArray.push([_data[i].bmcMac, 
								        			_data[i].bmcIP, 
								        			_data[i].bmcConn, 
								        			_data[i].bmcVer, 
								        			_data[i].bmcType.replace("SMC", "BMC")]);
				        	}
							
							searchNodeListLoading(false, nodelistArray);
						},
						error: function(xhr, status, error) {
				        	console.log("Search the node list failed: [" + xhr.status + "] " + xhr.statusText);
							searchNodeListLoading(false);
						},
				        cache: false
				    });
				});
				
				$('#dataTables_nodelist>tbody').delegate('tr', 'click', function () {
					linkPage($(this).find("td:eq(1)").text());
					$('#advancedSearch_modal').modal("hide");
				});
				
				$("#dataTables_filter>tbody").delegate("a[name='removeFilter']", "click", function() {
					$(this).parent().parent().remove();
					
					if($("#dataTables_filter>tbody>tr").length < filterMaxNumber) {
						$("#addFilter").css("pointer-events", "");
						$("#addFilter").css("opacity", "");
					}
				});
				
				$("#dataTables_filter>tbody").delegate("select[name='option']", "change", function() {
					var judgeElement = $(this).parent().parent().find("select[name=judge]");
					var contentElement = $(this).parent().parent().find("[name=content]");
					
					var bmcTypeList;
					var bmcTypeString;
					
					switch($(this).val()) {
						case "BMCType":
							//bmcTypeList = ["BMC", "CMC", "RMC"];
							bmcTypeList = ["BMC", "CMC"];
							bmcTypeString = combineOptionString(bmcTypeList);
							
							judgeElement.val("Equals");
							judgeElement.prop('disabled', true);
							contentElement.parent().html("<select name=\"content\" contentType=\"select\" class=\"form-control\">" + bmcTypeString  + "</select>");
							break;
						case "BMCFirmwareType":
							bmcFirmwareList = ["Vertiv", "AMI", "OpenBMC"];
							bmcFirmwareString = combineOptionString(bmcFirmwareList);
							
							judgeElement.val("Equals");
							judgeElement.prop('disabled', true);
							contentElement.parent().html("<select name=\"content\" contentType=\"select\" class=\"form-control\">" + bmcFirmwareString  + "</select>");
							break;
						case "ASICType":
							asicTypeList = ["AST2400", "AST2500"];
							asicTypeString = combineOptionString(asicTypeList);
							
							judgeElement.val("Equals");
							judgeElement.prop('disabled', true);
							contentElement.parent().html("<select name=\"content\" contentType=\"select\" class=\"form-control\">" + asicTypeString  + "</select>");
							break;
						case "BoardManufacturingDate":
						//case "BIOSReleaseDate":
							judgeElement.html(filterJudgeString_number);
							judgeElement.prop('disabled', false);
							contentElement.parent().html(
								"<div name=\"content\" class=\"form-group\">" + 
								"    <div class='input-group date' name='datetimepicker'>" + 
								"        <input name=\"content\" contentType=\"date\" type=\"text\" class=\"form-control\" />" + 
								"        <span class=\"input-group-addon\">" + 
								"            <span class=\"fa fa-calendar\"></span>" + 
								"        </span>" + 
								"    </div>" + 
								"</div>");
							$(this).parent().parent().find("div[name=datetimepicker]").datetimepicker({
				                showTodayButton: true, 
				                format: "YYYY-MM-DD HH:mm", 
				                defaultDate: new Date()
				            });
							break;
						default:
							if(judgeElement.text().indexOf("Contains") < 0)
								judgeElement.html(filterJudgeString);
							judgeElement.prop('disabled', false);
							if(!contentElement.is("input[contentType=\"text\"]"))
								contentElement.parent().html("<input name=\"content\" contentType=\"text\" type=\"text\" class=\"form-control\">");
							break;
					}
				});
				//Advanced Search
			});
			
			//Listener the action in iframe page.
		    $('#gsmiframe').on("load", function() {
		    	var action;
		    	
		    	if(gsmiframe_load_run) {
		    		action = gsmiframe_load_run.split("_");
		    		
		    		switch(action[0]) {
		    			case "Refresh GSM":
		    				window.location.href = "./GSM";
		    			break;
		    			
		    			case "Refresh Group List":
		    				getGroupList();
		    				break;
		    			
		    			case "Refresh Node List By Group":
		    				getNodeList_byGroupID(action[1]);
		    				break;
		    			
		    			case "Rename the Group":
		    				getGroupName(action[1]);
		    				break;
		    			
		    			default:
		    				break;
		    		}
		    		
		    		gsmiframe_load_run = "";
		    	}
		    	
		    	if($(this).attr('src') === "./GSMDashboard") {
		    		$('#gsmiframe').contents().find("#search_ip_range").on("click", function() {
		    			gsmiframe_load_run = "Refresh GSM";
		    		});
		    	}
		    	
		    	if($(this).attr('src') === "./GSMLanguage") {
		    		$('#gsmiframe').contents().find("#languageOption").on("change", function() {
		    			var setLanguage = $(this).val();
		    			var browserLanguage;
		    			
		    			if(setLanguage === "Auto detect") {
		    				if(navigator.language)
		    					browserLanguage = navigator.language.toLowerCase(); //Chrome, Firefox
			    			else if(navigator.browserLanguage)
		    					browserLanguage = navigator.browserLanguage.toLowerCase(); //IE
		    				
		    				if((browserLanguage.indexOf("zh") !== -1) || (browserLanguage.indexOf("tw") !== -1)) //zh-TW
		    					setLanguage = "Chinese";
		    				else if((browserLanguage.indexOf("en") !== -1) || (browserLanguage.indexOf("us") !== -1)) //en-US
		    					setLanguage = "English";
		    				else
		    					setLanguage = "Unknown";
		    			}
		    			
		    			if((setLanguage === "Chinese") || (setLanguage === "English") || (setLanguage === "Unknown")) {
		    				$.ajax({
			    				url: 'changeSessionLanauage',
			    			    data: {setLanguage: setLanguage},
			    			    dataType: 'json',
			    			    success: function(_data, status, xhr) {
			    			    	if(_data.status === "OK")
			    			    		window.location.href = "./GSM";
			    			    	else
			    			    		alert("Change the language failed: " + _data.status);
			    			    },
			    			    error: function(xhr, status, error) {
			    			    	console.log("Change the language failed: [" + xhr.status + "] " + xhr.statusText);
			    				},
			    			    cache: false
			    			});
		    			}
		    		});
		    	}
		    	
		    	if($(this).attr('src') === "./Grouplist") {
		    		$('#gsmiframe').contents().find("#createGroupBtn").on("click", function() {
		    			gsmiframe_load_run = "Refresh Group List";
		    		});
		    		
		    		$('#gsmiframe').contents().find("#deleteBtn").on("click", function() {
		    			gsmiframe_load_run = "Refresh Group List";
		    		});
		    	}
		    	
		    	if($(this).attr('src').indexOf("./GroupDashboard") >= 0) {
		    		$('#gsmiframe').contents().find("#subBtn").on("click", function() {
		    			gsmiframe_load_run = "Refresh Node List By Group_" + $(this).parent().parent().find("input[name=ID]").val();
		    		});
		    		
		    		$('#gsmiframe').contents().find("#delBtn").on("click", function() {
		    			gsmiframe_load_run = "Refresh Node List By Group_" + $(this).parent().parent().find("input[name=ID]").val();
		    		});
		    		
		    		$('#gsmiframe').contents().find("#renameGroupBtn").on("click", function() {
		    			gsmiframe_load_run = "Rename the Group_" + $(this).parent().parent().find("input[name=ID]").val();
		    		});
		    	}
		    	
		    	$(this).contents().mousemove(function (e) {
		    		window.parent.resetIdleTime(e);
			    });
		    	$(this).contents().keypress(function (e) {
		    		window.parent.resetIdleTime(e);
			    });
		    });
			
			$("#startUpdate").on("click", function() {
				$("#loading_modal").modal("show");
				
				$("#startUpdate").prop("disabled", true);
				$("#noUpdate").prop("disabled", true);
				$("#remindLater").prop("disabled", true);
				
				$.ajax({
					url: 'updateGSM',
					data: {path: gsmFileUrl},
					dataType: 'json',
					success: function(data) {
						if (data.status !== "OK")
							alert("Update GSM failed.");
						
						$("#loading_modal").modal("hide");
						countdown();
					},
					error: function(xhr, status, error) {
						alert("Update GSM failed: [" + xhr.status + "] " + xhr.statusText);
						$("#loading_modal").modal("hide");
					}
				});
			});
			
			$("#remindLater").on("click", function() {
				$.ajax({
					url: 'setRemindUpdate',
					data: {remindUpdate: false},
					dataType: 'json',
					success: function(data) {
						if (data.status !== "OK")
							alert("Set reminding later failed.");
					},
					error: function(xhr, status, error) {
						alert("Set reminding later failed: [" + xhr.status + "] " + xhr.statusText);
					}
				});
			});

			var delete_nodename = "";
			var delete_ip = "";
			// Trigger action when the contexmenu is about to be shown
			$("#Side_Bar_NodeList").bind("contextmenu", function (event) {
				// Avoid the real one
				event.preventDefault();
				// Show contextmenu
				if ($(event.target).is("a")) {
					delete_nodename = $(event.target).parent().attr('nodename'); //R281-T94-00 (10.1.7.36)
					delete_ip = $(event.target).parent().attr('id'); //10_1_7_36
					for(var i=0; i<3; i++)
						delete_ip = delete_ip.replace("_",".");

					$("#RightClickMenu").finish().toggle(100).
			
				// In the right position (the mouse)
				css({
					top: event.pageY + "px",
					left: event.pageX + "px"
				});
				}
			});

			// If the document is clicked somewhere
			$(document).bind("mousedown", function (e) {
				if (!$(e.target).parents("#Side_Bar_NodeList").length > 0) {  
					$("#RightClickMenu").hide(100);
				}
			});

			// If the menu element is clicked
			$("#RightClickMenu li").click(function(){
				switch($(this).attr("data-action")) {
					case "Delete_Node": 
						if(!confirm(delete_nodename + "  delete the node?")) {
							$("#RightClickMenu").hide(100);
						}
						else {
							deleteNodeFromNodeList();
						}
						break;
				}
				
				$("#RightClickMenu").hide(100);
			
			});

			/* Brian 2019/10/28: Delete node from the node list. */
			function deleteNodeFromNodeList() {
				$.ajax({
					url: 'deleteNodeFromNodeList',
					data: "ip=" + delete_ip,
					dataType: 'json',

					success: function(_data) {
						if(_data.status == "OK") {
							alert("Successfully delete the node:  " + delete_nodename);
							window.location.href = "./GSM";
						}
						else
							alert("Failed to delete the node:  " + delete_nodename);
					},
					
					error: function(xhr, status, error) {
						console.log("Delete node from node list failed: [" + xhr.status + "] " + xhr.statusText);
					},
			
					cache: false,
					contentType: false,
					processData: false
				});
			}
		</script>
	</body>
</html>
