<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="x" uri="http://java.sun.com/jsp/jstl/xml" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<!-- William 2018/12/18: Obtain log data from the database in batches. -->
<html>
<head>
	<title>GSM Event Log</title>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	
	<!-- CSS-->
	<link href="<c:url value="/resources/css/bootstrap/dataTables.bootstrap.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/dataTables.responsive.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/bootstrap.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/metisMenu.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/sb-admin.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/font-awesome/css/font-awesome.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/style_2016.css" />" rel="stylesheet">
	
	<!-- Javascript -->
	<script src="<c:url value="/resources/js/bootstrap/jquery.js" />"></script>
	<script src="<c:url value="/resources/js/bootstrap/bootstrap.min.js" />"></script>
	<script src="<c:url value="/resources/js/bootstrap/jquery.dataTables.min.js"/>"></script>
	<script src="<c:url value="/resources/js/bootstrap/dataTables.bootstrap.min.js"/>"></script>
	<script src="<c:url value="/resources/js/gsm_date.js"/>"></script>
</head>

<body>
	<div id="wrapper">
		<div id="page-wrapper">
			<div class="container-fluid">
            	<br>
				<div class="row">
					<div class="col-lg-12">
						<div class="panel panel-default">
							<div class="panel-heading">
								<sec:authorize access="hasAnyRole(${Access_LogsRW})"><button type="submit" onclick="clickedClear()" class="btn btn-primary"><spring:message code="Clear"/></button></sec:authorize>
								<button type="submit" onclick="clickedDownload()" class="btn btn-primary"><spring:message code="Download"/></button>
							</div>
							<!-- /.panel-heading -->
							<div class="panel-body">
								<div class="dataTable_wrapper">
									<table class="table table-striped table-bordered table-hover" id="dataTables">
										<thead>
											<tr >
												<th><spring:message code="Timestamp"/></th>
												<th><spring:message code="Level"/></th>
												<th><spring:message code="Description"/></th>
											</tr>
										</thead>
										<tbody>
										</tbody>
									</table>
								</div>
							</div>
							<!-- /.panel-body -->
						</div>
						<!-- /.panel -->
					</div>
					<!-- /.col-lg-12 -->
				</div>
				
				<div class="row">
					<div class="col-lg-12">
						<div class="panel panel-default">
							<div class="panel-heading">
								<spring:message code="UserActionLog"/>
							</div>
							<div class="panel-body">
								<div class="dataTable_wrapper">
									<table class="table table-striped table-bordered table-hover" id="userActionLogTables">
										<thead>
											<tr >
												<th><spring:message code="Number"/></th>
												<th><spring:message code="Timestamp"/></th>
												<th><spring:message code="userName"/></th>
												<th><spring:message code="ClientIP"/></th>
												<th><spring:message code="Action"/></th>
												<th><spring:message code="Description"/></th>
												<th><spring:message code="Result"/></th>
											</tr>
										</thead>
										<tbody>
										</tbody>
									</table>
								</div>
							</div>
							<div class="panel-footer">
								<button type="submit" onclick="clickedDownload2()" class="btn btn-primary"><spring:message code="Download"/></button>
							</div>
						</div>
						<!-- /.panel -->
					</div>
					<!-- /.col-lg-12 -->
				</div>
				<!-- /.row -->
			</div>
			<!-- /.container-fluid -->
		</div>
		<!-- /.page-wrapper -->
	</div>
	<!-- /#page-wrapper -->
	
	<!-- Page-Level Demo Scripts - Tables - Use for reference -->
	<script>
		
		var userActionLogTables;
		var dataTables;
		$(document).ready(function() {

			var errCode = '${errCode}';
			if( errCode != 0 )
				alert("<spring:message code="webErrMsg${errCode}"/>");
			
			dataTables = $('#dataTables').DataTable({
				"scrollX": true,
				"order": [[ 0, "desc" ]],
				language: {
					"emptyTable": <spring:message code="DataTable1"/>,
					"processing": <spring:message code="DataTable2"/>,
					"loadingRecords": <spring:message code="DataTable3"/>,
					"lengthMenu": <spring:message code="DataTable4"/>,
					"zeroRecords": <spring:message code="DataTable5"/>,
					"info": <spring:message code="DataTable6"/>,
					"infoEmpty": <spring:message code="DataTable7"/>,
					"infoFiltered": <spring:message code="DataTable8"/>,
					"infoPostFix": <spring:message code="DataTable9"/>,
					"search": <spring:message code="DataTable10"/>,
					"paginate": {
						"first": <spring:message code="DataTable11"/>,
						"previous": <spring:message code="DataTable12"/>,
						"next": <spring:message code="DataTable13"/>,
						"last": <spring:message code="DataTable14"/>
					},
					"aria": {
						"sortAscending": <spring:message code="DataTable15"/>,
						"sortDescending": <spring:message code="DataTable16"/>
					}
				}
			});
			
			userActionLogTables = $('#userActionLogTables').DataTable({
				"scrollX": true,
				"order": [[ 0, "desc" ]],
				language: {
					"emptyTable": <spring:message code="DataTable1"/>,
					"processing": <spring:message code="DataTable2"/>,
					"loadingRecords": <spring:message code="DataTable3"/>,
					"lengthMenu": <spring:message code="DataTable4"/>,
					"zeroRecords": <spring:message code="DataTable5"/>,
					"info": <spring:message code="DataTable6"/>,
					"infoEmpty": <spring:message code="DataTable7"/>,
					"infoFiltered": <spring:message code="DataTable8"/>,
					"infoPostFix": <spring:message code="DataTable9"/>,
					"search": <spring:message code="DataTable10"/>,
					"paginate": {
						"first": <spring:message code="DataTable11"/>,
						"previous": <spring:message code="DataTable12"/>,
						"next": <spring:message code="DataTable13"/>,
						"last": <spring:message code="DataTable14"/>
					},
					"aria": {
						"sortAscending": <spring:message code="DataTable15"/>,
						"sortDescending": <spring:message code="DataTable16"/>
					}
				}
			});
			
			getEventLog(true);
			getActionLog(true);
		});
		
		var eventLogIndex = 0;
		var eventLogLength = 50;
		function getEventLog(first)
		{
			if(first) {
				eventLogLoading(true);
			}
			
			$.ajax({
		        url: 'getEventLog',
		        data: {dataIndex:eventLogIndex, dataLength:eventLogLength},
		        dataType: 'json',
		        success: function(_data, status, xhr) {
		        	_data.eventLogList = JSON.parse(_data.eventLogList);
		        	
		        	if(_data.eventLogList.length > 0) {
		        		var logArray = [];
		        		for(var i=0 ; i<_data.eventLogList.length ; i++) {
			        		logArray.push([formatDate(new Date(_data.eventLogList[i].Timestamp["$date"]), _data.timestampFormat),
			    		        		   _data.eventLogList[i].Level,
			    		        		   _data.eventLogList[i].Description]);
			        	}
			        	eventLogLoading(false, logArray);
			        	
		        		eventLogIndex += eventLogLength;
		        		setTimeout(getEventLog, 50);
		        	}
		        	else {
		        		eventLogLoading(false);
		        	}
		        },
		        error: function(xhr, status, error) {
		        	eventLogLoading(false);
		        	console.log("Get the GSM event log failed: [" + xhr.status + "] " + xhr.statusText);
		        },
			    cache: false
		    });
		}
		
		var actionLogIndex = 0;
		var actionLogLength = 50;
		var actionLogNumber = 0;
		function getActionLog(first)
		{
			if(first) {
				actionLogLoading(true);
			}
			
			$.ajax({
		        url: 'getActionLog',
		        data: {dataIndex:actionLogIndex, dataLength:actionLogLength},
		        dataType: 'json',
		        success: function(_data, status, xhr) {
		        	_data.actionLogList = JSON.parse(_data.actionLogList);
		        	
		        	if(_data.actionLogList.length > 0) {
		        		var logArray = [];
		        		for(var i=0 ; i<_data.actionLogList.length ; i++) {
			        		logArray.push([actionLogNumber++,
			        			           formatDate(new Date(_data.actionLogList[i].Timestamp["$date"]), _data.timestampFormat),
			    		        		   _data.actionLogList[i].Username,
			    		        		   _data.actionLogList[i].ClientIP,
			    		        		   _data.actionLogList[i].Action,
			    		        		   _data.actionLogList[i].Description,
			    		        		   _data.actionLogList[i].Result]);
			        	}
			        	actionLogLoading(false, logArray);
			        	
		        		actionLogIndex += actionLogLength;
		        		setTimeout(getActionLog, 50);
		        	}
		        	else {
		        		actionLogLoading(false);
		        	}
		        },
		        error: function(xhr, status, error) {
		        	actionLogLoading(false);
		        	console.log("Get the user action's log failed: [" + xhr.status + "] " + xhr.statusText);
		        },
			    cache: false
		    });
		}
		
		function eventLogLoading(start, dataArray)
		{
			if(start) {
				$("#dataTables>tbody").html("<tr><td colspan='4' style='text-align: center; padding-left:8px;'><i class='fa fa-circle-o-notch fa-spin fa-2x fa-fw'></i></td><td style='display:none;'></td><td style='display:none;'></td><td style='display:none;'></td><td style='display:none;'></td></tr>");
			}
			else {
				setTimeout(function(){
					if($("#dataTables>tbody>tr>td").attr("colspan") == 4)
						dataTables.clear().draw(false);
					if(dataArray != null)
						dataTables.rows.add(dataArray).draw(false);
				}, 100);
			}
		}
		
		function actionLogLoading(start, dataArray)
		{
			if(start) {
				$("#userActionLogTables>tbody").html("<tr><td colspan='4' style='text-align: center; padding-left:8px;'><i class='fa fa-circle-o-notch fa-spin fa-2x fa-fw'></i></td><td style='display:none;'></td><td style='display:none;'></td><td style='display:none;'></td><td style='display:none;'></td></tr>");
			}
			else {
				setTimeout(function(){
					if($("#userActionLogTables>tbody>tr>td").attr("colspan") == 4)
						userActionLogTables.clear().draw(false);
					if(dataArray != null)
						userActionLogTables.rows.add(dataArray).draw(false);
				}, 100);
			}
		}
		
		function clickedClear() {
			window.location.href = "./ClearGSMLog";
		}
		
		function clickedDownload() {
			window.location.href = "./NodeEventLog_DownloadLog?Type=GSM";
		}
		
		function clickedDownload2() {
			window.location.href = "./UserActionLog_Download";
		}
	</script>
</body>
</html>