<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
	<title>Manual</title>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	
	<!-- CSS -->
	<link href="<c:url value="/resources/css/bootstrap/bootstrap.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/metisMenu.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/sb-admin.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/font-awesome/css/font-awesome.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/style_2016.css" />" rel="stylesheet">
	
	<!-- Java Script -->
	<script src="<c:url value="/resources/js/bootstrap/jquery.min.js" />"></script>
	<script src="<c:url value="/resources/js/bootstrap/bootstrap.min.js" />"></script>
</head>

<body>
	<div id="wrapper">
		<div id="page-wrapper">
			<div class="container-fluid">
				<br>
								
				<div class="row">
					<div class="col-lg-12">
						<div class="panel panel-default">
							<div class="list-group-item active">
								<h4><spring:message code="Version"/>:&nbsp;&nbsp;<spring:message code="ProjectName"/></h4>
							</div>
						</div>
						<!-- /.panel panel-default -->
					</div>
					<!-- /.col-lg-12 -->
				</div>
				
				<div class="row">
					<div class="col-lg-12">
						<div class="panel panel-default">
							<div class="panel-heading">
								<h4><spring:message code="Menu"/>&nbsp;<spring:message code="Description"/></h4>
							</div>
							
							<div class="panel-body">
								<ul id="helpMenuUL" class="nav nav-tabs" style="max-width:100%">
									
								</ul>
								<div class="panel-heading" style="text-align: center;">
									<h2><b id="helpMenuTitle"></b></h2>
								</div>
								<div class="tab-content">
									<iframe id="helpMenuIframe" class="gsmiframe" frameborder="0" onload="resizeIframe(this)" style="height: 0px;"></iframe>
								</div>
							</div>
						</div>
					</div>
				</div>
				
				<div class="row">
					<div class="col-lg-12">
						<div class="panel panel-default">
							<div class="panel-heading">
								<h4><spring:message code="helpMainMsg5"/></h4>
							</div><!-- /.panel-heading -->
							<div class="panel-body">
								<div class="dataTable_wrapper">
									&nbsp;&nbsp;&nbsp;&nbsp;-  System Processor: 2 GHZ and above <br>
									&nbsp;&nbsp;&nbsp;&nbsp;-  System Memory: Minimum 4 GB RAM <br>
									&nbsp;&nbsp;&nbsp;&nbsp;-  Free Disk Space: 1000 GB at least <br>
									&nbsp;&nbsp;&nbsp;&nbsp;-  Node Servers : 255 maximum
								</div>
							</div>
						</div>
					</div>
				</div>
				
				<div class="row">
					<div class="col-lg-12">
						<div class="panel panel-default">
							<div class="panel-heading">
								<h4><spring:message code="helpMainMsg6"/></h4>
							</div><!-- /.panel-heading -->
							<div class="panel-body">
								<div class="dataTable_wrapper">
									&nbsp;&nbsp;&nbsp;&nbsp;Browser:<br>
									&nbsp;&nbsp;&nbsp;&nbsp;-  Internet Explorer 9 or later <br>
									&nbsp;&nbsp;&nbsp;&nbsp;-  Google Chrome 39.0.2171.65 m or later<br>
									&nbsp;&nbsp;&nbsp;&nbsp;-  Mozilla Firefox 33.1.1 or later<br><br>
									&nbsp;&nbsp;&nbsp;&nbsp;Operating System:<br>
									&nbsp;&nbsp;&nbsp;&nbsp;-  Windows 2008 & 2012 R2 or later<br>
									&nbsp;&nbsp;&nbsp;&nbsp;-  Redhat/CentOS 6.3 or later<br>
									&nbsp;&nbsp;&nbsp;&nbsp;-  Ubuntu 16.04 or later<br>
								</div>
							</div>
						</div>
					</div>
				</div>
				
				<div class="row">
					<div class="col-lg-12">
						<div class="panel panel-default">
							<div class="panel-heading">
								<h4><spring:message code="mainMenu6-2"/> <spring:message code="List"/></h4>
							</div>
							<!-- /.panel-heading -->
							<table class="table table-striped table-bordered table-hover">
								<tbody>
									<tr><td> Apache Tomcat</td><td><a href="#" data-toggle="modal" data-target="#AL20">Apache License 2.0</a></td></tr>
									<tr><td> Ini4j</td><td><a href="#" data-toggle="modal" data-target="#AL20">Apache License 2.0</a></td></tr>
									<tr><td> Log4j</td><td><a href="#" data-toggle="modal" data-target="#AL20">Apache License 2.0</a></td></tr>
									<tr><td> Spring</td><td><a href="#" data-toggle="modal" data-target="#AL20">Apache License 2.0</a></td></tr>
									<tr><td> TFTP</td><td><a href="#" data-toggle="modal" data-target="#AL20">Apache License 2.0</a></td></tr>
									<tr><td> VXIPMI</td><td><a href="#" data-toggle="modal" data-target="#GPL">GPL License</a></td></tr>
									<tr><td> JFreeChart</td><td><a href="#" data-toggle="modal" data-target="#GLGP">LGPL license</a></td></tr>
									<tr><td> Bootstrap</td><td><a href="#" data-toggle="modal" data-target="#MIT">MIT License</a></td></tr>
									<tr><td> Flot</td><td><a href="#" data-toggle="modal" data-target="#MIT">MIT License</a></td></tr>
									<tr><td> JQuery</td><td><a href="#" data-toggle="modal" data-target="#MIT">MIT License</a></td></tr>
									<tr><td> PostgreSQL</td><td><a href="#" data-toggle="modal" data-target="#PSQL">PostgreSQL License</a></td></tr>
								</tbody>
							</table>
						</div>
						<!-- /.panel panel-default -->
					</div>
					<!-- /.col-lg-12 -->
				</div>
				
			</div><!-- /.container-fluid -->
		</div><!-- /.page-wrapper -->
	</div><!-- /#page-wrapper -->
	
	
	<div style="color:black" class="modal fade" id="AL20" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
		<div class="modal-dialog" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title" id="myModalLabel"> Apache License 2.0</h4>
				</div>
				
				<div class="modal-body">
				<p>
					Copyright (c) 2015 GIGA-BYTE<br><br>
					
					Licensed under the Apache License, Version 2.0 (the "License");<br>
					you may not use this file except in compliance with the License.<br>
					You may obtain a copy of the License at<br><br>
					
					&nbsp;&nbsp;&nbsp;&nbsp;http://www.apache.org/licenses/LICENSE-2.0<br><br>
					
					Unless required by applicable law or agreed to in writing, software distributed under the<br>
					License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS<br>
					OF ANY KIND, either express or implied. See the License for the specific language<br>
					governing permissions and limitations under the License.<br>
				</p>
				</div>
				
				<div class="modal-footer">
					<button type="button" class="btn btn-primary" data-dismiss="modal"><spring:message code="Close"/></button>
				</div>
			</div>
		</div>
	</div>
	
	<div style="color:black" class="modal fade" id="PSQL" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
		<div class="modal-dialog" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title" id="myModalLabel"> PostgreSQL License</h4>
				</div>
				
				<div class="modal-body">
				<p>
					Copyright (c) 2015 GIGA-BYTE<br><br>
					
					Permission to use, copy, modify, and distribute this software and its documentation for<br>
					any purpose, without fee, and without a written agreement is hereby granted, provided<br>
					that the above copyright notice and this paragraph and the following two paragraphs<br>
					appear in all copies.<br><br>
					
					IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY<br>
					FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,<br>
					INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE AND<br>
					ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF CALIFORNIA HAS BEEN<br>
					ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.<br><br>
					
					GIGA-BYTE SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT<br>
					LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR<br>
					A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON AN<br>
					"AS IS" BASIS, AND GIGA-BYTE HAS NO OBLIGATIONS TO PROVIDE MAINTENANCE,<br>
					SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.<br>
				</p>
				</div>
				
				<div class="modal-footer">
					<button type="button" class="btn btn-primary" data-dismiss="modal"><spring:message code="Close"/></button>
				</div>
			</div>
		</div>
	</div>
	
	<div style="color:black" class="modal fade" id="MIT" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
		<div class="modal-dialog" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title" id="myModalLabel"> MIT License</h4>
				</div>
				
				<div class="modal-body">
				<p>
					Copyright (c) 2015 GIGA-BYTE<br><br>
					
					Permission is hereby granted, free of charge, to any person obtaining a copy of this<br>
					software and associated documentation files (the "Software"), to deal in the Software<br>
					without restriction, including without limitation the rights to use, copy, modify, merge,<br>
					publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to<br>
					whom the Software is furnished to do so, subject to the following conditions:<br><br>
					
					The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.<br><br>
					
					THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,<br>
					EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF<br>
					MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND<br>
					NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT<br>
					HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER<br>
					IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR<br>
					IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.<br>
				</p>
				</div>
				
				<div class="modal-footer">
					<button type="button" class="btn btn-primary" data-dismiss="modal"><spring:message code="Close"/></button>
				</div>
			</div>
		</div>
	</div>
	
	<div style="color:black" class="modal fade" id="GLGP" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
		<div class="modal-dialog" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title" id="myModalLabel"> LGPL License</h4>
				</div>
				
				<div class="modal-body">
				<p>
					Copyright (c) 2015 GIGA-BYTE<br><br>
					
					This library is free software; you can redistribute it and/or<br>
					modify it under the terms of the GNU Lesser General Public<br>
					License as published by the Free Software Foundation; either<br>
					version 2.1 of the License, or (at your option) any later version.<br><br>
					
					This library is distributed in the hope that it will be useful,<br>
					but WITHOUT ANY WARRANTY; without even the implied warranty of<br>
					MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU<br>
					Lesser General Public License for more details.<br><br>
					
					You should have received a copy of the GNU Lesser General Public<br>
					License along with this library; if not, write to the Free Software<br>
					Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA<br>
				</p>
				</div>
				
				<div class="modal-footer">
					<button type="button" class="btn btn-primary" data-dismiss="modal"><spring:message code="Close"/></button>
				</div>
			</div>
		</div>
	</div>
	
	<div style="color:black" class="modal fade" id="GPL" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
		<div class="modal-dialog" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title" id="myModalLabel"> GPL License</h4>
				</div>
				
				<div class="modal-body">
				<p>
					Copyright (c) 2015 GIGA-BYTE<br><br>
					
					This program is free software: you can redistribute it and/or modify<br>
					it under the terms of the GNU General Public License as published by<br>
					the Free Software Foundation, either version 3 of the License, or<br>
					(at your option) any later version.<br><br>
					
					This program is distributed in the hope that it will be useful,<br>
					but WITHOUT ANY WARRANTY; without even the implied warranty of<br>
					MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the<br>
					GNU General Public License for more details.<br><br>
					
					You should have received a copy of the GNU General Public License<br>
					along with this program.  If not, see &lt;http://www.gnu.org/licenses/&gt;.<br>
				</p>
				</div>
				
				<div class="modal-footer">
					<button type="button" class="btn btn-primary" data-dismiss="modal"><spring:message code="Close"/></button>
				</div>
			</div>
		</div>
	</div>
</body>

<script>
	/**
	 * Name: item name (show in page)
	 * Link: item page name (xxx.jsp)
	 */
	var helpMenuList = [
		{"Name" : '<spring:message code="nav1"/>', "Link" : 
			[{"Name" : '<spring:message code="Description"/>', "Link" : "HelpNode"}, 
			 {"Name" : '<spring:message code="helpMenuNodeFilter"/>', "Link" : "HelpNodeFilter"}, 
			 {"Name" : '<spring:message code="helpMenuNodeDetail"/>', "Link" : "HelpNodeDetail"}, 
			 {"Name" : '<spring:message code="helpMenuNodeRemote"/>', "Link" : "HelpNodeRemote"}, 
			 {"Name" : '<spring:message code="helpMenuNodeSearch"/>', "Link" : "HelpNodeSearch"}]},
		{"Name" : '<spring:message code="nav2"/>', "Link" : [{"Name" : '<spring:message code="Description"/>', "Link" : "HelpGroup"}, {"Name" : '<spring:message code="helpMenuGroupCreate"/>', "Link" : "HelpGroupCreate"}]},
		{"Name" : '<spring:message code="nav8"/>', "Link" : "HelpDeployment"},
		{"Name" : '<spring:message code="nav3"/>', "Link" : "HelpAlert"},
		{"Name" : '<spring:message code="nav4"/>', "Link" : "HelpAccount"},
		{"Name" : '<spring:message code="nav6"/>', "Link" : "HelpPreference"}
	];
	
	function initHelpMenu()
	{
		$("#helpMenuUL").append(createHelpMenuHtmlString(helpMenuList));
	}
	
	function createHelpMenuHtmlString(obj)
	{
		var htmlString = "";
		
		if(isArray(obj)) {
			for(var i=0 ; i<obj.length ; i++) {
				if(isArray(obj[i].Link) || isObject(obj[i].Link)) {
					htmlString += '<li class="dropdown">'
							   +     '<a class="dropdown-toggle" data-toggle="dropdown" href="#">' + obj[i].Name + '<span class="caret"></span></a>'
							   +     '<ul class="dropdown-menu">';
					htmlString +=       createHelpMenuHtmlString(obj[i].Link);
					htmlString +=    '</ul>'
							   +  '</li>';
				}
				else {
					htmlString += createHelpMenuHtmlString(obj[i]);
				}
			}
		}
		else if(isObject(obj)) {
			htmlString = '<li><a data-toggle="tab" href="" link=' + obj.Link + '>' + obj.Name + '</a></li>';
		}
		
		return htmlString;
	}
	
	$("#helpMenuUL").delegate("a[data-toggle='tab']", "click", function() {
		$("#helpMenuTitle").html($(this).text());
		$("#helpMenuIframe").attr('src', "./" + $(this).attr("link"));
	});
	
	function isArray(obj)
	{
		if(checkType(obj) === 'array')
			return true;
		else
			return false;
	}
	
	function isObject(obj)
	{
		if(checkType(obj) === 'object')
			return true;
		else
			return false;
	}
	
	function checkType(obj)
	{
		if(typeof(obj) === 'object') {
			if($.isArray(obj))
				return 'array';
			else
				return 'object';
		}
		
		return typeof(obj);
	}
	
	function resizeIframe(iframe)
	{
		if(($(iframe).attr("src") == null) || ($(iframe).attr("src") === ""))
			return;
		
		iframe.style.height = '0px'; //set to default
		iframe.style.height = (iframe.contentWindow.document.body.scrollHeight * 1.01) + 'px'; // * 1.01 adjust to the appropriate height
	}
	
	$(document).ready(function() {
		initHelpMenu();
	});
	
	 $('#helpMenuIframe').on("load", function() {
		 var urlArray = document.getElementById("helpMenuIframe").contentWindow.location.href.split("/");
		 var url = urlArray[urlArray.length - 1];
		 
		 //Link to page from another page instead of link from select option list
		 if(($("#helpMenuUL").find("li.dropdown.active").length > 0) && !$("#helpMenuUL").find("li.dropdown.active").find("a[link='" + url + "']").parent().hasClass("active")) {
			 $("#helpMenuUL").find("li.dropdown.active").find("li.active").removeClass("active");
			 $("#helpMenuUL").find("li.dropdown.active").find("a[link='" + url + "']").parent().addClass("active");
			 $("#helpMenuTitle").html($("#helpMenuUL").find("li.dropdown.active").find("a[link='" + url + "']").text());
			 window.scrollTo(0, 0);
		 }
	 });
</script>
</html>