<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="x" uri="http://java.sun.com/jsp/jstl/xml" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
	<link rel="shortcut icon" href="https://www.gigabyte.com/Images/favicon_b.ico" type="image/x-icon" />
	<head>
		<title>GSM menu</title>
	    <meta charset="utf-8">
	    <meta name="viewport" content="width=device-width, initial-scale=1.0">
		
	    <!-- css -->
		<link href="<c:url value="/resources/css/bootstrap/dataTables.bootstrap.css" />" rel="stylesheet">
		<link href="<c:url value="/resources/css/bootstrap/dataTables.responsive.css" />" rel="stylesheet">
	    <link href="<c:url value="/resources/css/bootstrap/bootstrap.css" />" rel="stylesheet" >
		<link href="<c:url value="/resources/css/font-awesome/css/font-awesome.min.css" />" rel="stylesheet" >
	    <link href="<c:url value="/resources/css/bootstrap/style_2016.css" />" rel="stylesheet" >
		<style>
			.h-bold {
				font-weight: 600;
			    font-size: 38px;
			    font-family: 'Roboto', sans-serif;
			    margin: 0 0 30px;
			}
			
			h5 {
				color: white;
			    font-weight: 700;
			    font-size: 18px;
			    font-family: 'Roboto', sans-serif;
			    margin: 20px 0px 10px 0px;
			}
			
			.container-fluid>.row {
			    margin-right: 0px;
			    margin-left: 0px;
			    color: white;
			}
			
		    .box{width:30%; float:left;}
		    .zone{width:100%; height:100%;}
		    
		    body {background-image:none; background-color:black; overflow-x:auto;}
		    .dashboard-header {min-width:1024px; height:79px;}
		    .dashboard-header table {width:100%; height:100%;}
		    .dashboard-header a {padding:0 !important; height:25px; margin:0px 0px 0px 27px;}
		    .dashboard-header img {margin:0px;}
		    .home-section.color-dark {padding-top:30px; padding-bottom:50px;}
		    .container-fluid {min-width:1280px;}
		    .container-fluid>.row {margin-bottom:40px; width:100%;}
		    .h-bold {color:white;}
		    .animatedParent {width:50%;}
		    .animatedParent.right {float:right;}
		    .animatedParent.left {float:left;}
		    h5 {text-transform: none !important;}
		    canvas {margin: 0px auto;}
		    
		    .chart-legend {margin-top:10px; font-size:12px;}
		    .chart-legend>div {display:inline-block; text-align:left; margin-left:10px; margin-right:10px;}
		    .now-data {border-style: solid;}
		    .before-data {border-style: dotted;}
		    .chart-legend.line span {padding: 8px 8px 0px 0px; border-width: 2px; font-size: 0px;}
		    .chart-legend.pie span {padding: 10px 10px 0px 0px; border-width: 1px; border-style: solid; font-size: 0px;}
		    .chart-legend.pie {margin-top: 20px;}
		    .chart-legend.pie>div {margin-left:20px; margin-right:20px;}
		    .status-icon-1 {background-color: #E60012;}
		    .status-icon-2 {background-color: #FDD000;}
		    .status-icon-3 {background-color: #666464;}
		    .status-icon-4 {background-color: #67B72E;}
		    .status-icon-0 {background-color: #231815;}
		    
			#task_modal>.modal-dialog {
 				margin-top: 5% !important;
 				width: 70%;
			}
			#task_modalBody>ul.nav-tabs {
 				margin-bottom: 20px;
			}
	    </style>
	</head>
		
	<body>
		<div class="dashboard-header">
			<table border="0">
				<tr>
					<td class="topbar-logo">
						<a class="navbar-brand" rel="home" href="GSM" title="Gigabyte">
	                		<img src="/GSM/GSMLogo_Get/gsm_logo.png">
	                	</a>
					</td>
				</tr>
			</table>
		</div>
		
		<!-- Section: services -->
	    <div class="home-section color-dark">
			<div class="container-fluid">
				
				<div class="row">
					<div class="col-lg-8 col-lg-offset-2">
						<div class="text-center">
							<h1 class="h-bold">GSM <spring:message code="navside1"/></h1>
						</div>
					</div>
				</div>
				
				<div class="row">
					<div class="animatedParent left">
						<div class="row text-center" >
							<div class="service-desc">
								<h5><spring:message code="mainMenu7-1"/></h5>
								<br>
									<div id="canvas-holder">
										<canvas id="chart-node-status" width="640" height="230"> </canvas>
										<div class="chart-legend pie">
											<div>
												<div><span class="status-icon-1"></span>&nbsp;&nbsp;<spring:message code="FilterList6"/></div>
												<div><span class="status-icon-3"></span>&nbsp;&nbsp;<spring:message code="FilterList8"/></div>
											</div>
											<div>
												<div><span class="status-icon-2"></span>&nbsp;&nbsp;<spring:message code="FilterList7"/></div>
												<div><span class="status-icon-0"></span>&nbsp;&nbsp;<spring:message code="FilterList22"/></div>
											</div>
											<div>
												<div><span class="status-icon-4"></span>&nbsp;&nbsp;<spring:message code="FilterList9"/></div>
												<div>&nbsp;</div>
											</div>
										</div>
									</div>
								<!-- /.hidden-xs -->
							</div>
							<!-- /.service-desc -->
				        </div>
						<!-- /.row text-center -->
					</div>
					<!-- /.animatedParent -->
					
					<div class="animatedParent right">
						<div class="row text-center" >
							<div class="service-desc">
								<h5><spring:message code="NodeDetail7"/></h5>
								<br>
									<div id="canvas-holder">
										<canvas id="chart-power-consumption" width="640" height="230"> </canvas>
									</div>
									<div class="chart-legend pie">
										<div id="data_1">
											<div><span class="now-data" style="background-color:rgb(151,187,205); color:rgb(151,187,205);"></span>&nbsp;&nbsp;<spring:message code="mainMenu8"/></div>
										</div>
										<div id="data_2">
											<div><span class="now-data" style="background-color:rgb(220,220,220); color:rgb(220,220,220);"></span>&nbsp;&nbsp;<spring:message code="mainMenu9"/></div>
										</div>
									</div>
								<!-- /.hidden-xs -->
							</div>
							<!-- /.service-desc -->
				        </div>
						<!-- /.row text-center -->
					</div>
					<!-- /.animatedParent -->
				</div>
				
				<div class="row">
					<div class="col-lg-8 col-lg-offset-2">
						<div class="text-center">
							<div class="service-desc">
								<h5><spring:message code="NodeDetail17"/></h5>
								<br>
									<div id="canvas-holder">
										<canvas id="chart-service-task" width="640" height="230"> </canvas>
									</div>
									<div class="chart-legend pie">
										<div id="data_1">
											<div><span class="now-data" style="background-color:rgb(205, 152, 152); color:rgb(205, 152, 152);"></span>&nbsp;&nbsp;<spring:message code="mainMenu12"/></div>
										</div>
										<div id="data_2">
											<div><span class="now-data" style="background-color:rgb(220,220,220); color:rgb(220,220,220);"></span>&nbsp;&nbsp;<spring:message code="mainMenu13"/></div>
										</div>
										<div id="data_3">
											<div><span class="now-data" style="background-color:rgb(151,187,205); color:rgb(151,187,205);"></span>&nbsp;&nbsp;<spring:message code="mainMenu14"/></div>
										</div>
									</div>
								<!-- /.hidden-xs -->
							</div>
							<!-- /.service-desc -->
						</div>
					</div>
				</div>
				
			</div>
			<!-- /.container-fluid -->
		</div>
		<!-- /.home-section color-dark -->
		
		<div class="modal fade" id="task_modal" tabindex="-1" role="dialog">
			<div class="modal-dialog" role="document">
				<div class="modal-content">
					<div class="modal-header">
						<button type="button" class="close" data-dismiss="modal">&times;</button>
						<h4 class="modal-title"><spring:message code="NodeDetail17"/> <spring:message code="Information"/></h4>
					</div>
					<div id="task_modalBody" class="modal-body">
					    <ul class="nav nav-tabs" role="tablist">
					    </ul>
					    <div class="tab-content">
					    </div>
					</div>
				</div>
			</div>
		</div>
		
	    <!-- Core JavaScript Files -->
	    <script src="<c:url value="/resources/js/bootstrap/jquery.min.js" />"></script>	 
	    <script src="<c:url value="/resources/js/bootstrap/bootstrap.min.js" />"></script>
		<script src="<c:url value="/resources/js/Chart.bundle.min.js" />"></script>
		<script src="<c:url value="/resources/js/bootstrap/jquery.dataTables.min.js"/>"></script>
		<script src="<c:url value="/resources/js/bootstrap/dataTables.bootstrap.min.js"/>"></script>
		<script src="<c:url value="/resources/js/gsm_main.js" />"></script>
		
		<script>
			var updateInterval = 3 * 60 * 1000;
			var lineColor = ["rgb(151,187,205)", "rgb(220,220,220)"];
			var taskColor = "rgb(205, 152, 152)";
			
			//Node Status Chart
			var nodeStatusChart;
			var nodeStatusConfig = {
			    type: 'pie',
			    data: {
			        datasets: [{
			            data: [],
			            backgroundColor: [
			                "#E60012",
			                "#FDD000",
			                "#666464",
			                "#67B72E",
			                "#231815"
			            ],
				        hoverBackgroundColor: [
	      		        	"#ff808a",
	      		        	"#ffe880",
	      		        	"#c0bfbf",
	      		        	"#b9e699",
	      		        	"#cfb6af"
	      		        ],
	      		      	hoverBorderWidth: [
	      		      		0,
		      		      	0,
		      		      	0,
		      		    	0,
		      		    	0
	      		        ]
			        }],
			        labels: [
			            "<spring:message code="FilterList6"/>",
			            "<spring:message code="FilterList7"/>",
			            "<spring:message code="FilterList8"/>",
			            "<spring:message code="FilterList9"/>",
			            "<spring:message code="FilterList22"/>"
			        ]
			    },
			    options: {
			        responsive: false,
			        tooltips: {
		                enabled: true,
		            },
			        legend: {
	                	display: false,
			        	labels: {
			                fontColor: 'white',
			                fontSize: 13,
			                padding: 40
			            },
			            position: 'bottom',
			            onClick: function(event, legendItem) {
			            	setGSMDefaultPage("Filter", nodeStatusConfig.data.labels[obj[0]._index]);
			            }
			        },
			        animation: {
			            animateScale: true,
			            animateRotate: true,
			        },
			        onClick: function(event, obj) {
			        	if(obj.length > 0) {
			        		setGSMDefaultPage("Filter", nodeStatusConfig.data.labels[obj[0]._index]);
			        	}
		            }
			    }
			};
			
	        //Power Consumption Chart
	        var powerConsumptionChart;
	        var powerConsumptionConfig = {
	            type: 'horizontalBar',
	            data: {
	                labels: [],
	                datasets: [{
	    				label: '<spring:message code="mainMenu8"/>',
	    				backgroundColor: lineColor[0],
	    				data: []
	    			},
	    			{
	    				label: '<spring:message code="mainMenu9"/>',
	    				backgroundColor: lineColor[1],
	    				data: []
	    			}]
	            },
	            options: {
	                responsive: false,
	                legend: {
	                    display: false,
	                    position: 'bottom',
	                },
	                title: {
	                    display: false,
	                    text: ''
	                },
	                scales: {
	                    xAxes: [{
	                        display: true,
	                        scaleLabel: {
	                            display: true,
	                            labelString: '<spring:message code="mainMenu10"/>',
	                            fontColor: 'white',
	                        },
	                        ticks: {
	    		                fontColor: 'white',
	                            suggestedMin: 0,
	                            suggestedMax: 1,
	                        }
	                    }],
	                    yAxes: [{
	                        display: true,
	                        scaleLabel: {
	                            display: true,
	                            labelString: '<spring:message code="NodeDetail15"/>'+'(IP)',
	                            fontColor: 'white',
	                        },
	                        ticks: {
	    		                fontColor: 'white',
	    		            }
	                    }]
	                },
			        onClick: function(event, lineObj) {
			        	if(lineObj.length > 0) {
			        		setGSMDefaultPage("Power", powerConsumptionConfig.data.labels[lineObj[0]._index]);
			        	}
		            }
	            }
	        };
			
	        //Servie Task Chart
	        var taskData = []; //The task data from controller
	        var taskDataTableObj = {}; //The task data table object (key: service name, value: DataTable)
	        var serviceTaskChart;
	        var serviceTaskConfig = {
	            type: 'horizontalBar',
	            data: {
	                labels: [],
	                datasets: [{
	    				label: 'Active Threads',
	    				backgroundColor: taskColor,
	    				data: []
	    			},
	    			{
	    				label: 'Completed Threads',
	    				backgroundColor: lineColor[1],
	    				data: []
	    			}]
	            },
	            options: {
	                responsive: false,
	                legend: {
	                    display: false,
	                    position: 'bottom',
	                },
	                tooltips: {
	                	callbacks: {
		                	title: function(tooltipItem, data) {
		                		var dataIndex = tooltipItem[0]['index'];
			                	return data['labels'][dataIndex];
		                	},
		                	label: function(tooltipItem, data) {
		                		//Only show one data in label, and use correct color same with the bar
		                		if(parseInt(tooltipItem.value) === 0)
		                			return;
								
		                		var datasetIndex = tooltipItem.datasetIndex;
		                		var dataIndex    = tooltipItem.index;
		                		var labelArray = [];
		                		if(taskData[dataIndex].name == "SNMP Server")
		                			labelArray = ["(<spring:message code='mainMenu16'/>)"];
		                		else if(taskData.length > 0)
			                		labelArray = ["<spring:message code='mainMenu15'/>: " + taskData[dataIndex].totalThread,
			                					  "<spring:message code='mainMenu12'/>: " + taskData[dataIndex].activeThread,
			                					  "<spring:message code='mainMenu13'/>: " + taskData[dataIndex].completeThread,
			                					  "<spring:message code='Success'/>: " + taskData[dataIndex].successThread,
			                					  "<spring:message code='Failed'/>: " + taskData[dataIndex].failedThread];
		                		return labelArray;
		                	}
	                	}
	                },
	                title: {
	                    display: false,
	                    text: ''
	                },
	                scales: {
	                    xAxes: [{
	                        display: true,
	                        scaleLabel: {
	                            display: true,
	                            labelString: '<spring:message code="mainMenu17"/>',
	                            fontColor: 'white',
	                        },
	                        ticks: {
	    		                fontColor: 'white',
	                            suggestedMin: 0,
	                            suggestedMax: 1,
	                        }
	                    }],
	                    yAxes: [{
	                        display: true,
	                        scaleLabel: {
	                            display: true,
	                            labelString: '<spring:message code="mainMenu18"/>',
	                            fontColor: 'white',
	                        },
	                        ticks: {
	    		                fontColor: 'white',
	    		            }
	                    }]
	                },
			        onClick: function(event, lineObj) {
			        	if(lineObj.length > 0) {
			        		getServiceTaskDetail(taskData[lineObj[0]._index].name);
				        	$('#task_modalBody>ul.nav-tabs>li>a[href="#tab_' + taskData[lineObj[0]._index].name.replace(/\s/g, '') + '"]').tab('show');
			        	}
			        	else {
			        		getServiceTaskDetail(taskData[0].name);
				        	$('#task_modalBody>ul.nav-tabs>li:eq(0)>a').tab('show');
			        	}
			        	
			        	$('#task_modal').modal("show");
		            }
	            }
	        };
			
	        $(document).ready(function() {
				checkBrowser();
				
			    nodeStatusChart = new Chart(document.getElementById("chart-node-status").getContext("2d"), nodeStatusConfig);
			    powerConsumptionChart = new Chart(document.getElementById("chart-power-consumption").getContext("2d"), powerConsumptionConfig);
			    serviceTaskChart = new Chart(document.getElementById("chart-service-task").getContext("2d"), serviceTaskConfig);
				
			    getNodeStatusData();
			    getPowerConsumptionData();
			    getServiceTaskData();
			    
			    //Different color for resident service
			    Chart.pluginService.register({
		        	beforeUpdate: function(chartInstance) {
		        		if(chartInstance.id == 2) {
				        	chartInstance.data.datasets.forEach(function(dataset) {
				        		if(dataset.label == "Active Threads") {
						        	dataset.backgroundColor = chartInstance.data.labels.map(function(label) {
						        		if((label == "SNMP Server"))
						        			return lineColor[0];
						        		else
						        			return taskColor;
						        	});
				        		}
				        	});
		        		}
		        	}
		        });
			});
			
			function getNodeStatusData() {
				$.ajax({
					url: 'getChartNodeStatus',
					dataType: 'json',
					cache: false,
					success: function(_data, status, xhr) {
						var powerOffData;
						
						//When not any node in GSM Server, default set value of 1 to show the pie chart.
						if((_data.Critical == 0)
							&& (_data.NonCritical == 0)
							&& (_data.Unknown == 0)
							&& (_data.Health == 0)
							&& (_data.NoConnection == 0)) {
							powerOffData = 1;
							nodeStatusConfig.options.tooltips.enabled = false;
						}
						else {
							powerOffData = _data.NoConnection;
							nodeStatusConfig.options.tooltips.enabled = true;
						}
						
						nodeStatusConfig.data.datasets[0].data = [_data.Critical, _data.NonCritical, _data.Unknown, _data.Health, powerOffData];
						
						nodeStatusChart.update();
						
						setTimeout(getNodeStatusData, updateInterval);
					},
					error: function(xhr, status, error) {
			        	console.log("Get the node status data of chart failed: [" + xhr.status + "] " + xhr.statusText);
					}
				});
			}
			
			function getPowerConsumptionData() {
				$.ajax({
					url: 'getChartPowerConsumption',
					dataType: 'json',
					cache: false,
					success: function(_data, status, xhr) {
						var nowNodeNum = _data.NodeNum;
						
						powerConsumptionConfig.data.datasets[0].data = [];
						powerConsumptionConfig.data.datasets[1].data = [];
						powerConsumptionConfig.data.labels = [];
						
						for(var i=0 ; i<nowNodeNum ; i++) {
							//Node IP
							powerConsumptionConfig.data.labels.push(_data.Node[i]);
							
							//Now Data
							powerConsumptionConfig.data.datasets[0].data.push(_data.Power[i]);
							
							//24h before Data
							powerConsumptionConfig.data.datasets[1].data.push(_data.Power[(i+parseInt(nowNodeNum))]);
						}
						
						powerConsumptionChart.update();
						
						setTimeout(getPowerConsumptionData, updateInterval);
					},
					error: function(xhr, status, error) {
			        	console.log("Get the power consumption data of chart failed: [" + xhr.status + "] " + xhr.statusText);
					}
				});
			}
			
			function getServiceTaskData() {
				$.ajax({
					url: 'getChartServiceTask',
					dataType: 'json',
					cache: false,
					success: function(_data, status, xhr) {
						taskData = _data;
						
						serviceTaskConfig.data.datasets[0].data = [];
						serviceTaskConfig.data.datasets[1].data = [];
						serviceTaskConfig.data.labels = [];
						
						for(var i=0 ; i<_data.length ; i++) {
							//Service name
							serviceTaskConfig.data.labels.push(_data[i].name);
							
							//Active threads
							serviceTaskConfig.data.datasets[0].data.push(_data[i].activeThread);
							
							//Completed threads
							serviceTaskConfig.data.datasets[1].data.push(_data[i].completeThread);
							
							//Service task detail
							if(!(_data[i].name in taskDataTableObj)) {
								var serviceID = _data[i].name.replace(/\s/g, ''); //remove space from service name
								var tabID = "tab_" + serviceID;
								var dataTableID = "dataTables_" + serviceID;
								
								$("#task_modalBody>ul.nav-tabs").append("<li role=\"presentation\"" + ((i == 0) ? " class=\"active\"" : "") + "><a href=\"#" + tabID + "\" aria-controls=\"" + _data[i].name + "\" role=\"tab\" data-toggle=\"tab\">" + _data[i].name + "</a></li>");
								$("#task_modalBody>div.tab-content").append("<div role=\"tabpanel\" class=\"tab-pane " + ((i == 0) ? "active" : "") + "\" id=\"" + tabID + "\">" + 
																			"	<table id=\"" + dataTableID + "\" class=\"table table-striped table-bordered table-hover\">" + 
																			"		<thead>" + 
																			"			<tr>" + 
																			"				<th>" + '<spring:message code="mainMenu17"/>' + ' ' + '<spring:message code="NodeVmcli14"/>' + "</th>" + 
																			"				<th>" + '<spring:message code="mainMenu12"/>' + "</th>" + 
																			"				<th>" + '<spring:message code="Status"/>' + "</th>" + 
																			"				<th>" + '<spring:message code="StartTime"/>' + "</th>" + 
																			"				<th>" + '<spring:message code="EndTime"/>' + "</th>" + 
																			"				<th>" + '<spring:message code="Information"/>' + "</th>" + 
																			"			</tr>" + 
																			"		</thead>" + 
																			"		<tbody>" + 
																			"		</tbody>" + 
																			"	</table>" + 
																	        "</div>");
								
								taskDataTableObj[_data[i].name] = $('#' + dataTableID).DataTable({
																		"aaSorting": [[ 1, "desc" ]],
																		"pagingType": "full_numbers",
																		"responsive": true,
																		"createdRow": function(row, data, dataIndex) {
															                if(data[1] == "Running") {
															                    $(row).css({
															                    	"background-color": "rgb(255, 179, 179)",
															                    	"font-weight": "bold"
															                    });
															                }
															            }
									        						});
								
								//getServiceTaskDetail(_data[i].name);
							}
						}
						
						serviceTaskChart.update();
						
						setTimeout(getServiceTaskData, 5000);
					},
					error: function(xhr, status, error) {
			        	console.log("Get the service task data of chart failed: [" + xhr.status + "] " + xhr.statusText);
					}
				});
			}
			
			//Update the service detail when click
			$('#task_modalBody>ul.nav-tabs').delegate('a[data-toggle="tab"]', 'show.bs.tab', function (e) {
				getServiceTaskDetail($(e.target).text());
			});
			
			function getServiceTaskDetail(serviceName) {
				serviceDetailLoading(serviceName, true);
				
				$.ajax({
					url: 'getServiceTaskDetail',
    			    data: {serviceName: serviceName},
					dataType: 'json',
					cache: false,
					success: function(_data, status, xhr) {
						var taskArray = [];
						for(var i=0 ; i<_data.length ; i++) {
							taskArray.push([_data[i].type, 
											(_data[i].isStart ? (_data[i].isComplete ? "Completed" : "Running") : "-"), 
											(_data[i].isComplete ? (_data[i].isSuccess ? "Success" : "Fail") : "-"), 
											(_data[i].isStart ? _data[i].startTime : "-"), 
											(_data[i].isComplete ? _data[i].endTime : "-"), 
											_data[i].statusMsg]);
						}
						
						serviceDetailLoading(serviceName, false, taskArray);
					},
					error: function(xhr, status, error) {
						serviceDetailLoading(serviceName, false);
			        	console.log("Get the service task detail data failed: [" + xhr.status + "] " + xhr.statusText);
					}
				});
			}
			
			function serviceDetailLoading(serviceName, start, dataArray) {
				if(start) {
					$("#dataTables_" + serviceName.replace(/\s/g, '') + ">tbody").html("<tr><td colspan='6' style='text-align: center; padding-left:8px !important;'><i class='fa fa-circle-o-notch fa-spin fa-2x fa-fw'></i></td></tr>");
				}
				else {
					setTimeout(function(){
						taskDataTableObj[serviceName].clear().draw(false);
						if(dataArray != null)
							taskDataTableObj[serviceName].rows.add(dataArray).draw(false);
					}, 100);
				}
			}
			
			function setGSMDefaultPage(key, value) {
				$.ajax({
				    url: 'setGSMDefaultPage',
			        type: 'POST',
				    data: {
				    	key:key,
				    	value:value
					},
				    dataType: 'json',
				    success: function(_data, status, xhr) {
				    	window.location.href = "./GSM";
				    },
					error: function(xhr, status, error) {
			        	console.log("Set the GSM default page failed: [" + xhr.status + "] " + xhr.statusText);
					},
				    cache: false
				});
			}
		</script>
	</body>
</html>
