<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="x" uri="http://java.sun.com/jsp/jstl/xml" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
	<title>Node Event Log</title>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	
	<!-- CSS -->
	<link href="<c:url value="/resources/css/bootstrap/dataTables.bootstrap.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/dataTables.responsive.css" />" rel="stylesheet">
    <link href="<c:url value="/resources/css/bootstrap/bootstrap.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/metisMenu.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/sb-admin.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/font-awesome/css/font-awesome.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/style_2016.css" />" rel="stylesheet">
	
	<!-- Javascript -->
	<script src="<c:url value="/resources/js/bootstrap/jquery.js" />"></script>
	<script src="<c:url value="/resources/js/bootstrap/bootstrap.min.js" />"></script>
	<script src="<c:url value="/resources/js/bootstrap/jquery.dataTables.min.js"/>"></script>
	<script src="<c:url value="/resources/js/bootstrap/dataTables.bootstrap.min.js"/>"></script>
</head>

<body>
	<div id="wrapper">
		<div id="page-wrapper">
			<div class="container-fluid">
				<!-- Page Heading -->
				<div class="row page-title">
                    <div class="col-lg-12">
                        <h3 class="page-header">
                            <A onclick='window.open("https://${IP}", "_blank", "scrollbars=yes,resizable=yes,top=300,left=500,width=800,height=600")'> ${IP} </A>
                        </h3>
                    </div>
                </div>
				<!-- /.row -->
				<br>
				
				<!-- Node SEL -->
				<div class="row">
				   	<div class="col-lg-12">
				   		<div class="panel panel-default">
							<div class="panel-heading">
								<div class="row">
									<div class="col-sm-4">
										<div class="dataTables_length">
											<h4 style="display:inline-block; color: #666;">Node SEL</h4>
											&nbsp;&nbsp;
											<!-- <button type="submit" onclick="refreshSEL()" class="btn btn-primary"><spring:message code="Refresh"/></button> -->
											<sec:authorize access="hasAnyRole(${Access_LogsRW})">
											<button type="submit" id="clearBtn" onclick="clearSEL()" class="btn btn-primary" disabled><spring:message code="Clear"/></button>
											</sec:authorize>
											<button type="submit" id="downloadBtn" onclick="downloadSEL()" class="btn btn-primary" disabled><spring:message code="Download"/></button>
										</div>
									</div>
									<div class="col-sm-8">
										<div class="dataTables_filter">
											<h4 style="display:inline-block; color: #666;"><spring:message code="NodeEventLogFilter1"/>:</h4>
											<select id="sel_severity_filter" disabled>
												<option id="event_severity_default" value="" selected="selected"><spring:message code="NodeEventLogFilter1-1"/></option>
												<option id="event_severity_unknown" value="unknown"><spring:message code="NodeEventLogFilter1-2"/></option>
												<option id="event_severity_normal" value="normal"><spring:message code="NodeEventLogFilter1-4"/></option>
												<option id="event_severity_warning" value="warning"><spring:message code="NodeEventLogFilter1-5"/></option>
												<option id="event_severity_critical" value="critical"><spring:message code="NodeEventLogFilter1-6"/></option>
											</select>
											<h4 style="display:inline-block; color: #666;"><spring:message code="NodeEventLogFilter2"/>:</h4>
											<select id="sel_event_dir_filter" disabled>
												<option id="event_dir_default" value="" selected="selected"><spring:message code="NodeEventLogFilter2-1"/></option>
												<option id="event_dir_assertion" value="Assertion"><spring:message code="NodeEventLogFilter2-2"/></option>
												<option id="event_dir_deassertion" value="Deassertion"><spring:message code="NodeEventLogFilter2-3"/></option>
											</select>
											<h4 style="display:inline-block; color: #666;"><spring:message code="NodeEventLogFilter3"/>:</h4>
											<select id="sel_sensor_type_filter" disabled>
												<option id="sensor_type_default" value="" selected="selected"><spring:message code="NodeEventLogFilter3-1"/></option>
												<option id="sensor_type_temperature" value="Temperature"><spring:message code="NodeEventLogFilter3-2"/></option>
												<option id="sensor_type_voltage" value="Voltage"><spring:message code="NodeEventLogFilter3-3"/></option>
												<option id="sensor_type_fan" value="Fan"><spring:message code="NodeEventLogFilter3-4"/></option>
												<option id="sensor_type_processor" value="Processor"><spring:message code="NodeEventLogFilter3-5"/></option>
												<option id="sensor_type_memory" value="Memory"><spring:message code="NodeEventLogFilter3-6"/></option>
												<option id="sensor_type_sysevent" value="System Event"><spring:message code="NodeEventLogFilter3-7"/></option>
												<option id="sensor_type_lan" value="LAN"><spring:message code="NodeEventLogFilter3-8"/></option>
											</select>
										</div>
									</div>
								</div>
							</div>
							<!-- /.panel-heading -->
							<div class="panel-body" >
								<table class="table table-striped table-bordered table-hover" id="selDataTables">
									<thead>
										<tr>
											<th style="display:none">Record ID</th>
											<th style="width:1%"></th>
											<th style="width:1%"></th>
											<th style="width:10%"><spring:message code="Source"/></th>
											<th style="width:20%"><spring:message code="TimeStamp"/></th>
											<th><spring:message code="Description"/></th>
											<th style="display:none"><spring:message code="Sensornumber"/></th>
											<th style="display:none"><spring:message code="Eventdir"/></th>
											<th style="display:none"><spring:message code="Sensortype"/></th>
											<th style="display:none">Raw data</th>
											<th style="display:none">RGB</th>
											<th style="display:none">Severity</th>
										</tr>
									</thead>
									<tbody>
									</tbody>
								</table>
							</div>
							<!-- /.panel-body -->
						</div>
						<!-- /.panel -->
					</div>
					<!-- /.col-lg-12 -->
				</div>
				<!-- /.row -->
				<!-- Node SEL -->
				
				<!-- Node Log -->
				<!-- Node Log -->
			</div>
			<!-- /.container-fluid -->
		</div>
		<!-- /#page-wrapper -->
	</div>
	<!-- /#wrapper -->
	
	<script>
		var nodeSelListTable;
		
		/* Node SEL */
		$(document).ready(function() {
	    	nodeSelListTable = $('#selDataTables').DataTable({
				"aoColumns": [null,
							  { "bSortable": false },
							  { "bSortable": false },
							  null,
							  null,
							  null,
		              		  null,
		              		  null,
		              		  null,
		              		  null,
		              		  null,
		              		  null],
				"responsive": true,
			    "createdRow": function(row, data, dataIndex) {
			    	$(row).find('td:eq(0)').css("display", "none");
			    	if(!checkRedfishInterface())
			    		$(row).find('td:eq(1)').addClass("details-control fa fa-plus-circle");
			    	
			    	var imageName = "sevUnknown";
			    	switch (data[11].toLowerCase()) {
	    		    	case 'information':
	    		    		imageName = "sevInformational";
	    		    		break;
	    		    	case 'normal':
	    		    		imageName = "sevNormal";
	    		    		break;
	    		    	case 'warning':
	    		    		imageName = "sevWarning";
	    		    		break;
	    		    	case 'critical':
	    		    		imageName = "sevCritical";
	    		    		break;
	    		    	case 'nonrecoverable':
	    		    		imageName = "sevNon-Recoverable";
	    		    		break;
	    		    	case 'ok':
	    		    		imageName = "sevNormal";
	    		    		break;
	    		    }
		    		$(row).find('td:eq(2)').html('<img src="/GSM/resources/img/Icon_Sel_Severity/' + imageName + '.gif" style="padding-top: 3px;">');
		    		
			    	$(row).find('td:eq(6)').css("display", "none");
			    	$(row).find('td:eq(7)').css("display", "none");
			    	$(row).find('td:eq(8)').css("display", "none");
			    	$(row).find('td:eq(9)').css("display", "none");
			    	$(row).find('td:eq(10)').css("display", "none");
			    	$(row).find('td:eq(11)').css("display", "none");
			    	if(data[11].toLowerCase() === "critical")
			    		$(row).css("color", "red");
			    },
			    language: {
					"emptyTable": <spring:message code="DataTable1"/>,
					"processing": <spring:message code="DataTable2"/>,
					"loadingRecords": <spring:message code="DataTable3"/>,
					"lengthMenu": <spring:message code="DataTable4"/>,
					"zeroRecords": <spring:message code="DataTable5"/>,
					"info": <spring:message code="DataTable6"/>,
					"infoEmpty": <spring:message code="DataTable7"/>,
					"infoFiltered": <spring:message code="DataTable8"/>,
					"infoPostFix": <spring:message code="DataTable9"/>,
					"search": <spring:message code="DataTable10"/>,
					"paginate": {
						"first": <spring:message code="DataTable11"/>,
						"previous": <spring:message code="DataTable12"/>,
						"next": <spring:message code="DataTable13"/>,
						"last": <spring:message code="DataTable14"/>
					},
					"aria": {
						"sortAscending": <spring:message code="DataTable15"/>,
						"sortDescending": <spring:message code="DataTable16"/>
					}
				}
			});
	    	
			if("${IP}" != "")
				getNodeSEL("${IP}");

			$("#sel_sensor_type_filter").on("change", function() {
				SensorTypeFilter();
			});

			$("#sel_event_dir_filter").on("change", function() {
				EventDirFilter();
			});

			$("#sel_severity_filter").on("change", function() {
				SeverityFilter();
			});
		});
    	
    	$('#selDataTables tbody').delegate('td.details-control', 'click', function() {
	    	if(checkRedfishInterface()) {
	    		alert("Redfish interface not support SEL raw data.");
	    		return;
	    	}
	    	
	        var tr = $(this).closest('tr');
	        var row = nodeSelListTable.row(tr);
	        
	        if(row.child.isShown()) {
	            row.child.hide();
	            $(this).removeClass('fa fa-minus-circle');
	            $(this).addClass('fa fa-plus-circle');
	        }
	        else {
	            row.child(format(row.data())).show();
	            $(this).removeClass('fa fa-plus-circle');
	            $(this).addClass('fa fa-minus-circle');
	        }
	    });
		
		function getNodeSEL(ip)
		{
	    	nodeSelLoading(true);
	    	
			$.ajax({
				url: 'getNodeSEL',
			    data: {IP:ip},
			    dataType: 'json',
			    success: function(_data, status, xhr) {
					if(_data.isConn) {
				    	var selArray = [];
				    	for(var i=0 ; i<_data.NodeSEL.sel.length ; i++) {
				    		selArray.push([_data.NodeSEL.sel[i].RecordID, 
	                			    	   "", 
	                			    	   "", 
	                			    	   _data.NodeSEL.sel[i].Source, 
	                			    	   _data.NodeSEL.sel[i].Timestamp, 
	                			    	   _data.NodeSEL.sel[i].Summary, 
	                			    	   _data.NodeSEL.sel[i].SensorNumber, 
	                			    	   _data.NodeSEL.sel[i].EventDir, 
	                			    	   _data.NodeSEL.sel[i].SensorType, 
	                			    	   _data.NodeSEL.sel[i].RawData, 
	                			    	   (_data.NodeSEL.sel[i].Severity.toLowerCase() === 'critical') ? 'red' : 'initial', 
	                			    	   _data.NodeSEL.sel[i].Severity]);
					    }
				    	
				    	nodeSelLoading(false, selArray);
				    	
						$("#sel_event_dir_filter").prop("disabled", false);
						$("#sel_sensor_type_filter").prop("disabled", false);
						$("#sel_severity_filter").prop("disabled", false);
			    		$("#clearBtn").prop("disabled", false);
				    	$("#downloadBtn").prop("disabled", false);
			    	}
					else {
						$("#selDataTables>tbody").html("<tr><td colspan='12' style='text-align: center; padding-left:8px !important;'>No connection</td></tr>");
					}
			    },
			    error: function(xhr, status, error) {
			    	nodeSelLoading(false);
			    	console.log("Loading SEL failed: [" + xhr.status + "] " + xhr.statusText);
				},
			    cache: false
			});
		}
		
		function nodeSelLoading(start, dataArray)
		{
			if(start) {
				$("#selDataTables>tbody").html("<tr><td colspan='12' style='text-align: center; padding-left:8px !important;'><i class='fa fa-circle-o-notch fa-spin fa-2x fa-fw'></i></td></tr>");
			}
			else {
				setTimeout(function(){
					if($("#selDataTables>tbody>tr>td").attr("colspan") == 12)
						nodeSelListTable.clear().draw(false);
					if(dataArray != null)
						nodeSelListTable.rows.add(dataArray).draw(false);
				}, 100);
			}
		}
		
		/*function refreshSEL()
		{
			window.location.href = "./NodeEventLog_GetSEL?IP=" + '${IP}';
		}*/
		
		function clearSEL()
		{
			window.location.href = "./NodeEventLog_ClearSEL?IP=" + '${IP}';
		}
		
		function downloadSEL()
		{
			window.location.href = "./NodeEventLog_DownloadSEL?IP=" + '${IP}';
		}
		
		function format( d )
		{
		    // `d` is the original data object for the row
		    return '<table cellpadding="5" cellspacing="0" border="0" style="padding-left:50px;">'+
		        '<tr style="color:' + d[10] +'">'+
		            '<td>Raw data:&nbsp;&nbsp;</td>'+
		            '<td>' + d[9] + '</td>'+
		        '</tr>'+
		    '</table>';
		}
		
		function SensorTypeFilter()
		{
			$("#selDataTables thead th").each( function(i) {
				if ($(this).text() !== '') {
					var isEventDirColumn = (($(this).text() == "<spring:message code="Sensortype"/>") ? true : false);
					if (isEventDirColumn) {
						var table = $('#selDataTables').DataTable();
						table.columns(i).every( function() {
							if(this.search() !== $("#sel_sensor_type_filter").val()){
								this.search($("#sel_sensor_type_filter").val()).draw();
							}
						});
					}
				}
			});
		}
		
		function EventDirFilter()
		{
			$("#selDataTables thead th").each( function(i) {
				if ($(this).text() !== '') {
					var isEventDirColumn = (($(this).text() == "<spring:message code="Eventdir"/>") ? true : false);
					if (isEventDirColumn) {
						var table = $('#selDataTables').DataTable();
						table.columns(i).every( function() {
							if(this.search() !== $("#sel_event_dir_filter").val()){
								this.search($("#sel_event_dir_filter").val(), false, true, false).draw();
							}
						});
					}
				}
			});
		}
		
		function SeverityFilter()
		{
			$("#selDataTables thead th").each( function(i) {
				if ($(this).text() !== '') {
					var isSeverityColumn = (($(this).text() == 'Severity') ? true : false);
					if (isSeverityColumn) {
						var table = $('#selDataTables').DataTable();
						table.columns(i).every( function() {
							if(this.search() !== $("#sel_severity_filter").val()){
								this.search($("#sel_severity_filter").val()).draw();
							}
						});
					}
				}
			});
		}
		/* Node SEL */
		
		//Check the Redfish interface and block not support feature.
		function checkRedfishInterface()
		{
			if((parent.connectionInterface == "Redfish") || (parent.connectionInterface == "Auto") && ("${RedfishSupport}" == "true"))
				return true;
			else
				return false;
		}
	</script>
</body>
</html>