<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="x" uri="http://java.sun.com/jsp/jstl/xml" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<!-- William 2019/01/07: Make the New Network Time Protocol display the loading circle screen first, and load the data at the same time. -->
<html>
<head>
	<title>Node Remote Access</title>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	
	<style type="text/css">
		.progress-circle {
    		margin-top: 260px !important;
			width: 95px !important;
		}
		.alert {
			margin-bottom: 0px !important;
		}
		.modal-content.success {
			background-color: #dff0d8;
			color: #449d44;
		}
		.modal-content.fail {
			background-color: #f2dede;
			color: #d9534f;
		}
		.modal_msg .modal-title {
			font-weight: bold;
		}
		.modal_msg .modal-header {
			padding: 15px 15px 5px 15px;
			border-bottom: none;
		}
		.modal_msg .modal-body {
			padding: 5px 15px;
		}
	    .btn-file {
		    position: relative;
		    overflow: hidden;
		}
		.btn-file input[type=file] {
		    position: absolute;
		    top: 0;
		    right: 0;
		    min-width: 100%;
		    min-height: 100%;
		    font-size: 100px;
		    text-align: right;
		    filter: alpha(opacity=0);
		    opacity: 0;
		    outline: none;
		    background: white;
		    cursor: inherit;
		    display: block;
		}
		input[readonly] {
		  background-color: white !important;
		  cursor: text !important;
		}
	</style>
	
	<!-- CSS -->
    <link href="<c:url value="/resources/css/bootstrap/bootstrap.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/metisMenu.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/sb-admin.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/font-awesome/css/font-awesome.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/style_2016.css" />" rel="stylesheet">
	
	<!-- Javascript -->
	<script src="<c:url value="/resources/js/bootstrap/jquery.js" />"></script>
	<script src="<c:url value="/resources/js/bootstrap/bootstrap.min.js" />"></script>
	<script src="<c:url value="/resources/js/bootstrap/scripts.js" />"></script>
	<script src="<c:url value="/resources/js/bootstrap/password.js" />"></script>
</head>

<body>
	<div id="wrapper">
		<div id="page-wrapper">
			<div class="container-fluid">
				<!-- Page Heading -->
				<div class="row page-title">
                    <div class="col-lg-12">
                        <h3 class="page-header">
                            <A onclick='window.open("https://${IP}", "_blank", "scrollbars=yes,resizable=yes,top=300,left=500,width=800,height=600")'> ${IP} </A>
                        </h3>
                    </div>
                </div>
				<br>
				
				<!-- Power Status -->
				<div id="NodePowerStatus" class="row">
					<div class="col-lg-12">
						<div class="panel panel-default">
							<div class="panel-body">
								<h4><spring:message code="Nodelist5"/>: <span id="statusStr">Reading...</span></h4>
							</div>
						</div>
					</div>
				</div>
				<!-- Power Status -->
				
				<!-- Power Control -->
				<sec:authorize access="hasAnyRole(${Access_PowerControl})">
				<div class="row">
					<div id="PowerControl" class="col-lg-12">
						<div class="panel panel-default">
							<div class="panel-heading">
								<h4><spring:message code="NodeChassis1"/></h4>
							</div>
							<div class="panel-body">
								<div id="powerCtrl" class="btn-toolbar" sytle="margin: auto;" role="toolbar" aria-label="...">
									<div id="PowerBtn" class="btn-group" role="group" aria-label="Power on">
										<button type="button" onclick="setPower(this.getAttribute('option'))" option="1" class="btn btn-success" data-toggle="tooltip" data-placement="top" title="Power on" disabled>
											<i class="fa fa-power-off fa-5x" aria-hidden="true"></i>
										</button>
									</div>
									<div id="PowerCycle" class="btn-group" role="group" aria-label="Power cycle">
										<button type="button" onclick="setPower(this.getAttribute('option'))" option="2" class="btn btn-warning" data-toggle="tooltip" data-placement="top" title="Power cycle" disabled>
											<i class="fa fa-repeat fa-5x" aria-hidden="true"></i>
										</button>
									</div>
									<div id="HardReset" class="btn-group" role="group" aria-label="Hard reset">
										<button type="button" onclick="setPower(this.getAttribute('option'))" option="3" class="btn btn-primary" data-toggle="tooltip" data-placement="top" title="Hard reset" disabled>
											<i class="fa fa-refresh fa-5x" aria-hidden="true"></i>
										</button>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				</sec:authorize>
				<!-- Power Control -->
				
				<!-- Chassis Identify -->
				<sec:authorize access="hasAnyRole(${Access_Configuration})">
				<div class="row">
					<div id="ChassisIdentify" class="col-lg-12">
						<div class="panel panel-default">
							<div class="panel-heading">
								<h4><spring:message code="NodeChassis2"/></h4>
							</div>
							<div class="panel-body">
								<spring:message code="NodeChassis3"/>
								<select id="Seconds">
									<c:forEach var="i" begin="0" end="255">
										<option value="${i}"> ${i} </option>
									</c:forEach>
									<option value="256"> <spring:message code="NodeChassis5"/> </option>
								</select>
								<spring:message code="NodeChassis4"/>
								<button onclick="setIdentify()" class="btn btn-primary"><spring:message code="Submit"/></button>
							</div>
						</div>
					</div>
				</div>
				</sec:authorize>
				<!-- Chassis Identify -->
				
				<!-- Boot option -->
				<sec:authorize access="hasAnyRole(${Access_Configuration})">
				<div class="row">
					<div id="BootOption" class="col-lg-12">
						<div class="panel panel-default">
							<div class="panel-heading">
								<h4 style="display:inline-block;"><spring:message code="NodeChassis6"/></h4>
								&nbsp;&nbsp;
								<select id="BootMode">
									<option> Legacy </option>
									<option> UEFI </option>
								</select>
							</div>
							<div class="panel-body">
								<div id="powerCtrl" class="btn-toolbar" sytle="margin: auto;" role="toolbar" aria-label="...">
									<div class="btn-group" role="group" aria-label="pxe">
										<button type="button" onclick="setBootOption(this.getAttribute('boot-type'))" boot-type="pxe" class="btn btn-primary" data-toggle="tooltip" data-placement="top" title="pxe">
											<spring:message code="BootOption2"/>
										</button>&nbsp;&nbsp;
									</div>
									<div class="btn-group" role="group" aria-label="disk">
										<button type="button" onclick="setBootOption(this.getAttribute('boot-type'))" boot-type="disk" class="btn btn-primary" data-toggle="tooltip" data-placement="top" title="disk">
											<spring:message code="BootOption3"/>
										</button>&nbsp;&nbsp;
									</div>
									<div class="btn-group" role="group" aria-label="cdrom">
										<button type="button" onclick="setBootOption(this.getAttribute('boot-type'))" boot-type="cdrom" class="btn btn-primary" data-toggle="tooltip" data-placement="top" title="cdrom">
											<spring:message code="BootOption6"/>
										</button>&nbsp;&nbsp;
									</div>
									<div class="btn-group" role="group" aria-label="bios">
										<button type="button" onclick="setBootOption(this.getAttribute('boot-type'))" boot-type="bios" class="btn btn-primary" data-toggle="tooltip" data-placement="top" title="bios">
											<spring:message code="BootOption7"/>
										</button>&nbsp;&nbsp;
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				</sec:authorize>
				<!-- Boot option -->
				
				<!-- iKVM -->
				<div class="row">
					<div id="iKVM" class="col-lg-12">
					   	<div class="panel panel-default">
					   		<div class="panel-heading">
								<h4><spring:message code="Nodelist7"/></h4>
							</div>
							<div class="panel-body">
								<button class="btn btn-primary" onclick="downloadIkvmFile()" <c:if test="${BMCConnection == false}">disabled</c:if>><spring:message code="Download"/></button>
							</div>
					  	</div> 	
					</div>
				</div>
				<!-- iKVM -->
				
				<!-- Reboot BMC -->
				<sec:authorize access="hasAnyRole(${Access_PowerControl})">
				<div class="row">
					<div id="RebootBMC" class="col-lg-12">
					   	<div class="panel panel-default">
							<div class="panel-heading">
								<h4><spring:message code="NodePEF7"/> BMC</h4>
							</div>
							<div class="panel-body">								
								<div>
									<button type="button" class="btn btn-primary" onclick="bmcUtil(this.getAttribute('option'))" option='Reboot'>
										<spring:message code="NodePEF7"/>BMC
									</button>&nbsp;&nbsp;
								</div>
							</div>
						</div>
					</div>
				</div>
				</sec:authorize>
				<!-- Reboot BMC -->
				
				<!-- Backup/Restore BMC Configure -->
				<sec:authorize access="hasAnyRole(${Access_Configuration})">
				<div class="row">
					<div id="BMCBackup" class="col-lg-12">
					   	<div class="panel panel-default">
							<div class="panel-heading">
								<h4><spring:message code="NodePEF13"/></h4>
							</div>
							<div class="panel-body">								
								<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
									<form name="formData_BMC" enctype="multipart/form-data" class="form-inline">
										<div class="well">
											<div>
												<label><spring:message code="NodePEF15"/> (<spring:message code="NodeUpdate9"/> .bin)</label>
											</div>
											<div class="form-group col-lg-10">
												<div class="input-group" style="width: 100%">
											    	<div class="btn-group" style="width: 100%">
											    	<input type="text" class="form-control" style="width: 70%" readonly>
											    	<span class="btn btn-primary btn-file">
											            <i class="fa fa-globe"></i>&nbsp;<spring:message code="Browse"/><input id="bmcRestoreFile" type="file" name="file" multiple>
											        </span>
											        <button type="button" onclick="bmcUtil(this.getAttribute('option'))" option='Restore' class="btn btn-danger" title="<spring:message code="Restore"/>">
														<i class="fa fa-upload"></i>&nbsp;<spring:message code="Restore"/>
													</button>
													<button type="button" onclick="bmcUtil(this.getAttribute('option'))" option='Backup' class="btn btn-primary" title="<spring:message code="Backup"/>">
														<i class="fa fa-download"></i>&nbsp;<spring:message code="Backup"/>
													</button>
											    	</div>
												</div>
											</div>
											<div>
												<label style="font-weight: normal"><br/></label>
											</div>
										</div>
									</form>
								</div>
							</div>
						</div>
					</div>
				</div>
				</sec:authorize>
				<!-- Backup/Restore BMC Configure -->
				
				<!-- Restore BIOS settings -->
				<sec:authorize access="hasAnyRole(${Access_Configuration})">
				<div class="row">
					<div id="RestoreBIOS" class="col-lg-12">
					   	<div class="panel panel-default">
							<div class="panel-heading">
								<h4><spring:message code="NodeChassis7"/></h4>
							</div>
							<div class="panel-body">								
								<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
									<form name="formData_BIOS_D" enctype="multipart/form-data" class="form-inline">
										<div class="well">
											<div>
												<label><spring:message code="BiosDefault4"/> (<spring:message code="NodeUpdate9"/> .log/.txt)</label>
											</div>
											<div class="form-group col-lg-10">
												<div class="input-group" style="width: 100%">
											    	<div class="btn-group" style="width: 100%">
											    	<input type="text" class="form-control" style="width: 70%" readonly>
											    	<span class="btn btn-primary btn-file">
											            <i class="fa fa-globe"></i>&nbsp;<spring:message code="Browse"/><input type="file" name="file" multiple >
											        </span>
											        <button type="button" onclick="restoreBiosDefault()" class="btn btn-danger" title="<spring:message code="Restore"/>">
														<i class="fa fa-upload"></i>&nbsp;<spring:message code="Restore"/>
													</button>
											    	</div>
												</div>
											</div>
											<div>
												<label style="font-weight: normal">
													<spring:message code="BiosDefault5"/><br/>
												</label>
												<div style="padding-left:2em">
													<label style="font-weight: normal">
														<spring:message code="BiosDefault6"/><br/>
														<spring:message code="BiosDefault7"/><br/>
													</label>
												</div>
											</div>
										</div>
									</form>
								</div>
							</div>
						</div>
					</div>
				</div>
				</sec:authorize>
				<!-- Restore BIOS settings -->
				
				<!-- Import/Export BIOS Setup information -->
				<sec:authorize access="hasAnyRole(${Access_Configuration})">
				<div class="row">
					<div id="BIOSSetup" class="col-lg-12">
					   	<div class="panel panel-default">
							<div class="panel-heading">
								<h4><spring:message code="NodeChassis8"/></h4>
							</div>
							<div class="panel-body">								
								<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
									<form name="formData_BIOS" enctype="multipart/form-data" class="form-inline">
										<div class="well">
											<div>
												<label><spring:message code="BiosDefault8"/> (<spring:message code="NodeUpdate9"/> .json)</label>
											</div>
											<div class="form-group col-lg-10">
												<div class="input-group" style="width: 100%">
											    	<div class="btn-group" style="width: 100%">
											    	<input type="text" class="form-control" style="width: 70%" readonly>
											    	<span class="btn btn-primary btn-file">
											            <i class="fa fa-globe"></i>&nbsp;<spring:message code="Browse"/><input id="biosSetupFile" type="file" name="file" multiple>
											        </span>
											        <button type="button" onclick="bmcUtil(this.getAttribute('option'))" option='BIOSimport' class="btn btn-danger" title="<spring:message code="Import"/>">
														<i class="fa fa-upload"></i>&nbsp;<spring:message code="Import"/>
													</button>
													<button type="button" onclick="bmcUtil(this.getAttribute('option'))" option='BIOSexport' class="btn btn-primary" title="<spring:message code="Export"/>">
														<i class="fa fa-download"></i>&nbsp;<spring:message code="Export"/>
													</button>
											    	</div>
												</div>
											</div>
											<div>
												<label style="font-weight: normal"><br/></label>
											</div>
										</div>
									</form>
								</div>
							</div>
						</div>
					</div>
				</div>
				</sec:authorize>
				<!-- Import/Export BIOS Setup information -->
				
				<!-- Virtual Media (Vmcli) -->
				<sec:authorize access="hasAnyRole(${Access_VirtualMedia})">
				<div class="row">
					<c:set var="xmltext">${XMLString_File}</c:set>
					<x:parse xml="${xmltext}" var="output"/>
					<div id="VirtualMedia" class="col-lg-12">
						<div class="panel panel-default">
							<div class="panel-heading">
								<h4 style="display:inline-block;"><spring:message code="navside17"/></h4>
								<x:if select="$output/NodeVmcli/conf/os != 'unix'"><small style="display:inline-block;">( <spring:message code="NodeVmcli10"/> )</small></x:if>
							</div>
							<x:if select="$output/NodeVmcli/conf/os = 'unix'">
								<div class="panel-body">
									<form id="imageFiles">
										<div>
											<div class="page-header">
												<h4 style="display:inline-block;"><spring:message code="navside26"/>:&nbsp;</h4>
												<small style="display:inline-block;"><x:out select="$output/NodeVmcli/conf/path" /></small>
											</div>
										</div>
										<div>
											<h1 class="page-header">
												<small>
													<spring:message code="navside22"/> (.iso or img)
												</small>
											</h1>
										</div>
										<div id="selectByFile" class="dataTable_wrapper">
											<table class="table table-striped table-bordered table-hover" id="tab_logic">
		                                        <thead>
		                                            <tr>
		                                                <th><spring:message code="NodeVmcli4"/></th>
		                                                <th><spring:message code="NodeVmcli5"/></th>
		                                                <th><spring:message code="NodeVmcli6"/></th>
		                                                <th><spring:message code="NodeVmcli7"/></th>
		                                            </tr>
		                                        </thead>
		                                        <tbody>
													<x:forEach select="$output/NodeVmcli/files" var="item">
														<tr>
															<td>
																<input type="checkbox" name="image_select" value="<x:out select="$item/path" />">
															</td>
															<td>
																<x:out select="$item/name" />
															</td>
															<td>
																<x:out select="$item/size" />
															</td>
															<td>
																<x:out select="$item/path" />
															</td>
														</tr>
													</x:forEach>
													
		                                        </tbody>
		                                    </table>
										</div>
										<div>
											<h1 class="page-header">
												<small>
													<spring:message code="navside21"/>
												</small>
											</h1>
										</div>
										<div id="selectByDevice" class="dataTable_wrapper_device">
											<table class="table table-striped table-bordered table-hover" id="tab_logic">
		                                        <thead>
		                                            <tr >
		                                                <th><spring:message code="NodeVmcli4"/></th>
		                                                <th><spring:message code="NodeVmcli13"/></th>
		                                                <th><spring:message code="NodeVmcli14"/></th>
		                                                <th><spring:message code="NodeVmcli15"/></th>
		                                                <th><spring:message code="NodeVmcli16"/></th>
		                                            </tr>
		                                        </thead>
		                                        <tbody>
													<c:set var="xmltext">${XMLString_Device}</c:set>
													<x:parse xml="${xmltext}" var="output"/>
													<x:forEach select="$output/DeviceList/node" var="item">
														<tr>
															<td>
																<input type="checkbox" name="device_select" value="<x:out select="$item/name" />">
															</td>
															<td>
																<x:out select="$item/name" />
															</td>
															<td>
																<x:out select="$item/type" />
															</td>
															<td>
																<x:out select="$item/size" />
															</td>
															<td>
																<x:out select="$item/model" />
															</td>
														</tr>
													</x:forEach>
		                                        </tbody>
		                                    </table>
										</div>
										<div>
											<spring:message code="NodeVmcli12"/> :
											<input type="text" id="port" value="2068" onkeyup="return ValidateNumber($(this),value)" size="6" maxlength="6">
											<br/><br/>
										</div>
										
										<div>
											<button type="button" onclick="SetVmcli('mount')" class="btn btn-primary"><i class="fa fa-fw fa-link"></i> <spring:message code="NodeVmcli2"/></button>&nbsp&nbsp
											<button type="button" onclick="SetVmcli('umount')" class="btn btn-primary"><i class="fa fa-fw fa-chain-broken"></i> <spring:message code="NodeVmcli3"/></button>
										</div>
									</form>
								</div>
							</x:if>
						</div>
					</div>
				</div>
				</sec:authorize>
				<!-- Virtual Media (Vmcli) -->
				
				<!-- NTP -->
				<sec:authorize access="hasAnyRole(${Access_Configuration})">
				<div id="NetworkTime" class="row">
					<div class="col-lg-12">
						<div class="panel panel-default">
							<div class="panel-heading" id="ntpHead">
								<h4><spring:message code="NTP"/></h4>
							</div>
							<div class="panel-body" id="ntpBody">
								<table class="table table-striped table-bordered table-condenseds">
									<tbody id="NTPsetting">
										<tr>
											<td><strong><spring:message code="OpMode"/></strong></td> 
											<td> 
												<select class="form-control" id="OperationMode">
                                                    <option value="0">Disabled</option>
													<option value="2">Requested Mode</option>
													<option value="1">Daemon Mode</option> 
												</select>
											</td>
										</tr>
										<tr>
											<td><strong><spring:message code="NTP"/>Server 1</strong></td> 
											<td>
												<input id="NTP_1" type="text" class="form-control" placeholder="xxx.xxx.xxx.xxx" value="">
											</td>
										</tr>
										<tr>
											<td><strong><spring:message code="NTP"/>Server 2</strong></td> 
											<td>
												<input id="NTP_2" type="text" class="form-control" placeholder="xxx.xxx.xxx.xxx" value="">
											</td>
										</tr>
										<tr id="NTP_3_row">
											<td><strong><spring:message code="NTP"/>Server 3</strong></td> 
											<td>
												<input id="NTP_3" type="text" class="form-control" placeholder="xxx.xxx.xxx.xxx" value="">
											</td>
										</tr>
										<tr id="freq_row">
											<td><strong><spring:message code="ReqModeUpdateFreq"/></strong></td> 
											<td>
												<!-- This input filed only for number -->
												<input id="UpdateFrequency" type="text" onkeypress='return event.charCode >= 48 && event.charCode <= 57' class="form-control" placeholder="integer" value="">
											</td>
										</tr>
										<tr id="TSMethod_row" style="display:none;">
											<td><strong><spring:message code="TimeSyncMethod"/></strong></td> 
											<td>
												<label class="radio-inline">
													<input type="radio" name="TimeSynchronizationMethod" value="1"> Step Mode
												</label>
												<label class="radio-inline">
													<input type="radio" name="TimeSynchronizationMethod" value="0"> Slew Mode
												</label>
											</td>
										</tr>
									</tbody>
								</table>
								<button type="button" class="btn btn-primary" onclick="setNTP()"><spring:message code="setting"/></button>
							</div>
						</div>
					</div>
				</div>
				</sec:authorize>
				<!-- NTP -->
				
				<!-- BMC Account -->
				<sec:authorize access="hasAnyRole(${Access_Configuration})">
				<div class="row">
					<div id="BMCAccount" class="col-lg-12">
						<div class="panel panel-default">
							<div class="panel-heading">
								<h3 class="panel-title"><spring:message code="NodeSetting9"/></h3>
							</div>
							<div class="panel-body">
								<p id= "account_notify" class="bg-info"><spring:message code="NodeSetting10"/></p>
								<!-- Knut 2017/12/25: Remove login-form for supporting blank input -->
								<form action="./SetBMCAccount" class="form-horizontal">
									<div class="form-group">
										<label for="username" class="col-sm-2 control-label"><spring:message code="userName"/></label>
										<div class="col-sm-10 col-md-4 col-lg-4">
											<label class="sr-only" for="bmcUsername"><spring:message code="userName"/></label>
				                       		<input type="text" id="bmcUsername" class="form-control form-username" name="bmcUsername" value='${bmcUsername}' placeholder=<spring:message code="userName"/>>
								    	</div>
								  	</div>
								  	<div class="form-group">
								  		<label for="password" class="col-sm-2 control-label"><spring:message code="password"/></label>
								    	<div class="col-sm-10 col-md-4 col-lg-4">
								    		<label class="sr-only" for="bmcPassword"><spring:message code="password"/></label>
				                       		<input type="password" id="bmcPassword" class="form-control form-password" name="bmcPassword" value='${bmcPassword}' placeholder=<spring:message code="password"/>>
								    	</div>
								  	</div>
									<div class="form-group">
										<input type="hidden" name="IP" value='${IP}'/>
										<div class="col-sm-10 col-md-4 col-lg-4">
											<button type="submit" class="btn btn-primary" onclick="UserAndPwd()"><spring:message code="Submit"/></button>
										</div>
									</div>
								</form>
							</div>
						</div>
					</div>
				</div>
				</sec:authorize>
				<!-- BMC Account -->
				
				<!-- Agent Account -->
				<sec:authorize access="hasAnyRole(${Access_Configuration})">
				<div class="row">
					<div id="AgentAccount" class="col-lg-12">
						<div class="panel panel-default">
							<div class="panel-heading">
								<h3 class="panel-title"><spring:message code="NodeSetting14"/></h3>
							</div>
							<div class="panel-body">
								<p class="bg-info"><spring:message code="NodeSetting15"/></p>
								<form action="./SetAgentAccount" class="form-horizontal login-form">
									<div class="form-group">
										<label for="agentUsername" class="col-sm-2 control-label"><spring:message code="userName"/></label>
										<div class="col-sm-10 col-md-4 col-lg-4">
											<label class="sr-only" for="agentUsername"><spring:message code="userName"/></label>
											<input type="text" id="agentUsername" class="form-control form-username" name="agentUsername" value='${agentUsername}' placeholder=<spring:message code="userName"/>>
										</div>
									</div>
									<div class="form-group">
										<label for="agentPassword" class="col-sm-2 control-label"><spring:message code="password"/></label>
										<div class="col-sm-10 col-md-4 col-lg-4">
											<label class="sr-only" for="agentPassword"><spring:message code="password"/></label>
											<input type="password" id="agentPassword" class="form-control form-password" name="agentPassword" value='${agentPassword}' placeholder=<spring:message code="password"/>>
										</div>
									</div>
									<div class="form-group">
										<input type="hidden" name="IP" value='${IP}'/>
										<div class="col-sm-10 col-md-4 col-lg-4">
											<button type="submit" class="btn btn-primary" onclick="UserAndPwd()"><spring:message code="Submit"/></button>
										</div>
									</div>
								</form>
							</div>
						</div>
					</div>
				</div>
				</sec:authorize>
				<!-- Agent Account -->
			</div>
		</div>
	</div>
	
	<div class="modal fade" id="modal_loading" tabindex="-1" role="dialog" data-backdrop="static" data-keyboard="false">
		<div class="modal-dialog progress-circle" role="document">
			<div class="modal-content">
				<div id="modal_loading_div" class="alert">
					<i id="modal_loading_icon" class="fa fa-circle-o-notch fa-spin fa-3x fa-fw"></i>
				</div>
			</div>
		</div>
	</div>
	
	<div class="modal fade modal_msg" id="modal_msg" tabindex="-1" role="dialog">
		<div class="modal-dialog" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					<h4 name="modal_msg_title" class="modal-title">modal title</h4>
				</div>
				<div class="modal-body">
					<p name="modal_msg_msg">modal message</p>
				</div>
			</div>
		</div>
	</div>
	
	<script>
		var checkPowerInterval = 5 * 1000; //check power status every 5 sec
		
		var setPowerControlStatus = function(status) {
			var powerStatus = "OFF";
        	var powerLabel = "Power on";
        	
        	if(status === 0x01) {
        		powerStatus = "ON";
        		powerLabel = "Power off";
			}
        	else if(status !== 0x00){
				powerStatus = "Unknown";
			}
        	
        	if(powerStatus !== $("#statusStr").text()) {
				$("#statusStr").text(powerStatus);
				$("#PowerBtn").attr("aria-label", powerLabel);
				$("#PowerBtn").find("button").attr("title", powerLabel);
				$("#PowerBtn").find("button").attr("data-original-title", powerLabel);
				
				if((powerStatus === "ON")) {
					$("#PowerBtn").find("button").attr("option", '0');
					$("#PowerBtn").find("button").removeClass("btn-success").addClass("btn-danger");
					$("#PowerBtn").find("button>i").removeClass("fa-power-off").addClass("fa-circle-o");
				}
				else {
					$("#PowerBtn").find("button").attr("option", '1');
					$("#PowerBtn").find("button").removeClass("btn-danger").addClass("btn-success");
					$("#PowerBtn").find("button>i").removeClass("fa-circle-o").addClass("fa-power-off");
				}
				
				if(powerStatus === "Unknown") {
					if(!$("#PowerBtn").find("button").prop("disabled")) {
						$("#PowerBtn").find("button").prop("disabled", true);
						$("#PowerCycle").find("button").prop("disabled", true);
						$("#HardReset").find("button").prop("disabled", true);
					}
				}
				else if($("#PowerBtn").find("button").prop("disabled")) {
					$("#PowerBtn").find("button").prop("disabled", false);
					$("#PowerCycle").find("button").prop("disabled", false);
					$("#HardReset").find("button").prop("disabled", false);
				}
        	}
		};
		
		var setPower = function(option) {
			window.location.href = "./SetPowerControl?IP=" + '${IP}' + "&Option=" + option;
		};
		
		var checkPowerStatus = function() {
			$.ajax({
		        url: 'NodeRemoteAccess_CheckPowerStatus?IP=' + "${IP}",
		        dataType: 'json',
		        success: function(_data, status, xhr) {
		        	setPowerControlStatus(_data.status);
					setTimeout(checkPowerStatus, checkPowerInterval);
		        },
		        error: function(xhr, status, error) {
		        	setPowerControlStatus(0xFF);
		        	console.log("Get the power status failed: [" + xhr.status + "] " + xhr.statusText);
		        },
			    cache: false
		    });
		};
		
		var setIdentify = function() {
			var e = document.getElementById("Seconds");
			var seconds = e.options[e.selectedIndex].value;
			window.location.href = "./SetIdentifyLED?IP=" + '${IP}' + "&Time=" + seconds;
		};
		
		/**
		* Get the random ID, default ID length is 10 bytes
		*
		* @param idLength - random string length
		*/
		var randomID = function(idLength) {
		    var id = "";
		    
		    if(!idLength)
		    	idLength = 10;
			
		    for(var i=0 ; i<idLength ; i++) {
		    	switch(Math.floor((Math.random() * 3) + 1)) {
			    	case 1:
			    		//0~9
			    		id += Math.floor((Math.random() * 10));
			    		break;
			    	case 2:
			    		//A~Z
			    		id += String.fromCharCode(Math.floor((Math.random() * 26) + 65));
			    		break;
			    	case 3:
			    		//a~z
			    		id += String.fromCharCode(Math.floor((Math.random() * 26) + 97));
			    		break;
			    }
		    }
		    
		    return id;
		};
		
		/**
		* Show the message dialog
		*
		* @param title - dialog title
		* @param msg - dialog content message
		* @param success - is success or fail, change the dialog color to green/red
		* @param delay - delay to show the dialog
		*/
		var showMsgDialog = function(title, msg, success, delay) {
			var id;
			
			if(!delay)
				delay = 0;
			
			setTimeout(function() {
				showLoadingDialog(false);
				
				id = randomID(8);
				$("body").append('<div class="modal fade modal_msg" id="' + id + '" tabindex="-1" role="dialog">' + $("#modal_msg").html() + '</div>');
				$("#" + id).find("h4[name='modal_msg_title']").text(title);
				$("#" + id).find("p[name='modal_msg_msg']").text(msg);
				
				if(success)
					$("#" + id + ">div>div").addClass("success");
				else
					$("#" + id + ">div>div").addClass("fail");
				
				$("#" + id).on("hidden.bs.modal", function() {
					$("#" + id).remove(); //Remove itself
					$("body").css("padding-right", ""); //bootstrap modal bug, show/hide too fast cause [body padding-right:21px] not be deleted
				});
				$("#" + id).modal("show");
			}, delay);
		};
		
		var setBootOption = function(type) {
			var ip = '${IP}';
			var csrfParameter= "${_csrf.parameterName}";
			var csrfToken = "${_csrf.token}";
			var formData = new FormData();
		    
			formData.append('IP', ip);
		    formData.append('Type', type);
		    formData.append('Mode', $('#BootMode').find(":selected").text());
		    
		    $.ajax({
		    	url: 'SetBootOption?'+csrfParameter+'='+csrfToken,
		        type: 'POST',
		        data: formData,
		        success: function(_data, status, xhr) {
		        	showMsgDialog("Set Boot Option", "success", "success");
		        },
		        error: function(xhr, status, error) {
		        	alert("Setting Boot Option failed, please try again.");
		            console.log("Setting Boot Option failed: [" + xhr.status + "] " + xhr.statusText);
				},
		        cache: false,
		        contentType: false,
		        processData: false
		    });
		};

		var downloadIkvmFile = function() {
			if("${BMCFwType}" == "Vertiv" || ("${BMCFwType}" == "AMI")) {
				window.location.href = "./DownloadIkvmFile?IP=" + '${IP}';
			}
			else {
				alert("Not support " + "${BMCFwType}" + " version " + "${BMCVersion}");
				return;
			}
		};
		
		/**
		* Show the loading dialog
		*
		* @param show - boolean of show/hide
		* @param delay - delay to show the dialog
		*/
		var showLoadingDialog = function(show, delay) {
			if(!delay)
				delay = 0;
			
			setTimeout(function() {
				if(show)
					$('#modal_loading').modal('show');
				else
					$('#modal_loading').modal('hide');
			}, delay);
		};
		
		//Reboot BMC / Restore BMC / Backup BMC / Import BIOS / Export BIOS
		var bmcUtil = function(option) {
			var url = "";
			var fileData = "";
			
			var csrfParameter= "${_csrf.parameterName}";
			var csrfToken = "${_csrf.token}";
			var formData;
			
			switch(option) {
				case "Reboot":
					url = "SetBMCUtil";
					break;
				case "Restore":
					url = "UploadBMCUtil";
					fileData = "formData_BMC";
					break;
				case "Backup":
					url = "SetBMCUtil";
					break;
				case "BIOSimport":
					url = "UploadBMCUtil";
					fileData = "formData_BIOS";
					break;
				case "BIOSexport":
					url = "SetBMCUtil";
					break;
			}
			
			if(!url)
				return;
			
			showLoadingDialog(true);
			
			if(fileData === "")
				formData = new FormData();
			else
				formData = new FormData(document.forms.namedItem(fileData));
		    formData.append("IP", '${IP}');
		    formData.append("Option", option);
		    
			$.ajax({
		        url: url + "?" + csrfParameter + "=" + csrfToken,
		        type: 'POST',
		        data: formData,
				dataType: 'json',
		        success: function(data, status, xhr) {
		        	var jsonObj = JSON.parse(xhr.responseText);
		        	
		        	if(jsonObj.status)
		        		showMsgDialog(option + " " + "success", "", jsonObj.status);
		        	else
		        		showMsgDialog(option + " " + "fail", jsonObj.statusMsg, jsonObj.status);
		        	
		        	if((jsonObj.status) && ((option === "Backup") || (option === "BIOSexport")))
		        		window.location.href = "./DownloadBMCUtil?IP=${IP}&Option=" + option;
		        },
		        error: function(xhr, status, error) {
		        	showMsgDialog("Upload file failed:", "[" + xhr.status + "] " + xhr.statusText, false);
		            console.log("Upload file failed: [" + xhr.status + "] " + xhr.statusText);
				},
		        cache: false,
		        contentType: false,
		        processData: false
		    });
		};
		
		var restoreBiosDefault = function() {
			var r = confirm('<spring:message code="BiosDefault1"/>' + "\n" + '<spring:message code="BiosDefault2"/>' + "\n\n" + '<spring:message code="BiosDefault3"/>');
			var csrfParameter= "${_csrf.parameterName}";
			var csrfToken = "${_csrf.token}";
			var formData;
			
			if (r) {
				showLoadingDialog(true);
				
				formData = new FormData(document.forms.namedItem("formData_BIOS_D"));
			    formData.append('IP', '${IP}');
			    
				$.ajax({
			        url: "RestoreBiosDefault?" + csrfParameter + "=" + csrfToken,
			        type: 'POST',
			        data: formData,
					dataType: 'json',
			        success: function(data, status, xhr) {
			        	var jsonObj = JSON.parse(xhr.responseText);
			        	showMsgDialog("Restore BIOS default", jsonObj.statusMsg, jsonObj.status);
			        },
			        error: function(xhr, status, error) {
			        	showMsgDialog("Restore BIOS default failed:", "[" + xhr.status + "] " + xhr.statusText, false);
			            console.log("Restore BIOS default failed: [" + xhr.status + "] " + xhr.statusText);
					},
			        cache: false,
			        contentType: false,
			        processData: false
			    });
			}
		};
		
		var SetVmcli = function(action) {
			var port = $("#port").val();
		    var files = [];
		    
		    var csrfParameter= "${_csrf.parameterName}";
			var csrfToken = "${_csrf.token}";
			var formData = new FormData();
			
			if(!($('input[name=image_select]:checked', '#imageFiles').val()) && (!$('input[name=device_select]:checked', '#imageFiles').val()) && (action !== "umount"))	
				alert("<spring:message code="NodeVmcli8"/>");
			else if((escape($('input[name=image_select]:checked', '#imageFiles').val()).indexOf("%u") !== -1) || (escape($('input[name=device_select]:checked', '#imageFiles').val()).indexOf("%u") !== -1))
				alert("<spring:message code="NodeVmcli9"/>");
			else if(!($("#port").val()))
	    		alert("Port can't be empty or 0");
			else {
				showLoadingDialog(true);
			    
			    //Image files, type: cdrom
			    $("input[name='image_select']:checked").each(function() {
			    	files.push($(this).val());
			    });
			    
			    //Device files, type: fd-floppy, sd-removable, else-cdrom
			    $("input[name='device_select']:checked").each(function() {
			    	files.push($(this).val());
			    });
				
			    formData.append('IP', '${IP}');
			    formData.append('Action', action);
			    formData.append('Port', port);
			    formData.append('Files', files);
			    
				$.ajax({
			        url: "SetVmcli?" + csrfParameter + "=" + csrfToken,
			        type: 'POST',
			        data: formData,
					dataType: 'json',
			        success: function(data, status, xhr) {
			        	var jsonObj = JSON.parse(xhr.responseText);
			        	showMsgDialog(action, jsonObj.statusMsg, jsonObj.status);
			        },
			        error: function(xhr, status, error) {
			        	showMsgDialog("Set Virtual Media failed:", "[" + xhr.status + "] " + xhr.statusText, false);
			            console.log("Set Virtual Media failed: [" + xhr.status + "] " + xhr.statusText);
					},
			        cache: false,
			        contentType: false,
			        processData: false
			    });
			}
		};
		
		var validateIP = function(ip) {
	    	var re = new RegExp('^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$');
	    	
	    	if (re.test(ip))
	    		return true;
	    	else
	    		return false;
	    };
		
		var setNTP = function() {
	    	var operationMode = parseInt($("#OperationMode").val());
	    	var ntp_1 = $("#NTP_1").val();
	    	var ntp_2 = $("#NTP_2").val();
    		var ntp_3 = $("#NTP_3").val();
    		var updateFrequency = parseInt($("#UpdateFrequency").val());
    		//Time sync method only support CMC now, so hide this item
	    	var timeSynchronizationMethod = parseInt($("input[name='TimeSynchronizationMethod']:checked").val());
	    	
	    	switch(operationMode) {
		    	default:
		    	case 0: {
		    		ntp_1 = "";
	    	    	ntp_2 = "";
	        		ntp_3 = "";
	    			updateFrequency = 3;
	    			timeSynchronizationMethod = 1;
		    		break;
		    	}
		    	case 2: {
		    		if((ntp_1 === "") && (ntp_2 === "") && (ntp_3 === "")) {
	    	    		alert("At least one NTP server must be set");
	    	    		return;
	    	    	}
		    		
		    		if((operationMode === 2) && !(updateFrequency > 0)) {
	    	    		alert("Update Frequency can't be empty or 0");
	    	    		return;
	    	    	}
		    		break;
		    	}
		    	case 1: {
		    		if((ntp_1 === "") && (ntp_2 === "") && (ntp_3 === "")) {
	    	    		alert("At least one NTP server must be set");
	    	    		return;
	    	    	}
	    	    	
		    		updateFrequency = 3;
		    		break;
		    	}
	    	}
	    	
    		window.location.href = "./SetNTP?IP=" + '${IP}' + "&operationMode=" + operationMode + "&ntp_1=" + ntp_1 + "&ntp_2=" + ntp_2 + "&ntp_3=" + ntp_3 + "&updateFrequency=" + updateFrequency + "&timeSynchronizationMethod=" + timeSynchronizationMethod;
	    };
	    
		var UserAndPwd = function() {
			alert("The new username & password will be available after a few minutes.");
		};
		
		var checkNodeSupport = function() {
			$("#RestoreBIOS").remove(); //Gbt.Utility not support
			
			<%-- Chris 2018/04/24: Adjust function by BMC type --%>
	        switch ("${BmcFirmwareType}") {
	            case "AMI":
	                //$("#iKVM").remove(); //AMI use different iKVM library, only can use command to startup it
					$("#RebootBMC").remove(); //Use BMCUtil, only support Vertiv
					$("#BMCBackup").remove(); //Use BMCUtil, only support Vertiv and AST2500
	                $("#BIOSSetup").remove(); //Use BMCUtil, only support Vertiv and AST2500
	                $("#RestoreBIOS").remove(); //Only support Vertiv and AST2400
	                $("#VirtualMedia").remove(); //Only support Vertiv
					$("#NetworkTime").remove(); //Only support Vertiv and AST2500
	                break;
	            case "OpenBMC":
	                $("#iKVM").remove();
					$("#RebootBMC").remove();
					$("#BMCBackup").remove();
	                $("#RestoreBIOS").remove();
	                $("#BIOSSetup").remove();
	                $("#VirtualMedia").remove();
	                $("#NetworkTime").remove();
	                break;
	            default:
	                break;
	        }
	        
			if(parent.connectionInterface === "Redfish") {
				$("#NodePowerStatus").remove();
				$("#HardReset").remove();
				$("#ChassisIdentify").remove();
				$("#BootMode").remove();
				$("#iKVM").remove();
				$("#BMCBackup").remove();
				$("#RestoreBIOS").remove();
				$("#BIOSSetup").remove();
				$("#VirtualMedia").remove();
				$("#NetworkTime").remove();
			}
			
			if (("${BmcType}" === "RMC") || ("${BmcType}" === "CMC") || ('${JbodProduct}' === 'true')) {
				/* Brian 2019/06/28: Show power control button for CMC. */
				if ("${BmcType}" !== "CMC") {
					$("#PowerControl").remove()
				}
				
				if("${BmcFirmwareType}" !== "AMI") {
					$("#PowerCycle").remove();
					$("#HardReset").remove();
				}
				
				$("#ChassisIdentify").remove();
				$("#BootOption").remove();
				$("#iKVM").remove();
				$("#RebootBMC").remove();
				$("#RestoreBIOS").remove();
				$("#BIOSSetup").remove();
				$("#VirtualMedia").remove();
				$("#NetworkTime").remove();
				$("#AgentAccount").remove();
			}
			
			if("${AsicType}" !== "AST2400") {
				$("#RestoreBIOS").remove(); //Only support Vertiv and AST2400
			}
			if("${AsicType}" !== "AST2500") {
				$("#BMCBackup").remove(); //Use BMCUtil, only support Vertiv and AST2500
				$("#BIOSSetup").remove(); //Use BMCUtil, only support Vertiv and AST2500
				$("#NetworkTime").remove(); //Only support AST2500
			}
		};
		
		var ntpListLoading = function(start, data)
		{
			if(start) {
				$("#ntpHead").html("<div style='text-align: center;'><i class='fa fa-circle-o-notch fa-spin fa-2x fa-fw'></i></div>");
                $("#ntpBody").hide();
			}
			else {
				setTimeout(function() {
					if(data != null) {
	                    $("#ntpHead").html("<h4><spring:message code='NTP'/></h4>");
                        $("#OperationMode").val(data.operation_mode).change();
                        $("#NTP_1").val(data.ntp_1);
                        $("#NTP_2").val(data.ntp_2);
                        $("#NTP_3").val(data.ntp_3);
                        $("#UpdateFrequency").val(data.udpate_frequency);
                        $("input[name='TimeSynchronizationMethod'][value='" + data.time_sync_method + "']").prop('checked', true);
	                    $("#ntpBody").show();
					}
					else {
						$("#ntpHead").html("<h4>Get NTP data failed</h4>");
					}
				}, 100);
			}
		};
		
		var getNetworkTimeProtocol = function(first)
		{
			if(first) {
				ntpListLoading(true);
			}
			
			$.ajax({
		        url: 'getNetworkTimeProtocol',
		        data: {nodeIP:'${IP}'},
		        dataType: 'json',
		        success: function(_data, status, xhr) {
		        	ntpListLoading(false, _data);
		        },
		        error: function(xhr, status, error) {
		        	ntpListLoading(false);
		        	console.log("Get the network time protocol data failed: [" + xhr.status + "] " + xhr.statusText);
		        },
			    cache: false
		    });
		};
		
		$(document).ready(function() {
			checkNodeSupport();
			checkPowerStatus();
			<sec:authorize access="hasAnyRole(${Access_Configuration})">
            getNetworkTimeProtocol(true);
            </sec:authorize>
		});
		
		$('[data-toggle="tooltip"]').tooltip();
		
		$('.btn-file :file').on(
		{
			'change': function() {
				var numFiles = $(this).get(0).files ? $(this).get(0).files.length : 1;
				var label = $(this).val().replace(/\\/g, '/').replace(/.*\//, '');
				$(this).trigger('fileselect', [numFiles, label]);
			},
			'fileselect': function(event, numFiles, label) {
		        var input = $(this).parents('.input-group').find(':text');
		        var log = numFiles > 1 ? numFiles + ' files selected' : label;
		        if(input.length) {
		        	input.val(log);
		        } else {
		        	if(log)
		        		alert(log);
		        }
	    	}
		});
		
		$("#OperationMode").on('change', function() {
			var mode = $("#OperationMode option:selected").text(); 
			switch(mode){
				case "Daemon Mode":
					$("#NTPsetting input[type=radio]").attr('disabled', true);
					$("#NTPsetting input[type=text]").attr('disabled', false);
					$("#NTPsetting input[type=text][id=UpdateFrequency]").attr('disabled', true);
					break;
				case "Disabled":
					$("#NTPsetting input[type=radio]").attr('disabled', true);
					$("#NTPsetting input[type=text]").attr('disabled', true);
					break;
				case "Requested Mode":
					$("#NTPsetting input[type=radio]").attr('disabled', false);
					$("#NTPsetting input[type=text]").attr('disabled', false);
					break;
				case "Enabled":
					$("#NTPsetting input[type=text]").attr('disabled', false);
					break;
			}
		});
		
		$('#bmcPassword').password('hide');
		$('#agentPassword').password('hide');
	</script>
</body>
</html>