<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
	<title>Node Remote BIOS Setup</title>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	
	<!-- CSS -->
	<link href="<c:url value="/resources/css/bootstrap/morris.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/bootstrap-switch.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/bootstrap-datetimepicker.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/bootstrap.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/metisMenu.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/sb-admin.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/font-awesome/css/font-awesome.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/style_2016.css" />" rel="stylesheet">
	<style>
		table>tbody tr>td:first-child {
			width: 50%;
		}
		.progress-circle {
    		margin-top: 260px !important;
			width: 95px !important;
		}
		.alert {
			margin-bottom: 0px !important;
		}
		.modal-content.success {
			background-color: #dff0d8;
			color: #449d44;
		}
		.modal-content.fail {
			background-color: #f2dede;
			color: #d9534f;
		}
		.modal_msg .modal-title {
			font-weight: bold;
		}
		.modal_msg .modal-header {
			padding: 15px 15px 5px 15px;
			border-bottom: none;
		}
		.modal_msg .modal-body {
			padding: 5px 15px;
		}
	    .btn-file {
		    position: relative;
		    overflow: hidden;
		}
		.btn-file input[type=file] {
		    position: absolute;
		    top: 0;
		    right: 0;
		    min-width: 100%;
		    min-height: 100%;
		    font-size: 100px;
		    text-align: right;
		    filter: alpha(opacity=0);
		    opacity: 0;
		    outline: none;
		    background: white;
		    cursor: inherit;
		    display: block;
		}
	</style>
	
	<!-- Javascript -->
	<script src="<c:url value="/resources/js/bootstrap/jquery.js" />"></script>
	<script src="<c:url value="/resources/js/bootstrap/bootstrap.min.js" />"></script>
</head>

<body>
	<div id="wrapper">
		<div id="page-wrapper">
			<div class="container-fluid">
				<!-- Page Heading -->
				<div class="row page-title">
                    <div class="col-lg-12">
                        <h3 class="page-header">
                            <A onclick='window.open("https://${IP}", "_blank", "scrollbars=yes,resizable=yes,top=300,left=500,width=800,height=600")'> ${IP} </A>
                        </h3>
                    </div>
                </div>
				<br>
				<div class="row">
					<div id="remoteBIOSSetup" class="col-lg-12">
						<div class="panel panel-default">
							<div id="remoteBIOSSetupHead" class="panel-heading">
								<h4 style="display:inline-block;"><spring:message code="NodeDetail19"/></h4>
								<button id="save" type="button" class="btn btn-primary" title="<spring:message code="Save"/>" style="float:right; margin-left:10px;" disabled>
									<i class="fa fa-floppy-o"></i>&nbsp;<spring:message code="Save"/>
								</button>
								<button id="reset" type="button" class="btn btn-warning" title="<spring:message code="ResetDefault"/>" style="float:right; margin-left:10px;" disabled>
									<i class="fa fa-repeat"></i>&nbsp;<spring:message code="ResetDefault"/>
								</button>
								<div class="input-group" style="display:inline-block; float:right;">
								    <div name="uploadFileName" style="display:inline-block; margin-right:5px;"></div>
							    	<div class="btn-group">
								    	<!-- <span class="btn btn-primary btn-file" disabled> -->
								    	<span class="btn btn-primary btn-file">
								            <i class="fa fa-globe"></i>&nbsp;<spring:message code="Browse"/><input type="file" name="file">
								        </span>
								        <button id="import" type="button" class="btn btn-danger" title="<spring:message code="Import"/>" disabled>
											<i class="fa fa-upload"></i>&nbsp;<spring:message code="Import"/>
										</button>
										<button id="export" type="button" class="btn btn-primary" title="<spring:message code="Export"/>" disabled>
											<i class="fa fa-download"></i>&nbsp;<spring:message code="Export"/>
										</button>
							    	</div>
								</div>
							</div>
							<div id="remoteBIOSSetupBody" class="panel-body">
								<div class="dataTable_wrapper">
									<spring:message code="NodeRemoteBIOSSetup1"/>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="modal fade" id="modal_loading" tabindex="-1" role="dialog" data-backdrop="static" data-keyboard="false">
		<div class="modal-dialog progress-circle" role="document">
			<div class="modal-content">
				<div id="modal_loading_div" class="alert">
					<i id="modal_loading_icon" class="fa fa-circle-o-notch fa-spin fa-3x fa-fw"></i>
				</div>
			</div>
		</div>
	</div>
	<div class="modal fade modal_msg" id="modal_msg" tabindex="-1" role="dialog">
		<div class="modal-dialog" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					<h4 name="modal_msg_title" class="modal-title">modal title</h4>
				</div>
				<div class="modal-body">
					<p name="modal_msg_msg">modal message</p>
				</div>
			</div>
		</div>
	</div>
	
	<script>
		var biosValid = false;
	 	var originalRemoteBIOSSetup = {};
	 	var uploadRemoteBIOSSetup = {};
	 	
		$(document).ready(function() {
            getRemoteBIOSSetup();
		});
        
        function remoteBIOSSetupListLoading(start, status)
		{
			if(start) {
				$("#remoteBIOSSetupHead").html("<div style='text-align: center;'><i class='fa fa-circle-o-notch fa-spin fa-2x fa-fw'></i></div>");
                $("#remoteBIOSSetupBody").hide();
			}
			else {
				setTimeout(function(){
					$("#remoteBIOSSetupHead").html('<h4 style="display:inline-block;"><spring:message code="NodeDetail19"/></h4>' + 
												   '<button id="save" type="button" class="btn btn-primary" title="<spring:message code="Save"/>" style="float:right; margin-left:10px;" ' + (status ? '' : 'disabled') + '>' + 
												   '<i class="fa fa-floppy-o"></i>&nbsp;<spring:message code="Save"/>' + 
												   '</button>' + 
												   '<button id="reset" type="button" class="btn btn-warning" title="<spring:message code="ResetDefault"/>" style="float:right; margin-left:10px;" ' + (status ? '' : 'disabled') + '>' + 
												   '<i class="fa fa-repeat"></i>&nbsp;<spring:message code="ResetDefault"/>' + 
												   '</button>' + 
												   '<div class="input-group" style="display:inline-block; float:right;">' + 
												   '<div name="uploadFileName" style="display:inline-block; margin-right:5px;"></div>' + 
												   '<div class="btn-group">' + 
												   '<span class="btn btn-primary btn-file" ' + (status ? '' : 'disabled') + '>' + 
												   '<i class="fa fa-globe"></i>&nbsp;<spring:message code="Browse"/><input type="file" name="file">' + 
												   '</span>' + 
												   '<button id="import" type="button" class="btn btn-danger" title="<spring:message code="Import"/>" disabled>' + 
												   '<i class="fa fa-upload"></i>&nbsp;<spring:message code="Import"/>' + 
												   '</button>' + 
												   '<button id="export" type="button" class="btn btn-primary" title="<spring:message code="Export"/>" ' + (status ? '' : 'disabled') + '>' + 
												   '<i class="fa fa-download"></i>&nbsp;<spring:message code="Export"/>' + 
												   '</button>' + 
												   '</div>' + 
												   '</div>');
                    $("#remoteBIOSSetupBody").show();
				}, 100);
			}
		}
        
        /**
		* Show the message dialog
		*
		* @param title - dialog title
		* @param msg - dialog content message
		* @param success - is success or fail, change the dialog color to green/red
		* @param delay - delay to show the dialog
		*/
		function showMsgDialog(title, msg, success, delay, callback)
        {
			var id;
			
			if(!delay)
				delay = 0;
			
			setTimeout(function() {
				showLoadingDialog(false);
				
				id = randomID(8);
				$("body").append('<div class="modal fade modal_msg" id="' + id + '" tabindex="-1" role="dialog">' + $("#modal_msg").html() + '</div>');
				$("#" + id).find("h4[name='modal_msg_title']").text(title);
				$("#" + id).find("p[name='modal_msg_msg']").text(msg);
				
				if(success)
					$("#" + id + ">div>div").addClass("success");
				else
					$("#" + id + ">div>div").addClass("fail");
				
				$("#" + id).on("hidden.bs.modal", function() {
					$("#" + id).remove(); //Remove itself
					$("body").css("padding-right", ""); //bootstrap modal bug, show/hide too fast cause [body padding-right:21px] not be deleted
					
					if(callback != null)
						callback();
				});
				$("#" + id).modal("show");
			}, delay);
		};
		
		/**
		* Show the loading dialog
		*
		* @param show - boolean of show/hide
		* @param delay - delay to show the dialog
		*/
		function showLoadingDialog(show, delay)
		{
			if(!delay)
				delay = 0;
			
			setTimeout(function() {
				if(show)
					$('#modal_loading').modal('show');
				else
					$('#modal_loading').modal('hide');
			}, delay);
		};
		
		/**
		* Get the random ID, default ID length is 10 bytes
		*
		* @param idLength - random string length
		*/
		function randomID(idLength)
		{
		    var id = "";
		    
		    if(!idLength)
		    	idLength = 10;
			
		    for(var i=0 ; i<idLength ; i++) {
		    	switch(Math.floor((Math.random() * 3) + 1)) {
			    	case 1:
			    		//0~9
			    		id += Math.floor((Math.random() * 10));
			    		break;
			    	case 2:
			    		//A~Z
			    		id += String.fromCharCode(Math.floor((Math.random() * 26) + 65));
			    		break;
			    	case 3:
			    		//a~z
			    		id += String.fromCharCode(Math.floor((Math.random() * 26) + 97));
			    		break;
			    }
		    }
		    
		    return id;
		};
		
        function getRemoteBIOSSetup()
		{
        	remoteBIOSSetupListLoading(true);
        	
			$.ajax({
		        url: 'getRemoteBIOSSetup',
		        data: {bmcIP:'${IP}'},
		        dataType: 'json',
		        success: function(_data, status, xhr) {
		        	originalRemoteBIOSSetup = JSON.parse(JSON.stringify(_data));
	        		remoteBIOSSetupListLoading(false, parseBiosSetup(_data));
		        },
		        error: function(xhr, status, error) {
		        	remoteBIOSSetupListLoading(false, false);
		        	console.log("Get remote BIOS setup failed: [" + xhr.status + "] " + xhr.statusText);
		        },
			    cache: false
		    });
		}
        
        function parseBiosSetup(_data)
        {
        	if(!('attrList' in _data) || 
               !('RegistryEntries' in _data.attrList) || 
               !('Attributes' in _data.attrList.RegistryEntries) || 
               !('attrValue' in _data) || 
               !('Attributes' in _data.attrValue))
        	{
           		$("#remoteBIOSSetupBody>div").html('<spring:message code="NodeRemoteBIOSSetup1"/>');
        		return false;
        	}
        	
        	var htmlString = "";
       		var attrList = _data.attrList.RegistryEntries.Attributes;
       		var attrValues = _data.attrValue.Attributes;
       		htmlString += '<table class="table table-striped table-bordered table-hover" style="margin-bottom: 0px;">';
       		htmlString += '<tbody>';
           	for(var i=0 ; i<attrList.length ; i++) {
           		var attrValue = "";
           		if(attrList[i].AttributeName in attrValues)
           			attrValue = attrValues[attrList[i].AttributeName];
           		
           		htmlString += "<tr>";
           		htmlString += "<td name='" + attrList[i].AttributeName + "' type='" + attrList[i].Type + "' style='vertical-align: middle;'>";
           		htmlString += attrList[i].DisplayName;
           		htmlString += '<i class="fa fa-info-circle" aria-hidden="true" style="margin-left:5px;" data-toggle="tooltip" data-placement="bottom" title="' + attrList[i].HelpText + '"></i>';	
           		htmlString += "</td>";
           		htmlString += "<td>";
           		
           		switch(attrList[i].Type) {
            		case "Enumeration": {
                		htmlString += '<select class="form-control input-sm" ' + (attrList[i].ReadOnly ? 'disabled' : '') + '>';
            			for(var j=0 ; j<attrList[i].Value.length ; j++)
                			htmlString += "<option value='" + attrList[i].Value[j].ValueName + "' " + (attrValue === attrList[i].Value[j].ValueName ? "selected" : "") + ">" + attrList[i].Value[j].ValueDisplayName + "</option>";
                    	htmlString += "</select>";
            			break;
            		}
            		case "Boolean": {
                		htmlString += '<select class="form-control input-sm" ' + (attrList[i].ReadOnly ? 'disabled' : '') + '>';
            			htmlString += "<option value='true' " + (attrValue ? "selected" : "") + ">True</option><option value='false' " + (!attrValue ? "selected" : "") + ">False</option>";
                		htmlString += "</select>";
            			break;
            		}
            		case "Password": {
            			htmlString += '<label class="radio-inline"><input type="radio" name="password_radio_' + attrList[i].AttributeName + '" value="no_action" checked ' + (attrList[i].ReadOnly ? 'disabled' : '') + '><spring:message code="NoAction"/></label>' + 
            						  '<label class="radio-inline"><input type="radio" name="password_radio_' + attrList[i].AttributeName + '" value="set" ' + (attrList[i].ReadOnly ? 'disabled' : '') + '><spring:message code="Set"/></label>' + 
            						  '<label class="radio-inline"><input type="radio" name="password_radio_' + attrList[i].AttributeName + '" value="delete" ' + (attrList[i].ReadOnly ? 'disabled' : '') + '><spring:message code="Delete"/></label>';
                		htmlString += '<input class="form-password form-control input-sm" type="password" placeholder="Password" disabled>';
            			break;
            		}
            		case "Integer": {
            			htmlString += '<input class="form-control input-sm" type="number" min="' + attrList[i].LowerBound + '" max="' + attrList[i].UpperBound + '" value="' + attrValue + '" ' + (attrList[i].ReadOnly ? 'disabled' : '') + '>';
            			break;
            		}
            		default: {
            			htmlString += '<input class="form-control input-sm" type="text" value="' + attrValue + '" ' + (attrList[i].ReadOnly ? 'disabled' : '') + '>';
            			break;
            		}
           		}
           		
           		htmlString += "</td>";
           		htmlString += "</tr>";
           	}
       		htmlString += "</tbody>";
       		htmlString += "</table>";
           	
           	if(htmlString != "") {
           		$("#remoteBIOSSetupBody>div").html(htmlString);
       			$('[data-toggle="tooltip"]').tooltip();
       			biosValid = true;
       			return true;
           	}

       		$("#remoteBIOSSetupBody>div").html('<spring:message code="NodeRemoteBIOSSetup1"/>');
           	return false;
        }
        
        $("#remoteBIOSSetupBody>div").delegate("input[name^='password_radio_']", "change", function() {
        	var targetInput = $(this).parent().parent().find("input[type='password']");
        	switch($(this).val()) {
        		case "set": {
        			targetInput.prop("disabled", false);
        			targetInput.attr("placeholder", "New Password");
        			break;
        		}
        		case "delete": {
        			targetInput.prop("disabled", false);
        			targetInput.attr("placeholder", "Old Password");
        			break;
        		}
        		default: {
        			targetInput.val("");
        			targetInput.prop("disabled", true);
        			targetInput.attr("placeholder", "Password");
        			break;
        		}
        	}
        });
        
        $("#remoteBIOSSetupHead").delegate("button", "click", function() {
        	if(!('attrList' in originalRemoteBIOSSetup) || 
               !('RegistryEntries' in originalRemoteBIOSSetup.attrList) || 
               !('Attributes' in originalRemoteBIOSSetup.attrList.RegistryEntries) || 
               !('attrValue' in originalRemoteBIOSSetup) || 
               !('Attributes' in originalRemoteBIOSSetup.attrValue) || 
               !biosValid)
           	{
        		alert('<spring:message code="NodeRemoteBIOSSetup1"/>')
        		console.log('<spring:message code="NodeRemoteBIOSSetup1"/>');
           		return false;
           	}
        	
        	switch($(this).attr("id")) {
	        	case "save": {
	        		var oriAttrValues = originalRemoteBIOSSetup.attrValue.Attributes;
	        		var changeList = {};
	        		var passwordData = [];
	        		
	        		$("#remoteBIOSSetupBody>div>table>tbody>tr").each(function() {
	        			var attrName = $(this).find("td:eq(0)").attr("name");
	        			var attrType = $(this).find("td:eq(0)").attr("type");
	        			var attrValue = "";
	        			
	        			switch(attrType) {
		            		case "Boolean": {
		            			attrValue = ($(this).find("td:eq(1)>:first-child").val() === 'true');
		            			break;
		            		}
		            		case "Integer": {
		            			attrValue = parseInt($(this).find("td:eq(1)>:first-child").val());
		            			break;
		            		}
		            		case "Password": {
		            			attrValue = $(this).find("td:eq(1)>input[type='password']").val();
		            			if(attrValue !== "") {
		            				var passwordType = $(this).find("td:eq(1)>label>input[type='radio'][name='password_radio_" + attrName + "']:checked").val();
		            				passwordData.push({
		            					PasswordName: attrName, 
	            						NewPassword: ((passwordType === "set") ? attrValue : ""), 
	            						OldPassword: ((passwordType === "delete") ? attrValue : "")
		            				});
		            			}
		            			break;
		            		}
		            		case "Enumeration":
	        				default: {
		            			attrValue = $(this).find("td:eq(1)>:first-child").val();
		            			break;
		            		}
		           		}
	        			
	        			if((attrName in oriAttrValues) && (oriAttrValues[attrName] != attrValue) && (attrType != "Password")) {
	        				changeList[attrName] = attrValue;
	        			}
	        		});
	        		
	        		if((Object.keys(changeList).length > 0) || (passwordData.length > 0)) {
	        			showLoadingDialog(true);
	                	
	        			$.ajax({
					        url: 'setRemoteBIOSSetup',
					        type: 'POST',
					        data: {ip: '${IP}', action: 'set', data: JSON.stringify({Attributes: changeList}), passwordData: JSON.stringify(passwordData)},
					        dataType: 'json',
					        success: function(_data, status, xhr) {
					        	if(_data.status) {
					        		showMsgDialog('<spring:message code="NodeRemoteBIOSSetup3"/>', "", true, 1000, function() {
						        		location.reload();
						        	});
					        	}
					        	else {
					        		showMsgDialog('<spring:message code="NodeRemoteBIOSSetup4"/>', "", false, 1000);
					        	}
					        	
					        },
					        error: function(xhr, status, error) {
					        	console.log('<spring:message code="NodeRemoteBIOSSetup4"/>: [' + xhr.status + '] ' + xhr.statusText);
					        	showMsgDialog('<spring:message code="NodeRemoteBIOSSetup4"/>', xhr.statusText, false, 1000);
					        },
						    cache: false
					    });
	        		}
	        		else {
	        			showMsgDialog('<spring:message code="NodeRemoteBIOSSetup2"/>', "", true);
	        		}
	        		
	        		break;
	        	}
	        	case "reset": {
	        		if(confirm('<spring:message code="NodeRemoteBIOSSetup7"/>')) {
	                	showLoadingDialog(true);
	                	
	        			$.ajax({
					        url: 'setRemoteBIOSSetup',
					        type: 'POST',
					        data: {ip: '${IP}', action: 'reset', data: '{}', passwordData: '{}'},
					        dataType: 'json',
					        success: function(_data, status, xhr) {
					        	if(_data.status) {
						        	showMsgDialog('<spring:message code="NodeRemoteBIOSSetup5"/>', "", true, 1000, function() {
						        		location.reload();
						        	});
					        	}
					        	else {
					        		showMsgDialog('<spring:message code="NodeRemoteBIOSSetup6"/>', "", false, 1000);
					        	}
					        },
					        error: function(xhr, status, error) {
					        	console.log('<spring:message code="NodeRemoteBIOSSetup6"/>: [' + xhr.status + '] ' + xhr.statusText);
					        	showMsgDialog('<spring:message code="NodeRemoteBIOSSetup6"/>', xhr.statusText, false, 1000);
					        },
						    cache: false
					    });
	        		}
	        		break;
	        	}
	        	case "import": {
	        		if(Object.keys(uploadRemoteBIOSSetup.attrValue.Attributes).length > 0) {
	        			var oriAttrValues = originalRemoteBIOSSetup.attrValue.Attributes;
	        			var uploadAttrValues = uploadRemoteBIOSSetup.attrValue.Attributes;
	        			var changeList = {};
		        		var passwordData = [];
		        		
	        			for(var key in oriAttrValues) {
	        				if((key in uploadAttrValues) && (oriAttrValues[key] !== uploadAttrValues[key])) {
	        					if((typeof uploadAttrValues[key] === 'object') && 
	        					   ('PasswordName' in uploadAttrValues[key]) && 
	        					   ('NewPassword' in uploadAttrValues[key]) && 
	        					   ('OldPassword' in uploadAttrValues[key]))
	        					{
	        						passwordData.push(uploadAttrValues[key]);
	        					}
	        					else {
	        						changeList[key] = uploadAttrValues[key];
	        					}
	        				}
	        			}
	        			
	        			if((Object.keys(changeList).length > 0) || (passwordData.length > 0)) {
	        				showLoadingDialog(true);
		                	
		        			$.ajax({
						        url: 'setRemoteBIOSSetup',
						        type: 'POST',
						        data: {ip: '${IP}', action: 'set', data: JSON.stringify({Attributes: changeList}), passwordData: JSON.stringify(passwordData)},
						        dataType: 'json',
						        success: function(_data, status, xhr) {
						        	if(_data.status) {
						        		showMsgDialog('<spring:message code="NodeRemoteBIOSSetup3"/>', "", true, 1000, function() {
							        		location.reload();
							        	});
						        	}
						        	else {
						        		showMsgDialog('<spring:message code="NodeRemoteBIOSSetup4"/>', "", false, 1000);
						        	}
						        	
						        },
						        error: function(xhr, status, error) {
						        	console.log('<spring:message code="NodeRemoteBIOSSetup4"/>: [' + xhr.status + '] ' + xhr.statusText);
						        	showMsgDialog('<spring:message code="NodeRemoteBIOSSetup4"/>', xhr.statusText, false, 1000);
						        },
							    cache: false
						    });
	        			}
	        			else {
		        			showMsgDialog('<spring:message code="NodeRemoteBIOSSetup2"/>', "", true);
	        			}
	        		}
	        		else {
	        			console.log("JSON data is empty");
	        		}
	        		break;
	        	}
	        	case "export": {
	        		var exportJsonObj = JSON.parse(JSON.stringify(originalRemoteBIOSSetup.attrValue));
	        		exportJsonObj.Attributes = {};
	        		
	        		$("#remoteBIOSSetupBody>div>table>tbody>tr").each(function() {
	        			var attrName = $(this).find("td:eq(0)").attr("name");
	        			var attrType = $(this).find("td:eq(0)").attr("type");
	        			var attrValue = "";
	        			
	        			switch(attrType) {
		            		case "Boolean": {
		            			attrValue = ($(this).find("td:eq(1)>:first-child").val() === 'true');
		            			break;
		            		}
		            		case "Integer": {
		            			attrValue = parseInt($(this).find("td:eq(1)>:first-child").val());
		            			break;
		            		}
		            		case "Password": {
		            			var password = $(this).find("td:eq(1)>input[type='password']").val();
		            			if(password !== "") {
		            				var passwordType = $(this).find("td:eq(1)>label>input[type='radio'][name='password_radio_" + attrName + "']:checked").val();
		            				attrValue = {
			            				PasswordName: attrName, 
	            						NewPassword: ((passwordType === "set") ? password : ""), 
	            						OldPassword: ((passwordType === "delete") ? password : "")
		            				};
		            			}
		            			break;
		            		}
		            		case "Enumeration":
	        				default: {
		            			attrValue = $(this).find("td:eq(1)>:first-child").val();
		            			break;
		            		}
		           		}
	        			
	        			exportJsonObj.Attributes[attrName] = attrValue;
	        		});
	        		
	        		var fileName = "";
	        		if("RegistryVersion" in originalRemoteBIOSSetup.attrList) {
	        			fileName = originalRemoteBIOSSetup.attrList.RegistryVersion + "_";
	        			fileName = fileName.replace(/\-/g,"_");
	        		}
	        		fileName += formatDate("", "yyyy_MM_dd_HH_mm_ss") + ".json";
	        		
	        		download_file(fileName, JSON.stringify(exportJsonObj, null, 4));
	        		break;
	        	}
        	}
        });
        
        $("#remoteBIOSSetupHead").delegate('.btn-file :file', 'change', function() {
       		var numFiles = $(this).get(0).files ? $(this).get(0).files.length : 1;
       		var label = $(this).val().replace(/\\/g, '/').replace(/.*\//, '');
       		$(this).trigger('fileselect', [numFiles, label]);
       		
       		if(numFiles > 0) {
       			var filenameExt = "";
           		var filenameArray = $(this).get(0).files[0].name.split("\.");
           		if(filenameArray.length > 0)
           			filenameExt = filenameArray[filenameArray.length-1];
           		
           		if((filenameExt.toLowerCase() !== "json") || ($(this).get(0).files[0].type != "application/json")) {
           			uploadRemoteBIOSSetup.attrValue = {};
           			alert('<spring:message code="NodeRemoteBIOSSetup8"/>');
           			$(this).parents('.btn-group').find('button[id="import"]').prop("disabled", true);
           			return;
           		}
           		
           		var that = $(this);
           		var reader = new FileReader();
                reader.onload = function(e) {
                	var status = false;
                	
                    try {
                    	uploadRemoteBIOSSetup.attrValue = JSON.parse(this.result);
                   		if(biosValid && 
                   		   ('@odata.id' in uploadRemoteBIOSSetup.attrValue) && 
                   		   ('Attributes' in uploadRemoteBIOSSetup.attrValue) && 
                   		   (Object.keys(uploadRemoteBIOSSetup.attrValue.Attributes).length > 0))
                   		{
                   			status = true;
                   		}
                    }
                    catch(e) {
                    	console.log("Parse the JSON file fail: " + e);
                    }
                    
                    if(status) {
                    	that.parents('.btn-group').find('button[id="import"]').prop("disabled", false);
                    }
                    else {
               			uploadRemoteBIOSSetup.attrValue = {};
                    	alert('<spring:message code="NodeRemoteBIOSSetup8"/>');
                    	that.parents('.btn-group').find('button[id="import"]').prop("disabled", true);
                    }
                }
                reader.readAsText($(this).get(0).files[0]);
       		}
       		else {
       			uploadRemoteBIOSSetup.attrValue = {};
       			$(this).parents('.btn-group').find('button[id="import"]').prop("disabled", true);
       		}
       	}).delegate('.btn-file :file', 'fileselect', function(event, numFiles, label) {
       		var div = $(this).parents('.input-group').find('div[name="uploadFileName"]');
       		var log = numFiles > 1 ? numFiles + ' files selected' : label;
       		if(div.length) {
       			div.html(log);
       		} else {
	       		if(log)
	       			alert(log);
       		}
       	});
        
        /**
         * Download file (sel, config)
         * 
         * @filename   - file name of download file
         * @text       - file content
         */
        function download_file(filename, text)
        {
            var isIE = /*@cc_on!@*/false || !!document.documentMode;
            var isEdge = false;
            if(typeof(createImageBitmap) != "undefined") {
                isEdge = false;
            }
            else {
                isEdge = true;
            }

            if(isIE) {
                var blobObject = new Blob([text]);
                window.navigator.msSaveBlob(blobObject, filename);
            }
            else if(isEdge) {
                var blobObject = new Blob([text]);
                window.navigator.msSaveBlob(blobObject, filename);
            }
            else {
                var element = document.createElement('a');
                element.setAttribute('href', 'data:text/plain;charset=utf-8,' + encodeURIComponent(text));

                element.setAttribute('download', filename);

                element.style.display = 'none';
                document.body.appendChild(element);

                element.click();

                document.body.removeChild(element);
            }
        }
        
        /**
         * Formatted date
         * 
         * @param date   - Date() object
         * @param format - format date string (ex. "yyyy-MM-dd HH:mm:ss.SSS")
         * @return date string of converted based on format
         */
        function formatDate(date, format)
        {
            if((date == null) || (date === ""))
                date = new Date();
            else if(typeof(date) === "string")
                date = new Date(date);

            if(format == null)
                format = "yyyy-MM-dd HH:mm:ss.SSS";

            try {
                var format_array = format.split(/[\s\-\/\:\.\_]+/);
                for(var i=0 ; i<format_array.length ; i++) {
                    var convert_date = "";

                    //Parse the date
                    switch(format_array[i]) {
                        case "yyyy":
                            convert_date = date.getUTCFullYear().toString();
                            break;
                        case "MM":
                            convert_date = (date.getUTCMonth() + 1).toString();
                            break;
                        case "dd":
                            convert_date = date.getUTCDate().toString();
                            break;
                        case "HH":
                            convert_date = date.getUTCHours().toString();
                            break;
                        case "mm":
                            convert_date = date.getUTCMinutes().toString();
                            break;
                        case "ss":
                            convert_date = date.getUTCSeconds().toString();
                            break;
                        case "SSS":
                            convert_date = date.getUTCMilliseconds().toString();
                            break;
                        default:
                            convert_date = "??";
                            break;
                    }

                    //Fill zero to insufficient number of date string
                    for(j=convert_date.length ; j<format_array[i].length ; j++)
                        convert_date = "0" + convert_date;
                    
                    format = format.replace(format_array[i], convert_date);
                }
            }
            catch(e) {
                console.log("Format the date (" + date + ") to '" + format + "' format fail: " + e);
            }

            return format;
        }
	</script>
</body>
</html>
