<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="x" uri="http://java.sun.com/jsp/jstl/xml" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
	<title>Node Status</title>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	
	<!-- CSS -->
	<link href="<c:url value="/resources/css/bootstrap/dataTables.bootstrap.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/dataTables.responsive.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/bootstrap.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/metisMenu.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/sb-admin.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/font-awesome/css/font-awesome.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/style_2016.css" />" rel="stylesheet">
	<style>
		.hideTD {
			display: none;
		}
	</style>
	
	<!-- Javascript -->
	<script src="<c:url value="/resources/js/bootstrap/jquery.js" />"></script>
	<script src="<c:url value="/resources/js/bootstrap/bootstrap.min.js" />"></script>
	<script src="<c:url value="/resources/js/bootstrap/jquery.dataTables.min.js"/>"></script>
	<script src="<c:url value="/resources/js/bootstrap/dataTables.bootstrap.min.js"/>"></script>
</head>

<body>
	<div id="wrapper">
		<div id="page-wrapper">
			<div class="container-fluid">
				<br>
				<div class="row">
					<div class="col-lg-12">
						<div class="panel panel-default">
							<!-- /.panel-heading -->
							<div class="panel-body">
								<div class="dataTable_wrapper">
									<table class="table table-striped table-bordered table-hover" id="dataTables">
										<thead>
											<tr>
												<th width="1%"></th>
												<th style="display:none"></th>
												<th><spring:message code="Status"/></th>
												<th><spring:message code="Nodelist3"/></th>
												<th><spring:message code="Nodelist2"/></th>
												<th style="display:none"></th>
											</tr>
										</thead>
										<tbody>
										</tbody>
									</table>
								</div>
								<!-- /.dataTable-wrapper -->
							</div>
							<!-- /.panel-body -->
						</div>
						<!-- /.panel -->
					</div>
					<!-- /.col-lg-12 -->
				</div>
				<!-- /.row -->
			</div>
		</div>
		<!-- /.container-fluid -->
	</div>
	<!-- /.wrapper -->
	
	<!-- Page-Level Demo Scripts - Tables - Use for reference -->
	<script>
		var alertListIndex = 0;
		var alertListLength = 25;
		
		$(document).ready(function() {
			$('#dataTables').DataTable({
				"aaSorting": [[ 1, "asc" ]],
				"aoColumns": [ 
				              { "bSortable": false },
				              { "bSortable": false, "sClass": "hideTD" },
				              { "bSortable": false },
				              { "bSortable": false },
				              { "bSortable": false },
				              { "bSortable": false, "sClass": "hideTD" }],
				"stateSave":  false,
				"pagingType": "full_numbers",
				"scrollX":    true,
				"fnInfoCallback": function( oSettings, iStart, iEnd, iMax, iTotal, sPre ) {
			    },
			    "createdRow": function( row, data, dataIndex ) {
			    	if(data[2] == "Health")
			    		$( row ).find('td:eq(0)').addClass("fa fa-check-circle");
			    	else
			    		$( row ).find('td:eq(0)').addClass("details-control fa fa-plus-circle");
			    },
			    language: {
					"emptyTable": <spring:message code="DataTable1"/>,
					"processing": <spring:message code="DataTable2"/>,
					"loadingRecords": <spring:message code="DataTable3"/>,
					"lengthMenu": <spring:message code="DataTable4"/>,
					"zeroRecords": <spring:message code="DataTable5"/>,
					"info": <spring:message code="DataTable6"/>,
					"infoEmpty": <spring:message code="DataTable7"/>,
					"infoFiltered": <spring:message code="DataTable8"/>,
					"infoPostFix": <spring:message code="DataTable9"/>,
					"search": <spring:message code="DataTable10"/>,
					"paginate": {
						"first": <spring:message code="DataTable11"/>,
						"previous": <spring:message code="DataTable12"/>,
						"next": <spring:message code="DataTable13"/>,
						"last": <spring:message code="DataTable14"/>
					},
					"aria": {
						"sortAscending": <spring:message code="DataTable15"/>,
						"sortDescending": <spring:message code="DataTable16"/>
					}
				}
			});
			
			var table = $('#dataTables').DataTable();
			// Add event listener for opening and closing details
		    $('#dataTables tbody').on('click', 'td.details-control', function () {
		        var tr = $(this).closest('tr');
		        var row = table.row( tr );
		        
		        if ( row.child.isShown() ) {
		            // This row is already open - close it
		            row.child.hide();
		            $(this).removeClass('fa fa-minus-circle');
		            $(this).addClass('fa fa-plus-circle');
		        }
		        else {
		            // Open this row
		            row.child( format(row.data()) ).show();
		            //tr.addClass('shown');
		            $(this).removeClass('fa fa-plus-circle');
		            $(this).addClass('fa fa-minus-circle');
		        }
		    } );
			
		    $('#dataTables_filter>label>input').prop("disabled", true);
			updateGSMAlertList();
		});
		
		function updateGSMAlertList() {
			$.ajax({
		        url: 'getGSMAlertList',
		        data: {dataIndex:alertListIndex, dataLength:alertListLength},
		        dataType: 'json',
		        success: function(_data, status, xhr) {
		        	var alertArray = [];
		        	
		        	for(var i=0 ; i<_data.AlertList.length ; i++) {
		        		//Skip health node.
		        		if(_data.AlertList[i].Level == "4")
		        			continue;
		        		
		        		alertArray.push(["",
		    		        			_data.AlertList[i].Level,
		    		        			_data.AlertList[i].Status,
		    		        			_data.AlertList[i].IP,
		    		        			_data.AlertList[i].MAC,
		    		        			_data.AlertList[i].Description
		        		                ]);
		        	}
		        	
		        	$('#dataTables').DataTable().rows.add(alertArray).draw(false);
		        	
		        	if(_data.AlertList.length != 0) {
		        		alertListIndex += alertListLength;
		        		setTimeout(updateGSMAlertList, 50);
		        	}
		        	else {
		        		alertListIndex = 0;
		    		    $('#dataTables_filter>label>input').prop("disabled", false);
		        	}
		        },
		        error: function(xhr, status, error) {
		        	console.log("Get the GSM Alert List failed: [" + xhr.status + "] " + xhr.statusText);
		        },
			    cache: false
		    });
		}
		
		function format ( d ) {
			var htmlString;
			var descrip = d[5].split(",");
			htmlString = '<button type="button" class="btn btn-primary" id="Delete" onclick="cleanStatus(this)"';
			<sec:authorize ifNotGranted="ROLE_ADMIN">
			htmlString += ' disabled';
			</sec:authorize>
			htmlString += '><spring:message code="Delete"/></button>&nbsp;&nbsp;';
			htmlString += '<button type="button" class="btn btn-primary" id="ClearAll" onclick="cleanAllStatus(this)"';
			<sec:authorize ifNotGranted="ROLE_ADMIN">
			htmlString += ' disabled';
			</sec:authorize>
			htmlString += '><spring:message code="Clear"/> <spring:message code="All"/></button><br><br>';
			htmlString += '<table class="table table-hover"><thead></thead><tbody>';
			for(var i=0 ; i<descrip.length ; i++) {
				htmlString += '<tr id="nodeTrap">' +
							  '<td><input type="checkbox" name="" value=""';
			  	<sec:authorize ifNotGranted="ROLE_ADMIN">
					htmlString += ' disabled';
				</sec:authorize>
				htmlString += '></td>' +
	            			  '<td>' + descrip[i++] + '</td>' +
	            			  '<td>' + descrip[i] + '</td>' +
	        				  '</tr>';
			}
			htmlString += '</tbody></table>';
			
		    return htmlString;
		}
		
		function cleanStatus(obj) {
			var time = [];
			var msg = [];
			var thisIP = findIP(obj);
			var thisMAC = findMAC(obj);
			
			$(obj).parent().find('table tr').each(function() {
				if($(this).find('input:checkbox').prop("checked")) {
					time.push($(this).find('td').eq(1).html());
					msg.push($(this).find('td').eq(2).html());
				}
			});
			
			window.location.href = "./deleteNodeStatus?IP=" + thisIP + "&MAC=" + thisMAC + "&Type=Single&TimeStamp=" + time + "&Description=" + msg;
		}
		
		function cleanAllStatus(obj) {
			var macIndexOnTR = 4;
			var thisMAC = findMAC(obj);
			
			window.location.href = "./deleteNodeStatus?MAC=" + thisMAC + "&Type=All";
		}
		
		function findIP(obj) {
			var ipIndexOnTR = 3;
			return $(obj).parent().parent().parent().find('tr:not(#nodeTrap)').eq($(obj).parent().parent().index()-1).find('td').eq(ipIndexOnTR).html();
		}
		
		function findMAC(obj) {
			var macIndexOnTR = 4;
			return $(obj).parent().parent().parent().find('tr:not(#nodeTrap)').eq($(obj).parent().parent().index()-1).find('td').eq(macIndexOnTR).html();
		}
	</script>
</body>
</html>
