<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="x" uri="http://java.sun.com/jsp/jstl/xml" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
	<title>Node Update</title>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
		
    <style type="text/css">
    .progress {
    text-align:center;
    }
    .progress-value {
    position:absolute;
    right:0;
    left:0;
    }
    .btn-file {
    position: relative;
    overflow: hidden;
	}
	.btn-update {
    position: relative;
    overflow: hidden;
	}
	.btn-file input[type=file] {
	    position: absolute;
	    top: 0;
	    right: 0;
	    min-width: 100%;
	    min-height: 100%;
	    font-size: 100px;
	    text-align: right;
	    filter: alpha(opacity=0);
	    opacity: 0;
	    outline: none;
	    background: white;
	    cursor: inherit;
	    display: block;
	}
	
	input[readonly] {
	  background-color: white !important;
	  cursor: text !important;
	}
	</style>
	
	<!-- CSS -->
	<link href="<c:url value="/resources/css/bootstrap/bootstrap.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/bootstrap-switch.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/metisMenu.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/sb-admin.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/font-awesome/css/font-awesome.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/style_2016.css" />" rel="stylesheet">
	
	<!-- Javascript -->
	<script src="<c:url value="/resources/js/bootstrap/jquery.js" />"></script>
	<script src="<c:url value="/resources/js/bootstrap/bootstrap.min.js" />"></script>
	<script src="<c:url value="/resources/js/bootstrap/bootstrap-switch.min.js" />"></script>
</head>

<body>
    <div id="wrapper">
        <div id="page-wrapper">
            <div class="container-fluid">
                <!-- Page Heading -->
				<div class="row page-title">
                    <div class="col-lg-12">
                        <h3 class="page-header">
                            <A onclick='window.open("https://${IP}", "_blank", "scrollbars=yes,resizable=yes,top=300,left=500,width=800,height=600")'> ${IP} </A>
                        </h3>
                    </div>
                </div>
				<!-- /.row -->
				<br>
				<sec:authorize access="hasAnyRole(${Access_Configuration})">
				<div class="row">
				   	<div class="col-lg-12">
				   		<div class="panel panel-default">
							<div class="panel-body">
								<div class="row" id="TFTPSettings">
								   	<div class="col-lg-12">
								   		<div class="panel panel-default">
											<div class="panel-heading">
												<h4 style="display:inline-block;">TFTP</h4>&nbsp;&nbsp;
												<input id="tftpEnableCheckbox" class="switch" type="checkbox" data-size="mini" />
												&nbsp;&nbsp;
												<!-- <input id="tftpTypeCheckbox" class="switch" type="checkbox" data-size="mini" data-on-text="Local" data-off-text="Remote" data-on-color="primary" data-off-color="primary"/>&nbsp;&nbsp; -->
												<select id="tftpTypeSelect" class="form-control input-sm" style="display:inline-block; font-size:14px; width:90px;">
													<option value="Local"><spring:message code="Local"/></option>
													<!-- <option value="Remote">Remote</option> -->
												</select>
												&nbsp;&nbsp;
												<div class="input-group" style="display:inline-block;">
													<div class="btn-group">
														<input id="tftpIPInput" type="text" class="form-control input-sm" style="font-size:14px; width:130px;" value="${tftpIP}" />
														<button id="tftpSetButton" type="button" class="btn btn-primary btn-sm"><spring:message code="Submit"/></button>
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>
								
				                <div class="row">
								   	<div class="col-lg-12">
								   		<div class="panel panel-default">
											<div class="panel-heading">
												<h4 style="display: inline-block;"><spring:message code="NodeUpdate3"/></h4>
												<button id="showUpdateFirmwareLog" type="button" class="btn btn-primary" data-toggle="modal" data-target="#UpdateLog" style="float: right;">Log</button>
											</div>
											<!-- /.panel-heading -->
											<div class="panel-body">
												<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
													<div class="well form-group">
														<strong>BMC Version</strong>: <div id="bmc-version" style="display: inline-block;">${BMCVersion}</div><br>
														<c:if test="${BmcType == 'SMC'}">
															<strong>BIOS Version</strong>: <div id="bios-version" style="display: inline-block;">${BIOSVersion}</div><br>
														</c:if>
													</div>
												</div>
												
												<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
													
													<form name="updateFirmwareForm" enctype="multipart/form-data" class="form-inline">
														<div class="well">
															<div>
																<label><spring:message code="NodeUpdate1"/> (<spring:message code="NodeUpdate9"/> <label id="firmwareLabel">.zip</label>)</label>
															</div>
														    <div class="form-group col-lg-2">
														    	<select id="firmwareSelect" class="form-control" name="selectFirmwareType" style="width: 100%">
																    <c:set var="xmltext">${OptionXMLString}</c:set>
																    <x:parse xml="${xmltext}" var="output"/>
																    <x:forEach select="$output/NodeUpdateOptions/option" var="item">
																	    <option value="<x:out select="$item/value" />"><x:out select="$item/name" /></option>
																    </x:forEach>
															    </select>
														    </div>
														    <div class="form-group col-lg-10">
															    <div class="input-group" style="width: 100%">
			    											    	<div class="btn-group" style="width: 100%">
														    	    <input id="updateFilePathText" type="text" class="form-control" style="width: 70%" readonly>
														    	    <span id="updateFileBrowseButton" class="btn btn-primary btn-file">
														                <spring:message code="Browse"/> <input type="file" name="file" id="fileToUpload">
														            </span>
														            <input type="button" value=<spring:message code="Update"/> name="submit" class="btn btn-danger" id="startUpdateFirmware">
														    	    </div>
															    </div>
														    </div>
															<br><br><br>
															<div>
																<div class="progress">
																	<span class="progress-value" id="progressValue_Firmware"></span>
																	<div class="progress-bar progress-bar-striped active" id="progressBar_Firmware" role="progressbar"></div>
																</div>
															</div>
														</div>
													</form>
												</div>
											</div>
				
											<!-- /.panel-body -->
												
										</div>
										<!-- /.panel -->
									</div>
									<!-- /.col-lg-12 -->
								</div>
								<!-- /.row -->
								
								<div class="row" id="UpdateNodeLogo">
								   	<div class="col-lg-12">
								   		<div class="panel panel-default">
											<div class="panel-heading">
												<h4><spring:message code="NodeUpdate4"/></h4>
											</div>
											<!-- /.panel-heading -->
											<div class="panel-body">								
												<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
													<form name="updateLogoForm" enctype="multipart/form-data" class="form-inline">
														<div class="well">
															<div>
																<label><spring:message code="NodeUpdate4-2"/> (<spring:message code="NodeUpdate9"/> .zip)</label>
															</div>
													    	<div class="form-group col-lg-10">
															    <div class="input-group" style="width: 100%">
														    	    <div class="btn-group" style="width: 100%">
														    	    <input id="updateLogoFilePathText" type="text" class="form-control" style="width: 70%" readonly>
														    	    <span id="updateLogoFileBrowseButton" class="btn btn-primary btn-file">
														                <spring:message code="Browse"/> <input type="file" name="file" id="updateLogoFile">
														            </span>
														                <input type="button" value=<spring:message code="Update"/> name="submit" class="btn btn-danger" id="startUpdateLogo">
														    	    </div>
															    </div>
														    </div>
															<br><br><br>
															<div>
																<div class="progress">
																	<span class="progress-value" id="progressValue_Logo"></span>
																	<div class="progress-bar progress-bar-striped active" id="progressBar_Logo" role="progressbar"></div>
																</div>
															</div>
															<div>
																<label style = "font-weight: normal"><spring:message code="NodeUpdate4-3"/></label>
															</div>
														</div>
													</form>
												</div>
											</div>
											<!-- /.panel-body -->
										</div>
										<!-- /.panel -->
									</div>
									<!-- /.col-lg-12 -->
								</div>
								<!-- /.row -->
							</div>
						</div>
					</div>
				</div>
				</sec:authorize>
				<sec:authorize access="hasAnyRole(${Access_Configuration})">
				<div class="row">
				   	<div id="UpdateGSMAgent" class="col-lg-12">
				   		<div class="panel panel-default">
							<div class="panel-heading">
								<h4><spring:message code="NodeUpdate8"/></h4>
							</div>
							<div class="panel-body">
								<div id="gsmAgentStatus" class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
								</div>
								<div id="gsmAgentUpdate" class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="display:none;">
									<form name="updateGSMAgentForm" enctype="multipart/form-data" class="form-inline">
										<div class="well">
											<div>
												<label><spring:message code="NodeUpdate5-2"/> (<spring:message code="NodeUpdate9"/> .war)</label>
											</div>
									    	<div class="form-group col-lg-10">
											    <div class="input-group" style="width: 100%">
										    	    <div class="btn-group" style="width: 100%">
										    	    <input id="updateGSMAgentFilePathText" type="text" class="form-control" style="width: 70%" readonly>
										        	<span id="updateGSMAgentFileBrowseButton" class="btn btn-primary btn-file">
										                <spring:message code="Browse"/> <input type="file" name="file" id="updateGSMAgentFile">
										            </span>
										                <input type="button" value=<spring:message code="Update"/> name="submit" class="btn btn-danger" id="startUpdateGSMAgent">
										    	    </div>
											    </div>
										    </div>
											<br><br><br>
											<div>
												<div class="progress">
													<span class="progress-value" id="progressValue_GSMAgent"></span>
													<div class="progress-bar progress-bar-striped active" id="progressBar_GSMAgent" role="progressbar"></div>
												</div>
											</div>
										</div>
									</form>
								</div>
							</div>
						</div>
					</div>
				</div>
				</sec:authorize>
				<!-- /.row -->
				
            </div>
            <!-- /.container-fluid -->
        </div>
        <!-- /#page-wrapper -->
	</div>
    <!-- /#wrapper -->
	
	<div style="color:black" class="modal fade" id="UpdateLog" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
		<div class="modal-dialog" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title" id="myModalLabel">Update firmware log</h4>
				</div>
				
				<div class="modal-body">
				<p id="LogArea">
				</p>
				</div>
				
				<div class="modal-footer">
					<button type="button" class="btn btn-primary" data-dismiss="modal"><spring:message code="Close"/></button>
				</div>
			</div>
		</div>
	</div>
	
    <!-- Javascript -->
	<script>
    	var ipAddress = "${IP}";
    	var updateType = "";    //Firmware/Logo/Agent/Unknown
    	var uploadLock = false; //Lock update the update progress status by checkUpdateStatus() function, change to update the status by ajax xhr of upload file
    	var updateLock = false; //Lock control the TFTP and upload file until the update is complete
		var tftpEnable = false; //Enable/Disable TFTP
    	
		var checkUpdateStatus;
		
		var removeProgressColor = function() {
			$("#progressBar_" + updateType).removeClass("progress-bar-danger");
			$("#progressBar_" + updateType).removeClass("progress-bar-success");
			$("#progressBar_" + updateType).removeClass("progress-bar-striped active");
		};
		
		var setProgress = function(text, colorClass, percent) {
			if(text)
				$("#progressValue_" + updateType).text(text);
			if(colorClass)
				$("#progressBar_" + updateType).addClass(colorClass);
			if(percent)
				$("#progressBar_" + updateType).css("width", percent);
		};
		
		var initProgressStatus = function() {
			removeProgressColor();
			setProgress("Starting...", "progress-bar-striped active", "0%");
		};
		
		var uploadFile = function(type) {
			var csrfParameter= "${_csrf.parameterName}";
			var csrfToken = "${_csrf.token}";
			var formData;
			
			if(updateLock)
				return false;
			
			uploadLock = true;
			updateType = type;
			initProgressStatus();
			
			formData = new FormData(document.forms.namedItem("update" + type + "Form"));
		    formData.append("IP", ipAddress);
		    formData.append("selectType", type);
		    
		    $.ajax({
		        url: "UploadUpdateFile?" + csrfParameter + "=" + csrfToken,
		        type: 'POST',
		        data: formData,
				dataType: 'json',
		        xhr: function(xhr, status, error) {
		            var myXhr = $.ajaxSettings.xhr();
		            if(myXhr.upload) {
		                myXhr.upload.addEventListener(
		                	'progress', 
		                	function(e) {
		                		var percent;
			                	if(e.lengthComputable) {
			        		    	percent=Math.ceil((e.loaded/e.total)*100);
			        		    	if(percent > 30) {
			        					setProgress("Uploading " + percent + "%...", null, percent + "%");
			        		    	}
			        		    	else {
			        					setProgress(null, null, "0%");
			        		    	}
			        		    }
		               		}, 
		               		false
		               	);
		            }
		            return myXhr;
		        },
		        success: function(_data, status, xhr) {
		        	var jsonObj = JSON.parse(xhr.responseText);
		        	if(!jsonObj.status) {
		    			removeProgressColor();
    					setProgress(jsonObj.statusMsg, null, "0%");
		        	}
		        	uploadLock = false;
		        },
		        error: function(xhr, status, error) {
		        	console.log("Upload " + type + " file to GSM server failed: [" + xhr.status + "] " + xhr.statusText);
		        	uploadLock = false;
				},
		        cache: false,
		        contentType: false,
		        processData: false
		    });
		};
		
		var resetUpdateStatus = function(clickElement) {
			$.ajax({
				url: 'resetUpdateStatus',
				data: {IP: ipAddress},
				dataType: 'json',
				success: function(_data, status, xhr) {
					uploadFile(clickElement.attr("id").replace("startUpdate", ""));
				},
				error: function(xhr, status, error) {
					console.log("Reset the update status failed: [" + xhr.status + "] " + xhr.statusText);
				},
				cache: false
			});
		};
		
		var updateVersion = function() {
			$.ajax({
				url: 'nodeUpdateVersion',
				data: {nodeIP: ipAddress},
				dataType: 'json',
				success: function(_data, status, xhr) {
					if(_data.bmcVersion != "N/A") {
						$("#bmc-version").html(_data.bmcVersion);
					}
					if(_data.biosVersion != "N/A") {
						$("#bios-version").html(_data.biosVersion);
					}
				},
				error: function(xhr, status, error) {
					console.log("Get the update version failed: " + "[" + xhr.status + "] " + xhr.statusText);
				},
				cache: false
			});
		};
		
		var lockButtonAction = function() {
			//lock firmware
			$("#firmwareSelect").prop("disabled", true);
			$("#updateFilePathText").prop("disabled", true);
			$("#updateFileBrowseButton").attr("disabled", true);
			$("#fileToUpload").prop("disabled", true);
			$("#startUpdateFirmware").prop("disabled", true);
			
			//lock logo
			$("#updateLogoFilePathText").prop("disabled", true);
			$("#updateLogoFileBrowseButton").attr("disabled", true);
			$("#updateLogoFile").prop("disabled", true);
			$("#startUpdateLogo").prop("disabled", true);
			
			if(updateLock) {
				//lock tftp
				$("#tftpEnableCheckbox").bootstrapSwitch('disabled',true);
				$("#tftpTypeSelect").prop("disabled", true);
				$("#tftpIPInput").prop("disabled", true);
				$("#tftpSetButton").prop("disabled", true);
				
				//lock agent
				$("#updateGSMAgentFilePathText").prop("disabled", true);
				$("#updateGSMAgentFileBrowseButton").attr("disabled", true);
				$("#startUpdateGSMAgent").prop("disabled", true);
			}
		};
		
		var unlockButtonAction = function() {
			if(!updateLock) {
				if(tftpEnable) {
					//unlock firmware
					$("#firmwareSelect").prop("disabled", false);
					$("#updateFilePathText").prop("disabled", false);
					$("#updateFileBrowseButton").attr("disabled", false);
					$("#fileToUpload").prop("disabled", false);
					$("#startUpdateFirmware").prop("disabled", false);
					
					//unlock logo
					$("#updateLogoFilePathText").prop("disabled", false);
					$("#updateLogoFileBrowseButton").attr("disabled", false);
					$("#updateLogoFile").prop("disabled", false);
					$("#startUpdateLogo").prop("disabled", false);
					
					//unlock tftp
					$("#tftpTypeSelect").prop("disabled", false);
					$("#tftpIPInput").prop("disabled", false);
				}
				
				//unlock tftp
				$("#tftpEnableCheckbox").bootstrapSwitch('disabled',false);
				$("#tftpSetButton").prop("disabled", false);
				
				//unlock agent
				$("#updateGSMAgentFilePathText").prop("disabled", false);
				$("#updateGSMAgentFileBrowseButton").attr("disabled", false);
				$("#startUpdateGSMAgent").prop("disabled", false);
			}
		};
		
		var updateProgressStatus = function(data) {
			var progressClass = "";
			var progressPercent = "";
			
			if(!uploadLock && (data.updateType != "Unknown")) {
				updateType = data.updateType;
				
				if(data.isComplete) {
					if(updateLock) {
						updateVersion();
						updateLock = false;
						unlockButtonAction();
					}
					progressClass = "progress-bar-" + (data.isSuccess ? "success" : "danger");
					progressPercent = "100%";
				}
				else {
					if(!updateLock) {
						updateLock = true;
						lockButtonAction();
					}
					progressClass = "progress-bar-striped active";
					progressPercent = data.statusPercent;
				}
				
				removeProgressColor();
				setProgress(data.statusMsg, progressClass, progressPercent);
			}
			
			if(updateLock)
				setTimeout(checkUpdateStatus, 1000);
			else
				setTimeout(checkUpdateStatus, 3000);
		};
		
		checkUpdateStatus = function() {
			$.ajax({
				url: 'nodeUpdateStatus',
				data: {IP: ipAddress},
				dataType: 'json',
				success: function(_data, status, xhr) {
					updateProgressStatus(_data);
				},
				error: function(xhr, status, error) {
					console.log("Get the update status failed: " + "[" + xhr.status + "] " + xhr.statusText);
				},
				cache: false
			});
		};
		
		var checkNodeSupport = function() {
			switch("${BmcType}") {
				case "SMC":
					break;
				default:
					$('#UpdateNodeLogo').remove();
					$('#UpdateGSMAgent').remove();
					break;
			}
			
			switch("${BmcFirmwareType}") {
				case "Vertiv":
					break;
				case "OpenBMC":
					$('#UpdateNodeLogo').remove();
					break;
				default:
				case "AMI":
					$('#UpdateNodeLogo').remove();
					$('#UpdateGSMAgent').remove();
					break;
			}
		};
		
		var checkUpdateFirmwareOption = function() {
			switch($("#firmwareSelect").val()) {
				case "BMC":
					$("#firmwareLabel").text(".zip");
					break;
				case "BIOS":
					$("#firmwareLabel").text(".zip");
					break;
				case "PSU":
					$("#firmwareLabel").text(".hex");
					break;
				case "CPLD_MB":
					$("#firmwareLabel").text("xxx.zip / xxx.tgz");
					break;
				case "CPLD_BPB":
					$("#firmwareLabel").text("xxx.zip / xxx.tgz");
					break;
			}
		};
		
		var checkAgentStatus = function() {
			if($('#UpdateGSMAgent').length > 0) {
				$("#gsmAgentStatus").html("<div style='text-align: center;'><i class='fa fa-circle-o-notch fa-spin fa-2x fa-fw'></i></div>");
				
				$.ajax({
					url: 'getAgentInfo',
					data: {bmcIP:'${IP}'},
					dataType: 'json',
					success: function(_data, status, xhr) {
						if(_data.isAlive) {
							$("#gsmAgentStatus").remove();
							$("#gsmAgentUpdate").show();
						}
						else {
							$("#gsmAgentStatus").html('<spring:message code="webErrMsg29"/>');
							$("#gsmAgentUpdate").remove();
						}
					},
					error: function(xhr, status, error) {
						$("#gsmAgentStatus").html("Get the GSM Agent status failed, cannot update firmware");
						$("#gsmAgentUpdate").remove();
			        	console.log("Get the Agent info failed: [" + xhr.status + "] " + xhr.statusText);
					}
				});
			}
		}
		
		var enableTFTP = function() {
			$("#tftpTypeSelect").prop("disabled", false);
			$("#tftpIPInput").prop("disabled", false);
			unlockButtonAction();
		};
		
		var disableTFTP = function() {
			$("#tftpTypeSelect").prop("disabled", true);
			$("#tftpIPInput").prop("disabled", true);
			lockButtonAction();
		};
		
		var checkTFTPSettings = function() {
			$("#tftpTypeSelect").val("${tftpType}");
			
			if("${tftpEnable}" === "true") {
				enableTFTP();
				tftpEnable = true;
				$("#tftpEnableCheckbox").bootstrapSwitch('state', true);
			}
			else {
				disableTFTP();
				tftpEnable = false;
				$("#tftpEnableCheckbox").bootstrapSwitch('state', false);
			}
			
			//AMI and OpenBMC don't use TFTP to update node firmware, but use the RESTful
			if (("${BmcFirmwareType}" === "AMI") || ("${BmcFirmwareType}" === "OpenBMC")) {
				$("#TFTPSettings").hide();
				enableTFTP();
				tftpEnable = true;
				$("#tftpEnableCheckbox").bootstrapSwitch('state', true);
			}
		};
		
		var getTFTPType = function() {
			return $("#tftpTypeSelect").val();
		};
		
		var getURLIP = function() {
			var hostAddress = window.location.host;
			var ip;
			
			if(hostAddress.includes(":"))
				ip = hostAddress.split(":")[0];
			else
				ip = hostAddress;
			
			if(ip === "localhost")
				ip = "0.0.0.0";
			
			return ip;
		};
		
		$(document).ready(function() {
			checkNodeSupport();
			checkUpdateFirmwareOption();
			checkTFTPSettings();
			checkAgentStatus();
			checkUpdateStatus();
		});
		
		$('.btn-file :file').on({
			'change': function() {
				var numFiles = $(this).get(0).files ? $(this).get(0).files.length : 1;
				var label = $(this).val().replace(/\\/g, '/').replace(/.*\//, '');
				$(this).trigger('fileselect', [numFiles, label]);
			},
			'fileselect': function(event, numFiles, label) {
		        var input = $(this).parents('.input-group').find(':text');
		        var log = numFiles > 1 ? numFiles + ' files selected' : label;
		        
		        if(input.length) {
		        	input.val(log);
		        } else {
		        	if(log) 
		        		alert(log);
		        }
	    	}
		});
		
		$("#firmwareSelect").on("change", function() {
			checkUpdateFirmwareOption();
		});
		
		$("input[id^='startUpdate']").on("click", function() {
			resetUpdateStatus($(this));
		});
		
		$('#showUpdateFirmwareLog').click(function() {	
			$.ajax({
				url: 'nodeUpdateLog',
				data: {IP: ipAddress},
				dataType: 'json',
				success: function(_data, status, xhr) {
					var logArea = document.getElementById('LogArea');
					logArea.innerHTML = _data.log;
				},
				error: function(xhr, status, error) {
					console.log("Get last log failed: [" + xhr.status + "] " + xhr.statusText);
				},
				cache: false
			});
		});
		
		$("#tftpEnableCheckbox").on('switchChange.bootstrapSwitch',function () {
			if($(this).is(":checked")) {
				enableTFTP();
				if(($("#tftpIPInput").val() === "0.0.0.0") || ($("#tftpIPInput").val() === "")) {
					if(getTFTPType() === "Local") {
						$("#tftpIPInput").val(getURLIP());
					}
					else {
						$("#tftpIPInput").val("0.0.0.0");
					}
				}
			}
			else {
				disableTFTP();
			}
		});
		
		$("#tftpTypeSelect").on("change", function() {
			if(getTFTPType() === "Local") {
				$("#tftpIPInput").val(getURLIP());
			}
		});
		
		$("#tftpSetButton").on("click", function() {
			if(!$("#tftpEnableCheckbox").is(":checked")) {
				if(!confirm('<spring:message code="TFTPSettingMsg5"/>'))
					return;
			}
				
			if(("${tftpEnable}" === "true") && $("#tftpEnableCheckbox").is(":checked") && ("${tftpType}" !== getTFTPType())) {
				if(!confirm('<spring:message code="TFTPSettingMsg6"/>'))
					return;
			}
			
			$.ajax({
			    url: 'setTFTPSettings',
			    data: {
			    	enable:$("#tftpEnableCheckbox").is(":checked"),
			    	ip:$("#tftpIPInput").val(),
			    	//type:getTFTPType()
			    	type:"Local"
				},
			    dataType: 'json',
			    success: function(_data, status, xhr) {
					alert(_data.msg);
					window.location.href = "./NodeUpdate?IP=${IP}";
			    },
			    error: function(xhr, status, error) {
			    	alert("Set the TFTP settings failed.");
			        console.log("Set the TFTP settings failed: [" + xhr.status + "] " + xhr.statusText);
			    },
			    cache: false
			});
		});
	</script>

</body>

</html>