<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="x" uri="http://java.sun.com/jsp/jstl/xml" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
	<title>Account</title>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	
	<!-- CSS -->
	<link href="<c:url value="/resources/css/bootstrap/dataTables.bootstrap.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/dataTables.responsive.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/bootstrap.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/metisMenu.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/sb-admin.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/font-awesome/css/font-awesome.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/style_2016.css" />" rel="stylesheet">
	
	<!-- Javascript -->
	<script src="<c:url value="/resources/js/bootstrap/jquery.js" />"></script>
	<script src="<c:url value="/resources/js/bootstrap/bootstrap.min.js" />"></script>
	<script src="<c:url value="/resources/js/bootstrap/jquery.dataTables.min.js"/>"></script>
	<script src="<c:url value="/resources/js/bootstrap/dataTables.bootstrap.min.js"/>"></script>
	
	<style>
		.modal-process-dialog {
			margin-top: 260px !important;
			width: 95px !important;
		}
	</style>
</head>

<body>
	<div id="wrapper">
		<div id="page-wrapper">
			<div class="container-fluid">
				<br>
				<sec:authorize access="hasAnyRole(${Access_AccountManage})">
				<div class="row">
					<div class="col-lg-12">
						<div class="panel panel-default">
							<div class="panel-heading">
								<button type="button" class="btn btn-primary" data-toggle="modal" data-target="#addModal"><spring:message code="Add"/></button>
								<button type="submit" id="delBtn" onclick="clickedDelete()" class="btn btn-primary" disabled><spring:message code="Delete"/></button>
							</div>
							<!-- /.panel-heading -->
							<div class="panel-body">
								<div id="panelCheckBox" class="dataTable_wrapper">
									<table class="table table-striped table-bordered table-hover" id="dataTables">
										<thead>
											<tr>
												<th><spring:message code="Select"/></th>
												<th><spring:message code="NodeSetting5"/></th>
												<th><spring:message code="userName"/></th>
												<th><spring:message code="Level"/></th>
												<th><spring:message code="Type"/></th>
												<th><spring:message code="Edit"/></th>
											</tr>
										</thead>
										<tbody>
											<c:set var="xmltext">${XMLString}</c:set>
											<x:parse xml="${xmltext}" var="output"/>
											<x:forEach select="$output/UserList/user" var="item" varStatus="index">
												<tr class="gradeA" user-no="${index.index}">
													<td><div class="checkbox"><label><input type="checkbox" name="deleteUser" id="del${index.count}" value="<x:out select='$item/username' />"></label></div></td>
													<td><x:out select="$item/enable" /></td>
													<td><x:out select="$item/username" /></td>
													<td><x:out select="$item/privilege" /></td>
													<td><x:out select="$item/type" /></td>
													<td><button type="submit" id="editBtn" onclick="clickedEdit(${index.index})" class="btn btn-primary"><spring:message code="Edit"/></button></td>
												</tr>
											</x:forEach>
										</tbody>
									</table>
								</div>
								<!-- /.dataTable_wrapper -->
							</div>
							<!-- /.panel-body -->
						</div>
						<!-- /.panel -->
					</div>
					<!-- /.col-lg-12 -->
				</div>
				<!-- /.row -->
				
				<div class="row">
					<div class="col-lg-12">
						<div class="panel panel-default">
							<div class="panel-heading">
								<button type="submit" id="saveBTN" onclick="savePermission()" class="btn btn-primary"><spring:message code="Save"/></button>
							</div>
							<!-- /.panel-heading -->
							<div class="panel-body">
								<table class="table table-striped table-bordered table-hover" id="RoleDataTables">
									<thead>
										<tr>
											<th><spring:message code="Permission"/></th>
											<th style="text-align:center;">ROLE_OPERATOR</th>
											<th style="text-align:center;">ROLE_OSADM</th>
											<th style="text-align:center;">ROLE_USER</th>
										</tr>
									</thead>
									<tbody id="PermissionTable" align="center" valign="center">
										<tr>
											<td></td>
											<td></td>
											<td></td>
											<td></td>
										</tr>
									</tbody>
								</table>
								<!-- /.dataTable_wrapper -->
							</div>
							<!-- /.panel-body -->
						</div>
						<!-- /.panel -->
					</div>
					<!-- /.col-lg-12 -->
				</div>
				</sec:authorize>
				<!-- /.row -->

				<div class="row">
					<div class="col-lg-12">
						<div class="panel panel-default">
							<div class="panel-heading">
								<h4><spring:message code="LDAP"/></h4>
							</div>
							<div class="panel-body">
								<div class="dataTable_wrapper">
									<table class="table table-striped table-bordered table-hover">
										<thead>
											<tr>
												<th><spring:message code="LDAP_Host"/></th>
												<th><spring:message code="LDAP_Port"/></th>
											</tr>
										</thead>
										<tbody>
											<c:set var="ldaptext">${LDAPString}</c:set>
											<x:parse xml="${ldaptext}" var="ldap"/>
											<x:set select="$ldap/LDAP/ldap" var="item"/>
											<tr>
												<td><input id="ldap_host" class="form-control" type="text" value=<x:out select="$item/host"/>></td>
												<td><input id="ldap_port" class="form-control" type="text" value=<x:out select="$item/port"/>></td>
											</tr>
										</tbody>
									</table>
								</div>
								<button id="submitButton" class="btn btn-primary"><spring:message code="Submit"/></button>
							</div>
						</div>
					</div>
				</div>

			</div>
			<!-- /.container -->
		</div>
		<!-- /.page-wrapper -->
	</div>
	<!-- /.wrapper -->	
	
	<!-- Add Modal -->
	<div style="color:black" class="modal fade" id="addModal" tabindex="-1" role="dialog" aria-labelledby="addModalLabel">
		<div class="modal-dialog" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title" id="addModalLabel"><spring:message code="Add"/> <spring:message code="Member"/></h4>
				</div>
				
				<div class="modal-body">
					<div class="container-fluid">
						<table class="table table-striped table-bordered table-hover">
							<tbody>
								<tr class="gradeA">
									<td>
										<label for="username"><spring:message code="userName"/></label><br>
										<input type="text" class="form-control" id="username">
									</td>
									<td>
										<label for="password"><spring:message code="password"/></label><br>
										<input type="password" class="form-control" id="password">
									</td>
								</tr>
								<tr class="gradeA">
									<td>
										<label for="username"><spring:message code="NodeSetting5"/></label><br>
										<input type="radio" name="radios1" id="radios1" checked> true
										<input type="radio" name="radios1" id="radios1"> false
									</td>
									<td>
										<label for="username"><spring:message code="Level"/></label><br>
										<select id="level">
											<option value="ROLE_ADMIN" selected> ROLE_ADMIN </option>
											<option value="ROLE_OSADM"> ROLE_OSADM </option>
											<option value="ROLE_OPERATOR"> ROLE_OPERATOR </option>
											<option value="ROLE_USER"> ROLE_USER </option>
										</select>
									</td>
								</tr>
							</tbody>
						</table>
					</div>
				</div>
				
				<div class="modal-footer">
					<button type="submit" id="addBtn" onclick="clickedSubmit()" class="btn btn-primary" disabled><spring:message code="Submit"/></button>
					<button type="button" class="btn btn-primary" data-dismiss="modal"><spring:message code="Close"/></button>
				</div>
			</div>
		</div>
	</div>
	
	<!-- Edit Modal -->
	<div style="color:black" class="modal fade" id="editModal" tabindex="-1" role="dialog" aria-labelledby="editModalLabel">
		<div class="modal-dialog" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title" id="editModalLabel"><spring:message code="Edit"/> <spring:message code="Member"/></h4>
				</div>
				
				<div class="modal-body">
					<div class="container-fluid">
						<table class="table table-striped table-bordered table-hover">
							<tbody>
								<tr class="gradeA">
									<th><spring:message code="Type"/></th>
									<td id="editType"></td>
								</tr>
								<tr class="gradeA">
									<td>
										<label for="username"><spring:message code="userName"/></label><br>
										<input type="text" class="form-control" id="editUsername" disabled>
									</td>
									<td>
										<label for="password"><spring:message code="password"/></label><br>
										<input type="password" class="form-control" id="editPassword">
									</td>
								</tr>
								<tr class="gradeA">
									<td>
										<label for="username"><spring:message code="NodeSetting5"/></label><br>
										<input type="radio" name="editRadios1" id="editRadios1" value="true" checked> true
										<input type="radio" name="editRadios1" id="editRadios1" value="false"> false
									</td>
									<td>
										<label for="username"><spring:message code="Level"/></label><br>
										<select id="editLevel">
											<option value="ROLE_ADMIN" selected> ROLE_ADMIN </option>
											<option value="ROLE_OSADM"> ROLE_OSADM </option>
											<option value="ROLE_OPERATOR"> ROLE_OPERATOR </option>
											<option value="ROLE_USER"> ROLE_USER </option>
										</select>
									</td>
								</tr>
							</tbody>
						</table>
					</div>
				</div>
				
				<div class="modal-footer">
					<button type="submit" id="editSubmitBtn" onclick="clickedEditSubmit()" class="btn btn-primary"><spring:message code="Submit"/></button>
					<button type="button" class="btn btn-primary" data-dismiss="modal"><spring:message code="Close"/></button>
				</div>
			</div>
		</div>
	</div>
	
	
	<div class="modal fade" id="setRoleModal" tabindex="-1" role="dialog" data-backdrop="static" data-keyboard="false">
		<div class="modal-dialog modal-process-dialog" role="document">
			<div class="modal-content">
				<div class="alert" style="margin-bottom: 0px;">
					<i class="fa fa-circle-o-notch fa-spin fa-3x fa-fw"></i>
				</div>
			</div>
		</div>
	</div>
	<script>
		$("#submitButton").on("click", function() {
			var ldap_host = $("#ldap_host").val();
			var ldap_port = $("#ldap_port").val();
			$.ajax({
				url: 'SubmitLDAP',
				data: {ldap_host: ldap_host,
						ldap_port: ldap_port},
				dataType: 'json',
				success: function(_data, status, xhr) {
					if(_data.status == "true") {
						alert("LDAP configuration saved successfully");
					} else {
						alert("Invalid LDAP server configuration");
					}
				},
				error: function(xhr, status, error) {
					console.log("Set the LDAP failed: [" + xhr.status + "] " + xhr.statusText);
				},
				cache: false
			});
		});
		$(document).ready(function() {
			var errCode = '${errCode}';
			if( errCode != 0 )
				alert("<spring:message code="webErrMsg${errCode}"/>");
			
			$('#dataTables').DataTable({
				"scrollX":   true,
				language: {
					"emptyTable": <spring:message code="DataTable1"/>,
					"processing": <spring:message code="DataTable2"/>,
					"loadingRecords": <spring:message code="DataTable3"/>,
					"lengthMenu": <spring:message code="DataTable4"/>,
					"zeroRecords": <spring:message code="DataTable5"/>,
					"info": <spring:message code="DataTable6"/>,
					"infoEmpty": <spring:message code="DataTable7"/>,
					"infoFiltered": <spring:message code="DataTable8"/>,
					"infoPostFix": <spring:message code="DataTable9"/>,
					"search": <spring:message code="DataTable10"/>,
					"paginate": {
						"first": <spring:message code="DataTable11"/>,
						"previous": <spring:message code="DataTable12"/>,
						"next": <spring:message code="DataTable13"/>,
						"last": <spring:message code="DataTable14"/>
					},
					"aria": {
						"sortAscending": <spring:message code="DataTable15"/>,
						"sortDescending": <spring:message code="DataTable16"/>
					}
				}
			});
			
			<x:forEach select="$output/UserList/user" var="item" varStatus="index">
				var value = '<x:out select="$item/username" />';
				if( value.indexOf("admin") > -1 ) {
					$("input[id=del${index.count}]").prop("disabled", true);
					$("tr[user-no=${index.index}]").find("button").prop("disabled", false);
				}
			</x:forEach>
			
			getPermissionTable();
		});
		
		$("#panelCheckBox input[type='checkbox']").click(function() {
			if($("#panelCheckBox input[type='checkbox']").is(":checked")) {
				$("button[ID=delBtn]").prop('disabled', false);
			} else {
				$("button[ID=delBtn]").prop('disabled', true);
			}
		});
		
		$('#username').bind('input', function() {
			var username = $('#username').val();
			var password = $('#password').val();
			if( username != "" && password != "" )
				$("button[ID=addBtn]").prop('disabled', false);
			else
				$("button[ID=addBtn]").prop('disabled', true);
		});
		
		$('#password').bind('input', function() {
			var username = $('#username').val();
			var password = $('#password').val();
			if( username != "" && password != "" )
				$("button[ID=addBtn]").prop('disabled', false);
			else
				$("button[ID=addBtn]").prop('disabled', true);
		});
		
		function clickedDelete() {
			var checkboxes = document.getElementsByName("deleteUser");
			var selectAccount = [];
			for(var i=0; i<checkboxes.length; i++) {
				if( checkboxes[i].checked ) {
					selectAccount.push(checkboxes[i].value);
				}
			}
			window.location.href = "./SetUserAccount?Action=delete&SelectAccount=" + encodeURI(selectAccount);
		}
		
		/* Brian.K 2020/11/11: Check user name contain special characters. */
		function clickedSubmit() {
			var username = document.getElementById('username').value;
			var password = document.getElementById('password').value;
			
			var specialKey = "[`~!@#$^&;*()=|{}':;',\\[\\].<>/?~!#￥……;*()——|{}【】‘;:”“'。,、?]‘' ";
			var strArray = username.toString().split("");
			
			for(var i = 0; i < strArray.length; i++) {
				var key = specialKey.indexOf(strArray[i]);
				if (key != -1) {
					alert("Don't use invalid character: " + specialKey[key].toString());
					document.getElementById("username").value = "";
					return;
				}
			}
			
			var enable = document.getElementById('radios1').checked;
			var level = document.getElementById('level').value;
			var Paras = "&Username=" + username + "&Password=" + password + "&Enable=" + enable + "&Level=" + level;
			window.location.href = "./SetUserAccount?Action=add" + encodeURI(Paras);
		}
		
		function clickedEdit(no) {
			$("#editUsername").val($("tr[user-no=" + no + "]>td:eq(2)").text());
			$("#editPassword").val("");
			$("input:radio[name=editRadios1]").filter("[value=" + $("tr[user-no=" + no + "]>td:eq(1)").text() + "]").prop("checked", true);
			$("#editLevel").val($("tr[user-no=" + no + "]>td:eq(3)").text());
			$("#editType").text($("tr[user-no=" + no + "]>td:eq(4)").text());
			
			if($("tr[user-no=" + no + "]>td:eq(4)").text() == "LDAP") {
				$("#editPassword").prop('disabled', true);
				$("input:radio[name=editRadios1]").prop('disabled', true);
			}
			else {
				$("#editPassword").prop('disabled', false);
				$("input:radio[name=editRadios1]").prop('disabled', false);
			}
			
			/* Brian 2019/08/16: User name "admin" only edit password. */
			if($("#editUsername").val() == "admin") {
				$("#editLevel").prop('disabled', true);
				$("input:radio[name=editRadios1]").prop('disabled', true);
			}
			else {
				$("#editLevel").prop('disabled', false);
				$("input:radio[name=editRadios1]").prop('disabled', false);
			}

			$("#editModal").modal("show");
		}
		
		function clickedEditSubmit() {
			window.location.href = "./SetUserAccount?Action=edit" + encodeURI("&Username=" + $("#editUsername").val() + "&Password=" + $("#editPassword").val() + "&Enable=" + $("input:radio[name=editRadios1]:checked").val() + "&Level=" + $("#editLevel").val());
		}
				
		function getPermissionTable() {
			$.ajax({
				url: 'getPermissionTable',
				type:"POST",
				data: {},
				dataType: 'json',
				success: function(_data, status, xhr) {
					$("#PermissionTable").empty();
					var htmlString = "";
					
					for(var i=0 ; i<_data.PermissionList.length ; i++) {
						if(_data.PermissionList[i] === "Remote Control Access")
							continue;
						
						var index = 1 << i;
						
						htmlString += '<tr>';
						if(_data.PermissionList[i] === "User Account Management") htmlString += '<td align="left"><spring:message code="AccountPermission1"/></td>';
						else if(_data.PermissionList[i] === "Virtual Media Access") htmlString += '<td align="left"><spring:message code="AccountPermission2"/></td>';
						else if(_data.PermissionList[i] === "Power Control Access") htmlString += '<td align="left"><spring:message code="AccountPermission3"/></td>';
						else if(_data.PermissionList[i] === "Logs (Modify/Delete)") htmlString += '<td align="left"><spring:message code="AccountPermission4"/></td>';
						else if(_data.PermissionList[i] === "Configuration") htmlString += '<td align="left"><spring:message code="AccountPermission5"/></td>';
						else if(_data.PermissionList[i] === "Get Information") htmlString += '<td align="left"><spring:message code="AccountPermission6"/></td>';
						else if(_data.PermissionList[i] === "Diagnosis (Use diagnostic tools)") htmlString += '<td align="left"><spring:message code="AccountPermission7"/></td>';
						else if(_data.PermissionList[i] === "Delete Node") htmlString += '<td align="left"><spring:message code="AccountPermission8"/></td>';
						else htmlString += '<td align="left">' + _data.PermissionList[i] + '</td>';
						htmlString += '<td><input type="checkbox" name="checkbox_operator_' + index + '" value="ROLE_OPERATOR" ' + (((_data.ROLE_OPERATOR & index) > 0) ? 'checked' : '') + '></td>';
						htmlString += '<td><input type="checkbox" name="checkbox_osadm_' + index + '"    value="ROLE_OSADM" '    + (((_data.ROLE_OSADM & index) > 0) ? 'checked' : '')    + '></td>';
						htmlString += '<td><input type="checkbox" name="checkbox_user_' + index + '"     value="ROLE_USER" '     + (((_data.ROLE_USER & index) > 0) ? 'checked' : '')     + '></td>';
						htmlString += '</tr>';
					}
					
					$("#PermissionTable").append(htmlString);
				},
				error: function(xhr, status, error) {
					console.log("Get the Permission Table failed: [" + xhr.status + "] " + xhr.statusText);
				},
				cache: false
			});
		}
		
		function savePermission() {
			var operatorSum = 0;
			var osadmSum = 0;
			var userSum = 0;
			$("input[name^='checkbox_operator_']:checked").each(function() {
				operatorSum += Number($(this).attr("name").split("_")[2]);
			});
			$("input[name^='checkbox_osadm_']:checked").each(function() {
				osadmSum += Number($(this).attr("name").split("_")[2]);
			});
			$("input[name^='checkbox_user_']:checked").each(function() {
				userSum += Number($(this).attr("name").split("_")[2]);
			});
			
			$('#setRoleModal').modal('show');
			$.ajax({
				url: 'setPermissionTable',
				type: "POST",
				data: {
					operatorSum: operatorSum,
					osadmSum: osadmSum,
					userSum: userSum
				},
				dataType: 'json',
				success: function(_data, status, xhr) {
					getPermissionTable();
					$('#setRoleModal').modal('hide');
				},
				error: function(xhr, status, error) {
					$('#setRoleModal').modal('hide');
					alert("Failed to apply new role permission!");
					console.log("Set the Permission Table failed: [" + xhr.status + "] " + xhr.statusText);
				},
				cache: false
			});
		}
	</script>
</body>
</html>