<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="x" uri="http://java.sun.com/jsp/jstl/xml" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
	<title>Group Event Log</title>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	
	<!-- CSS -->
	<link href="<c:url value="/resources/css/bootstrap/dataTables.bootstrap.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/dataTables.responsive.css" />" rel="stylesheet">
    <link href="<c:url value="/resources/css/bootstrap/bootstrap.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/metisMenu.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/sb-admin.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/font-awesome/css/font-awesome.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/style_2016.css" />" rel="stylesheet">
	
	<!-- Javascript -->
	<script src="<c:url value="/resources/js/bootstrap/jquery.js" />"></script>
	<script src="<c:url value="/resources/js/bootstrap/bootstrap.min.js" />"></script>
	<script src="<c:url value="/resources/js/bootstrap/jquery.dataTables.min.js"/>"></script>
	<script src="<c:url value="/resources/js/bootstrap/dataTables.bootstrap.min.js"/>"></script>
	<script src="<c:url value="/resources/js/gsm_date.js"/>"></script>
</head>

<body>
	<div id="wrapper">
		<div id="page-wrapper">
			<div class="container-fluid">
				<!-- Page Heading -->
				<div class="row page-title">
                    <div class="col-lg-12">
                        <h3 class="page-header">
                            ${Name}
                        </h3>
                    </div>
                </div>
				<!-- /.row -->
				<br>
				
				<div class="row">
					<div class="col-lg-12">
						<div class="panel panel-default">
							<div class="panel-heading">
								<sec:authorize access="hasAnyRole(${Access_LogsRW})">
								<button type="submit" onclick="clickedClear()" class="btn btn-primary"><spring:message code="Clear"/></button>
								</sec:authorize>
								<button type="submit" onclick="clickedDownload()" class="btn btn-primary"><spring:message code="Download"/></button>
							</div>
							<!-- /.panel-heading -->
							<div class="panel-body">
								<div class="dataTable_wrapper">
									<table id="eventListTable" class="table table-striped table-bordered table-hover">
										<thead>
											<tr>
												<th><spring:message code="Timestamp"/></th>
												<th><spring:message code="Level"/></th>
												<th><spring:message code="Description"/></th>
											</tr>
										</thead>
										<tbody>
										</tbody>
									</table>
								</div>
								<!-- /.dataTable_wrapper -->
							</div>
							<!-- /.panel-body -->
						</div>
						<!-- /.panel -->
					</div>
					<!-- /.col-lg-12 -->
				</div>
				<!-- /.row -->
			</div>
			<!-- /.container-fluid -->
		</div><!-- /#page-wrapper -->
	</div><!-- /#page-wrapper -->
	
	<script>
		var groupEventListTable;
		$(document).ready(function() {
			var errCode = '${errCode}';
			if( errCode != 0 )
				alert("<spring:message code="webErrMsg${errCode}"/>");
			
			groupEventListTable = $('#eventListTable').DataTable({
				"scrollX": true,
				"order": [[ 0, "desc" ]]
			});
			
			getGroupEventList(true);
		});

		var eventListIndex = 0;
		var eventListLength = 25;
		function getGroupEventList(first)
		{
			if(first) {
				groupEventLoading(true);
			}
			
			$.ajax({
		        url: 'getGroupEventList',
		        data: {groupID:'${ID}', dataIndex:eventListIndex, dataLength:eventListLength},
		        dataType: 'json',
		        success: function(_data, status, xhr) {
	        		//console.log(_data);
	        		_data.eventList = JSON.parse(_data.eventList);
	        		
		        	if(_data.eventList.length > 0) {
		        		var eventArray = [];
		        		for(var i=0 ; i<_data.eventList.length ; i++) {
			        		eventArray.push([formatDate(new Date(_data.eventList[i].Timestamp["$date"]), _data.timestampFormat),
			    		        			_data.eventList[i].Level,
			    		        			_data.eventList[i].Description]);
			        	}
		        		groupEventLoading(false, eventArray);
			        	
		        		eventListIndex += eventListLength;
		        		setTimeout(getGroupEventList, 50);
		        	}
		        	else {
		        		groupEventLoading(false);
		        	}
		        },
		        error: function(xhr, status, error) {
		        	groupEventLoading(false);
		        	console.log("Get the group event list failed: [" + xhr.status + "] " + xhr.statusText);
		        },
			    cache: false
		    });
		}
		
		function groupEventLoading(start, dataArray)
		{
			if(start) {
				$("#eventListTable>tbody").html("<tr><td colspan='3' style='text-align: center; padding-left:8px !important;'><i class='fa fa-circle-o-notch fa-spin fa-2x fa-fw'></i></td></tr>");
			}
			else {
				setTimeout(function(){
					if($("#eventListTable>tbody>tr>td").attr("colspan") == 3)
						groupEventListTable.clear().draw(false);
					if(dataArray != null)
						groupEventListTable.rows.add(dataArray).draw(false);
				}, 100);
			}
		}
		
		function clickedClear()
		{
			window.location.href = "./ClearRackLog?ID=" + '${ID}' + "&Filter=GroupList";
		}
		
		function clickedDownload()
		{
			window.location.href = "./NodeEventLog_DownloadLog?Type=Group&ID=" + '${ID}' + "&Filter=GroupList";
		}
	</script>
</body>
</html>