<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="x" uri="http://java.sun.com/jsp/jstl/xml" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
	<title>Group List</title>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<meta name="description" content="">
	<meta name="author" content="">
	
	<!-- CSS -->
	<link href="<c:url value="/resources/css/bootstrap/dataTables.bootstrap.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/dataTables.responsive.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/bootstrap.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/metisMenu.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/sb-admin.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/font-awesome/css/font-awesome.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/style_2016.css" />" rel="stylesheet">
	
	<!-- Javascript -->
	<script src="<c:url value="/resources/js/bootstrap/jquery.js" />"></script>
	<script src="<c:url value="/resources/js/bootstrap/bootstrap.min.js" />"></script>
	<script src="<c:url value="/resources/js/bootstrap/jquery.dataTables.min.js"/>"></script>
	<script src="<c:url value="/resources/js/bootstrap/dataTables.bootstrap.min.js"/>"></script>
</head>

<body>
	<div id="wrapper">
		<div id="page-wrapper">
			<div class="container-fluid">
				<br>
				<div class="row">
					<div class="col-lg-12">
						<div class="panel panel-default">
							<div class="panel-heading">
								<sec:authorize access="hasAnyRole(${Access_Configuration})">
								<button id="add" class="btn btn-primary" type="button"><spring:message code="Add"/></button>
								<button type="button" id="deleteBtn" class="btn btn-primary" disabled><spring:message code="Delete"/></button>
								</sec:authorize>
							</div>
							<!-- /.panel-heading -->
							<div class="panel-body">
								<div class="dataTable_wrapper">
									<table class="table table-striped table-bordered table-hover" id="dataTables">
										<thead>
											<tr>
												<th><spring:message code="Select"/></th>
												<th><spring:message code="Grouplist2"/></th>
												<th><spring:message code="Grouplist3"/></th>
												<th><spring:message code="Grouplist4"/></th>
												<th><spring:message code="Description"/></th>
											</tr>
										</thead>
										<tbody>
											<c:set var="xmltext">${XMLString}</c:set>
											<x:parse xml="${xmltext}" var="output"/>
											<x:forEach select="$output/GroupList/group" var="item" varStatus="index">
												<tr class="gradeA">
													<td><div class="checkbox"><label><input type="checkbox" name="selectGroup" id="del${index.count}" value=<x:out select="$item/groupID" /> <sec:authorize access="!hasAnyRole(${Access_Configuration})">disabled</sec:authorize>></label></div></td>
													<td><x:out select="$item/groupID" /></td>
													<!--  <td><a href="<c:url value="./GroupDashboard?ID=" /><x:out select="$item/groupID" />"><x:out select="$item/groupName" /></a></td> -->
													<td><x:out select="$item/groupName" /></td>
													<td><x:out select="$item/groupType" /></td>
													<td>
														<input class="form-control" id="note_<x:out select="$item/groupID" />" value='<x:out select="$item/description" />' <sec:authorize access="!hasAnyRole(${Access_Configuration})">disabled</sec:authorize>>
														<button id=<x:out select="$item/groupID" /> class="btn btn-primary" onclick="btn(this.id)" <sec:authorize access="!hasAnyRole(${Access_Configuration})">disabled</sec:authorize>><spring:message code="Submit"/></button>
													</td>
												</tr>
											</x:forEach>
										</tbody>
									</table>
								</div>
								<!-- /.dataTable-wrapper -->
							</div>
							<!-- /.panel-body -->
						</div>
						<!-- /.panel -->
					</div>
					<!-- /.col-lg-12 -->
				</div>
				<!-- /.row -->
				
				<div id="addInfo" class="row" style="display:none">
					<div class="col-lg-12">
						<div class="panel panel-default">
							<!-- /.panel-heading -->
							<div class="panel-body">
								<div class="dataTable_wrapper">
									<form action="./CreateGroup" class="login-form">
										<table class="table table-striped table-bordered table-hover">
											<tbody>
												<tr class="gradeA">
													<td><spring:message code="Grouplist3"/></td>
													<td><input type=text id="groupName" class="form-control" name="groupname" value="" required="required"></td>
												</tr>
												<tr class="gradeA">
													<td><spring:message code="Grouplist4"/></td>
													<td><select name="groupType">
														<!-- <option value="OpenRack1.0" selected> OpenRack1.0 </option>
														<option value="OpenRack2.0" > OpenRack2.0 </option>
														<option value="Standard with CMC" > Standard with CMC </option> -->
														<option value="Standard without CMC" > Standard without CMC </option>
														<option value="GPGPU" > GPGPU </option>
													</select></td>
												</tr>
												
											</tbody>
										</table>
										<div>
											<button type="submit" id="createGroupBtn" class="btn btn-primary" ><spring:message code="Submit"/></button>
											<button id="close" type="button" class="btn btn-primary"><spring:message code="Close"/></button>
										</div>
										
									</form>
								</div>
								<!-- /.dataTable-wrapper -->
							</div>
							<!-- /.panel-body -->
						</div>
						<!-- /.panel -->
					</div>
					<!-- /.col-lg-12 -->
				</div>
				
			</div>
		</div>
		<!-- /.container-fluid -->
	</div>
	<!-- /#wrapper -->
	
	<!-- Page-Level Demo Scripts - Tables - Use for reference -->
	<script>
		$(document).ready(function() {
			$("#dataTables").DataTable({
				stateSave:  true,
				pagingType: "full_numbers",
				"scrollX":  true,
				language: {
					"emptyTable": <spring:message code="DataTable1"/>,
					"processing": <spring:message code="DataTable2"/>,
					"loadingRecords": <spring:message code="DataTable3"/>,
					"lengthMenu": <spring:message code="DataTable4"/>,
					"zeroRecords": <spring:message code="DataTable5"/>,
					"info": <spring:message code="DataTable6"/>,
					"infoEmpty": <spring:message code="DataTable7"/>,
					"infoFiltered": <spring:message code="DataTable8"/>,
					"infoPostFix": <spring:message code="DataTable9"/>,
					"search": <spring:message code="DataTable10"/>,
					"paginate": {
						"first": <spring:message code="DataTable11"/>,
						"previous": <spring:message code="DataTable12"/>,
						"next": <spring:message code="DataTable13"/>,
						"last": <spring:message code="DataTable14"/>
					},
					"aria": {
						"sortAscending": <spring:message code="DataTable15"/>,
						"sortDescending": <spring:message code="DataTable16"/>
					}
				}
			});
		});
		
		function btn(click_id) {
			var id, note, URL;
			id = click_id;
			note = document.getElementById("note_"+click_id).value;	
			URL = "./GroupEdit?ID=" + id + "&note=" + note;
			window.alert("<spring:message code="Submit"/> <spring:message code="Description"/>: " + note);
			window.location.href = URL;
			
		}
		
		$("input[type='checkbox']").click(function() {
			if($("input[type='checkbox']").is(":checked")) {
				$("button[ID=deleteBtn]").prop("disabled", false);
			} else {
				$("button[ID=deleteBtn]").prop("disabled", true);
			}
		});
		
		var URL;
		var groupArray = [];
		$("#deleteBtn").click(function() {
			$("input:checkbox:checked").each(function(){
				groupArray.push($(this).val());
			});
			URL = "./DeleteGroup?selectGroup=" + groupArray;
			window.location.href = URL;
		});
		
		$("#add").click(function(){
			if(addInfo.style.display == 'none')
				addInfo.style.display='';
		});
		
		$("#close").click(function(){
			if(addInfo.style.display == '')
				addInfo.style.display='none';
		});
	</script>
</body>
</html>