<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="x" uri="http://java.sun.com/jsp/jstl/xml" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
	<title>GSM Alert Management</title>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	
	<!-- CSS-->
	<link href="<c:url value="/resources/css/bootstrap/bootstrap-switch.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/dataTables.bootstrap.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/dataTables.responsive.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/bootstrap.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/metisMenu.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/sb-admin.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/font-awesome/css/font-awesome.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/style_2016.css" />" rel="stylesheet">
	
	<!-- Javascript -->
	<script src="<c:url value="/resources/js/bootstrap/jquery.js" />"></script>
	<script src="<c:url value="/resources/js/bootstrap/bootstrap.min.js" />"></script>
	<script src="<c:url value="/resources/js/bootstrap/bootstrap-switch.min.js" />"></script>
	<script src="<c:url value="/resources/js/bootstrap/jquery.dataTables.min.js"/>"></script>
	<script src="<c:url value="/resources/js/bootstrap/dataTables.bootstrap.min.js"/>"></script>
</head>

<body>
	<div id="wrapper">
		<div id="page-wrapper">
			<div class="container-fluid">
				<br>
				<div class="row">
					<div class="col-lg-12">
						<c:set var="xmltext_snmp">${XMLString_snmp}</c:set>
						<x:parse xml="${xmltext_snmp}" var="outputSNMP"/>
						<x:set select="$outputSNMP/SNMPList/snmp" var="item"/>
						
						<sec:authorize access="hasAnyRole(${Access_Configuration})">
						<div class="panel panel-default">
							<div class="panel-heading">
								<h4><spring:message code="GSMSNMP"/></h4>
							</div><!-- /.panel-heading -->
							<div class="panel-body">
								<div class="panel panel-default">
									<div style="padding: 10px 15px;text-decoration:underline;">
										<h4><spring:message code="GSMSNMP1"/></h4>
									</div><!-- /.panel-heading -->
									
									<div class="panel-body">
										<div class="dataTable_wrapper">
											<table class="table table-striped table-bordered table-hover" id="dataTables">
												<tbody>
													<tr>
														<td><spring:message code="GSMSNMP3"/></td>
														<td><input type="checkbox" id="check0" checked data-size="mini"></td>
													</tr>
													<tr>
														<td><spring:message code="GSMSNMP4"/></td>
														<td>
															<select id="localAddress">
																<x:forEach select="$outputSNMP/SNMPList/localAddressList" var="ipList">
																<option value="<x:out select="$ipList/ip" />" <x:if select="$item/localAddress = $ipList/ip">selected</x:if>> <x:out select="$ipList/ip" /> </option>
																</x:forEach>
															</select>
														</td>
													</tr>
													<tr>
														<td><spring:message code="GSMSNMP5"/></td>
														<td>
															<select id="status">
																<!-- <option id="level0" value="0"> DEBUG </option>
																<option id="level1" value="1"> INFO </option>
																<option id="level2" value="2"> WARN </option>
																<option id="level3" value="3"> ERROR </option>
																<option id="level4" value="4"> FATAL </option> -->
																<option id="level3" value="3"> Unknown </option>
																<option id="level2" value="2"> Non-Critical </option>
																<option id="level1" value="1"> Critical </option>
															</select>
														</td>
													</tr>
												</tbody>
											</table>
											<spring:message code="GSMSNMP7"/><br>
											&nbsp;&nbsp;&nbsp;&nbsp;<spring:message code="GSMSNMP7-1"/><br>
											&nbsp;&nbsp;&nbsp;&nbsp;<spring:message code="GSMSNMP7-2"/><br>
											&nbsp;&nbsp;&nbsp;&nbsp;<spring:message code="GSMSNMP7-3"/>
										</div>
									</div><!-- /.panel-body -->
								</div><!-- /.panel -->
								
								<div class="panel panel-default">
									<div style="padding: 10px 15px;text-decoration:underline;">
										<h4><spring:message code="GSMSNMP2"/></h4>
									</div><!-- /.panel-heading -->
									
									<div class="panel-body">
										<div class="dataTable_wrapper">
											<table class="table table-striped table-bordered table-hover" id="dataTables2">
												<thead>
													<tr>
														<th><spring:message code="NodeSetting3"/></th>
														<th><spring:message code="NodeSetting5"/></th>
														<th><spring:message code="NodeSetting6"/></th>
													</tr>
												</thead>
												<tbody>
													<tr>
														<td>1</td>
														<td><input type="checkbox" id="check1" checked data-size="mini"><br><br></td>
														<td><input type="text" id="check1_addr" value="<x:out select="$item/ipv4Destination1" />"></td>
													</tr>
													<tr>
														<td>2</td>
														<td><input type="checkbox" id="check2" checked data-size="mini"><br><br></td>
														<td><input type="text" id="check2_addr" value="<x:out select="$item/ipv4Destination2" />"></td>
													</tr>
													<tr>
														<td>3</td>
														<td><input type="checkbox" id="check3" checked data-size="mini"><br><br></td>
														<td><input type="text" id="check3_addr" value="<x:out select="$item/ipv4Destination3" />"></td>
													</tr>
													<tr>
														<td>4</td>
														<td><input type="checkbox" id="check4" checked data-size="mini"><br><br></td>
														<td><input type="text" id="check4_addr" value="<x:out select="$item/ipv4Destination4" />"></td>
													</tr>
												</tbody>
											</table>
										</div>
									</div><!-- /.panel-body -->
								</div><!-- /.panel -->
								<button type="button" onclick="clickedSubmit()" class="btn btn-primary"><spring:message code="Submit"/></button>
							</div>
						</div>
						</sec:authorize>
						
						<sec:authorize access="hasAnyRole(${Access_Configuration})">
						<div class="panel panel-default">
							<div class="panel-heading">
								<h4><spring:message code="GSMSMTP1"/></h4>
							</div>
							
							<div class="panel-body">
								<form action="SaveSMTP">
									<div class="dataTable_wrapper">
										<c:set var="xmltext_smtp">${XMLString_smtp}</c:set>
										<x:parse xml="${xmltext_smtp}" var="outputSMTP"/>
										<x:set select="$outputSMTP/SMTPList/Property" var="item2"/>
										<table class="table table-striped table-bordered table-hover">
											<thead>
												<tr>
													<th><spring:message code="GSMSMTP2"/></th>
													<th><spring:message code="GSMSMTP3"/></th>
													<th><spring:message code="GSMSMTP4"/></th>
													<th><spring:message code="GSMSMTP5"/></th>
													<!-- <th><spring:message code="GSMSMTP6"/></th> -->
													<th><spring:message code="GSMSMTP7"/></th>
													<th><spring:message code="GSMSMTP17"/></th>
													<th><spring:message code="GSMSMTP16"/></th>
												</tr>
											</thead>
											<tbody>
												<x:forEach select="$outputSMTP/SMTPList/List" end="0" var="item_smtp">
													<tr>
														<td><input type="hidden" name="ID" value="<x:out select="$item_smtp/ID"/>"><input name="Host" class="form-control" type="text" style="border-color: rgba(255, 255, 255, 0); background-color: rgba(255, 255, 255, 0); box-shadow:none;" value="<x:out select="$item_smtp/Host" />"></td>
														<td><input name="Port" class="form-control" type="text" style="border-color: rgba(255, 255, 255, 0); background-color: rgba(255, 255, 255, 0); box-shadow:none;" value="<x:out select="$item_smtp/Port" />"></td>
														<td><input id="Account" name="Account" class="form-control" type="text" style="border-color: rgba(255, 255, 255, 0); background-color: rgba(255, 255, 255, 0); box-shadow:none;" value="<x:out select="$item_smtp/Account" />"></td>
														<td><input id="Password" name="Password" class="form-control" type="password" style="border-color: rgba(255, 255, 255, 0); background-color: rgba(255, 255, 255, 0); box-shadow:none;" value="<x:out select="$item_smtp/Password" />"></td>
														<!-- <td><input name="Name" class="form-control" type="text" style="border-color: rgba(255, 255, 255, 0); background-color: rgba(255, 255, 255, 0); box-shadow:none;" value="<x:out select="$item/Name" />" <sec:authorize ifNotGranted="ROLE_ADMIN">disabled</sec:authorize>></td> -->
														<td><input name="Addr" class="form-control" type="text" style="border-color: rgba(255, 255, 255, 0); background-color: rgba(255, 255, 255, 0); box-shadow:none;" value="<x:out select="$item_smtp/Addr" />"></td>
														<td><input onchange="authChange(this.checked)" type="checkbox" name="Auth" id="Auth"></td>
														<td><input type="checkbox" name="TLS" id="TLS"></td>
													</tr>
												</x:forEach>
											</tbody>
										</table>
										<br/>
										<table class="table table-striped table-bordered table-hover" id="tab_logic">
											<thead>
												<tr>
													<th><spring:message code="GSMSMTP8"/></th>
													<th><spring:message code="GSMSMTP7"/></th>
													<th><spring:message code="GSMSMTP9"/></th>
													<th><spring:message code="GSMSMTP10"/></th>
												</tr>
											</thead>
											<tbody>
												<x:forEach select="$outputSMTP/SMTPList/List" begin="1" var="item_smtp">
													<tr>
														<td><input type="hidden" name="ID" value="<x:out select="$item_smtp/ID"/>"><input type="checkbox" name="Enable" value="<x:out select="$item_smtp/ID" />" <x:out select="$item_smtp/Enable" />></td>
														<td><input name="SubAddr" class="form-control" type="text" style="border-color: rgba(255, 255, 255, 0); background-color: rgba(255, 255, 255, 0); box-shadow:none;" value="<x:out select="$item_smtp/SubAddr" />"></td>
														<td>
															<select name="eventLevel">
																<!-- <option id="level0" value="0" <x:if select="$item_smtp/eventLevel = 0">selected</x:if>> DEBUG </option>
																<option id="level1" value="1" <x:if select="$item_smtp/eventLevel = 1">selected</x:if>> INFO </option>
																<option id="level2" value="2" <x:if select="$item_smtp/eventLevel = 2">selected</x:if>> WARN </option>
																<option id="level3" value="3" <x:if select="$item_smtp/eventLevel = 3">selected</x:if>> ERROR </option>
																<option id="level4" value="4" <x:if select="$item_smtp/eventLevel = 4">selected</x:if>> FATAL </option> -->
																<option id="level3" value="3" <x:if select="$item_smtp/eventLevel >= 3">selected</x:if><x:if select="$item_smtp/eventLevel < 1">selected</x:if>> Unknown </option>
																<option id="level2" value="2" <x:if select="$item_smtp/eventLevel = 2">selected</x:if>> Non-Critical </option>
																<option id="level1" value="1" <x:if select="$item_smtp/eventLevel = 1">selected</x:if>> Critical </option>
															</select>
														</td>
														<td><input type="checkbox" name="Delete" value="<x:out select="$item_smtp/ID" />"></td>
													</tr>
												</x:forEach>
												<tr id='new0'></tr>
											</tbody>
										</table>
									</div>
									<spring:message code="GSMSNMP7"/><br>
									&nbsp;&nbsp;&nbsp;&nbsp;<spring:message code="GSMSNMP7-1"/><br>
									&nbsp;&nbsp;&nbsp;&nbsp;<spring:message code="GSMSNMP7-2"/><br>
									&nbsp;&nbsp;&nbsp;&nbsp;<spring:message code="GSMSNMP7-3"/>
									<br/><br/>
									<table style="width:100%">
										<tr>
											<td style="width:50%">
												<button type="submit" class="btn btn-primary"><i class="fa fa-floppy-o"></i>&nbsp;&nbsp;<spring:message code="Save"/></button>&nbsp;&nbsp;&nbsp;
												<a class="btn btn-primary" id="Cancel_data" href="/GSM/GSMAlertManagement"><i class="fa fa-times"></i>&nbsp;&nbsp;<spring:message code="Cancel"/></a>&nbsp;&nbsp;&nbsp;
												<a class="btn btn-primary" id="Send_testmail" href="SendTestMail"><i class="fa fa-paper-plane"></i>&nbsp;&nbsp;<spring:message code="GSMSMTP11"/></a>
											</td>
											<td style="text-align:right; width:50%;">
												<a id="Add_data"><i class="fa fa-plus-circle fa-2x"></i></a>
											</td>
										</tr>
									</table>
								</form>
							</div>			
						</div>
						</sec:authorize>
						<%-- <br />
						<div class="panel panel-default">
							<div class="panel-heading">
								<h4><spring:message code="GSMSMTP12"/></h4>
							</div>
							<!-- /.panel-heading -->
							<div class="panel-body">
								<form action="SendTestMail">
									<div class="dataTable_wrapper">
										<table class="table table-striped table-bordered table-hover">
											<thead>
												<tr>
													<th><spring:message code="GSMSMTP13"/></th>
												</tr>
											</thead>
											<tbody>
												<tr>
													<td><input name="mailTo" class="form-control" type="text" style="border-color: rgba(255, 255, 255, 0); background-color: rgba(255, 255, 255, 0); box-shadow:none;" /></td>
												</tr>
											</tbody>
											<thead>
												<tr>
													<th><spring:message code="GSMSMTP14"/></th>
												</tr>
											</thead>
											<tbody>
												<tr>
													<td><input name="mailTitle" class="form-control" type="text" style="border-color: rgba(255, 255, 255, 0); background-color: rgba(255, 255, 255, 0); box-shadow:none;" /></td>
												</tr>
											</tbody>
											<thead>
												<tr>
													<th><spring:message code="GSMSMTP15"/></th>
												</tr>
											</thead>
											<tbody>
												<tr>
													<td><textarea name="mailContent" rows="5" class="form-control" style="border-color: rgba(255, 255, 255, 0); background-color: rgba(255, 255, 255, 0); box-shadow:none;"></textarea></td>
												</tr>
											</tbody>
										</table>
									</div>
									<table style="width:100%">
										<tr>
											<td style="width:50%">
												<button type="submit" class="btn btn-primary"><i class="fa fa-paper-plane"></i>&nbsp;&nbsp;<spring:message code="Send"/></button>&nbsp;&nbsp;&nbsp;
												<a class="btn btn-primary" id="Cancel_data" href="/GSM/GSMAlertManagement"><i class="fa fa-times"></i>&nbsp;&nbsp;<spring:message code="Cancel"/></a>
											</td>
										</tr>
									</table>
								</form>
							</div>
							<!-- /.panel-body -->
						</div> --%>
					</div><!-- /.col-lg-12 -->
				</div><!-- /.row -->
			</div><!-- /.container-fluid -->
		</div><!-- /.page-wrapper -->
	</div><!-- /#page-wrapper -->
	
	<!-- Page-Level Demo Scripts - Tables - Use for reference -->
	<sec:authorize access="!hasAnyRole(${Access_Configuration})" var="var_not_Access_Configuration"/>
	<script>
	
	$(document).ready(function() {
		<sec:authorize ifAnyGranted="${Access_Configuration_JS}">
		var isAuth = '<x:out select="$item2/Auth" />';
		var isTLS = '<x:out select="$item2/TLS" />';
		
		if (isAuth == "true") {
			$("#Auth").prop("checked", true);
			$("#Account").prop("readOnly", false);
			$("#Password").prop("readOnly", false);
		} else {
			$("#Auth").prop("checked", false);
			$("#Account").prop("readOnly", true);
			$("#Password").prop("readOnly", true);
		}
		
		if (isTLS == "true")
			$("#TLS").prop("checked", true);
		else
			$("#TLS").prop("checked", false);
		</sec:authorize>
		
		var errCode = '${errCode}';
		if( errCode != 0 )
			alert("<spring:message code="webErrMsg${errCode}"/>");
		
		var statusArray = [];
		statusArray.push('<x:out select="$item/enabled" />');
		statusArray.push('<x:out select="$item/ipv4Enabled1" />');
		statusArray.push('<x:out select="$item/ipv4Enabled2" />');
		statusArray.push('<x:out select="$item/ipv4Enabled3" />');
		statusArray.push('<x:out select="$item/ipv4Enabled4" />');
		
		for(var i=0; i<statusArray.length; i++) {
			if( statusArray[i].localeCompare('true') == 0 ) {
				<c:if test="${var_not_Access_Configuration}">$("#check" + i).prop('checked', true);</c:if>
				$("#check" + i).bootstrapSwitch('state', true);
			} else {
				<c:if test="${var_not_Access_Configuration}">$("#check" + i).prop('checked', false);</c:if>
				$("#check" + i).bootstrapSwitch('state', false);
			}
		}
		
		<sec:authorize ifAnyGranted="${Access_Configuration_JS}">
		//$('#status')[0].selectedIndex = '<x:out select="$item/actionLevel" />';
		
		//New event level range is 1~3 (Critical, Non-Critical, Unknown)
		var snmpLevel = '<x:out select="$item/actionLevel" />';	
		snmpLevel = parseInt(snmpLevel);
		if((snmpLevel < 1) || (snmpLevel > 3))
			snmpLevel = 3;
		$('#status').val(snmpLevel);
		</sec:authorize>
		
		$("#localAddress").on("change", function(){
			clickedSubmit();
		});
		
		//SMTP code function
		
		$(".form-control").focus(function(){
			var objTD = $(this);
			//objTD.css("text-align", "center");
			objTD.css("border-color", "#66afe9");
			objTD.css("box-shadow", "inset 0 1px 1px rgba(0,0,0,.075), 0 0 8px rgba(102,175,233,.6)");
			objTD.select();
			
			objTD.blur(function() {
				//objTD.css("text-align", "left");
				objTD.css("border-color", "rgba(255, 255, 255, 0)");
				objTD.css("box-shadow", "none");
			});
		});
		
		var item=0;
		$("#Add_data").click(function(){
			
			$('#new'+item).html("" +
					"<td><input type=\"hidden\" name=\"ID\" value=\"new" + item + "\"><input type=\"checkbox\" name=\"Enable\" value=\"new" + item + "\"></td>" +
					"<td><input name=\"SubAddr\" class=\"form-control\" type=\"text\" style=\"border-color: rgba(255, 255, 255, 0); background-color: rgba(255, 255, 255, 0); box-shadow:none;\"></td>" +
					"<td>" +
					"<select name=\"eventLevel\">" +
					/*"<option id=\"level0\" value=\"0\" selected> DEBUG </option>" +
					"<option id=\"level1\" value=\"1\"> INFO </option>" +
					"<option id=\"level2\" value=\"2\"> WARN </option>" +
					"<option id=\"level3\" value=\"3\"> ERROR </option>" +
					"<option id=\"level4\" value=\"4\"> FATAL </option>" +*/
					"<option id=\"level3\" value=\"3\"selected> Unknown </option>" +
					"<option id=\"level2\" value=\"2\"> Non-Critical </option>" +
					"<option id=\"level1\" value=\"1\"> Critical </option>" +
					"</select>" +
					"</td>" +
					"<td><input type=\"checkbox\" name=\"Delete\" value=\"new" + item + "\"></td>");
			
			$('#tab_logic').append('<tr id="new'+(item+1)+'"></tr>');
			item++;
		});
	});
	
	//$("input[type=checkbox]").bootstrapSwitch();
	
	$("input[type=checkbox]").on('switchChange.bootstrapSwitch',function () {
		var id = $(this).attr("id");
		var textID = id + "_addr";
		var noIP = "0.0.0.0";
		
		if($("#" + id).is(":checked")) {
			$("input[id=" + textID + "]").prop("disabled", false);
		} else {
			$("input[id=" + textID + "]").val(noIP);
			$("input[id=" + textID + "]").prop("disabled", true);
		}
	});
	
	/*William 2018/11/22: Avoid empty strings*/
	function clickedSubmit() {
		var e = document.getElementById("status");
		var action = e.options[e.selectedIndex].value;
		var ipv4Enable = [], ipv4Destination = [];
		
		for(var i=0; i<=4; i++) {
			var id = "check" + i;
			var textID = id + "_addr";
			var ipv4 = "";
			var noIP = "0.0.0.0";
			
			if (i == 0) {
				ipv4 = document.getElementById("localAddress").value;
			}
			else {
				ipv4 = document.getElementById(textID).value;
			}
			
			if (ipv4 == "") {
				ipv4 = noIP;
			}
				
			if( /^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$|^(([a-zA-Z]|[a-zA-Z][a-zA-Z0-9\-]*[a-zA-Z0-9])\.)*([A-Za-z]|[A-Za-z][A-Za-z0-9\-]*[A-Za-z0-9])$|^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$/.test(ipv4) ) {
				if (ipv4 == noIP) {
					ipv4Enable.push(false);
				}
				else {
					ipv4Enable.push(document.getElementById(id).checked);
				}
				ipv4Destination.push(ipv4);
			} 
			else {
				var msg = (i == 0) ? "Host Address" : "<spring:message code="NodeSetting3"/>" + i;
				alert(msg + ": <spring:message code="NodeSetting8"/>");
				return;
			}
		}
		
		window.location.href = "./SetGSMSNMP?action=" + action + "&ipv4Enable=" + ipv4Enable + "&ipv4Destination=" + ipv4Destination;
	}
	
	function authChange(isAuth) {
		if (isAuth) {
			$("#Account").prop("readOnly", false);
			$("#Password").prop("readOnly", false);
		} else {
			$("#Account").prop("readOnly", true);
			$("#Password").prop("readOnly", true);
		}
	}
		
	</script>
</body>
</html>
