<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="x" uri="http://java.sun.com/jsp/jstl/xml" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
    <head>
        <title>Group Alert Management</title>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        
        <!-- CSS -->
        <link href="<c:url value="/resources/css/bootstrap/bootstrap-switch.min.css" />" rel="stylesheet">
        <link href="<c:url value="/resources/css/bootstrap/dataTables.bootstrap.css" />" rel="stylesheet">
        <link href="<c:url value="/resources/css/bootstrap/dataTables.responsive.css" />" rel="stylesheet">
        <link href="<c:url value="/resources/css/bootstrap/bootstrap.min.css" />" rel="stylesheet">
        <link href="<c:url value="/resources/css/bootstrap/metisMenu.min.css" />" rel="stylesheet">
        <link href="<c:url value="/resources/css/bootstrap/sb-admin.css" />" rel="stylesheet">
        <link href="<c:url value="/resources/css/font-awesome/css/font-awesome.min.css" />" rel="stylesheet">
        <link href="<c:url value="/resources/css/bootstrap/style_2016.css" />" rel="stylesheet">
        
        <!-- Javascript -->
        <script src="<c:url value="/resources/js/bootstrap/jquery.js" />"></script>
        <script src="<c:url value="/resources/js/bootstrap/bootstrap.min.js" />"></script>
        <script src="<c:url value="/resources/js/bootstrap/bootstrap-switch.min.js" />"></script>
        <script src="<c:url value="/resources/js/bootstrap/jquery.dataTables.min.js"/>"></script>
        <script src="<c:url value="/resources/js/bootstrap/dataTables.bootstrap.min.js"/>"></script>
    </head>
    
    <body>
        <div id="wrapper">
            <div id="page-wrapper">
                <div class="container-fluid">
                    <!-- Page Heading -->
                    <div class="row page-title">
                        <div class="col-lg-12">
                            <h3 class="page-header" id="groupHeader">
                                ${Name}
                            </h3>
                        </div>
                    </div>
                    <br>
                    
                    <!-- Trap -->
                    <sec:authorize access="hasAnyRole(${Access_Configuration})">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="panel panel-default">
                                <div class="panel-heading">
                                    <h4><spring:message code="NodeSetting2"/></h4>
                                </div>
                                <div class="panel-body">
                                    <div class="dataTable_wrapper">
                                        <table class="table table-striped table-bordered table-hover" id="trapDataTables">
                                            <thead>
                                                <tr>
                                                    <th><spring:message code="NodeSetting16"/></th>
                                                    <th><spring:message code="NodeSetting5"/></th>
                                                    <th><spring:message code="NodeSetting17"/></th>
                                                    <th><spring:message code="NodeSetting18"/></th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </table>
                                    </div>
                                    <button id="setTrap" type="button" onclick="SetMember()" class="btn btn-primary"><spring:message code="Submit"/></button>
                                </div>
                            </div>
                        </div>
                    </div>
                    </sec:authorize>
                    <!-- Trap -->
                    
					<div style="color:black" class="modal fade" id="member" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
						<div class="modal-dialog" role="document">
							<div class="modal-content">
								<div class="modal-header">
									<h4 class="modal-title" id="myModalLabel"><spring:message code="NodeSetting2"/></h4>
								</div>
								<div class="modal-body">
									<div id="modalCheckBox" class="dataTable_wrapper">
										<table class="table table-striped table-bordered table-hover" id="dataTables-example2">
											<thead>
												<tr>
													<th><spring:message code="Select"/></th>
													<th><spring:message code="Nodelist2"/></th>
													<th><spring:message code="Nodelist3"/></th>
													<th><spring:message code="Nodelist5"/></th>
												</tr>
											</thead>
											<tbody>
												<c:set var="xmltext">${XMLString}</c:set>
												<x:parse xml="${xmltext}" var="output"/>
												<x:forEach select="$output/NodeList/node" var="item">
													<tr class="gradeA">
														<td><div class="checkbox"><label><input type="checkbox" name="addIP" value=<x:out select="$item/bmcIP" />></label></div></td>
														<td><x:out select="$item/bmcMAC" /></td>
														<td><x:out select="$item/bmcIP" /></td>
														<x:choose>
															<x:when select="$item/nodeType = 'SMC'">
																<td>BMC</td>
															</x:when>
															<x:otherwise>
																<td><x:out select="$item/nodeType" /></td>
															</x:otherwise>
														</x:choose>
													</tr>
												</x:forEach>
											</tbody>
										</table>
									</div>
								</div>
								<div class="modal-footer">
									<button type="submit" id="addBtn" onclick="clickedSubmitTRAP()" class="btn btn-primary" disabled><spring:message code="Submit"/></button>
									<button type="button" class="btn btn-primary" data-dismiss="modal"><spring:message code="Close"/></button>
								</div>
							</div>
						</div>
					</div>
					
                    <!-- PEF - RMC/CMC -->
                    <!-- <sec:authorize access="hasAnyRole(${Access_Configuration})">
                    <div id="GroupPEF1" class="row">
                        <div class="col-lg-12">
                            <div class="panel panel-default">
                                <div class="panel-heading">
                                    <h4 id="panelHead1"><spring:message code="Group"/> <spring:message code="NodePEF11"/> (PEF)</h4>
                                </div>
                                <div class="panel-body"> -->
                                    <!-- <div class="dataTable_wrapper">
                                        <table class="table table-striped table-bordered table-hover">
                                            <h4><spring:message code="NodePEF1"/></h4>
                                            <thead>
                                                <tr><th><spring:message code="NodePEF4"/></th></tr>
                                            </thead>
                                            <tbody>
                                                <c:choose>
                                                    <c:when test="${BmcType == 'RMC'}">
                                                        <tr style="display:none;"><td><input type="checkbox" id="action1" value="0"> <spring:message code="NodePEF7"/></td></tr>
                                                        <tr style="display:none;"><td><input type="checkbox" id="action2" value="1"> <spring:message code="NodePEF8"/></td></tr>
                                                        <tr style="display:none;"><td><input type="checkbox" id="action3" value="2"> <spring:message code="NodePEF9"/></td></tr>
                                                    </c:when>
                                                <c:otherwise>
                                                    <tr><td><input name="pefCheckbox" type="checkbox" id="action1" value="0"> <spring:message code="NodePEF7"/></td></tr>
                                                    <tr><td><input name="pefCheckbox" type="checkbox" id="action2" value="1"> <spring:message code="NodePEF8"/></td></tr>
                                                    <tr><td><input name="pefCheckbox" type="checkbox" id="action3" value="2"> <spring:message code="NodePEF9"/></td></tr>
                                                </c:otherwise>
                                              </c:choose>  
                                              <tr><td><input name="pefCheckbox" type="checkbox" id="action4" value="3"> <spring:message code="NodePEF10"/></td></tr>
                                            </tbody>
                                        </table>
                                    </div>
                                    <br> -->
                                    <!-- <h4><spring:message code="NodePEF12"/></h4>
                                    <input type="checkbox" id="enable"> <spring:message code="NodePEF3"/><br><br> -->
                                    <!-- <div class="dataTable_wrapper">
                                        <table class="table table-striped table-bordered table-hover" id="pefDataTables1">
                                            <thead>
                                                <tr>
                                                    <th><spring:message code="NodePEF5"/></th>
                                                    <th><spring:message code="NodePEF6"/></th>
                                                    <th><spring:message code="NodePEF7"/></th>
                                                    <th><spring:message code="NodePEF8"/></th>
                                                    <th><spring:message code="NodePEF9"/></th>
                                                    <th><spring:message code="NodePEF10"/></th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </table>
                                    </div>
                                  <button type="button" onclick="setNodePEF()" class="btn btn-primary"><spring:message code="Submit"/></button>  
                                </div>
                            </div>
                        </div>
                    </div>
                    </sec:authorize> -->
                    <!-- PEF - RMC/CMC -->
                    
                    <!-- PEF -->
                    <!-- <sec:authorize access="hasAnyRole(${Access_Configuration})">
                    <div id="GroupPEF2" class="row">
                        <div class="col-lg-12">
                            <div class="panel panel-default">
                                <div class="panel-heading">
                                    <h4 id="panelHead2"><spring:message code="Group"/> <spring:message code="NodePEF11"/> (PEF)</h4>
                                </div>
                                <div class="panel-body"> -->
                                    <!-- <div class="dataTable_wrapper">
                                        <table class="table table-striped table-bordered table-hover">
                                            <h4><spring:message code="NodePEF1"/></h4>
                                            <thead>
                                                <tr><th><spring:message code="NodePEF4"/></th></tr>
                                            </thead>
                                            <tbody>
                                                <c:choose>
                                                    <c:when test="${BmcType == 'RMC'}">
                                                        <tr style="display:none;"><td><input type="checkbox" id="action1" value="0"> <spring:message code="NodePEF7"/></td></tr>
                                                        <tr style="display:none;"><td><input type="checkbox" id="action2" value="1"> <spring:message code="NodePEF8"/></td></tr>
                                                        <tr style="display:none;"><td><input type="checkbox" id="action3" value="2"> <spring:message code="NodePEF9"/></td></tr>
                                                    </c:when>
                                                <c:otherwise>
                                                    <tr><td><input name="pefCheckbox" type="checkbox" id="action1" value="0"> <spring:message code="NodePEF7"/></td></tr>
                                                    <tr><td><input name="pefCheckbox" type="checkbox" id="action2" value="1"> <spring:message code="NodePEF8"/></td></tr>
                                                    <tr><td><input name="pefCheckbox" type="checkbox" id="action3" value="2"> <spring:message code="NodePEF9"/></td></tr>
                                                </c:otherwise>
                                              </c:choose>  
                                              <tr><td><input name="pefCheckbox" type="checkbox" id="action4" value="3"> <spring:message code="NodePEF10"/></td></tr>
                                            </tbody>
                                        </table>
                                    </div>
                                    <br> -->
                                    <!-- <h4><spring:message code="NodePEF12"/></h4>
                                    <input type="checkbox" id="enable"> <spring:message code="NodePEF3"/><br><br> -->
                                    <!-- <div class="dataTable_wrapper">
                                        <table class="table table-striped table-bordered table-hover" id="pefDataTables2">
                                            <thead>
                                                <tr>
                                                    <th><spring:message code="NodePEF5"/></th>
                                                    <th><spring:message code="NodePEF6"/></th>
                                                    <th><spring:message code="NodePEF7"/></th>
                                                    <th><spring:message code="NodePEF8"/></th>
                                                    <th><spring:message code="NodePEF9"/></th>
                                                    <th><spring:message code="NodePEF10"/></th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </table>
                                    </div>
                                  <button type="button" onclick="setGroupPEF()" class="btn btn-primary"><spring:message code="Submit"/></button>  
                                </div>
                            </div>
                        </div>
                    </div>
                    </sec:authorize> -->
                    <!-- PEF -->
                </div>
            </div>
        </div>
        
        <sec:authorize access="hasAnyRole(${Access_Configuration})" var="var_not_Access_configuration">
        <script>
            /* Trap */
            var trapDataTables;
            $(document).ready(function() {
                trapDataTables = $('#trapDataTables').DataTable({
                    "searching": false, 
                    "bFilter": false,
                    "bSort": false,
                    "paging": false,
                    info: false,
                    responsive: true,
                    "scrollX": false
                });
                getGroupTrap(true);
            });
            
            //$("input[name=trapCheckbox]").bootstrapSwitch();
            /*William 2018/11/27: Avoid setting related parameters when Enable is off*/
            $("#trapDataTables>tbody").delegate("input[name=trapCheckbox]", "switchChange.bootstrapSwitch", function() {
                var id = $(this).attr("id");
                var textID = id + "_addr";
                var radioIpv4ID = id + "_trapIpv4";
                var radioIpv6ID = id + "_trapIpv6";
                var noIPv4 = "0.0.0.0";
                var noIPv6 = "::";
                if ($("#" + id).is(":checked")) {
                    $("input[id=" + textID + "]").prop("disabled", false);
                    $("input[id=" + radioIpv4ID + "]").prop("disabled", false);
                    $("input[id=" + radioIpv6ID + "]").prop("disabled", false);
                }
                else {
                    if (document.getElementById(radioIpv4ID).checked) {
                        $("input[id=" + textID + "]").val(noIPv4);
                    } 
                    else {
                        $("input[id=" + textID + "]").val(noIPv6);
                    }
                    $("input[id=" + textID + "]").prop("disabled", true);
                    $("input[id=" + radioIpv4ID + "]").prop("disabled", true);
                    $("input[id=" + radioIpv6ID + "]").prop("disabled", true);
                }
            });
            
            $("#trapDataTables>tbody").delegate("input[type='radio'][name^='trapRadios']", "change", function() {
                if($(this).val() === "IPv4")
                    $("#" + $(this).attr("id").replace("_trapIpv4", "") + "_addr").val("0.0.0.0");
                else
                    $("#" + $(this).attr("id").replace("_trapIpv6", "") + "_addr").val("::");
            });
            
            function getGroupTrap(first) {
                if(first) {
                    groupTrapListLoading(true);
                }
                
                $.ajax({
                    url: 'getGroupTrap',
                    data: {groupId:'${ID}'},
                    dataType: 'json',
                    success: function(_data, status, xhr) {                       
                        if(_data.dataArray.length > 0) {
                            var trapArray = [];
                            for(var i=0 ; i<_data.dataArray.length ; i++) {
                                trapArray.push([_data.dataArray[i].trapID,
                                                '<input name="trapCheckbox" type="checkbox" id="check' + (i+1) + '" data-size="mini" ' + (_data.dataArray[i].trapEnabled === 'true' ? 'checked' : '') + '>',
                                                '<input type="radio" name="trapRadios' + (i+1) + '" id="check' + (i+1) + '_trapIpv4" value="IPv4" ' + (_data.dataArray[i].trapIpType === 'IPv4' ? 'checked' : '') + '>&nbsp;&nbsp;&nbsp;' + 
                                                '<input type="radio" name="trapRadios' + (i+1) + '" id="check' + (i+1) + '_trapIpv6" value="IPv6" ' + (_data.dataArray[i].trapIpType === 'IPv6' ? 'checked' : '') + '>',
                                                '<input type="text" id="check' + (i+1) + '_addr" value="' + _data.dataArray[i].trapDestination + '" ' + (_data.dataArray[i].trapEnabled === 'true' ? '' : 'disabled') + '>']);
                            }
                            
                            groupTrapListLoading(false, trapArray);
                        }
                        else {
                            groupTrapListLoading(false);
                        }
                    },
                    error: function(xhr, status, error) {
                        groupTrapListLoading(false);
                        console.log("Get the group IP trap failed: [" + xhr.status + "] " + xhr.statusText);
                    },
                    cache: false
                });
            }
            
            function groupTrapListLoading(start, dataArray) {
                if(start) {
                    $("#trapDataTables>tbody").html("<tr><td colspan='4' style='text-align: center; padding-left:8px !important;'><i class='fa fa-circle-o-notch fa-spin fa-2x fa-fw'></i></td></tr>");
                }
                else {
                    setTimeout(function(){
                        if($("#trapDataTables>tbody>tr>td").attr("colspan") == 4)
                            trapDataTables.clear().draw(false);
                        if((dataArray != null) && (dataArray.length > 0)) {
                            trapDataTables.rows.add(dataArray).draw(false);
                            for(var i=0 ; i<dataArray.length ; i++)
                                $("#check" + (i+1)).bootstrapSwitch();
                        }
                        else {
                            $("#trapDataTables>tbody").html("<tr><td colspan='4'>Get Trap destination failed</td></tr>");
                            $("#setTrap").remove();
                        }
                    }, 100);
                }
            }
            
			function SetMember() {
				$('#member').modal('show');
			}
			
            /* William 2018/11/22: Avoid empty strings
             * William 2018/11/27: Add the setting value of IP Type
             */
            function clickedSubmitTRAP() {
                var ipEnable = [], trapIpRadios = [], ipDestination = [], selectIPMember = [];
                for (var i=1 ; i<=$('#trapDataTables>tbody>tr').length ; i++) {
                    var id = "check" + i;
                    var textID = id + "_addr";
                    var radioIpv4ID = id + "_trapIpv4";
                    var radioIpv6ID = id + "_trapIpv6";
                    var noIP = "0.0.0.0";
                    var ip = document.getElementById(textID).value;
                    
                    if (ip == "") {
                        ip = noIP;
                    }
                    
                    if (document.getElementById(radioIpv4ID).checked) {
                        trapIpRadios.push("IPv4");
                    }
                    else {
                        trapIpRadios.push("IPv6");
                    }
                    
                    if ( /^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$|^(([a-zA-Z]|[a-zA-Z][a-zA-Z0-9\-]*[a-zA-Z0-9])\.)*([A-Za-z]|[A-Za-z][A-Za-z0-9\-]*[A-Za-z0-9])$|^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$/.test(ip) ) {
                        if (ip == noIP) {
                            ipEnable.push(false);
                        }
                        else {
                            ipEnable.push(document.getElementById(id).checked);
                        }
                        ipDestination.push(ip);
                    }
                    else {
                        alert("<spring:message code="NodeSetting3"/>" + i + ": <spring:message code="NodeSetting8"/>");
                        return;
                    }
                }
				
				for (var i = 0;i < $('[name="addIP"]').length;i++) {
					if ($('[name="addIP"]')[i].checked)
						selectIPMember.push($('[name="addIP"]')[i].value);
				}
				
				var Paras = "&ipEnable=" + ipEnable + "&ipType=" + trapIpRadios + "&ipDestination=" + ipDestination + "&selectIPMember=" + selectIPMember;
                window.location.href = "./GroupSetTrap?ID=" + '${ID}' + Paras+"&Filter=GroupList";
            }
            
			$("#modalCheckBox input[type='checkbox']").click(function() {
				if ($("#modalCheckBox input[type='checkbox']").is(":checked"))
					$("button[ID=addBtn]").prop('disabled', false);
				else
					$("button[ID=addBtn]").prop('disabled', true);
			});
			
            /* PEF */
            /*var pefErrCode;
            var pefGlobalAlert;
            var pefGlobalAction;
            var groupName;
            var groupType;
            var nodeType;
            var nodeIP;
            var sensorAction = [];
            var numOfFilter;
            var pefDataTables1;
            var pefDataTables2;
            $(document).ready(function() {
                pefDataTables1 = $('#pefDataTables1').DataTable({
                     "searching": false, 
                     "bFilter": false,
                     "bSort": false,
                     "paging": false,
                     info: false,
                     responsive: true,
                     "scrollX": false,
                     "createdRow": function( row, data, dataIndex ) {
                    }
                });
                pefDataTables2 = $('#pefDataTables2').DataTable({
                     "searching": false, 
                     "bFilter": false,
                     "bSort": false,
                     "paging": false,
                     info: false,
                     responsive: true,
                     "scrollX": false,
                     "createdRow": function( row, data, dataIndex ) {
                    }
                });
                
                getGroupPEF(true);
                
                //GSM not support global enable
                //var nodeEnable = '${nodeGlobalAlert}';
                //if( (nodeEnable & 0x20) == 0x20 )
                //    document.getElementById("nodeEnable").checked = false;
                //else
                //    document.getElementById("nodeEnable").checked = true;
                
                //GbtUtility not support global action
                //var nodeAction = '${nodeGlobalAction}';
                //if( (nodeAction & 0x04) == 0x04 )
                //    document.getElementById("nodeAction1").checked = true;
                //
                //if( (nodeAction & 0x08) == 0x08 )
                //    document.getElementById("nodeAction2").checked = true;
                //
                //if( (nodeAction & 0x02) == 0x02 )
                //    document.getElementById("nodeAction3").checked = true;
                //
                //if( (nodeAction & 0x01) == 0x01 )
                //    document.getElementById("nodeAction4").checked = true;
            });
            
            $("#GroupPEF").delegate("input[type=checkbox]", "change", function() {
                var id = $(this).attr("id");
                
                if (id.indexOf("action") != -1) {
                    var index = "4";
                    //GbtUtility not support global action
                    //if (id.localeCompare('action1') == 0) {
                    //    index = "1";
                    //}
                    //else if (id.localeCompare('action2') == 0) {
                    //    index = "2";
                    //}
                    //else if (id.localeCompare('action3') == 0) {
                    //    index = "3";
                    //}
                    for (var i = 0; i<numOfFilter; i++) {
                        if(this.checked) {
                            $("input[id=radios" + index + (i+1)).prop("disabled", false);
                        } else {
                            $("input[id=radios" + index + (i+1)).prop("disabled", true);
                        }
                    }
                }
            });
            
            function setFilterAction(elementId) {
                for (var i = 0; i < numOfFilter; i++) {
                    <sec:authorize ifAnyGranted="${Access_Configuration}">
                        for (var j = 0; i < 4; i ++) {
                        var tag = "action" + i;
                        if (document.getElementById(tag).checked == true) {
                            $("input[id=radios" + (i+1) + (i+1)).prop("disabled", false);
                        }
                        else {
                            $("input[id=radios" + (i+1) + (i+1)).prop("disabled", true);
                        }
                    }
                    </sec:authorize>
                if( sensorAction[i] <= 0x01 )
                    document.getElementById(elementId + "01").checked = true;
                
                if( (sensorAction[i] & 0x04) == 0x04 )
                    document.getElementById(elementId + "11").checked = true;
                
                if( (sensorAction[i] & 0x08) == 0x08 )
                    document.getElementById(elementId + "21").checked = true;
                
                if( (sensorAction[i] & 0x02) == 0x02 )
                    document.getElementById(elementId + "31").checked = true;
                
                if( (sensorAction[i] & 0x01) == 0x01 )
                    document.getElementById(elementId + "41").checked = true;
                }
            }
            
            function getGroupPEF(first) {
                if(first) {
                    nodePEFListLoading(true);
                    groupPEFListLoading(true);
                }
                
                $.ajax({
                    url: 'getGroupPEF',
                    data: {groupId:'${ID}'},
                    dataType: 'json',
                    success: function(_data, status, xhr) {
                        if(_data.length > 0) {
                            var pefArray1 = [];
                            var pefArray2 = [];
                            numOfFilter = _data.length;
                            pefErrCode = _data[0].pefErrCode;
                            pefGlobalAlert = _data[0].globalAlert;
                            pefGlobalAction = _data[0].globalAction;
                            groupName = _data[0].Name;
                            groupType = _data[0].GroupType;
                            nodeType = _data[0].nodeType;
                            nodeIP = _data[0].nodeIP;
                            if( pefErrCode != 0 )
                                alert("<spring:message code="webErrMsg20"/>");
                            
                            for(var i=0 ; i<_data.length ; i++) {
                                sensorAction[i] = _data[i].sensorAction;
                                pefArray1.push([_data[i].sensorName,
                                              '<input type="radio" name="nodeRadios1" id="nodeRadios01"> None',
                                              '<input type="radio" name="nodeRadios1" id="nodeRadios11"> Reboot',
                                              '<input type="radio" name="nodeRadios1" id="nodeRadios21"> Power Cycle',
                                              '<input type="radio" name="nodeRadios1" id="nodeRadios31"> Power Off',
                                              '<input type="checkbox" id="nodeRadios41">']);
                                pefArray2.push([_data[i].sensorName,
                                              '<input type="radio" name="groupRadios1" id="groupRadios01"> None',
                                              '<input type="radio" name="groupRadios1" id="groupRadios11"> Reboot',
                                              '<input type="radio" name="groupRadios1" id="groupRadios21"> Power Cycle',
                                              '<input type="radio" name="groupRadios1" id="groupRadios31"> Power Off',
                                              '<input type="checkbox" id="groupRadios41">']);
                            }
                            $("#groupHeader").html("<h3 class='page-header' id='groupHeader'>" + groupName + "</h3>");
                            nodePEFListLoading(false, pefArray1);
                            groupPEFListLoading(false, pefArray2);
                        }
                        else {
                            nodePEFListLoading(false);
                            groupPEFListLoading(false);
                        }
                    },
                    error: function(xhr, status, error) {
                        nodePEFListLoading(false);
                        groupPEFListLoading(false);
                        console.log("Get the node PEF failed: [" + xhr.status + "] " + xhr.statusText);
                    },
                    cache: false
                });
            }
            
            function nodePEFListLoading(start, dataArray) {
                if(start) {
                    $("#pefDataTables1>tbody").html("<tr><td colspan='6' style='text-align: center; padding-left:8px !important;'><i class='fa fa-circle-o-notch fa-spin fa-2x fa-fw'></i></td></tr>");
                }
                else {
                    setTimeout(function(){
                        if($("#pefDataTables1>tbody>tr>td").attr("colspan") == 6)
                            pefDataTables1.clear().draw(false);
                        if(dataArray != null){
                            pefDataTables1.rows.add(dataArray).draw(false);
                            setFilterAction("nodeRadios");
                        }
                        if(groupType == "Standard with CMC") {
                            $("#panelHead1").html("<h4 id='panelHead1'>" + nodeIP + "(" + nodeType + ")" + "  <spring:message code='NodePEF11'/> (PEF)</h4>");
                            $("input[id=nodeRadios11]").prop("disabled", true);
                            $("input[id=nodeRadios21]").prop("disabled", true);
                        }
                        else if(groupType == "OpenRack 2.0") {
                            $("#panelHead1").html("<h4 id='panelHead1'>" + nodeIP + "(" + nodeType + ")" + "  <spring:message code='NodePEF11'/> (PEF)</h4>");
                            $("input[id=nodeRadios01]").prop("disabled", true);
                            $("input[id=nodeRadios11]").prop("disabled", true);
                            $("input[id=nodeRadios21]").prop("disabled", true);
                            $("input[id=nodeRadios31]").prop("disabled", true);
                        }
                        else {
                            $("#GroupPEF1").remove();
                        }
                    }, 100);
                }
            }
            
            function groupPEFListLoading(start, dataArray) {
                if(start) {
                    $("#pefDataTables2>tbody").html("<tr><td colspan='6' style='text-align: center; padding-left:8px !important;'><i class='fa fa-circle-o-notch fa-spin fa-2x fa-fw'></i></td></tr>");
                }
                else {
                    setTimeout(function(){
                        if($("#pefDataTables2>tbody>tr>td").attr("colspan") == 6)
                            pefDataTables2.clear().draw(false);
                        if(dataArray != null){
                            pefDataTables2.rows.add(dataArray).draw(false);
                            setFilterAction("groupRadios");
                        } 
                    }, 100);
                }
            }
            
            function setNodePEF() {
                var nodeAction = [];
                //GbtUtility not support global action
                //for(var i=1; i<=4; i++) {
                //    var nodeTag = "nodeAction" + i;
                //    if( document.getElementById(nodeTag).checked == true )
                //        nodeAction.push(document.getElementById(nodeTag).value);
                //}
                
                var nodeValue = 0x00;
                for(var i=0; i<nodeAction.length; i++) {
                    if( nodeAction[i] == 0 )
                        nodeValue = nodeValue + 0x04;
                    else if( nodeAction[i] == 1 )
                        nodeValue = nodeValue + 0x08;
                    else if( nodeAction[i] == 2 )
                        nodeValue = nodeValue + 0x02;
                    else
                        nodeValue = nodeValue + 0x01;
                }
                
                //GSM not support global enable
                var nodeEnable = 0xa2;
                //if( document.getElementById("nodeEnable").checked == true )
                //    nodeEnable = 0x82;
                
                var nodeFilterAction = [];
                var nodeFilterValue = 0x00;
                if( document.getElementById("nodeRadios01").checked == true )
                    nodeFilterValue = nodeFilterValue + 0x00;               
                else if( document.getElementById("nodeRadios11").checked == true )
                    nodeFilterValue = nodeFilterValue + 0x04;              
                else if( document.getElementById("nodeRadios21").checked == true )
                    nodeFilterValue = nodeFilterValue + 0x08;             
                else if( document.getElementById("nodeRadios31").checked == true )
                    nodeFilterValue = nodeFilterValue + 0x02;
                
                if( document.getElementById("nodeRadios41").checked == true )
                    nodeFilterValue = nodeFilterValue + 0x01;
                
                nodeFilterAction.push(nodeFilterValue);
                
                var nodeParas = "&globalEnable=" + nodeEnable + "&globalAction=" + nodeValue + "&filterAction=" + nodeFilterAction;
                window.location.href = "./SetGroupPEF_SingleNode?IP=" + nodeIP + "&ID=" + '${ID}' + nodeParas + "&Filter=GroupList";
            }
            
            function setGroupPEF() {
                var action = [];
                //GbtUtility not support global action
                //for (var i = 1; i <= 4; i ++) {
                //    var tag = "action" + i;
                //    if (document.getElementById(tag).checked == true) {
                //        action.push(document.getElementById(tag).value);
                //    }
                //}
                var value = 0x00;
                for (var i = 0; i < action.length; i ++) {
                    if (action[i] == 0) {
                        value = value + 0x04;
                    }
                    else if (action[i] == 1) {
                        value = value + 0x08;
                    }
                    else if (action[i] == 2) {
                        value = value + 0x02;
                    }
                    else {
                        value = value + 0x01;
                    }
                }
                
                //GSM not support global enable
                var enable = 0xa2;
                //if (document.getElementById("enable").checked == true) {
                //    enable = 0x82;
                //}
                var groupFilterAction = [];
                var groupFilterValue = 0x00;
                if (document.getElementById("groupRadios01").checked == true)
                    groupFilterValue = groupFilterValue + 0x00;             
                else if (document.getElementById("groupRadios11").checked == true)
                    groupFilterValue = groupFilterValue + 0x04;        
                else if (document.getElementById("groupRadios21").checked == true)
                    groupFilterValue = groupFilterValue + 0x08;     
                else if (document.getElementById("groupRadios31").checked == true)
                    groupFilterValue = groupFilterValue + 0x02;
                
                if (document.getElementById("groupRadios41").checked == true)
                    groupFilterValue = groupFilterValue + 0x01;
                
                groupFilterAction.push(groupFilterValue);
                
                var Paras = "&globalEnable=" + enable + "&globalAction=" + value + "&filterAction=" + groupFilterAction;
                window.location.href = "./SetGroupPEF?ID=" + '${ID}' + Paras+"&Filter=GroupList";
            }*/
        </script>
        </sec:authorize>
    </body>
</html>
